/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.joyent.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.compute.AbstractVMSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineProductFilterOptions;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.joyent.JoyentException;
import org.dasein.cloud.joyent.JoyentMethod;
import org.dasein.cloud.joyent.SmartDataCenter;
import org.dasein.cloud.joyent.compute.MachineCapabilities;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.UnitOfMeasure;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Machine
extends AbstractVMSupport<SmartDataCenter> {
    Logger logger = SmartDataCenter.getLogger(Machine.class, "std");
    private SmartDataCenter provider;
    private volatile transient MachineCapabilities capabilities;
    private static HashMap<String, MiData> miCache = new HashMap();
    private static HashMap<String, VirtualMachineProduct> productCache = new HashMap();
    private static HashMap<String, String> urnMapping = new HashMap();

    Machine(SmartDataCenter sdc) {
        super((CloudProvider)sdc);
        this.provider = sdc;
    }

    public VirtualMachine alterVirtualMachineProduct(@Nonnull String virtualMachineId, @Nonnull String productId) throws InternalException, CloudException {
        JoyentMethod method = new JoyentMethod(this.provider);
        method.doPostString(this.provider.getEndpoint(), "machines/" + virtualMachineId, "action=resize&package=" + productId);
        return this.getVirtualMachine(virtualMachineId);
    }

    public void start(@Nonnull String vmId) throws InternalException, CloudException {
        JoyentMethod method = new JoyentMethod(this.provider);
        method.doPostString(this.provider.getEndpoint(), "machines/" + vmId, "action=start");
    }

    private void discover(@Nonnull VirtualMachine vm) throws InternalException, CloudException {
        String miId = vm.getProviderMachineImageId();
        if (miCache.containsKey(miId)) {
            MiData d = miCache.get(miId);
            vm.setArchitecture(d.architecture);
            vm.setPlatform(d.platform);
        } else {
            if (!this.provider.getComputeServices().hasImageSupport()) {
                vm.setArchitecture(Architecture.I64);
                vm.setPlatform(Platform.UNKNOWN);
                return;
            }
            MachineImage img = this.provider.getComputeServices().getImageSupport().getImage(miId);
            if (img == null) {
                vm.setArchitecture(Architecture.I64);
                vm.setPlatform(Platform.UNKNOWN);
            } else {
                if (img.getName().contains("64")) {
                    vm.setArchitecture(Architecture.I64);
                } else if (img.getName().contains("32")) {
                    vm.setArchitecture(Architecture.I32);
                } else {
                    vm.setArchitecture(Architecture.I64);
                }
                vm.setPlatform(Platform.guess((String)(img.getName() + " " + img.getDescription())));
                MiData d = new MiData();
                d.architecture = vm.getArchitecture();
                d.platform = vm.getPlatform();
                miCache.put(miId, d);
            }
        }
    }

    @Nonnull
    public VirtualMachineCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new MachineCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        if (productCache.containsKey(productId)) {
            return productCache.get(productId);
        }
        for (VirtualMachineProduct prd : this.listProducts(Architecture.I64)) {
            if (!prd.getProviderProductId().equals(productId)) continue;
            productCache.put(productId, prd);
            return prd;
        }
        return null;
    }

    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String vmId) throws InternalException, CloudException {
        JoyentMethod method = new JoyentMethod(this.provider);
        try {
            String json = method.doGetJson(this.provider.getEndpoint(), "machines/" + vmId);
            if (json == null) {
                return null;
            }
            return this.toVirtualMachine(new JSONObject(json));
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        Boolean isSubscribed;
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"isSubscribedVirtualMachine", Boolean.class, (CacheLevel)CacheLevel.REGION_ACCOUNT);
        Iterable cachedIsSubscribed = cache.get(this.getContext());
        if (cachedIsSubscribed != null && cachedIsSubscribed.iterator().hasNext() && (isSubscribed = (Boolean)cachedIsSubscribed.iterator().next()) != null) {
            return isSubscribed;
        }
        JoyentMethod method = new JoyentMethod(this.provider);
        try {
            method.doGetJson(this.provider.getEndpoint(), "packages");
        }
        catch (JoyentException e) {
            if (e.getErrorType().equals((Object)CloudErrorType.AUTHENTICATION)) {
                cache.put(this.getContext(), Collections.singleton(false));
                return false;
            }
            throw e;
        }
        cache.put(this.getContext(), Collections.singleton(true));
        return true;
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        Map meta;
        JoyentMethod method = new JoyentMethod(this.provider);
        HashMap<String, String> post = new HashMap<String, String>();
        if (withLaunchOptions.getUserData() != null) {
            post.put("metadata.user-script", withLaunchOptions.getUserData());
        }
        if (withLaunchOptions.getHostName() != null) {
            String name = this.validateName(withLaunchOptions.getHostName());
            post.put("name", name);
        }
        if (withLaunchOptions.getStandardProductId() != null) {
            post.put("package", withLaunchOptions.getStandardProductId());
        }
        if (withLaunchOptions.getMachineImageId() != null) {
            post.put("dataset", withLaunchOptions.getMachineImageId());
        }
        if ((meta = withLaunchOptions.getMetaData()).size() > 0) {
            for (Map.Entry entry : meta.entrySet()) {
                post.put("metadata." + (String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        post.put("metadata.dsnTrueImage", withLaunchOptions.getMachineImageId());
        post.put("metadata.dsnTrueProduct", withLaunchOptions.getStandardProductId());
        post.put("metadata.dsnDescription", withLaunchOptions.getDescription());
        String json = method.doPostString(this.provider.getEndpoint(), "machines", new JSONObject(post).toString());
        if (json == null) {
            throw new CloudException("No machine was created");
        }
        try {
            return this.toVirtualMachine(new JSONObject(json));
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull String fromMachineImageId, @Nonnull VirtualMachineProduct product, @Nonnull String dataCenterId, @Nonnull String name, @Nonnull String description, @Nullable String withKeypairId, @Nullable String inVlanId, boolean withAnalytics, boolean asSandbox, @Nullable String[] firewallIds, Tag ... tags) throws InternalException, CloudException {
        VMLaunchOptions options = inVlanId == null ? VMLaunchOptions.getInstance((String)product.getProviderProductId(), (String)fromMachineImageId, (String)name, (String)description).inDataCenter(dataCenterId) : VMLaunchOptions.getInstance((String)product.getProviderProductId(), (String)fromMachineImageId, (String)name, (String)description).inVlan(null, dataCenterId, inVlanId);
        if (withKeypairId != null) {
            options = options.withBoostrapKey(withKeypairId);
        }
        if (tags != null) {
            for (Tag t : tags) {
                options = options.withMetaData(t.getKey(), (Object)t.getValue());
            }
        }
        if (firewallIds != null) {
            options = options.behindFirewalls(firewallIds);
        }
        options = options.withUserData("#!/usr/bin/env sh\n\nexport PATH=/opt/local/bin:/opt/local/sbin:/usr/bin:/usr/sbin\n\nif [[ $EUID -ne 0 ]] ; then\n  echo \"Must be root to install enstratus package\"\n  exit 1\nfi\n\necho \"==> Updating package lists...\"\nout=$(pkgin update)\nif [[ $? -ne 0 ]] ; then\n  echo \"error updating package lists\"\n  exit 1\nfi\n\necho \"==> Installing Sun-jdk6...\"\nout=$(yes | pkgin in sun-jdk6 sun-jre6)\nif [[ $? -ne 0 ]] ; then\n  echo \"error installing java\"\n  exit 1\nfi\n\necho \"==> Installing enstratus package...\"\nout=$(pkgin -y in enstratus-agent)\nif [[ $? -ne 0 ]] ; then\n  echo \"error installing enstratus agent\"\n  exit 1\nfi\n");
        return this.launch(options);
    }

    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull String machineImageId) throws InternalException, CloudException {
        MachineImage image = ((SmartDataCenter)this.getProvider()).getComputeServices().getImageSupport().getImage(machineImageId);
        Iterable allProducts = this.listProducts(image.getArchitecture());
        ArrayList<VirtualMachineProduct> products = new ArrayList<VirtualMachineProduct>();
        long minRamSize = 0L;
        String value = (String)image.getProviderMetadata().get("min_ram");
        if (value != null) {
            minRamSize = Long.parseLong(value);
        }
        for (VirtualMachineProduct product : allProducts) {
            boolean includeProduct = true;
            if (product.getRamSize().longValue() < minRamSize) {
                includeProduct = false;
            } else if (product.getRootVolumeSize() != null && product.getRootVolumeSize().longValue() < image.getMinimumDiskSizeGb()) {
                includeProduct = false;
            }
            if (!includeProduct) continue;
            products.add(product);
        }
        return products;
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(VirtualMachineProductFilterOptions options, Architecture architecture) throws InternalException, CloudException {
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"VM.listProducts", VirtualMachineProduct.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)TimePeriod.valueOf((Number)1, (String)"day"));
        Iterable cachedProducts = cache.get(this.getContext());
        if (cachedProducts != null && cachedProducts.iterator().hasNext()) {
            return cachedProducts;
        }
        JoyentMethod method = new JoyentMethod(this.provider);
        String json = method.doGetJson(this.provider.getEndpoint(), "packages");
        if (json == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<VirtualMachineProduct> products = new ArrayList<VirtualMachineProduct>();
            JSONArray list = new JSONArray(json);
            for (int i = 0; i < list.length(); ++i) {
                JSONObject ob = list.getJSONObject(i);
                VirtualMachineProduct prd = new VirtualMachineProduct();
                if (ob.has("name")) {
                    prd.setName(ob.getString("name"));
                }
                if (ob.has("memory")) {
                    prd.setRamSize(new Storage((Number)ob.getInt("memory"), (StorageUnit)Storage.MEGABYTE));
                }
                if (ob.has("disk")) {
                    prd.setRootVolumeSize(new Storage((Number)ob.getInt("disk"), (StorageUnit)Storage.MEGABYTE));
                }
                if (ob.has("vcpus")) {
                    prd.setCpuCount(ob.getInt("vcpus"));
                }
                if (prd.getCpuCount() == 0) {
                    prd.setCpuCount(1);
                }
                if (ob.has("description")) {
                    prd.setDescription(ob.getString("description"));
                } else {
                    prd.setDescription(prd.getName());
                }
                prd.setProviderProductId(ob.getString("id"));
                if (options != null) {
                    if (!options.matches(prd)) continue;
                    products.add(prd);
                    continue;
                }
                products.add(prd);
            }
            cache.put(this.getContext(), products);
            return products;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        JoyentMethod method = new JoyentMethod(this.provider);
        try {
            JSONArray machines = new JSONArray(method.doGetJson(this.provider.getEndpoint(), "machines"));
            ArrayList<ResourceStatus> vms = new ArrayList<ResourceStatus>();
            for (int i = 0; i < machines.length(); ++i) {
                ResourceStatus vm = this.toStatus(machines.getJSONObject(i));
                if (vm == null) continue;
                vms.add(vm);
            }
            return vms;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        JoyentMethod method = new JoyentMethod(this.provider);
        try {
            JSONArray machines = new JSONArray(method.doGetJson(this.provider.getEndpoint(), "machines"));
            ArrayList<VirtualMachine> vms = new ArrayList<VirtualMachine>();
            for (int i = 0; i < machines.length(); ++i) {
                VirtualMachine vm = this.toVirtualMachine(machines.getJSONObject(i));
                if (vm == null) continue;
                vms.add(vm);
            }
            return vms;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void stop(@Nonnull String vmId, boolean force) throws InternalException, CloudException {
        JoyentMethod method = new JoyentMethod(this.provider);
        method.doPostString(this.provider.getEndpoint(), "machines/" + vmId, "action=stop");
    }

    public void reboot(@Nonnull String vmId) throws CloudException, InternalException {
        JoyentMethod method = new JoyentMethod(this.provider);
        method.doPostString(this.provider.getEndpoint(), "machines/" + vmId, "action=reboot");
    }

    public void terminate(@Nonnull String vmId, @Nullable String explanation) throws InternalException, CloudException {
        long timeout = System.currentTimeMillis() + 1200000L;
        JoyentMethod method = new JoyentMethod(this.provider);
        VirtualMachine vm = this.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such server: " + vmId);
        }
        VmState currentState = vm.getCurrentState();
        while (VmState.PENDING.equals((Object)currentState) && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                return;
            }
            currentState = vm.getCurrentState();
        }
        if (VmState.RUNNING.equals((Object)currentState)) {
            method.doPostString(this.provider.getEndpoint(), "machines/" + vmId, "action=stop");
        }
        while (!VmState.STOPPED.equals((Object)currentState) && !VmState.TERMINATED.equals((Object)currentState) && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                return;
            }
            currentState = vm.getCurrentState();
        }
        method.doDelete(this.provider.getEndpoint(), "machines/" + vmId);
        if (timeout < 300000L) {
            timeout = System.currentTimeMillis() + 300000L;
        }
        while (System.currentTimeMillis() < timeout) {
            if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState())) {
                return;
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            vm = this.getVirtualMachine(vmId);
        }
        this.logger.warn((Object)"System timed out waiting for VM termination");
    }

    @Nullable
    public String getPassword(@Nonnull String vmId) throws InternalException, CloudException {
        String[] adminUsernames = new String[]{"root", "administrator", "admin"};
        JoyentMethod method = new JoyentMethod(this.provider);
        try {
            JSONObject ob = new JSONObject(method.doGetJson(this.provider.getEndpoint(), "machines/" + vmId + "/metadata?credentials=true"));
            if (ob.has("credentials")) {
                JSONObject credentials = ob.getJSONObject("credentials");
                for (String username : adminUsernames) {
                    if (!ob.has(username)) continue;
                    return ob.getString(username);
                }
            }
        }
        catch (JSONException e) {
            throw new InternalException("Unable to parse the response", (Throwable)e);
        }
        return null;
    }

    @Nullable
    public String getUserData(@Nonnull String vmId) throws InternalException, CloudException {
        JoyentMethod method = new JoyentMethod(this.provider);
        try {
            JSONObject ob = new JSONObject(method.doGetJson(this.provider.getEndpoint(), "machines/" + vmId + "/metadata"));
            if (ob.has("user-script")) {
                return ob.getString("user-script");
            }
        }
        catch (JSONException e) {
            throw new InternalException("Unable to parse the response", (Throwable)e);
        }
        return null;
    }

    private VirtualMachine toVirtualMachine(JSONObject ob) throws CloudException, InternalException {
        if (ob == null) {
            return null;
        }
        try {
            JSONObject md;
            JSONArray names;
            VirtualMachine vm = new VirtualMachine();
            vm.setClonable(false);
            vm.setImagable(false);
            vm.setLastPauseTimestamp(-1L);
            vm.setPersistent(true);
            vm.setProviderDataCenterId(this.provider.getContext().getRegionId() + "a");
            vm.setProviderOwnerId(this.provider.getContext().getAccountNumber());
            vm.setProviderRegionId(this.provider.getContext().getRegionId());
            vm.setTerminationTimestamp(-1L);
            if (ob.has("id")) {
                vm.setProviderVirtualMachineId(ob.getString("id"));
            }
            if (ob.has("name")) {
                vm.setName(ob.getString("name"));
            }
            if (ob.has("package")) {
                vm.setProductId(ob.getString("package"));
            }
            if (ob.has("ips")) {
                JSONArray ips = ob.getJSONArray("ips");
                ArrayList<String> pubIp = new ArrayList<String>();
                ArrayList<String> privIp = new ArrayList<String>();
                for (int i = 0; i < ips.length(); ++i) {
                    String addr = ips.getString(i);
                    boolean pub = false;
                    if (!addr.startsWith("10.") && !addr.startsWith("192.168.")) {
                        if (addr.startsWith("172.")) {
                            String[] nums = addr.split("\\.");
                            if (nums.length != 4) {
                                pub = true;
                            } else {
                                try {
                                    int x = Integer.parseInt(nums[1]);
                                    if (x < 16 || x > 31) {
                                        pub = true;
                                    }
                                }
                                catch (NumberFormatException ignore) {}
                            }
                        } else {
                            pub = true;
                        }
                    }
                    if (pub) {
                        pubIp.add(addr);
                        continue;
                    }
                    privIp.add(addr);
                }
                if (!pubIp.isEmpty()) {
                    vm.setPublicIpAddresses(pubIp.toArray(new String[pubIp.size()]));
                }
                if (!privIp.isEmpty()) {
                    vm.setPrivateIpAddresses(privIp.toArray(new String[privIp.size()]));
                }
            }
            if (ob.has("metadata") && (names = (md = ob.getJSONObject("metadata")).names()) != null) {
                for (int i = 0; i < names.length(); ++i) {
                    String name = names.getString(i);
                    if (name.equals("dsnDescription")) {
                        vm.setDescription(md.getString(name));
                        continue;
                    }
                    if (name.equals("dsnTrueImage")) {
                        vm.setProviderMachineImageId(md.getString(name));
                        continue;
                    }
                    vm.addTag(name, md.getString(name));
                }
            }
            if (vm.getProviderMachineImageId() == null && ob.has("dataset")) {
                vm.setProviderMachineImageId(this.getImageIdFromUrn(ob.getString("dataset")));
            }
            if (ob.has("created")) {
                vm.setCreationTimestamp(this.provider.parseTimestamp(ob.getString("created")));
            }
            vm.setPausable(false);
            vm.setRebootable(false);
            if (ob.has("state")) {
                vm.setCurrentState(this.toState(ob.getString("state")));
                if (VmState.RUNNING.equals((Object)vm.getCurrentState())) {
                    vm.setRebootable(true);
                } else if (VmState.STOPPED.equals((Object)vm.getCurrentState())) {
                    vm.setImagable(true);
                }
            }
            vm.setLastBootTimestamp(vm.getCreationTimestamp());
            if (vm.getName() == null) {
                vm.setName(vm.getProviderVirtualMachineId());
            }
            if (vm.getDescription() == null) {
                vm.setDescription(vm.getName());
            }
            this.discover(vm);
            boolean isVMSmartOs = vm.getPlatform().equals((Object)Platform.SMARTOS);
            if (vm.getProductId() == null) {
                VirtualMachineProduct d = null;
                int disk = ob.getInt("disk");
                int ram = ob.getInt("memory");
                Iterator i$ = this.listProducts(vm.getArchitecture()).iterator();
                while (i$.hasNext()) {
                    VirtualMachineProduct prd;
                    d = prd = (VirtualMachineProduct)i$.next();
                    boolean isProductSmartOs = prd.getName().contains("smartos");
                    if (prd.getRootVolumeSize().convertTo((UnitOfMeasure)Storage.MEGABYTE).intValue() != disk || prd.getRamSize().intValue() != ram || isVMSmartOs && !isProductSmartOs || !isVMSmartOs && isProductSmartOs) continue;
                    vm.setProductId(prd.getProviderProductId());
                    break;
                }
            }
            return vm;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    private VmState toState(@Nonnull String s) {
        if (s.equalsIgnoreCase("running")) {
            return VmState.RUNNING;
        }
        if (s.equalsIgnoreCase("provisioning")) {
            return VmState.PENDING;
        }
        if (s.equalsIgnoreCase("stopping")) {
            return VmState.STOPPING;
        }
        if (s.equalsIgnoreCase("stopped")) {
            return VmState.STOPPED;
        }
        if (s.equalsIgnoreCase("deleted")) {
            return VmState.TERMINATED;
        }
        this.logger.warn((Object)("DEBUG: Unknown Joyent VM state: " + s));
        return VmState.PENDING;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject ob) throws CloudException, InternalException {
        if (ob == null) {
            return null;
        }
        try {
            VmState state = VmState.PENDING;
            String vmId = null;
            if (ob.has("id")) {
                vmId = ob.getString("id");
            }
            if (ob.has("state")) {
                state = this.toState(ob.getString("state"));
            }
            if (vmId == null) {
                return null;
            }
            return new ResourceStatus(vmId, (Object)state);
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getImageIdFromUrn(String urn) throws CloudException, InternalException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("ENTER: " + Machine.class.getName() + ".getImageIdFromUrn(" + urn + ")"));
        }
        try {
            String id;
            if (urnMapping.containsKey(urn)) {
                String string = urnMapping.get(urn);
                return string;
            }
            MachineImage img = this.provider.getComputeServices().getImageSupport().getImage(urn);
            if (img != null && (id = img.getProviderMachineImageId()) != null) {
                urnMapping.put(urn, id);
                String string = id;
                return string;
            }
            String string = urn;
            return string;
        }
        finally {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("EXIT: " + Machine.class.getName() + ".getImageIdFromUrn()"));
            }
        }
    }

    private String validateName(String originalName) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < originalName.length(); ++i) {
            char c = originalName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                name.append(c);
                continue;
            }
            if ((c < '0' || c > '9') && c != '-' && c != '_' && c != ' ' || name.length() <= 0) continue;
            if (c == ' ') {
                c = '-';
            }
            name.append(c);
        }
        if (name.length() < 1) {
            return "unnamed-" + System.currentTimeMillis();
        }
        if (name.charAt(name.length() - 1) == '-' || name.charAt(name.length() - 1) == '_') {
            name.deleteCharAt(name.length() - 1);
        }
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Server.createTags");
        try {
            try {
                JoyentMethod method = new JoyentMethod(this.provider);
                method.doDelete(this.provider.getEndpoint(), "machines/" + vmId + "/tags");
                do {
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (!method.doGetJson(this.provider.getEndpoint(), "machines/" + vmId + "/tags").equals("{}"));
            }
            catch (CloudException e) {
                this.logger.error((Object)("Error while deleting all tags for - " + vmId + "."), (Throwable)e);
            }
            this.updateTags(vmId, tags);
        }
        finally {
            APITrace.end();
        }
    }

    public void setTags(@Nonnull String[] vmIds, Tag ... tags) throws CloudException, InternalException {
        for (String vmId : vmIds) {
            this.setTags(vmId, tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Server.updateTags");
        try {
            try {
                JoyentMethod method = new JoyentMethod(this.provider);
                HashMap<String, String> post = new HashMap<String, String>();
                for (int i = 0; i < tags.length; ++i) {
                    post.put(tags[i].getKey(), tags[i].getValue() == null ? "" : tags[i].getValue());
                }
                method.doPostString(this.provider.getEndpoint(), "machines/" + vmId + "/tags", new JSONObject(post).toString());
            }
            catch (CloudException e) {
                this.logger.error((Object)("Error while creating the tags for - " + vmId + "."), (Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void updateTags(@Nonnull String[] vmIds, Tag ... tags) throws CloudException, InternalException {
        for (String vmId : vmIds) {
            this.updateTags(vmId, tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Server.removeTags");
        try {
            JoyentMethod method = new JoyentMethod(this.provider);
            for (int i = 0; i < tags.length; ++i) {
                try {
                    method.doDelete(this.provider.getEndpoint(), "machines/" + vmId + "/tags/" + tags[i].getKey());
                    while (method.doGetJson(this.provider.getEndpoint(), "machines/" + vmId + "/tags/" + tags[i].getKey()) != null) {
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    continue;
                }
                catch (CloudException e) {
                    this.logger.error((Object)("Error while deleting the tags for - " + vmId + "."), (Throwable)e);
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void removeTags(@Nonnull String[] vmIds, Tag ... tags) throws CloudException, InternalException {
        for (String vmId : vmIds) {
            this.removeTags(vmId, tags);
        }
    }

    private static class MiData {
        public Architecture architecture;
        public Platform platform;

        private MiData() {
        }
    }
}

