/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.joyent.storage;

import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaObject;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaCryptoException;
import com.joyent.manta.exception.MantaObjectException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.joyent.SmartDataCenter;
import org.dasein.cloud.joyent.storage.MantaCapabilities;
import org.dasein.cloud.joyent.storage.MantaStorageServices;
import org.dasein.cloud.storage.AbstractBlobStoreSupport;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.BlobStoreCapabilities;
import org.dasein.cloud.storage.FileTransfer;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class Manta
extends AbstractBlobStoreSupport<SmartDataCenter> {
    public static final String CUSTOM_PROP_STORAGE_URL = "storageUrl";
    private static final Logger logger = SmartDataCenter.getLogger(MantaStorageServices.class, "std");
    private MantaClient mantaClient;
    private String rootPath;
    private String publicPath;
    private volatile transient MantaCapabilities capabilities;
    private final char[] BUCKET_CHARS = new char[]{'-', '.'};
    private final char[] OBJECT_CHARS = new char[]{'-', '.', ',', '#', '+'};

    public Manta(SmartDataCenter provider) throws IOException, CloudException {
        super((CloudProvider)provider);
    }

    public BlobStoreCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new MantaCapabilities((SmartDataCenter)this.getProvider());
        }
        return this.capabilities;
    }

    private void checkContext() throws CloudException, InternalException {
        ProviderContext ctx = ((SmartDataCenter)this.getProvider()).getContext();
        if (ctx == null) {
            throw new InternalException("No context has been established for this request");
        }
        if (this.mantaClient == null) {
            try {
                this.mantaClient = this.getClient();
            }
            catch (IOException e) {
                throw new CloudException("Unable to initialise Manta client", (Throwable)e);
            }
            this.rootPath = "/" + ctx.getAccountNumber() + "/stor";
            this.publicPath = "/" + ctx.getAccountNumber() + "/public";
        }
    }

    private MantaClient getClient() throws CloudException, IOException {
        List fields = ((SmartDataCenter)this.getProvider()).getContextRequirements().getConfigurableValues();
        String keyName = "";
        String privateKey = "";
        char[] keyPassword = null;
        for (ContextRequirements.Field f : fields) {
            byte[] password;
            if (f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) {
                byte[][] keyPair = (byte[][])((SmartDataCenter)this.getProvider()).getContext().getConfigurationValue(f);
                keyName = new String(keyPair[0], "utf-8");
                privateKey = new String(keyPair[1], "utf-8");
                continue;
            }
            if (!f.type.equals((Object)ContextRequirements.FieldType.PASSWORD) || (password = (byte[])((SmartDataCenter)this.getProvider()).getContext().getConfigurationValue(f)) == null) continue;
            keyPassword = new String(password, "utf-8").toCharArray();
        }
        return MantaClient.newInstance((String)((SmartDataCenter)this.getProvider()).getContext().getCustomProperties().getProperty(CUSTOM_PROP_STORAGE_URL), (String)((SmartDataCenter)this.getProvider()).getContext().getAccountNumber(), (String)privateKey, (String)keyName, keyPassword);
    }

    public boolean allowsNestedBuckets() throws CloudException, InternalException {
        return true;
    }

    public boolean allowsRootObjects() throws CloudException, InternalException {
        return true;
    }

    public boolean allowsPublicSharing() throws CloudException, InternalException {
        return true;
    }

    public void clearBucket(@Nonnull String bucket) throws CloudException, InternalException {
        this.checkContext();
        String path = this.toStoragePath(bucket, null, !this.isPublic(bucket, null));
        boolean retryRecursively = false;
        try {
            this.mantaClient.delete(path);
        }
        catch (MantaCryptoException e) {
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            retryRecursively = true;
            logger.debug((Object)"Directory is not empty. Delete recursively.", (Throwable)e);
        }
        catch (MantaClientHttpResponseException e) {
            retryRecursively = true;
            logger.debug((Object)"Directory is not empty. Delete recursively.", (Throwable)e);
        }
        if (retryRecursively) {
            try {
                this.mantaClient.deleteRecursive(path);
            }
            catch (MantaCryptoException e) {
                throw new CloudException((Throwable)e);
            }
            catch (IOException e) {
                throw new CloudException((Throwable)e);
            }
            catch (MantaClientHttpResponseException e) {
                throw new CloudException((Throwable)e);
            }
        }
    }

    @Nonnull
    public Blob createBucket(@Nonnull String bucket, boolean findFreeName) throws InternalException, CloudException {
        this.checkContext();
        try {
            this.mantaClient.putDirectory(this.toStoragePath(bucket, null, true), null);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaCryptoException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaClientHttpResponseException e) {
            throw new CloudException((Throwable)e);
        }
        return Blob.getInstance((String)((SmartDataCenter)this.getProvider()).getContext().getRegionId(), (String)"", (String)bucket, (long)new Date().getTime());
    }

    public boolean exists(@Nonnull String bucket) throws InternalException, CloudException {
        this.checkContext();
        return this.getMantaObjectMetadata(bucket, null, true) != null || this.getMantaObjectMetadata(bucket, null, false) != null;
    }

    @Nullable
    public Blob getBucket(@Nonnull String bucketName) throws InternalException, CloudException {
        this.checkContext();
        Blob bucket = null;
        MantaObject mantaObject = this.getMantaObjectMetadata(bucketName, null);
        if (mantaObject == null) {
            return null;
        }
        if (this.isDirectory(mantaObject)) {
            bucket = Blob.getInstance((String)((SmartDataCenter)this.getProvider()).getContext().getRegionId(), (String)"", (String)bucketName, (long)new Date().getTime());
        }
        return bucket;
    }

    private boolean isDirectory(@Nonnull MantaObject mantaObject) {
        return mantaObject.getHttpHeaders().getContentType().equals("application/x-json-stream; type=directory");
    }

    private Double getContentLength(@Nonnull MantaObject mantaObject) {
        return mantaObject.getHttpHeaders().getContentLength().doubleValue();
    }

    @Nullable
    public Blob getObject(@Nullable String bucketName, @Nonnull String objectName) throws InternalException, CloudException {
        this.checkContext();
        this.checkBucket(bucketName);
        MantaObject mantaObject = this.getMantaObjectMetadata(bucketName, objectName);
        if (mantaObject == null) {
            return null;
        }
        return Blob.getInstance((String)((SmartDataCenter)this.getProvider()).getContext().getRegionId(), (String)"", (String)bucketName, (String)objectName, (long)new Date().getTime(), (Storage)new Storage((Number)this.getContentLength(mantaObject), (StorageUnit)Storage.BYTE));
    }

    @Nullable
    public Storage<Byte> getObjectSize(@Nullable String bucketName, @Nullable String objectName) throws InternalException, CloudException {
        MantaObject mantaObject;
        this.checkContext();
        this.checkBucket(bucketName);
        Storage storage = null;
        if (objectName != null && (mantaObject = this.getMantaObjectMetadata(bucketName, objectName)) != null) {
            storage = new Storage((Number)this.getContentLength(mantaObject), (StorageUnit)Storage.BYTE);
        }
        return storage;
    }

    @Nullable
    private MantaObject getMantaObjectMetadata(@Nullable String bucket, @Nullable String object, boolean isPrivate) throws CloudException, InternalException {
        try {
            return this.mantaClient.head(this.toStoragePath(bucket, object, isPrivate));
        }
        catch (MantaClientHttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaCryptoException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    private MantaObject getMantaObjectMetadata(@Nullable String bucket, @Nullable String object) throws CloudException, InternalException {
        MantaObject o = this.getMantaObjectMetadata(bucket, object, true);
        if (o == null) {
            o = this.getMantaObjectMetadata(bucket, object, false);
        }
        return o;
    }

    public int getMaxBuckets() throws CloudException, InternalException {
        return Integer.MAX_VALUE;
    }

    public Storage<Byte> getMaxObjectSize() throws InternalException, CloudException {
        return new Storage((Number)Long.MAX_VALUE, (StorageUnit)Storage.BYTE);
    }

    public int getMaxObjectsPerBucket() throws CloudException, InternalException {
        return 1000000;
    }

    @Nonnull
    public NamingConstraints getBucketNameRules() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255).lowerCaseOnly().limitedToLatin1().constrainedBy(this.BUCKET_CHARS);
    }

    @Nonnull
    public NamingConstraints getObjectNameRules() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255).lowerCaseOnly().limitedToLatin1().constrainedBy(this.OBJECT_CHARS);
    }

    @Nonnull
    public String getProviderTermForBucket(@Nonnull Locale locale) {
        return "directory";
    }

    @Nonnull
    public String getProviderTermForObject(@Nonnull Locale locale) {
        return "object";
    }

    public boolean isPublic(@Nullable String bucket, @Nullable String object) throws CloudException, InternalException {
        this.checkContext();
        return this.getMantaObjectMetadata(bucket, object, false) != null;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        Boolean isSubscribed;
        this.checkContext();
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"Blob.isSubscribed", Boolean.class, (CacheLevel)CacheLevel.REGION_ACCOUNT);
        Iterable cachedIsSubscribed = cache.get(((SmartDataCenter)this.getProvider()).getContext());
        if (cachedIsSubscribed != null && cachedIsSubscribed.iterator().hasNext() && (isSubscribed = (Boolean)cachedIsSubscribed.iterator().next()) != null) {
            return isSubscribed;
        }
        try {
            this.mantaClient.listObjects(this.rootPath);
            cache.put(((SmartDataCenter)this.getProvider()).getContext(), Collections.singleton(true));
            return true;
        }
        catch (MantaClientHttpResponseException ex) {
            if (ex.getStatusCode() == 403) {
                cache.put(((SmartDataCenter)this.getProvider()).getContext(), Collections.singleton(false));
                return false;
            }
            throw new CloudException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new CloudException((Throwable)ex);
        }
    }

    @Nonnull
    public Iterable<Blob> list(@Nullable String bucket) throws CloudException, InternalException {
        Collection mantaObjects;
        this.checkContext();
        this.checkBucket(bucket);
        ArrayList<Blob> result = new ArrayList<Blob>();
        try {
            mantaObjects = this.mantaClient.listObjects(this.toStoragePath(bucket, null, !this.isPublic(bucket, null)));
        }
        catch (MantaCryptoException e) {
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaObjectException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaClientHttpResponseException e) {
            throw new CloudException((Throwable)e);
        }
        for (MantaObject mantaObject : mantaObjects) {
            if (mantaObject.isDirectory()) {
                result.add(Blob.getInstance((String)((SmartDataCenter)this.getProvider()).getContext().getRegionId(), (String)"", (String)bucket, (long)new Date().getTime()));
                continue;
            }
            String objectName = this.parseObjectName(mantaObject.getPath());
            result.add(Blob.getInstance((String)((SmartDataCenter)this.getProvider()).getContext().getRegionId(), (String)"", (String)bucket, (String)objectName, (long)new Date().getTime(), (Storage)new Storage((Number)mantaObject.getContentLength(), (StorageUnit)Storage.BYTE)));
        }
        return result;
    }

    public void makePublic(@Nonnull String bucket) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Not supported yet");
    }

    public void makePublic(@Nullable String bucket, @Nonnull String object) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Not supported yet");
    }

    public void move(@Nullable String fromBucket, @Nullable String objectName, @Nullable String toBucket) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Manta does not have support of buckets");
    }

    public void removeBucket(@Nonnull String bucket) throws CloudException, InternalException {
        this.checkContext();
        boolean retryRecursively = false;
        String path = this.toStoragePath(bucket, null, !this.isPublic(bucket, null));
        try {
            this.mantaClient.delete(path);
        }
        catch (MantaCryptoException e) {
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            retryRecursively = true;
            logger.debug((Object)"Directory is not empty. Delete recursively.", (Throwable)e);
        }
        catch (MantaClientHttpResponseException e) {
            retryRecursively = true;
            logger.debug((Object)"Directory is not empty. Delete recursively.", (Throwable)e);
        }
        if (retryRecursively) {
            try {
                this.mantaClient.deleteRecursive(path);
            }
            catch (MantaCryptoException ex) {
                throw new CloudException((Throwable)ex);
            }
            catch (MantaClientHttpResponseException ex) {
                throw new CloudException((Throwable)ex);
            }
            catch (IOException ex) {
                throw new CloudException((Throwable)ex);
            }
        }
    }

    public void removeObject(@Nullable String bucket, @Nonnull String object) throws CloudException, InternalException {
        this.checkContext();
        this.checkBucket(bucket);
        try {
            this.mantaClient.delete(this.toStoragePath(bucket, object, !this.isPublic(bucket, object)));
        }
        catch (MantaCryptoException e) {
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaClientHttpResponseException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public String renameBucket(@Nonnull String oldName, @Nonnull String newName, boolean findFreeName) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not supported yet");
    }

    public void renameObject(@Nullable String bucket, @Nonnull String oldName, @Nonnull String newName) throws CloudException, InternalException {
        this.checkContext();
        String path = this.toStoragePath(bucket, oldName, !this.isPublic(bucket, oldName));
        String linkPath = path + this.parseObjectName(newName);
        String objPath = path + this.parseObjectName(oldName);
        try {
            this.mantaClient.putSnapLink(linkPath, objPath, null);
            this.mantaClient.delete(objPath);
        }
        catch (MantaCryptoException e) {
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaClientHttpResponseException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Blob upload(@Nonnull File sourceFile, @Nullable String bucket, @Nonnull String objectName) throws CloudException, InternalException {
        this.checkContext();
        if (bucket == null) {
            bucket = "";
        }
        String validObjectName = this.parseObjectName(objectName);
        this.put(bucket, objectName, sourceFile);
        return Blob.getInstance((String)((SmartDataCenter)this.getProvider()).getContext().getRegionId(), (String)"", (String)bucket, (String)validObjectName, (long)new Date().getTime(), (Storage)new Storage((Number)sourceFile.length(), (StorageUnit)Storage.BYTE));
    }

    private void checkBucket(@Nullable String bucket) throws OperationNotSupportedException {
    }

    @Nonnull
    private String toPath(@Nullable String bucket, @Nullable String object) {
        String path = "/";
        if (bucket != null) {
            path = path + bucket;
        }
        if (object != null) {
            if (!path.endsWith("/") && !object.startsWith("/")) {
                path = path + "/";
            }
            path = path + object;
        }
        return path;
    }

    @Nonnull
    private String toStoragePath(@Nullable String bucket, @Nullable String object, boolean isPrivate) {
        if (isPrivate) {
            return this.rootPath + this.toPath(bucket, object);
        }
        return this.publicPath + this.toPath(bucket, object);
    }

    @Nonnull
    private String parsePath(@Nonnull String objectName) {
        return objectName.substring(0, objectName.lastIndexOf(47) + 1);
    }

    @Nonnull
    private String parseObjectName(@Nonnull String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    protected void get(@Nullable String bucket, @Nonnull String object, @Nonnull File toFile, @Nullable FileTransfer transfer) throws InternalException, CloudException {
        this.checkContext();
        try {
            MantaObject mantaObject = this.mantaClient.get(this.toStoragePath(bucket, object, !this.isPublic(bucket, object)));
            FileUtils.copyInputStreamToFile((InputStream)mantaObject.getDataInputStream(), (File)toFile);
        }
        catch (MantaCryptoException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaClientHttpResponseException e) {
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
    }

    protected void put(@Nullable String bucket, @Nonnull String objectName, @Nonnull File file) throws InternalException, CloudException {
        this.checkContext();
        if (bucket == null) {
            bucket = "";
        }
        this.checkBucket(bucket);
        String pathToDir = this.toStoragePath(bucket, null, true);
        String validObjectName = this.parseObjectName(objectName);
        try {
            if (!this.exists(pathToDir)) {
                this.createBucket(bucket, false);
            }
            MantaObject mantaObject = new MantaObject(pathToDir + "/" + validObjectName);
            mantaObject.setDataInputFile(file);
            this.mantaClient.put(mantaObject);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaCryptoException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaClientHttpResponseException e) {
            throw new CloudException((Throwable)e);
        }
    }

    protected void put(@Nullable String bucketName, @Nonnull String objectName, @Nonnull String content) throws InternalException, CloudException {
        this.checkContext();
        if (bucketName == null) {
            bucketName = "";
        }
        this.checkBucket(bucketName);
        String pathToDir = this.toStoragePath(bucketName, null, true);
        String validObjectName = this.parseObjectName(objectName);
        try {
            if (!this.exists(pathToDir)) {
                this.createBucket(bucketName, false);
            }
            MantaObject mantaObject = new MantaObject(pathToDir + "/" + validObjectName);
            mantaObject.setDataInputString(content);
            this.mantaClient.put(mantaObject);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaCryptoException e) {
            throw new CloudException((Throwable)e);
        }
        catch (MantaClientHttpResponseException e) {
            throw new CloudException((Throwable)e);
        }
    }

    public String getSignedObjectUrl(@Nonnull String bucket, @Nonnull String object, @Nonnull String expiresEpochInSeconds) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Signed object URLs are not currently supported.");
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }
}

