/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.joyent.storage;

import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.joyent.SmartDataCenter;
import org.dasein.cloud.storage.BlobStoreCapabilities;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class MantaCapabilities
extends AbstractCapabilities<SmartDataCenter>
implements BlobStoreCapabilities {
    static final int MAX_BUCKETS = 100;
    static final int MAX_OBJECTS = -1;
    static final Storage<Byte> MAX_OBJECT_SIZE = new Storage((Number)5000000000L, (StorageUnit)Storage.BYTE);

    public MantaCapabilities(SmartDataCenter provider) {
        super((CloudProvider)provider);
    }

    public boolean allowsNestedBuckets() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsRootObjects() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsPublicSharing() throws CloudException, InternalException {
        return true;
    }

    public int getMaxBuckets() throws CloudException, InternalException {
        return 100;
    }

    @Nonnull
    public Storage<Byte> getMaxObjectSize() throws InternalException, CloudException {
        return MAX_OBJECT_SIZE;
    }

    public int getMaxObjectsPerBucket() throws CloudException, InternalException {
        return -1;
    }

    @Nonnull
    public NamingConstraints getBucketNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255).lowerCaseOnly().limitedToLatin1().constrainedBy(new char[]{'-', '.'});
    }

    @Nonnull
    public NamingConstraints getObjectNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255).lowerCaseOnly().limitedToLatin1().constrainedBy(new char[]{'-', '.', ',', '#', '+'});
    }

    @Nonnull
    public String getProviderTermForBucket(@Nonnull Locale locale) {
        return "bucket";
    }

    @Nonnull
    public String getProviderTermForObject(@Nonnull Locale locale) {
        return "object";
    }
}

