/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.security.joyent;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.security.joyent.DefaultClientFactory;
import org.dasein.security.joyent.JoyentClientFactory;

public class AuthClientFactory
extends DefaultClientFactory
implements JoyentClientFactory {
    public AuthClientFactory(ProviderContext providerContext) {
        super(providerContext);
    }

    @Override
    @Nonnull
    public HttpClient getClient(String endpoint) throws CloudException, InternalException {
        int targetPort;
        URI uri;
        if (endpoint == null) {
            throw new CloudException("No cloud endpoint was defined");
        }
        boolean ssl = endpoint.startsWith("https");
        try {
            uri = new URI(endpoint);
            targetPort = uri.getPort();
            if (targetPort < 1) {
                targetPort = ssl ? 443 : 80;
            }
        }
        catch (URISyntaxException e) {
            throw new CloudException((Throwable)e);
        }
        HttpHost targetHost = new HttpHost(uri.getHost(), targetPort, uri.getScheme());
        DefaultHttpClient client = (DefaultHttpClient)super.getClient(endpoint);
        try {
            String userName = new String(this.getProviderContext().getAccessPublic(), "utf-8");
            String password = new String(this.getProviderContext().getAccessPrivate(), "utf-8");
            client.getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(userName, password));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException((Throwable)e);
        }
        return client;
    }
}

