/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.security.joyent;

import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.security.joyent.JoyentHttpAuth;

public class BasicSchemeHttpAuth
implements JoyentHttpAuth {
    private ProviderContext providerContext;

    public BasicSchemeHttpAuth(ProviderContext providerContext) {
        this.providerContext = providerContext;
    }

    @Override
    public void addPreemptiveAuth(@Nonnull HttpRequest request) throws CloudException, InternalException {
        if (this.providerContext == null) {
            throw new CloudException("No context was defined for this request");
        }
        try {
            String username = new String(this.providerContext.getAccessPublic(), "utf-8");
            String password = new String(this.providerContext.getAccessPrivate(), "utf-8");
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            request.addHeader(new BasicScheme().authenticate((Credentials)creds, request));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException((Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new InternalException((Throwable)e);
        }
    }
}

