/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.security.joyent;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.security.joyent.JoyentClientFactory;

public class DefaultClientFactory
implements JoyentClientFactory {
    private final ProviderContext providerContext;

    public DefaultClientFactory(ProviderContext providerContext) {
        this.providerContext = providerContext;
    }

    @Override
    @Nonnull
    public HttpClient getClient(String endpoint) throws CloudException, InternalException {
        if (this.providerContext == null) {
            throw new CloudException("No context was defined for this request");
        }
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)Consts.UTF_8.toString());
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        Properties p = this.providerContext.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPortStr = p.getProperty("proxyPort");
            int proxyPort = 0;
            if (proxyPortStr != null) {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, proxyPort));
            }
        }
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        client.addRequestInterceptor(new HttpRequestInterceptor((HttpParams)params){
            final /* synthetic */ HttpParams val$params;
            {
                this.val$params = httpParams;
            }

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (!request.containsHeader("Accept-Encoding")) {
                    request.addHeader("Accept-Encoding", "gzip");
                }
                request.setParams(this.val$params);
            }
        });
        client.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header header;
                HttpEntity entity = response.getEntity();
                if (entity != null && (header = entity.getContentEncoding()) != null) {
                    for (HeaderElement codec : header.getElements()) {
                        if (!codec.getName().equalsIgnoreCase("gzip")) continue;
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        break;
                    }
                }
            }
        });
        return client;
    }

    protected ProviderContext getProviderContext() {
        return this.providerContext;
    }
}

