/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.security.joyent;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.util.encoders.Base64;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.joyent.SmartDataCenter;
import org.dasein.security.joyent.JoyentHttpAuth;

public class SignatureHttpAuth
implements JoyentHttpAuth {
    private static final DateFormat RFC1123_DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
    private static final String AUTH_HEADER = "Signature keyId=\"/%s/keys/%s\",algorithm=\"rsa-sha256\",signature=\"%s\"";
    private static final String AUTH_SIGN = "date: %s";
    private static final String SIGN_ALGORITHM = "SHA256WithRSAEncryption";
    private SmartDataCenter provider;

    public SignatureHttpAuth(SmartDataCenter provider) {
        this.provider = provider;
    }

    @Override
    public void addPreemptiveAuth(@Nonnull HttpRequest request) throws CloudException, InternalException {
        if (this.provider.getContext() == null) {
            throw new CloudException("No context was defined for this request");
        }
        Date date = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime();
        String now = RFC1123_DATE_FORMAT.format(date);
        request.setHeader("Date", now);
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Signature signature = Signature.getInstance(SIGN_ALGORITHM);
            List fields = this.provider.getContextRequirements().getConfigurableValues();
            String keyName = "";
            String privateKey = "";
            char[] keyPassword = null;
            for (ContextRequirements.Field f : fields) {
                byte[] password;
                if (f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) {
                    byte[][] keyPair = (byte[][])this.provider.getContext().getConfigurationValue(f);
                    keyName = new String(keyPair[0], "utf-8");
                    privateKey = new String(keyPair[1], "utf-8");
                    continue;
                }
                if (!f.type.equals((Object)ContextRequirements.FieldType.PASSWORD) || (password = (byte[])this.provider.getContext().getConfigurationValue(f)) == null) continue;
                keyPassword = new String(password, "utf-8").toCharArray();
            }
            KeyPair keyPair = this.getKeyPair(privateKey, keyPassword);
            if (keyPair == null) {
                throw new InternalException("Unable to generate a key-pair from key data.");
            }
            signature.initSign(keyPair.getPrivate());
            String signingString = String.format(AUTH_SIGN, now);
            signature.update(signingString.getBytes("UTF-8"));
            byte[] signedDate = signature.sign();
            byte[] encodedSignedDate = Base64.encode((byte[])signedDate);
            request.addHeader("Authorization", String.format(AUTH_HEADER, this.provider.getContext().getAccountNumber(), keyName, new String(encodedSignedDate)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException((Throwable)e);
        }
        catch (SignatureException e) {
            throw new InternalException((Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new InternalException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private KeyPair getKeyPair(String privateKeyContent, final @Nullable char[] password) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(privateKeyContent.getBytes());
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        PEMReader pemReader = null;
        pemReader = password != null ? new PEMReader((Reader)reader, new PasswordFinder(){

            public char[] getPassword() {
                return password;
            }
        }) : new PEMReader((Reader)reader);
        try {
            KeyPair keyPair = (KeyPair)pemReader.readObject();
            return keyPair;
        }
        finally {
            reader.close();
            pemReader.close();
        }
    }
}

