/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.nimbula;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.nimbula.NimbulaDirector;
import org.json.JSONException;
import org.json.JSONObject;

public class NimbulaMethod {
    private static final Logger logger = NimbulaDirector.getLogger(NimbulaMethod.class);
    private static final Logger wire = NimbulaDirector.getWireLogger(NimbulaMethod.class);
    private String authCookie = null;
    private NimbulaDirector cloud = null;
    private String response = null;
    private String url = null;

    public NimbulaMethod(@Nonnull NimbulaDirector cloud, @Nonnull String resource) throws CloudException {
        ProviderContext ctx = cloud.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        Properties properties = ctx.getCustomProperties();
        String ignoreCertSignature = null;
        if (properties != null) {
            ignoreCertSignature = properties.getProperty("ignoreCertSignature", "false");
        }
        if (ignoreCertSignature == null || ignoreCertSignature.equalsIgnoreCase("true")) {
            // empty if block
        }
        this.cloud = cloud;
        this.url = cloud.getURL(resource);
        if (properties != null) {
            this.authCookie = properties.getProperty("nimbulaAuthCookie");
        }
        if (this.authCookie != null && this.authCookie.trim().length() < 1) {
            this.authCookie = null;
        }
    }

    @Nonnull
    private HttpClient getClient(@Nonnull ProviderContext ctx, boolean ssl) {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPort = p.getProperty("proxyPort");
            if (proxyHost != null) {
                int port = 0;
                if (proxyPort != null && proxyPort.length() > 0) {
                    port = Integer.parseInt(proxyPort);
                }
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port, ssl ? "https" : "http"));
            }
        }
        return new DefaultHttpClient((HttpParams)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate() throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + NimbulaMethod.class.getName() + ".authenticate()"));
        }
        try {
            if (this.authCookie != null) {
                return;
            }
            String uri = this.cloud.getURL("authenticate") + "/";
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [POST (" + new Date() + ")] -> " + uri + " >--------------------------------------------------------------------------------------"));
            }
            try {
                HttpResponse response;
                ProviderContext ctx = this.cloud.getContext();
                if (ctx == null) {
                    throw new CloudException("Unable to authenticate without a context");
                }
                HttpClient client = this.getClient(ctx, uri.startsWith("https"));
                HttpPost post = new HttpPost(uri);
                HashMap<String, String> request = new HashMap<String, String>();
                try {
                    request.put("user", "/" + ctx.getAccountNumber() + "/" + new String(ctx.getAccessPublic(), "utf-8"));
                    request.put("password", new String(ctx.getAccessPrivate(), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalException((Throwable)e);
                }
                post.addHeader("Accept", "application/nimbula-v2+json");
                try {
                    post.setEntity((HttpEntity)new StringEntity(new JSONObject(request).toString(), "application/nimbula-v2+json", "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalException((Throwable)e);
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)post.getRequestLine().toString());
                    for (Header header : post.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                    try {
                        wire.debug((Object)EntityUtils.toString((HttpEntity)post.getEntity()));
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    wire.debug((Object)"");
                }
                try {
                    response = client.execute((HttpUriRequest)post);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                int code = response.getStatusLine().getStatusCode();
                logger.debug((Object)("HTTP STATUS: " + code));
                if (code != 204) {
                    HttpEntity entity = response.getEntity();
                    String data = "";
                    if (entity != null) {
                        try {
                            data = EntityUtils.toString((HttpEntity)entity);
                        }
                        catch (IOException e) {
                            throw new CloudException((Throwable)e);
                        }
                    }
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)data);
                        wire.debug((Object)"");
                    }
                }
                this.checkResponse(response, code);
            }
            finally {
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [POST (" + new Date() + ")] -> " + uri + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + NimbulaMethod.class.getName() + ".authenticate()"));
            }
        }
    }

    private void checkResponse(@Nonnull HttpResponse response, @Nonnegative int code) throws CloudException, InternalException {
        this.checkResponse(response, code, null);
    }

    @Nonnull
    private String getErrorMessage(@Nullable String body, @Nonnull String defaultMessage) {
        if (body != null) {
            try {
                String ref;
                JSONObject ob = new JSONObject(body);
                String msg = ob.getString("message");
                if (ob.has("reference") && (ref = ob.getString("reference")) != null) {
                    msg = msg + " [reference=" + ref + "]";
                }
                return msg;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultMessage;
    }

    private void checkResponse(@Nonnull HttpResponse response, @Nonnegative int code, @Nullable String responseBody) throws CloudException, InternalException {
        String message;
        ProviderContext ctx = this.cloud.getContext();
        if (ctx == null) {
            throw new CloudException("No context is set for this request");
        }
        Header[] headers = response.getHeaders("Set-Cookie");
        if (headers != null) {
            for (Header header : headers) {
                if (!header.getValue().startsWith("nimbula=")) continue;
                this.authCookie = header.getValue();
                Properties props = ctx.getCustomProperties();
                if (props == null) {
                    props = new Properties();
                    ctx.setCustomProperties(props);
                }
                props.setProperty("nimbulaAuthCookie", this.authCookie);
            }
        }
        switch (code) {
            case 401: {
                message = this.getErrorMessage(responseBody, "You must authenticate before making this call");
                throw new InternalException(code + ": " + message);
            }
            case 403: {
                message = this.getErrorMessage(responseBody, "You do not have access to the requested resource");
                throw new CloudException(code + ": " + message);
            }
            case 404: {
                return;
            }
            case 405: {
                message = this.getErrorMessage(responseBody, "Invalid HTTP method");
                throw new InternalException(code + ": " + message);
            }
            case 406: {
                message = this.getErrorMessage(responseBody, "Invalid request for resource");
                throw new InternalException(code + ": " + message);
            }
            case 409: {
                message = this.getErrorMessage(responseBody, "A conflict exists with the resource you were accessing");
                throw new CloudException(code + ": " + message);
            }
            case 410: {
                message = this.getErrorMessage(responseBody, "The resource you are referencing no longer exists");
                throw new CloudException(code + ": " + message);
            }
            case 415: {
                message = this.getErrorMessage(responseBody, "Request is not JSON");
                throw new InternalException(code + ": " + message);
            }
        }
        if (code >= 500) {
            message = this.getErrorMessage(responseBody, "Unknown error");
            throw new CloudException(code + ": " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int delete(@Nonnull String target) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + NimbulaMethod.class.getName() + ".delete(" + target + ")"));
        }
        try {
            int n;
            this.authenticate();
            String service = this.getUrl(this.url, target);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [DELETE (" + new Date() + ")] -> " + service + " >--------------------------------------------------------------------------------------"));
            }
            try {
                HttpResponse response;
                ProviderContext ctx = this.cloud.getContext();
                if (ctx == null) {
                    throw new CloudException("No context was set for this request");
                }
                HttpClient client = this.getClient(ctx, service.startsWith("https"));
                HttpDelete delete = new HttpDelete(service);
                delete.addHeader("Accept", "application/nimbula-v2+json");
                delete.setHeader("Cookie", this.authCookie);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)delete.getRequestLine().toString());
                    for (Header header : delete.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
                try {
                    response = client.execute((HttpUriRequest)delete);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                int code = response.getStatusLine().getStatusCode();
                logger.debug((Object)("HTTP STATUS: " + code));
                this.checkResponse(response, code);
                n = code;
            }
            catch (Throwable throwable) {
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [DELETE (" + new Date() + ")] -> " + service + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
                throw throwable;
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [DELETE (" + new Date() + ")] -> " + service + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
            return n;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + NimbulaMethod.class.getName() + ".delete()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int get(@Nonnull String target) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + NimbulaMethod.class.getName() + ".get(" + target + ")"));
        }
        try {
            HttpEntity entity;
            int code;
            HttpResponse response;
            block25: {
                int len$;
                this.authenticate();
                target = !target.startsWith("/") ? this.getUrl(this.url, target) : this.url + target;
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)"");
                    wire.debug((Object)(">>> [GET (" + new Date() + ")] -> " + target + " >--------------------------------------------------------------------------------------"));
                }
                try {
                    ProviderContext ctx = this.cloud.getContext();
                    if (ctx == null) {
                        throw new CloudException("No context was set for this request");
                    }
                    HttpClient client = this.getClient(ctx, target.startsWith("https"));
                    HttpGet get = new HttpGet(target);
                    get.addHeader("Accept", "application/nimbula-v2+json");
                    get.setHeader("Cookie", this.authCookie);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)get.getRequestLine().toString());
                        for (Header header : get.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                    try {
                        response = client.execute((HttpUriRequest)get);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)response.getStatusLine().toString());
                            for (Header header : response.getAllHeaders()) {
                                wire.debug((Object)(header.getName() + ": " + header.getValue()));
                            }
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                        e.printStackTrace();
                        throw new InternalException((Throwable)e);
                    }
                    code = response.getStatusLine().getStatusCode();
                    logger.debug((Object)("HTTP STATUS: " + code));
                    if (code != 401) break block25;
                    len$ = code;
                }
                catch (Throwable throwable) {
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + target + " <--------------------------------------------------------------------------------------"));
                        wire.debug((Object)"");
                    }
                    throw throwable;
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + target + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
                return len$;
            }
            if (code != 204 && (entity = response.getEntity()) != null) {
                try {
                    this.response = EntityUtils.toString((HttpEntity)entity);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)this.response);
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    throw new CloudException((Throwable)e);
                }
            }
            this.checkResponse(response, code);
            int n = code;
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + target + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
            return n;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + NimbulaMethod.class.getName() + ".get()"));
            }
        }
    }

    @Nonnull
    public JSONObject getResponseBody() throws JSONException {
        return new JSONObject(this.response);
    }

    @Nonnull
    private String getUrl(@Nonnull String endpoint, @Nullable String id) throws CloudException, InternalException {
        ProviderContext ctx = this.cloud.getContext();
        if (ctx == null) {
            throw new CloudException("No context is set for this request");
        }
        try {
            String user = new String(ctx.getAccessPublic(), "utf-8");
            String account = ctx.getAccountNumber();
            if (!endpoint.endsWith("/")) {
                if (id != null && id.startsWith("/")) {
                    return endpoint + id;
                }
                if (id != null) {
                    return endpoint + "/" + account + "/" + user + "/" + id;
                }
                return endpoint + "/" + account + "/" + user;
            }
            if (id != null && id.startsWith("/")) {
                if (id.equals("/")) {
                    return endpoint;
                }
                return endpoint + id.substring(1);
            }
            if (id != null) {
                return endpoint + id;
            }
            return endpoint + account + "/" + user;
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int list() throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + NimbulaMethod.class.getName() + ".list()"));
        }
        try {
            int n;
            ProviderContext ctx = this.cloud.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            this.authenticate();
            String target = this.url.endsWith("info") ? this.url + "/" : this.url + "/" + ctx.getAccountNumber() + "/";
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [GET (" + new Date() + ")] -> " + target + " >--------------------------------------------------------------------------------------"));
            }
            try {
                HttpEntity entity;
                HttpResponse response;
                HttpClient client = this.getClient(ctx, target.startsWith("https"));
                HttpGet get = new HttpGet(target);
                get.addHeader("Accept", "application/nimbula-v2+json");
                get.setHeader("Cookie", this.authCookie);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)get.getRequestLine().toString());
                    for (Header header : get.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
                try {
                    response = client.execute((HttpUriRequest)get);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                int code = response.getStatusLine().getStatusCode();
                logger.debug((Object)("HTTP STATUS: " + code));
                if (code != 204 && (entity = response.getEntity()) != null) {
                    try {
                        this.response = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)this.response);
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        throw new CloudException((Throwable)e);
                    }
                }
                this.checkResponse(response, code);
                n = code;
            }
            catch (Throwable throwable) {
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + target + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
                throw throwable;
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + target + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
            return n;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + NimbulaMethod.class.getName() + ".list()"));
            }
        }
    }

    @Nonnegative
    public int discover() throws CloudException, InternalException {
        return this.discover(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int discover(@Nullable String userId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + NimbulaMethod.class.getName() + ".discover(" + userId + ")"));
        }
        try {
            int n;
            this.authenticate();
            ProviderContext ctx = this.cloud.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            String target = "/" + ctx.getAccountNumber() + "/";
            if (userId != null) {
                target = target + userId + "/";
            }
            target = this.url + target;
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [GET (" + new Date() + ")] -> " + target + " >--------------------------------------------------------------------------------------"));
            }
            try {
                HttpEntity entity;
                HttpResponse response;
                HttpClient client = this.getClient(ctx, target.startsWith("https"));
                HttpGet get = new HttpGet(target);
                get.addHeader("Accept", "application/nimbula-v2+directory+json");
                get.setHeader("Cookie", this.authCookie);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)get.getRequestLine().toString());
                    for (Header header : get.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
                try {
                    response = client.execute((HttpUriRequest)get);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                int code = response.getStatusLine().getStatusCode();
                logger.debug((Object)("HTTP STATUS: " + code));
                if (code != 204 && (entity = response.getEntity()) != null) {
                    try {
                        this.response = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)this.response);
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        throw new CloudException((Throwable)e);
                    }
                }
                this.checkResponse(response, code);
                n = code;
            }
            catch (Throwable throwable) {
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + target + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
                throw throwable;
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + target + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
            return n;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + NimbulaMethod.class.getName() + ".discover()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int post(@Nonnull Map<String, Object> state) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + NimbulaMethod.class.getName() + ".post(" + state + ")"));
        }
        try {
            int n;
            this.authenticate();
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [POST (" + new Date() + ")] -> " + this.url + "/ >--------------------------------------------------------------------------------------"));
            }
            try {
                HttpResponse response;
                ProviderContext ctx = this.cloud.getContext();
                if (ctx == null) {
                    throw new CloudException("No context was set for this request");
                }
                HttpClient client = this.getClient(ctx, this.url.startsWith("https"));
                HttpPost post = new HttpPost(this.url + "/");
                post.setHeader("Cookie", this.authCookie);
                post.addHeader("Accept", "application/nimbula-v2+json");
                try {
                    post.setEntity((HttpEntity)new StringEntity(new JSONObject(state).toString(), "application/nimbula-v2+json", "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalException((Throwable)e);
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)post.getRequestLine().toString());
                    for (Header header : post.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                    try {
                        wire.debug((Object)EntityUtils.toString((HttpEntity)post.getEntity()));
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    wire.debug((Object)"");
                }
                try {
                    response = client.execute((HttpUriRequest)post);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                int code = response.getStatusLine().getStatusCode();
                logger.debug((Object)("HTTP STATUS: " + code));
                if (code != 204) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        try {
                            this.response = EntityUtils.toString((HttpEntity)entity);
                        }
                        catch (IOException e) {
                            throw new CloudException((Throwable)e);
                        }
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)this.response);
                            wire.debug((Object)"");
                        }
                    }
                    this.checkResponse(response, code, this.response);
                } else {
                    this.checkResponse(response, code);
                }
                n = code;
            }
            catch (Throwable throwable) {
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [POST (" + new Date() + ")] -> " + this.url + "/ <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
                throw throwable;
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [POST (" + new Date() + ")] -> " + this.url + "/ <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
            return n;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + NimbulaMethod.class.getName() + ".post()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int put(@Nonnull String targetId, @Nonnull Map<String, Object> state) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + NimbulaMethod.class.getName() + ".put(" + targetId + "," + state + ")"));
        }
        try {
            int n;
            this.authenticate();
            String target = this.getUrl(this.url, targetId);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [PUT (" + new Date() + ")] -> " + target + " >--------------------------------------------------------------------------------------"));
            }
            try {
                HttpResponse response;
                ProviderContext ctx = this.cloud.getContext();
                if (ctx == null) {
                    throw new CloudException("No context was set for this request");
                }
                HttpClient client = this.getClient(ctx, target.startsWith("https"));
                HttpPut put = new HttpPut(target);
                put.addHeader("Content-Type", "application/json");
                put.setHeader("Cookie", this.authCookie);
                try {
                    put.setEntity((HttpEntity)new StringEntity(new JSONObject(state).toString(), "application/json", "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalException((Throwable)e);
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)put.getRequestLine().toString());
                    for (Header header : put.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                    try {
                        wire.debug((Object)EntityUtils.toString((HttpEntity)put.getEntity()));
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    wire.debug((Object)"");
                }
                try {
                    response = client.execute((HttpUriRequest)put);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                int code = response.getStatusLine().getStatusCode();
                logger.debug((Object)("HTTP STATUS: " + code));
                if (code != 204) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        try {
                            this.response = EntityUtils.toString((HttpEntity)entity);
                        }
                        catch (IOException e) {
                            throw new CloudException((Throwable)e);
                        }
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)this.response);
                            wire.debug((Object)"");
                        }
                    }
                    this.checkResponse(response, code, this.response);
                } else {
                    this.checkResponse(response, code);
                }
                n = code;
            }
            catch (Throwable throwable) {
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [PUT (" + new Date() + ")] -> " + this.url + "/ <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
                throw throwable;
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [PUT (" + new Date() + ")] -> " + this.url + "/ <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
            return n;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + NimbulaMethod.class.getName() + ".put()"));
            }
        }
    }
}

