/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.nimbula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.nimbula.NimbulaDirector;
import org.dasein.cloud.nimbula.NimbulaMethod;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Site
implements DataCenterServices {
    private NimbulaDirector cloud = null;

    public Site(@Nonnull NimbulaDirector cloud) {
        this.cloud = cloud;
    }

    @Nullable
    public DataCenter getDataCenter(@Nonnull String dcId) throws InternalException, CloudException {
        ProviderContext ctx = this.cloud.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this context");
        }
        for (DataCenter dc : this.listDataCenters(regionId)) {
            if (!dcId.equals(dc.getProviderDataCenterId())) continue;
            return dc;
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "data center";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "site";
    }

    @Nullable
    public Region getRegion(@Nonnull String siteId) throws InternalException, CloudException {
        for (Region region : this.listRegions()) {
            if (!region.getProviderRegionId().equals(siteId)) continue;
            return region;
        }
        return null;
    }

    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String siteId) throws InternalException, CloudException {
        Region region = this.getRegion(siteId);
        if (region == null) {
            throw new CloudException("No such region: " + siteId);
        }
        DataCenter dc = new DataCenter();
        dc.setActive(true);
        dc.setAvailable(true);
        dc.setName(region.getName() + " (DC)");
        dc.setProviderDataCenterId(region.getProviderRegionId());
        dc.setRegionId(region.getProviderRegionId());
        return Collections.singletonList(dc);
    }

    @Nonnull
    public Collection<Region> listRegions() throws InternalException, CloudException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, "info");
        method.list();
        try {
            ArrayList<Region> regions = new ArrayList<Region>();
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                Region region = this.toRegion(array.getJSONObject(i));
                if (region == null) continue;
                regions.add(region);
            }
            return regions;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    private Region toRegion(@Nullable JSONObject json) throws CloudException {
        if (json == null) {
            return null;
        }
        try {
            String name;
            String string = name = json.has("name") ? json.getString("name") : null;
            if (name == null || name.length() < 1) {
                return null;
            }
            Region region = new Region();
            region.setActive(true);
            region.setAvailable(true);
            region.setJurisdiction("US");
            region.setName(name);
            region.setProviderRegionId(name);
            return region;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }
}

