/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.nimbula.compute;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.nimbula.NimbulaDirector;
import org.dasein.cloud.nimbula.NimbulaMethod;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Image
implements MachineImageSupport {
    private static final Logger logger = NimbulaDirector.getLogger(Image.class);
    public static final String IMAGELIST = "imagelist";
    public static final String MACHINEIMAGE = "machineimage";
    private NimbulaDirector cloud;

    Image(@Nonnull NimbulaDirector cloud) {
        this.cloud = cloud;
    }

    public void downloadImage(@Nonnull String machineImageId, @Nonnull OutputStream toOutput) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Nullable
    public MachineImage getMachineImage(@Nonnull String machineImageId) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, MACHINEIMAGE);
        int code = method.get(machineImageId);
        if (code == 404 || code == 401) {
            return null;
        }
        try {
            return this.toMachineImage(method.getResponseBody());
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    public String getMachineImageId(@Nonnull String imagelist, @Nonnegative int entryNumber) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, IMAGELIST);
        method.get(imagelist);
        try {
            JSONObject item = method.getResponseBody();
            JSONArray entries = item.getJSONArray("entries");
            for (int i = 0; i < entries.length(); ++i) {
                JSONObject entry = entries.getJSONObject(i);
                JSONArray images = entry.getJSONArray("machineimages");
                if (images.length() < entryNumber) continue;
                return images.getString(entryNumber - 1);
            }
            return null;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale) {
        return "machine image";
    }

    public boolean hasPublicLibrary() {
        return true;
    }

    @Nonnull
    public AsynchronousTask<String> imageVirtualMachine(@Nonnull String vmId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Imaging not yet supported");
    }

    @Nonnull
    public AsynchronousTask<String> imageVirtualMachineToStorage(@Nonnull String vmId, @Nonnull String name, @Nonnull String description, String directory) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Imaging not yet supported");
    }

    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        return machineImageId.startsWith("/nimbula/public");
    }

    @Nonnull
    public String installImageFromUpload(@Nonnull MachineImageFormat format, @Nonnull InputStream imageStream) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Imaging not yet supported");
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<MachineImage> listMachineImages() throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, MACHINEIMAGE);
        method.list();
        try {
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                MachineImage image = this.toMachineImage(array.getJSONObject(i));
                if (image == null) continue;
                images.add(image);
            }
            return images;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public Iterable<MachineImage> listMachineImagesOwnedBy(@Nullable String accountId) throws CloudException, InternalException {
        if (accountId == null) {
            accountId = "/nimbula/public/";
        } else if (!accountId.endsWith("/")) {
            accountId = accountId + "/";
        }
        NimbulaMethod method = new NimbulaMethod(this.cloud, MACHINEIMAGE);
        int code = method.get(accountId);
        if (code == 401) {
            return Collections.emptyList();
        }
        try {
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                MachineImage image = this.toMachineImage(array.getJSONObject(i));
                if (image == null) continue;
                images.add(image);
            }
            return images;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String forMachineImageId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.NIMBULA);
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    private boolean matches(MachineImage image, String keyword, Platform platform, Architecture architecture) {
        if (architecture != null && !architecture.equals((Object)image.getArchitecture())) {
            return false;
        }
        if (platform != null && !platform.equals((Object)Platform.UNKNOWN)) {
            Platform mine = image.getPlatform();
            if (platform.isWindows() && !mine.isWindows()) {
                return false;
            }
            if (platform.isUnix() && !mine.isUnix()) {
                return false;
            }
            if (platform.isBsd() && !mine.isBsd()) {
                return false;
            }
            if (platform.isLinux() && !mine.isLinux()) {
                return false;
            }
            if (platform.equals((Object)Platform.UNIX) ? !mine.isUnix() : !platform.equals((Object)mine)) {
                return false;
            }
        }
        if (keyword != null) {
            keyword = keyword.toLowerCase();
            if (!(image.getDescription().toLowerCase().contains(keyword) || image.getName().toLowerCase().contains(keyword) || image.getProviderMachineImageId().toLowerCase().contains(keyword))) {
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public String registerMachineImage(@Nonnull String atStorageLocation) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No registering machine images at any storage location");
    }

    public void remove(@Nonnull String machineImageId) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, MACHINEIMAGE);
        method.delete(machineImageId);
    }

    @Nonnull
    public Iterable<MachineImage> searchMachineImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture) throws CloudException, InternalException {
        final String k = keyword;
        final Platform p = platform;
        final Architecture a = architecture;
        this.cloud.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<MachineImage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<MachineImage> iterator) throws Exception {
                try {
                    for (MachineImage image : Image.this.listMachineImages()) {
                        if (!Image.this.matches(image, k, p, a)) continue;
                        iterator.push((Object)image);
                    }
                    for (MachineImage image : Image.this.listMachineImagesOwnedBy(null)) {
                        if (!Image.this.matches(image, k, p, a)) continue;
                        iterator.push((Object)image);
                    }
                }
                finally {
                    Image.this.cloud.release();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    public void shareMachineImage(@Nonnull String machineImageId, @Nonnull String withAccountId, boolean allow) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Nimbula does not support image sharing of any kind.");
    }

    public boolean supportsCustomImages() {
        return false;
    }

    public boolean supportsImageSharing() {
        return false;
    }

    public boolean supportsImageSharingWithPublic() {
        return false;
    }

    @Nullable
    private MachineImage toMachineImage(@Nonnull JSONObject ob) throws JSONException, CloudException {
        ProviderContext ctx = this.cloud.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        if (!ob.has("name")) {
            return null;
        }
        MachineImage image = new MachineImage();
        String name = ob.getString("name");
        String[] idInfo = this.cloud.parseId(name);
        image.setProviderOwnerId(idInfo[0]);
        image.setProviderMachineImageId(name);
        image.setName(idInfo[2]);
        Platform platform = Platform.UNKNOWN;
        try {
            JSONObject attrs = ob.getJSONObject("attributes");
            platform = Platform.guess((String)attrs.getString("type"));
            image.setDescription(idInfo[2] + " (" + attrs.getString("type") + ")");
        }
        catch (Throwable ignore) {
            image.setDescription(idInfo[2]);
        }
        image.setPlatform(platform);
        image.setArchitecture(Architecture.I64);
        image.setCurrentState(MachineImageState.ACTIVE);
        image.setProviderRegionId(regionId);
        image.setSoftware("");
        image.setType(MachineImageType.STORAGE);
        return image;
    }

    @Nonnull
    public String transfer(@Nonnull CloudProvider fromCloud, @Nonnull String machineImageId) throws CloudException, InternalException {
        throw new CloudException("No transfers supported");
    }
}

