/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.nimbula.compute;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.Tag;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VmStatistics;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.nimbula.NimbulaDirector;
import org.dasein.cloud.nimbula.NimbulaMethod;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Instance
implements VirtualMachineSupport {
    private static final Logger logger = NimbulaDirector.getLogger(Instance.class);
    public static final String INSTANCE = "instance";
    public static final String LAUNCHPLAN = "launchplan";
    public static final String SHAPE = "shape";
    private NimbulaDirector cloud;

    Instance(@Nonnull NimbulaDirector cloud) {
        this.cloud = cloud;
    }

    public void unpause(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Pause/unpause is not supported");
    }

    @Nonnull
    public VirtualMachine clone(@Nonnull String vmId, @Nonnull String intoDcId, @Nonnull String name, @Nonnull String description, boolean powerOn, String ... firewallIds) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Cloning is not currently supported.");
    }

    public void disableAnalytics(String vmId) throws InternalException, CloudException {
    }

    public void enableAnalytics(String vmId) throws InternalException, CloudException {
    }

    @Nonnull
    public String getConsoleOutput(@Nonnull String vmId) throws InternalException, CloudException {
        return "";
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -2;
    }

    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, SHAPE);
        int code = method.get("/" + productId);
        if (code == 404 || code == 401) {
            return null;
        }
        try {
            return this.toProduct(method.getResponseBody());
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public String getProviderTermForServer(@Nonnull Locale locale) {
        return INSTANCE;
    }

    @Nonnull
    public VmStatistics getVMStatistics(@Nonnull String vmId, long from, long to) throws InternalException, CloudException {
        return new VmStatistics();
    }

    @Nonnull
    public Iterable<VmStatistics> getVMStatisticsForPeriod(@Nonnull String vmId, long from, long to) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Requirement identifyPasswordRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String vmId) throws InternalException, CloudException {
        try {
            return this.toVirtualMachine(this.getInstance(vmId));
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    private JSONObject getInstance(String vmId) throws InternalException, CloudException, JSONException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, INSTANCE);
        int code = method.get(vmId);
        if (code == 404 || code == 401) {
            return null;
        }
        return method.getResponseBody();
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, INSTANCE);
        try {
            method.list();
            return true;
        }
        catch (CloudException e) {
            String msg = e.getMessage();
            if (msg.startsWith("401:") || msg.startsWith("403:")) {
                return false;
            }
            throw e;
        }
        catch (InternalException e) {
            String msg = e.getMessage();
            if (msg.startsWith("401:") || msg.startsWith("403:")) {
                return false;
            }
            throw e;
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error testing subscription: " + e.getMessage()));
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("Error testing subscription: " + e.getMessage()));
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return false;
    }

    private LaunchInfo getLaunchInfo(String imageId) throws CloudException, InternalException {
        String[] idInfo = this.cloud.parseId(imageId);
        NimbulaMethod method = new NimbulaMethod(this.cloud, "imagelist");
        method.get("/" + idInfo[0] + "/" + idInfo[1] + "/");
        try {
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                JSONObject ob = array.getJSONObject(i);
                JSONArray entries = ob.getJSONArray("entries");
                String imageList = ob.getString("name");
                for (int j = 0; j < entries.length(); ++j) {
                    JSONObject entry = entries.getJSONObject(j);
                    JSONArray images = entry.getJSONArray("machineimages");
                    for (int k = 0; k < images.length(); ++k) {
                        String id = images.getString(k);
                        if (!id.equals(imageId)) continue;
                        LaunchInfo launchInfo = new LaunchInfo();
                        launchInfo.entry = k + 1;
                        launchInfo.imageList = imageList;
                        return launchInfo;
                    }
                }
            }
            return null;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull String fromMachineImageId, @Nonnull VirtualMachineProduct product, @Nonnull String dataCenterId, @Nonnull String name, @Nonnull String description, @Nullable String withKeypairId, @Nullable String inVlanId, boolean withAnalytics, boolean asSandbox, String ... firewalls) throws InternalException, CloudException {
        return this.launch(fromMachineImageId, product, dataCenterId, name, description, withKeypairId, inVlanId, withAnalytics, asSandbox, firewalls, new Tag[0]);
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull String fromMachineImageId, @Nonnull VirtualMachineProduct product, @Nonnull String dataCenterId, @Nonnull String name, @Nonnull String description, @Nullable String withKeypairId, String inVlanId, boolean withAnalytics, boolean asSandbox, @Nullable String[] firewalls, Tag ... tags) throws InternalException, CloudException {
        VMLaunchOptions options = inVlanId == null ? VMLaunchOptions.getInstance((String)product.getProviderProductId(), (String)fromMachineImageId, (String)name, (String)description).inDataCenter(dataCenterId) : VMLaunchOptions.getInstance((String)product.getProviderProductId(), (String)fromMachineImageId, (String)name, (String)description).inVlan(null, dataCenterId, inVlanId);
        if (withKeypairId != null) {
            options = options.withBoostrapKey(withKeypairId);
        }
        if (tags != null) {
            for (Tag t : tags) {
                options = options.withMetaData(t.getKey(), (Object)t.getValue());
            }
        }
        if (firewalls != null) {
            options = options.behindFirewalls(firewalls);
        }
        return this.launch(options);
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions options) throws CloudException, InternalException {
        HashMap<String, Object> state = new HashMap<String, Object>();
        LaunchInfo launch = this.getLaunchInfo(options.getMachineImageId());
        state.put("relationships", new ArrayList());
        ArrayList targets = new ArrayList();
        HashMap<String, Object> plan = new HashMap<String, Object>();
        plan.put("label", options.getFriendlyName());
        plan.put(SHAPE, options.getStandardProductId());
        plan.put("imagelist", launch.imageList);
        plan.put("entry", launch.entry);
        if (options.getFirewallIds().length > 0) {
            ArrayList ids = new ArrayList();
            Collections.addAll(ids, options.getFirewallIds());
            plan.put("seclists", ids);
        }
        targets.add(plan);
        state.put("instances", targets);
        NimbulaMethod method = new NimbulaMethod(this.cloud, LAUNCHPLAN);
        method.post(state);
        try {
            JSONArray instances = method.getResponseBody().getJSONArray("instances");
            if (instances.length() < 1) {
                throw new CloudException("Cloud failed to launch any instances without comment.");
            }
            VirtualMachine vm = this.toVirtualMachine(instances.getJSONObject(0));
            if (vm == null) {
                throw new CloudException("No virtual machine was created, but no error was specified");
            }
            return vm;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        try {
            JSONObject ob = this.getInstance(vmId);
            if (ob == null || !ob.has("name")) {
                throw new CloudException("No such instance: " + vmId);
            }
            if (!ob.has("seclists")) {
                return Collections.emptyList();
            }
            ArrayList<String> ids = new ArrayList<String>();
            JSONArray arr = ob.getJSONArray("seclists");
            for (int i = 0; i < arr.length(); ++i) {
                ids.add(arr.getString(i));
            }
            return ids;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull Architecture architecture) throws InternalException, CloudException {
        if (architecture.equals((Object)Architecture.I32)) {
            return Collections.emptyList();
        }
        NimbulaMethod method = new NimbulaMethod(this.cloud, SHAPE);
        method.list();
        try {
            ArrayList<VirtualMachineProduct> products = new ArrayList<VirtualMachineProduct>();
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                products.add(this.toProduct(array.getJSONObject(i)));
            }
            return products;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        return Collections.singletonList(Architecture.I64);
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, INSTANCE);
        method.list();
        try {
            ArrayList<VirtualMachine> vms = new ArrayList<VirtualMachine>();
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                VirtualMachine vm = this.toVirtualMachine(array.getJSONObject(i));
                if (vm == null) continue;
                vms.add(vm);
            }
            return vms;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    public void pause(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Pause/unpause not supported");
    }

    public void reboot(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Reboots not supported");
    }

    public void resume(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Suspend/resume not supported");
    }

    public void start(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Start/stop not supported");
    }

    public void stop(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Start/stop not supported");
    }

    public boolean supportsAnalytics() {
        return false;
    }

    public boolean supportsPauseUnpause(@Nonnull VirtualMachine vm) {
        return false;
    }

    public boolean supportsStartStop(@Nonnull VirtualMachine vm) {
        return false;
    }

    public boolean supportsSuspendResume(@Nonnull VirtualMachine vm) {
        return false;
    }

    public void suspend(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Suspend/resume not supported");
    }

    public void terminate(@Nonnull String vmId) throws InternalException, CloudException {
        long timeout = System.currentTimeMillis() + 1200000L;
        NimbulaMethod method = new NimbulaMethod(this.cloud, INSTANCE);
        VirtualMachine vm = this.getVirtualMachine(vmId);
        while (timeout > System.currentTimeMillis() && vm != null && VmState.PENDING.equals((Object)vm.getCurrentState())) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            vm = this.getVirtualMachine(vmId);
        }
        method.delete(vmId);
        while (timeout > System.currentTimeMillis()) {
            if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState())) {
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            vm = this.getVirtualMachine(vmId);
        }
        throw new CloudException("The system timed out waiting for the virtual machine to terminate");
    }

    @Nonnull
    private VirtualMachineProduct toProduct(@Nonnull JSONObject ob) throws JSONException {
        VirtualMachineProduct product = new VirtualMachineProduct();
        product.setProviderProductId(ob.getString("name"));
        product.setRamSize(new Storage((Number)ob.getInt("ram"), (StorageUnit)Storage.MEGABYTE));
        if (ob.has("cpus")) {
            product.setCpuCount((int)ob.getDouble("cpus"));
        }
        if (product.getCpuCount() < 1) {
            product.setCpuCount(1);
        }
        product.setDescription(ob.getString("name"));
        product.setName(ob.getString("name"));
        product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
        if (product.getRamSize().intValue() < 256) {
            product.setRamSize(new Storage((Number)256, (StorageUnit)Storage.MEGABYTE));
        }
        return product;
    }

    @Nonnull
    private VmState toState(@Nonnull String value) {
        if (value.equalsIgnoreCase("running")) {
            return VmState.RUNNING;
        }
        if (value.equalsIgnoreCase("initializing") || value.equalsIgnoreCase("starting") || value.equalsIgnoreCase("queued")) {
            return VmState.PENDING;
        }
        if (value.equalsIgnoreCase("terminating")) {
            return VmState.STOPPING;
        }
        logger.warn((Object)("DEBUG: Unknown Nimbula VM state: " + value));
        return VmState.PENDING;
    }

    @Nullable
    private VirtualMachine toVirtualMachine(@Nullable JSONObject ob) throws JSONException, InternalException, CloudException {
        if (ob == null) {
            return null;
        }
        ProviderContext ctx = this.cloud.getContext();
        if (ctx == null) {
            throw new CloudException("No context set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        String desc = ob.getString("name");
        VirtualMachine vm = new VirtualMachine();
        String[] idInfo = this.cloud.parseId(ob.getString("name"));
        vm.setProviderRegionId(regionId);
        vm.setProviderDataCenterId(regionId);
        vm.setProductId(ob.getString(SHAPE));
        vm.setClonable(false);
        vm.setImagable(true);
        vm.setPausable(false);
        vm.setPersistent(false);
        vm.setArchitecture(Architecture.I64);
        vm.setRebootable(false);
        vm.setCurrentState(this.toState(ob.getString("state")));
        vm.setDescription(ob.getString("label") + " [" + desc + "]");
        vm.setLastPauseTimestamp(-1L);
        vm.setName(ob.getString("label"));
        vm.setPlatform(Platform.UNKNOWN);
        vm.setPrivateDnsAddress(null);
        try {
            String ip = ob.getString("ip");
            if (ip != null) {
                vm.setPrivateIpAddresses(new String[]{ip});
            }
        }
        catch (JSONException ignore) {
            // empty catch block
        }
        try {
            String startTime = ob.getString("start_time");
            if (startTime != null) {
                try {
                    long ts = this.cloud.parseTimestamp(startTime);
                    vm.setCreationTimestamp(ts);
                    vm.setLastBootTimestamp(ts);
                }
                catch (ParseException e) {
                    logger.warn((Object)("Error parsing time: " + startTime));
                }
            }
        }
        catch (JSONException ignore) {
            // empty catch block
        }
        vm.setProviderAssignedIpAddressId(null);
        String imagelist = ob.getString("imagelist");
        String entry = ob.getString("entry");
        vm.setProviderMachineImageId(this.cloud.getComputeServices().getImageSupport().getMachineImageId(imagelist, Integer.parseInt(entry)));
        vm.setProviderOwnerId(idInfo[0]);
        vm.setProviderVirtualMachineId(ob.getString("name"));
        vm.setPublicDnsAddress(null);
        vm.setPublicIpAddresses(new String[0]);
        vm.setRootPassword(null);
        vm.setRootUser(null);
        vm.setTerminationTimestamp(-1L);
        return vm;
    }

    private static class LaunchInfo {
        public int entry;
        public String imageList;

        private LaunchInfo() {
        }
    }
}

