/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.nimbula.network;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.nimbula.NimbulaDirector;
import org.dasein.cloud.nimbula.NimbulaMethod;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SecurityList
implements FirewallSupport {
    private static final Logger logger = NimbulaDirector.getLogger(SecurityList.class);
    public static final String SECURITY_APPLICATION = "secapplication";
    public static final String SECURITY_IP_LIST = "seciplist";
    public static final String SECURITY_LIST = "seclist";
    public static final String SECURITY_RULES = "secrule";
    private NimbulaDirector provider;

    SecurityList(@Nonnull NimbulaDirector provider) {
        this.provider = provider;
    }

    private String createApplication(Protocol protocol, String dport) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_APPLICATION);
        HashMap<String, Object> state = new HashMap<String, Object>();
        String name = protocol.name().toLowerCase();
        state.put("protocol", name);
        state.put("dport", dport);
        state.put("uri", null);
        name = name + dport.replaceAll("-", "_");
        state.put("name", this.provider.getNamePrefix() + "/dsn_" + name);
        state.put("icmptype", "");
        state.put("icmpcode", "");
        method.post(state);
        try {
            JSONObject ob = method.getResponseBody();
            return ob.getString("name");
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new CloudException((Throwable)e);
        }
    }

    private String createList(String cidr) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_IP_LIST);
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("secipentries", Collections.singletonList(cidr));
        state.put("uri", null);
        state.put("name", this.provider.getNamePrefix() + "/dsn" + cidr.replaceAll("\\.", "_").replaceAll("/", "_"));
        method.post(state);
        try {
            JSONObject ob = method.getResponseBody();
            return ob.getString("name");
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new CloudException((Throwable)e);
        }
    }

    private String getApplicationId(Protocol protocol, int startPort, int endPort, boolean create) throws InternalException, CloudException {
        String dport = String.valueOf(startPort);
        if (endPort > startPort) {
            dport = dport + "-" + endPort;
        }
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_APPLICATION);
        method.list();
        try {
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                JSONObject ob = array.getJSONObject(i);
                if (!ob.has("protocol") || !ob.getString("protocol").equals(protocol.name().toLowerCase()) || !ob.has("dport") || !ob.getString("dport").equals(dport)) continue;
                return ob.getString("name");
            }
            if (create) {
                return this.createApplication(protocol, dport);
            }
            return null;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    private String getIpListId(String forCidr, boolean create) throws InternalException, CloudException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_IP_LIST);
        method.list();
        try {
            JSONArray array = method.getResponseBody().getJSONArray("result");
            String ipListId = null;
            for (int i = 0; i < array.length(); ++i) {
                String entry;
                JSONArray entries;
                JSONObject ob = array.getJSONObject(i);
                if (!ob.has("secipentries") || (entries = ob.getJSONArray("secipentries")).length() != 1 || !(entry = entries.getString(0)).equals(forCidr)) continue;
                ipListId = ob.getString("name");
            }
            if (ipListId == null && create) {
                ipListId = this.createList(forCidr);
            }
            return ipListId;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        return this.authorize(firewallId, Direction.INGRESS, cidr, protocol, beginPort, endPort);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_RULES);
        String ipListId = this.getIpListId(cidr, true);
        String appId = this.getApplicationId(protocol, beginPort, endPort, true);
        String ruleId = this.provider.getNamePrefix() + "/dsn_" + protocol.name() + "_" + System.currentTimeMillis() + "_" + beginPort + "_" + endPort;
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("dst_list", "seclist:" + firewallId);
        state.put("src_list", "seciplist:" + ipListId);
        state.put("uri", null);
        state.put("application", appId);
        state.put("action", "PERMIT");
        state.put("name", ruleId);
        method.post(state);
        return ruleId;
    }

    private String toSecurityListName(String rawName) throws CloudException, InternalException {
        StringBuilder str = new StringBuilder();
        rawName = rawName.toLowerCase();
        for (int i = 0; i < rawName.length(); ++i) {
            char c = rawName.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            str.append(c);
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        if (str.length() > 0) {
            String acct = ctx.getAccountNumber();
            try {
                String user = new String(ctx.getAccessPublic(), "utf-8");
                return "/" + acct + "/" + user + "/" + str.toString();
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e);
            }
        }
        throw new CloudException("Invalid name: " + rawName);
    }

    @Nonnull
    public String create(@Nonnull String name, @Nonnull String description) throws InternalException, CloudException {
        Firewall firewall;
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_LIST);
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("policy", "");
        state.put("uri", null);
        state.put("outbound_cidr_policy", "");
        state.put("name", this.toSecurityListName(name));
        method.post(state);
        try {
            firewall = this.toFirewall(method.getResponseBody());
            if (firewall == null) {
                throw new CloudException("No firewall was part of the response");
            }
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new CloudException((Throwable)e);
        }
        return firewall.getProviderFirewallId();
    }

    @Nonnull
    public String createInVLAN(@Nonnull String name, @Nonnull String description, @Nonnull String providerVlanId) throws InternalException, CloudException {
        throw new UnsupportedOperationException("VLAN security list creation is not supported");
    }

    public void delete(@Nonnull String firewallId) throws InternalException, CloudException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_LIST);
        method.delete(firewallId);
    }

    @Nullable
    public Firewall getFirewall(@Nonnull String firewallId) throws InternalException, CloudException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_LIST);
        int code = method.get(firewallId);
        if (code == 404 || code == 401) {
            return null;
        }
        try {
            return this.toFirewall(method.getResponseBody());
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "security list";
    }

    @Nonnull
    public Collection<FirewallRule> getRules(@Nonnull String firewallId) throws InternalException, CloudException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_RULES);
        method.list();
        try {
            ArrayList<FirewallRule> rules = new ArrayList<FirewallRule>();
            JSONArray array = method.getResponseBody().getJSONArray("result");
            String id = "seclist:" + firewallId;
            for (int i = 0; i < array.length(); ++i) {
                Collection<FirewallRule> r;
                JSONObject ob = array.getJSONObject(i);
                if (ob == null || ob.has("dst_is_ip") && ob.getBoolean("dst_is_ip") || !ob.has("dst_list") || !ob.getString("dst_list").equals(id) || (r = this.toRule(firewallId, ob)) == null) continue;
                rules.addAll(r);
            }
            return rules;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public Collection<Firewall> list() throws InternalException, CloudException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_LIST);
        method.list();
        try {
            ArrayList<Firewall> firewalls = new ArrayList<Firewall>();
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                Firewall firewall = this.toFirewall(array.getJSONObject(i));
                if (firewall == null) continue;
                firewalls.add(firewall);
            }
            return firewalls;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed();
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    private void revoke(String ruleId) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_RULES);
        method.delete(ruleId);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, Direction.INGRESS, cidr, protocol, beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_RULES);
        String ipListId = this.getIpListId(cidr, false);
        String appId = this.getApplicationId(protocol, beginPort, endPort, false);
        if (ipListId == null || appId == null) {
            return;
        }
        method.list();
        try {
            JSONArray array = method.getResponseBody().getJSONArray("result");
            String id = "seclist:" + firewallId;
            for (int i = 0; i < array.length(); ++i) {
                String listId;
                JSONObject ob = array.getJSONObject(i);
                if (ob == null || ob.has("dst_is_ip") && ob.getBoolean("dst_is_ip") || !ob.has("dst_list") || !ob.getString("dst_list").equals(id) || !ob.has("src_list") || !(listId = ob.getString("src_list")).equals("seciplist:" + ipListId) || !ob.has("application") || !ob.getString("application").equals(appId)) continue;
                this.revoke(ob.getString("name"));
            }
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    public boolean supportsRules(@Nonnull Direction direction, boolean inVlan) throws CloudException, InternalException {
        return !inVlan && direction.equals((Object)Direction.INGRESS);
    }

    @Nullable
    private Firewall toFirewall(@Nullable JSONObject ob) throws JSONException, CloudException {
        String id;
        if (ob == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        String string = id = ob.has("name") ? ob.getString("name") : null;
        if (id == null) {
            return null;
        }
        Firewall fw = new Firewall();
        fw.setProviderFirewallId(id);
        fw.setActive(true);
        fw.setAvailable(true);
        fw.setRegionId(regionId);
        String name = id;
        if (fw.getName() == null) {
            String[] tmp = id.split("/");
            name = tmp == null || tmp.length < 1 ? id : tmp[tmp.length - 1];
            fw.setName(name);
        }
        if (fw.getDescription() == null) {
            fw.setDescription(name);
        }
        return fw;
    }

    private Collection<FirewallRule> toRule(String firewallId, JSONObject ob) throws JSONException, CloudException, InternalException {
        String dport;
        JSONObject app;
        String destList = ob.has("dst_list") ? ob.getString("dst_list") : null;
        String appId = ob.has("application") ? ob.getString("application") : null;
        FirewallRule rule = new FirewallRule();
        if (destList == null || appId == null) {
            return null;
        }
        if (!ob.has("name")) {
            return null;
        }
        rule.setFirewallId(firewallId);
        rule.setProviderRuleId(ob.getString("name"));
        rule.setPermission(Permission.ALLOW);
        if (ob.has("dst_is_ip") && ob.getBoolean("dst_is_ip")) {
            rule.setDirection(Direction.EGRESS);
        } else {
            rule.setDirection(Direction.INGRESS);
        }
        if (ob.has("action")) {
            rule.setPermission(ob.getString("action").equalsIgnoreCase("permit") ? Permission.ALLOW : Permission.DENY);
        }
        if ((app = this.getSecurityApplication(appId)) == null) {
            return null;
        }
        String protocol = app.getString("protocol");
        rule.setProtocol(Protocol.valueOf((String)protocol.toUpperCase()));
        if (app.has("dport") && (dport = app.getString("dport")) != null && !dport.equals("")) {
            int idx = dport.indexOf(45);
            if (idx < 1) {
                rule.setStartPort(Integer.parseInt(dport));
                rule.setEndPort(Integer.parseInt(dport));
            } else {
                String s = dport.substring(0, idx);
                String e = dport.substring(idx + 1);
                rule.setStartPort(Integer.parseInt(s));
                rule.setStartPort(Integer.parseInt(e));
            }
        }
        ArrayList<FirewallRule> rules = new ArrayList<FirewallRule>();
        if (ob.has("src_is_ip") && ob.getBoolean("src_is_ip")) {
            JSONArray entries;
            String ipList;
            String string = ipList = ob.has("src_list") ? ob.getString("src_list") : null;
            if (ipList == null) {
                return null;
            }
            JSONObject l = this.getSecurityIpList(ipList.substring("seciplist:".length()));
            if (l == null) {
                return null;
            }
            JSONArray jSONArray = entries = l.has("secipentries") ? l.getJSONArray("secipentries") : null;
            if (entries == null) {
                return null;
            }
            for (int i = 0; i < entries.length(); ++i) {
                String entry = entries.getString(i);
                if (entry == null) continue;
                FirewallRule copy = new FirewallRule();
                copy.setCidr(entry);
                copy.setDirection(rule.getDirection());
                copy.setEndPort(rule.getEndPort());
                copy.setFirewallId(rule.getFirewallId());
                copy.setPermission(rule.getPermission());
                copy.setProtocol(rule.getProtocol());
                copy.setProviderRuleId(rule.getProviderRuleId() + ":" + copy.getCidr());
                copy.setStartPort(rule.getStartPort());
                rules.add(copy);
            }
        }
        return rules;
    }

    private JSONObject getSecurityApplication(String secIpListId) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_APPLICATION);
        int code = method.get(secIpListId);
        if (code == 404 || code == 401) {
            return null;
        }
        try {
            return method.getResponseBody();
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    private JSONObject getSecurityIpList(String secIpListId) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.provider, SECURITY_IP_LIST);
        int code = method.get(secIpListId);
        if (code == 404 || code == 401) {
            return null;
        }
        try {
            return method.getResponseBody();
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }
}

