/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.nimbula.network;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.NICCreateOptions;
import org.dasein.cloud.network.NetworkInterface;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.nimbula.NimbulaDirector;
import org.dasein.cloud.nimbula.NimbulaMethod;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Vethernet
implements VLANSupport {
    private static final Logger logger = NimbulaDirector.getLogger(VLANSupport.class);
    public static final String VDHCPD = "vdhcpd";
    private NimbulaDirector cloud;

    Vethernet(@Nonnull NimbulaDirector cloud) {
        this.cloud = cloud;
    }

    public void addRouteToAddress(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String address) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not currently supported");
    }

    public void addRouteToGateway(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String gatewayId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not currently supported");
    }

    public void addRouteToNetworkInterface(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("NICs not yet supported");
    }

    public void addRouteToVirtualMachine(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not currently supported");
    }

    public boolean allowsNewNetworkInterfaceCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsNewVlanCreation() throws CloudException, InternalException {
        ProviderContext ctx = this.cloud.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        return "root".equals(ctx.getAccountNumber());
    }

    private int findId() throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, "vethernet");
        method.list();
        try {
            boolean found;
            JSONArray array = method.getResponseBody().getJSONArray("result");
            int id = 1;
            block2: do {
                found = false;
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject ob = array.getJSONObject(i);
                    int current = ob.getInt("id");
                    if (current != id) continue;
                    ++id;
                    found = true;
                    continue block2;
                }
            } while (found);
            return id;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    private JSONObject findVdhcpd(String vlanId) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, VDHCPD);
        method.list();
        try {
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                JSONObject ob = array.getJSONObject(i);
                String id = ob.getString("vethernet");
                if (id == null || !id.equals(vlanId)) continue;
                return ob;
            }
            return null;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    public int getMaxVlanCount() throws CloudException, InternalException {
        return 0;
    }

    @Nullable
    public VLAN getVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, "vethernet");
        int code = method.get(vlanId);
        if (code == 404 || code == 401) {
            return null;
        }
        try {
            VLAN vlan = this.toVlan(method.getResponseBody());
            this.setNetwork(vlan);
            return vlan;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    public boolean isNetworkInterfaceSupportEnabled() throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, "vethernet");
        method.list();
        try {
            ArrayList<VLAN> vlans = new ArrayList<VLAN>();
            JSONArray array = method.getResponseBody().getJSONArray("result");
            for (int i = 0; i < array.length(); ++i) {
                VLAN vlan = this.toVlan(array.getJSONObject(i));
                if (vlan == null) continue;
                this.setNetwork(vlan);
                vlans.add(vlan);
            }
            return vlans;
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    public void removeInternetGateway(@Nonnull String forVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No internet gateway support");
    }

    public void removeNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("NICs not yet supported");
    }

    public void removeRoute(@Nonnull String inRoutingTableId, @Nonnull String destinationCidr) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not yet supported");
    }

    public void removeRoutingTable(@Nonnull String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not yet supported");
    }

    @Nonnull
    public Subnet createSubnet(@Nonnull String cidr, @Nonnull String inProviderVlanId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Subnets are not supported");
    }

    @Nonnull
    public VLAN createVlan(@Nonnull String cidr, @Nonnull String name, @Nonnull String description, @Nonnull String domainName, @Nonnull String[] dnsServers, @Nonnull String[] ntpServers) throws CloudException, InternalException {
        String ipStop;
        VLAN vlan;
        String[] dotted;
        ProviderContext ctx = this.cloud.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        if (!"root".equals(ctx.getAccountNumber())) {
            throw new OperationNotSupportedException("VLAN creation is not yet supported for non-root");
        }
        int id = this.findId();
        int[] parts = new int[4];
        int idx = cidr.indexOf(47);
        int mask = 32;
        if (idx > -1) {
            mask = Integer.parseInt(cidr.substring(idx + 1));
            cidr = cidr.substring(0, idx);
        }
        if ((dotted = cidr.split("\\.")).length != 4) {
            throw new CloudException("Invalid IP address: " + cidr);
        }
        int i = 0;
        for (String dot : dotted) {
            try {
                parts[i++] = Integer.parseInt(dot);
            }
            catch (NumberFormatException e) {
                throw new CloudException("Invalid IP address: " + cidr);
            }
        }
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("id", id);
        state.put("description", description);
        state.put("type", "vlan");
        state.put("uri", null);
        try {
            state.put("name", "/" + this.cloud.getContext().getAccountNumber() + "/" + new String(this.cloud.getContext().getAccessPublic(), "utf-8") + "/vnet" + id);
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Failed UTF-8 encoding: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
        NimbulaMethod method = new NimbulaMethod(this.cloud, "vethernet");
        method.post(state);
        try {
            vlan = this.toVlan(method.getResponseBody());
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new CloudException((Throwable)e);
        }
        state.clear();
        if (mask == 32 || mask == 31) {
            ipStop = cidr;
        } else {
            int count;
            if (mask >= 24) {
                count = (int)Math.pow(2.0, 32 - mask) - 1;
                if (count > 4) {
                    count -= 4;
                }
                parts[3] = parts[3] + count;
            } else if (mask >= 16) {
                count = (int)Math.pow(2.0, 24 - mask) - 1;
                if (count > 4) {
                    count -= 4;
                }
                parts[2] = parts[2] + count;
            } else if (mask >= 8) {
                count = (int)Math.pow(2.0, 16 - mask) - 1;
                if (count > 4) {
                    count -= 4;
                }
                parts[1] = parts[1] + count;
            } else {
                count = (int)Math.pow(2.0, 8 - mask) - 1;
                if (count > 4) {
                    count -= 4;
                }
                parts[0] = parts[0] + count;
            }
            ipStop = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        }
        state.put("iprange_mask", mask);
        state.put("dns_server", dnsServers[0]);
        state.put("dns_server_standby", dnsServers[1]);
        state.put("iprange_start", cidr);
        state.put("iprange_stop", ipStop);
        state.put("uri", null);
        try {
            state.put("vethernet", "/" + this.cloud.getContext().getAccountNumber() + "/" + new String(this.cloud.getContext().getAccessPublic(), "utf-8") + "/vnet" + id);
            state.put("name", "/" + this.cloud.getContext().getAccountNumber() + "/" + new String(this.cloud.getContext().getAccessPublic(), "utf-8") + "/vdhcpd" + id);
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Encoding error: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
        int slash = cidr.indexOf(47);
        state.put("iprouter", cidr.subSequence(0, slash));
        method = new NimbulaMethod(this.cloud, VDHCPD);
        method.post(state);
        return vlan;
    }

    public void detachNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("NICs not yet supported");
    }

    public int getMaxNetworkInterfaceCount() throws CloudException, InternalException {
        return 0;
    }

    public void removeVlan(String vlanId) throws CloudException, InternalException {
        NimbulaMethod method = new NimbulaMethod(this.cloud, "vethernet");
        method.delete(vlanId);
        JSONObject ob = this.findVdhcpd(vlanId);
        if (ob != null) {
            method = new NimbulaMethod(this.cloud, VDHCPD);
            try {
                method.delete(ob.getString("name"));
            }
            catch (JSONException e) {
                if (logger.isDebugEnabled()) {
                    logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
    }

    public boolean supportsInternetGatewayCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsRawAddressRouting() throws CloudException, InternalException {
        return false;
    }

    private void setNetwork(VLAN vlan) throws CloudException, InternalException {
        try {
            JSONObject ob = this.findVdhcpd(vlan.getProviderVlanId());
            if (ob != null) {
                vlan.setDnsServers(new String[]{ob.getString("dns_server"), ob.getString("dns_server_standby")});
                vlan.setCidr(ob.getString("iprange_start") + "/" + ob.getString("iprange_mask"));
            }
        }
        catch (JSONException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)("Error parsing JSON: " + e.getMessage()));
                e.printStackTrace();
            }
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private VLAN toVlan(@Nullable JSONObject ob) throws JSONException, CloudException {
        if (ob == null) {
            return null;
        }
        ProviderContext ctx = this.cloud.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        String name = ob.getString("name");
        VLAN vlan = new VLAN();
        String[] idInfo = this.cloud.parseId(name);
        vlan.setName(idInfo[2]);
        vlan.setDescription(idInfo[2]);
        vlan.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4});
        vlan.setCurrentState(VLANState.AVAILABLE);
        if (ob.has("description")) {
            vlan.setDescription(ob.getString("description"));
        }
        vlan.setProviderVlanId(name);
        vlan.setProviderOwnerId(idInfo[0]);
        vlan.setProviderRegionId(regionId);
        vlan.setProviderDataCenterId(vlan.getProviderRegionId() + "-a");
        return vlan;
    }

    public boolean allowsNewSubnetCreation() throws CloudException, InternalException {
        return false;
    }

    public void assignRoutingTableToSubnet(@Nonnull String subnetId, @Nonnull String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not supported");
    }

    public void assignRoutingTableToVlan(@Nonnull String vlanId, @Nonnull String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not supported");
    }

    public void attachNetworkInterface(@Nonnull String nicId, @Nonnull String vmId, int index) throws CloudException, InternalException {
        throw new OperationNotSupportedException("NICs tables not yet supported");
    }

    public String createInternetGateway(@Nonnull String forVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Internet gateways not supported");
    }

    @Nonnull
    public String createRoutingTable(@Nonnull String forVlanId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not currently supported");
    }

    @Nonnull
    public NetworkInterface createNetworkInterface(@Nonnull NICCreateOptions options) throws CloudException, InternalException {
        throw new OperationNotSupportedException("NICs not yet supported");
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "NIC";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "subnet";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "vethernet";
    }

    public NetworkInterface getNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        return null;
    }

    public RoutingTable getRoutingTableForSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Requirement getRoutingTableSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public RoutingTable getRoutingTableForVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        return null;
    }

    public Subnet getSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Requirement getSubnetSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isSubnetDataCenterConstrained() throws CloudException, InternalException {
        return false;
    }

    public boolean isVlanDataCenterConstrained() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Collection<String> listFirewallIdsForNIC(@Nonnull String nicId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfaces() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesForVM(@Nonnull String forVmId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInVLAN(@Nonnull String vlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<RoutingTable> listRoutingTables(@Nonnull String inVlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<Subnet> listSubnets(@Nonnull String inVlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    public void removeSubnet(String providerSubnetId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Subnets are not supported");
    }
}

