/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.openstack.nova.os.AuthenticationContext;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.util.APITrace;

public class NovaLocationServices
implements DataCenterServices {
    private NovaOpenStack provider;

    public NovaLocationServices(NovaOpenStack provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenter getDataCenter(String providerDataCenterId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getDataCenter");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context exists for this request");
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new CloudException("No region is known for zones request");
            }
            for (DataCenter dc : this.listDataCenters(regionId)) {
                if (!dc.getProviderDataCenterId().equals(providerDataCenterId)) continue;
                DataCenter dataCenter = dc;
                return dataCenter;
            }
            DataCenter dataCenter = null;
            return dataCenter;
        }
        finally {
            APITrace.end();
        }
    }

    public String getProviderTermForDataCenter(Locale locale) {
        return "data center";
    }

    public String getProviderTermForRegion(Locale locale) {
        return "region";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getRegion(String providerRegionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getRegion");
        try {
            for (Region region : this.listRegions()) {
                if (!region.getProviderRegionId().equals(providerRegionId)) continue;
                Region region2 = region;
                return region2;
            }
            Region region = null;
            return region;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataCenter> listDataCenters(String providerRegionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listDataCenters");
        try {
            Region region = this.getRegion(providerRegionId);
            if (region == null) {
                throw new CloudException("No such region: " + providerRegionId);
            }
            DataCenter dc = new DataCenter();
            dc.setActive(true);
            dc.setAvailable(true);
            dc.setName(region.getProviderRegionId() + "-a");
            dc.setProviderDataCenterId(region.getProviderRegionId() + "-a");
            dc.setRegionId(providerRegionId);
            List<DataCenter> list = Collections.singletonList(dc);
            return list;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Region> listRegions() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listRegions");
        try {
            AuthenticationContext ctx = this.provider.getAuthenticationContext();
            Collection<Region> collection = ctx.listRegions();
            return collection;
        }
        finally {
            APITrace.end();
        }
    }
}

