/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.openstack.nova.os.AbstractMethod;
import org.dasein.cloud.openstack.nova.os.AuthenticationContext;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.ext.hp.cdn.HPCDN;
import org.json.JSONException;
import org.json.JSONObject;

public class NovaMethod
extends AbstractMethod {
    public NovaMethod(NovaOpenStack provider) {
        super(provider);
    }

    public void deleteServers(@Nonnull String resource, @Nonnull String resourceId) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getComputeUrl();
        if (endpoint == null) {
            throw new CloudException("No compute endpoint exists");
        }
        this.delete(context.getAuthToken(), endpoint, resource + "/" + resourceId);
    }

    public void deleteNetworks(@Nonnull String resource, @Nonnull String resourceId) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getNetworkUrl();
        if (endpoint == null) {
            throw new CloudException("No network endpoint exists");
        }
        if (resource != null && !endpoint.endsWith("/") && !resource.startsWith("/")) {
            endpoint = endpoint + "/";
        }
        this.delete(context.getAuthToken(), endpoint, resource + "/" + resourceId);
    }

    @Nullable
    public JSONObject getServers(@Nonnull String resource, @Nullable String resourceId, boolean suffix) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getComputeUrl();
        if (endpoint == null) {
            throw new CloudException("No compute URL has been established in " + context.getMyRegion());
        }
        if (resourceId != null) {
            resource = resource + "/" + resourceId;
        } else if (suffix) {
            resource = resource + "/detail";
        }
        String response = this.getString(context.getAuthToken(), endpoint, resource);
        if (response == null) {
            return null;
        }
        try {
            return new JSONObject(response);
        }
        catch (JSONException e) {
            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", response);
        }
    }

    @Nullable
    public JSONObject getNetworks(@Nonnull String resource, @Nullable String resourceId, boolean suffix) throws CloudException, InternalException {
        String response;
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getNetworkUrl();
        if (endpoint == null) {
            throw new CloudException("No network URL has been established in " + context.getMyRegion());
        }
        if (resourceId != null) {
            resource = resource + "/" + resourceId;
        } else if (suffix) {
            resource = resource + "/detail";
        }
        if (resource != null && !endpoint.endsWith("/") && !resource.startsWith("/")) {
            endpoint = endpoint + "/";
        }
        if ((response = this.getString(context.getAuthToken(), endpoint, resource)) == null) {
            return null;
        }
        try {
            return new JSONObject(response);
        }
        catch (JSONException e) {
            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", response);
        }
    }

    @Nullable
    public String postServersForString(@Nonnull String resource, @Nullable String resourceId, @Nonnull JSONObject body, boolean suffix) throws CloudException, InternalException {
        String computeEndpoint;
        AuthenticationContext context = this.provider.getAuthenticationContext();
        if (resourceId != null) {
            resource = resource + "/" + (suffix ? resourceId + "/action" : resourceId);
        }
        if ((computeEndpoint = context.getComputeUrl()) == null) {
            throw new CloudException("No compute endpoint exists");
        }
        return this.postString(context.getAuthToken(), computeEndpoint, resource, body.toString());
    }

    @Nullable
    public JSONObject postServers(@Nonnull String resource, @Nullable String resourceId, @Nonnull JSONObject body, boolean suffix) throws CloudException, InternalException {
        String computeEndpoint;
        AuthenticationContext context = this.provider.getAuthenticationContext();
        if (resourceId != null) {
            resource = resource + "/" + (suffix ? resourceId + "/action" : resourceId);
        }
        if ((computeEndpoint = context.getComputeUrl()) == null) {
            throw new CloudException("No compute endpoint exists");
        }
        String response = this.postString(context.getAuthToken(), computeEndpoint, resource, body.toString());
        if (response == null) {
            return null;
        }
        try {
            return new JSONObject(response);
        }
        catch (JSONException e) {
            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", response);
        }
    }

    @Nullable
    public JSONObject postNetworks(@Nonnull String resource, @Nullable String resourceId, @Nonnull JSONObject body, boolean suffix) throws CloudException, InternalException {
        String response;
        String endpoint;
        AuthenticationContext context = this.provider.getAuthenticationContext();
        if (resourceId != null) {
            resource = resource + "/" + (suffix ? resourceId + "/action" : resourceId);
        }
        if ((endpoint = context.getNetworkUrl()) == null) {
            throw new CloudException("No network endpoint exists");
        }
        if (resource != null && !endpoint.endsWith("/") && !resource.startsWith("/")) {
            endpoint = endpoint + "/";
        }
        if ((response = this.postString(context.getAuthToken(), endpoint, resource, body.toString())) == null) {
            return null;
        }
        try {
            return new JSONObject(response);
        }
        catch (JSONException e) {
            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", response);
        }
    }

    @Nullable
    public String getHPCDN(@Nullable String resourceId) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl("hpext:cdn");
        if (endpoint == null) {
            throw new CloudException("No CDN URL has been established in " + context.getMyRegion());
        }
        return this.getString(context.getAuthToken(), endpoint, resourceId == null ? "" : "/" + resourceId);
    }

    public void putHPCDN(String container) throws CloudException, InternalException {
        Map<String, String> headers = new HashMap<String, String>();
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl("hpext:cdn");
        if (endpoint == null) {
            throw new CloudException("No CDN URL has been established in " + context.getMyRegion());
        }
        if (container == null) {
            throw new InternalException("No container was specified");
        }
        headers.put("X-TTL", "86400");
        this.putHeaders(context.getAuthToken(), endpoint, "/" + container, headers);
        headers = this.headResource("hpext:cdn", HPCDN.RESOURCE, container);
        if (headers == null) {
            throw new CloudException("No container enabled");
        }
    }

    public void postHPCDN(String container, Map<String, String> headers) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl("hpext:cdn");
        if (endpoint == null) {
            throw new CloudException("No CDN URL has been established in " + context.getMyRegion());
        }
        if (container == null) {
            throw new InternalException("No container was specified");
        }
        this.postHeaders(context.getAuthToken(), endpoint, "/" + container, headers);
    }

    public void deleteHPCDN(String container) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl("hpext:cdn");
        if (endpoint == null) {
            throw new CloudException("No CDN URL has been established in " + context.getMyRegion());
        }
        this.delete(context.getAuthToken(), endpoint, "/" + container);
    }
}

