/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.openstack.nova.os.AuthenticationContext;
import org.dasein.cloud.openstack.nova.os.NovaException;
import org.dasein.cloud.openstack.nova.os.NovaLocationServices;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.OpenStackProvider;
import org.dasein.cloud.openstack.nova.os.compute.NovaComputeServices;
import org.dasein.cloud.openstack.nova.os.ext.hp.HPPlatformServices;
import org.dasein.cloud.openstack.nova.os.ext.rackspace.RackspacePlatformServices;
import org.dasein.cloud.openstack.nova.os.identity.NovaIdentityServices;
import org.dasein.cloud.openstack.nova.os.network.NovaNetworkServices;
import org.dasein.cloud.openstack.nova.os.storage.SwiftStorageServices;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.storage.StorageServices;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class NovaOpenStack
extends AbstractCloud {
    private static final Logger logger = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
    private static OpenStackProvider provider;

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls, @Nonnull String type) {
        String pkg = NovaOpenStack.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("os") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.nova." + type + "." + pkg + NovaOpenStack.getLastItem(cls.getName())));
    }

    public static boolean isSupported(@Nonnull String version) {
        int minor;
        int major;
        int idx = version.indexOf(46);
        if (idx < 0) {
            major = Integer.parseInt(version);
            minor = 0;
        } else {
            String[] parts = version.split("\\.");
            major = Integer.parseInt(parts[0]);
            minor = Integer.parseInt(parts[1]);
        }
        return major <= 2 && minor < 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public synchronized AuthenticationContext getAuthenticationContext() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this, (String)"Cloud.getAuthenticationContext");
        try {
            AuthenticationContext authenticationContext;
            Cache cache = Cache.getInstance((CloudProvider)this, (String)"authenticationContext", AuthenticationContext.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)25, (TimePeriodUnit)TimePeriod.MINUTE));
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            Iterable current = cache.get(ctx);
            if (current != null) {
                authenticationContext = (AuthenticationContext)current.iterator().next();
            } else {
                NovaMethod method = new NovaMethod(this);
                authenticationContext = method.authenticate();
                if (authenticationContext == null) {
                    NovaException.ExceptionItems items = new NovaException.ExceptionItems();
                    items.code = 401;
                    items.type = CloudErrorType.AUTHENTICATION;
                    items.message = "unauthorized";
                    items.details = "The API keys failed to authentication with the specified endpoint.";
                    throw new NovaException(items);
                }
                cache.put(ctx, Collections.singletonList(authenticationContext));
            }
            AuthenticationContext authenticationContext2 = authenticationContext;
            return authenticationContext2;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getCloudName();
        return name != null ? name : "OpenStack";
    }

    @Nonnull
    public NovaComputeServices getComputeServices() {
        return new NovaComputeServices(this);
    }

    @Nonnull
    public NovaIdentityServices getIdentityServices() {
        return new NovaIdentityServices(this);
    }

    @Nonnull
    public NovaLocationServices getDataCenterServices() {
        return new NovaLocationServices(this);
    }

    @Nullable
    public PlatformServices getPlatformServices() {
        if (this.getCloudProvider().equals((Object)OpenStackProvider.HP)) {
            return new HPPlatformServices(this);
        }
        if (this.getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
            return new RackspacePlatformServices(this);
        }
        return super.getPlatformServices();
    }

    @Nullable
    public StorageServices getStorageServices() {
        ProviderContext pc = this.getContext();
        if (pc == null) {
            return null;
        }
        if (pc.getStorageEndpoint() == null) {
            try {
                AuthenticationContext ctx = this.getAuthenticationContext();
                if (ctx.getStorageUrl() == null) {
                    return null;
                }
            }
            catch (CloudException e) {
                e.printStackTrace();
                return null;
            }
            catch (InternalException e) {
                e.printStackTrace();
                return null;
            }
            return new SwiftStorageServices(this);
        }
        return new SwiftStorageServices(this);
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getProviderName();
        return name != null ? name : "OpenStack";
    }

    @Nonnegative
    public int getMajorVersion() throws CloudException, InternalException {
        AuthenticationContext ctx = this.getAuthenticationContext();
        String endpoint = ctx.getComputeUrl();
        if (endpoint == null && (endpoint = ctx.getStorageUrl()) == null) {
            return 1;
        }
        while (endpoint.endsWith("/") && endpoint.length() > 1) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        String[] parts = endpoint.split("/");
        int idx = parts.length - 1;
        do {
            endpoint = parts[idx];
            while (!Character.isDigit(endpoint.charAt(0)) && endpoint.length() > 1) {
                endpoint = endpoint.substring(1);
            }
            if (!Character.isDigit(endpoint.charAt(0))) continue;
            int i = endpoint.indexOf(46);
            try {
                if (i == -1) {
                    return Integer.parseInt(endpoint);
                }
                String[] d = endpoint.split("\\.");
                return Integer.parseInt(d[0]);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        } while (idx-- > 0);
        return 1;
    }

    @Nonnegative
    public int getMinorVersion() throws CloudException, InternalException {
        AuthenticationContext ctx = this.getAuthenticationContext();
        String endpoint = ctx.getComputeUrl();
        if (endpoint == null && (endpoint = ctx.getStorageUrl()) == null) {
            return 1;
        }
        while (endpoint.endsWith("/") && endpoint.length() > 1) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        String[] parts = endpoint.split("/");
        int idx = parts.length - 1;
        do {
            endpoint = parts[idx];
            while (!Character.isDigit(endpoint.charAt(0)) && endpoint.length() > 1) {
                endpoint = endpoint.substring(1);
            }
            if (!Character.isDigit(endpoint.charAt(0))) continue;
            int i = endpoint.indexOf(46);
            try {
                if (i == -1) {
                    return Integer.parseInt(endpoint);
                }
                String[] d = endpoint.split("\\.");
                return Integer.parseInt(d[1]);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        } while (idx-- > 0);
        return 1;
    }

    @Nonnull
    public NovaNetworkServices getNetworkServices() {
        return new NovaNetworkServices(this);
    }

    public boolean isHP() {
        return this.getProviderName().equalsIgnoreCase("hp");
    }

    public boolean isInsecure() {
        Properties p;
        ProviderContext ctx = this.getContext();
        String value = ctx == null ? null : ((p = ctx.getCustomProperties()) == null ? null : p.getProperty("insecure"));
        if (value == null) {
            value = System.getProperty("insecure");
        }
        return value != null && value.equalsIgnoreCase("true");
    }

    public boolean isRackspace() {
        return this.getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE);
    }

    @Nonnull
    public OpenStackProvider getCloudProvider() {
        provider = OpenStackProvider.getProvider(this.getProviderName());
        return provider;
    }

    public boolean isPostCactus() throws CloudException, InternalException {
        return this.getMajorVersion() > 1 || this.getMinorVersion() > 0;
    }

    public long parseTimestamp(String time) throws CloudException {
        if (time == null) {
            return 0L;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        if (time.length() > 0) {
            try {
                return fmt.parse(time).getTime();
            }
            catch (ParseException e) {
                fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                try {
                    return fmt.parse(time).getTime();
                }
                catch (ParseException encore) {
                    fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    try {
                        return fmt.parse(time).getTime();
                    }
                    catch (ParseException again) {
                        try {
                            return fmt.parse(time).getTime();
                        }
                        catch (ParseException whynot) {
                            fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                return fmt.parse(time).getTime();
                            }
                            catch (ParseException because) {
                                throw new CloudException("Could not parse date: " + time);
                            }
                        }
                    }
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        APITrace.begin((CloudProvider)this, (String)"Cloud.testContext");
        try {
            NovaMethod method = new NovaMethod(this);
            AuthenticationContext ctx = method.authenticate();
            String string = ctx == null ? null : ctx.getTenantId();
            return string;
        }
        catch (Throwable t) {
            logger.warn((Object)("Failed to test OpenStack connection context: " + t.getMessage()));
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }
}

