/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.openstack.nova.os.AbstractMethod;
import org.dasein.cloud.openstack.nova.os.AuthenticationContext;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;

public class SwiftMethod
extends AbstractMethod {
    public SwiftMethod(NovaOpenStack provider) {
        super(provider);
    }

    public void delete(@Nonnull String bucket) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getStorageUrl();
        if (endpoint == null) {
            throw new CloudException("No storage endpoint exists for " + context.getMyRegion());
        }
        this.delete(context.getAuthToken(), endpoint, "/" + bucket);
    }

    public void delete(@Nonnull String bucket, @Nonnull String object) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getStorageUrl();
        if (endpoint == null) {
            throw new CloudException("No storage endpoint exists for " + context.getMyRegion());
        }
        this.delete(context.getAuthToken(), endpoint, "/" + bucket + "/" + object);
    }

    @Nonnull
    public List<String> get(@Nullable String bucket) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getStorageUrl();
        if (endpoint == null) {
            throw new CloudException("No storage endpoint exists for " + context.getMyRegion());
        }
        String response = this.getString(context.getAuthToken(), endpoint, bucket == null ? "/" : "/" + bucket);
        ArrayList<String> entries = new ArrayList<String>();
        if (response != null && (response = response.trim()).length() > 0) {
            String[] lines = response.split("\n");
            if (lines.length < 1) {
                entries.add(response);
            } else {
                for (String line : lines) {
                    entries.add(line.trim());
                }
            }
        }
        return entries;
    }

    @Nullable
    public InputStream get(@Nonnull String bucket, @Nonnull String object) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getStorageUrl();
        if (endpoint == null) {
            throw new CloudException("No storage endpoint exists for " + context.getMyRegion());
        }
        return this.getStream(context.getAuthToken(), endpoint, "/" + bucket + "/" + object);
    }

    @Nullable
    public Map<String, String> head(@Nonnull String bucket) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getStorageUrl();
        if (endpoint == null) {
            throw new CloudException("No storage endpoint exists for " + context.getMyRegion());
        }
        return this.head(context.getAuthToken(), endpoint, "/" + bucket);
    }

    @Nullable
    public Map<String, String> head(@Nonnull String bucket, @Nonnull String object) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getStorageUrl();
        if (endpoint == null) {
            throw new CloudException("No storage endpoint exists for " + context.getMyRegion());
        }
        return this.head(context.getAuthToken(), endpoint, "/" + bucket + "/" + object);
    }

    public void put(@Nonnull String bucket) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getStorageUrl();
        if (endpoint == null) {
            throw new CloudException("No storage endpoint exists for " + context.getMyRegion());
        }
        this.putString(context.getAuthToken(), endpoint, "/" + bucket, null);
    }

    public void put(@Nonnull String bucket, @Nonnull String object, @Nullable String md5Hash, @Nonnull InputStream payload) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getStorageUrl();
        if (endpoint == null) {
            throw new CloudException("No storage endpoint exists for " + context.getMyRegion());
        }
        this.putStream(context.getAuthToken(), endpoint, "/" + bucket + "/" + object, md5Hash, payload);
    }
}

