/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.AbstractVolumeSupport;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CinderVolume
extends AbstractVolumeSupport {
    private static final Logger logger = NovaOpenStack.getLogger(CinderVolume.class, "std");
    public static final String SERVICE = "volume";

    public CinderVolume(@Nonnull NovaOpenStack provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    private String getAttachmentsResource() {
        return "os-volume_attachments";
    }

    @Nonnull
    private String getResource() {
        return "/volumes";
    }

    @Nonnull
    private String getTypesResource() {
        return "/types";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(@Nonnull String volumeId, @Nonnull String toServer, @Nonnull String device) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.attach");
        try {
            HashMap<String, String> attachment = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> wrapper = new HashMap<String, HashMap<String, String>>();
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            attachment.put("volumeId", volumeId);
            attachment.put("device", device);
            wrapper.put("volumeAttachment", attachment);
            if (method.postString("compute", "/servers", toServer, this.getAttachmentsResource(), new JSONObject(wrapper)) == null) {
                throw new CloudException("No response from the cloud");
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String createVolume(@Nonnull VolumeCreateOptions options) throws InternalException, CloudException {
        if (options.getVlanId() != null) {
            throw new OperationNotSupportedException("Creating NFS volumes is not supported in " + this.getProvider().getCloudName());
        }
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.createVolume");
        try {
            Map md;
            HashMap wrapper = new HashMap();
            HashMap<String, Object> json = new HashMap<String, Object>();
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            json.put("display_name", options.getName());
            json.put("display_description", options.getDescription());
            Storage<Gigabyte> size = options.getVolumeSize();
            if (size == null || size.intValue() < this.getMinimumVolumeSize().intValue()) {
                size = this.getMinimumVolumeSize();
            } else if (this.getMaximumVolumeSize() != null && size.intValue() > this.getMaximumVolumeSize().intValue()) {
                size = this.getMaximumVolumeSize();
            }
            json.put("size", size.intValue());
            if (options.getSnapshotId() != null) {
                json.put("snapshot_id", options.getSnapshotId());
            }
            if ((md = options.getMetaData()) != null && !md.isEmpty()) {
                json.put("metadata", md);
            }
            if (options.getVolumeProductId() != null) {
                VolumeProduct product = null;
                for (VolumeProduct p : this.listVolumeProducts()) {
                    if (!p.getProviderProductId().equals(options.getVolumeProductId())) continue;
                    product = p;
                    break;
                }
                if (product != null) {
                    json.put("volume_type", product.getName());
                }
            }
            wrapper.put(SERVICE, json);
            JSONObject result = method.postString(SERVICE, this.getResource(), null, new JSONObject(wrapper), true);
            if (result != null && result.has(SERVICE)) {
                try {
                    Volume volume = this.toVolume(result.getJSONObject(SERVICE), this.listVolumeProducts());
                    if (volume != null) {
                        String string = volume.getProviderVolumeId();
                        return string;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("create(): Unable to understand create response: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"create(): No volume was created by the create attempt, and no error was returned");
            throw new CloudException("No volume was created");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(@Nonnull String volumeId, boolean force) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.detach");
        try {
            Volume volume = this.getVolume(volumeId);
            if (volume == null) {
                throw new CloudException("No such volume: " + volumeId);
            }
            if (volume.getProviderVirtualMachineId() == null) {
                throw new CloudException("Volume " + volumeId + " is not attached");
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.deleteResource("compute", "/servers", volume.getProviderVirtualMachineId(), this.getAttachmentsResource() + "/" + volumeId);
        }
        finally {
            APITrace.end();
        }
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return -2;
    }

    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1024, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        if (((NovaOpenStack)this.getProvider()).isRackspace()) {
            return new Storage((Number)100, (StorageUnit)Storage.GIGABYTE);
        }
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return SERVICE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Volume getVolume(@Nonnull String volumeId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.getVolume");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getResource(SERVICE, this.getResource(), volumeId, true);
            if (ob == null) {
                Volume volume = null;
                return volume;
            }
            if (ob.has(SERVICE)) {
                Volume volume = this.toVolume(ob.getJSONObject(SERVICE), this.listVolumeProducts());
                return volume;
            }
            Volume volume = null;
            return volume;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return ((NovaOpenStack)this.getProvider()).isHP() ? Requirement.NONE : Requirement.OPTIONAL;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        ArrayList<String> list = new ArrayList<String>();
        if (platform.isWindows()) {
            list.add("xvdf");
            list.add("xvdg");
            list.add("xvdh");
            list.add("xvdi");
            list.add("xvdj");
        } else {
            list.add("/dev/vdf");
            list.add("/dev/vdg");
            list.add("/dev/vdh");
            list.add("/dev/vdi");
            list.add("/dev/vdj");
        }
        return list;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VolumeProduct> listVolumeProducts() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.listVolumeProducts");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"volumeProducts", VolumeProduct.class, (CacheLevel)CacheLevel.REGION_ACCOUNT);
            Iterable current = cache.get(this.getContext());
            if (current != null) {
                Iterable iterable = current;
                return iterable;
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            ArrayList<VolumeProduct> products = new ArrayList<VolumeProduct>();
            JSONObject json = method.getResource(SERVICE, this.getTypesResource(), null, false);
            if (json != null && json.has("volume_types")) {
                try {
                    JSONArray list = json.getJSONArray("volume_types");
                    for (int i = 0; i < list.length(); ++i) {
                        String[] names;
                        VolumeType type;
                        JSONObject specs;
                        JSONObject t = list.getJSONObject(i);
                        String name = t.has("name") ? t.getString("name") : null;
                        String id = t.has("id") ? t.getString("id") : null;
                        JSONObject jSONObject = specs = t.has("extra_specs") ? t.getJSONObject("extra_specs") : null;
                        if (name == null || id == null) continue;
                        VolumeType volumeType = type = name.toLowerCase().contains("ssd") ? VolumeType.SSD : VolumeType.HDD;
                        if (specs != null && (names = JSONObject.getNames((JSONObject)specs)) != null && names.length > 0) {
                            for (String field : names) {
                                String value;
                                if (!specs.has(field) || !(specs.get(field) instanceof String) || (value = specs.getString(field)) == null || !value.toLowerCase().contains("ssd")) continue;
                                type = VolumeType.SSD;
                                break;
                            }
                        }
                        products.add(VolumeProduct.getInstance((String)id, (String)name, (String)name, (VolumeType)type));
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("listVolumes(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for volumes in " + json.toString());
                }
            }
            cache.put(this.getContext(), Collections.unmodifiableList(products));
            ArrayList<VolumeProduct> arrayList = products;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVolumeStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.listVolumeStatus");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            ArrayList<ResourceStatus> volumes = new ArrayList<ResourceStatus>();
            JSONObject json = method.getResource(SERVICE, this.getResource(), null, false);
            if (json != null && json.has("volumes")) {
                try {
                    JSONArray list = json.getJSONArray("volumes");
                    for (int i = 0; i < list.length(); ++i) {
                        ResourceStatus volume = this.toStatus(list.getJSONObject(i));
                        if (volume == null) continue;
                        volumes.add(volume);
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("listVolumes(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for volumes in " + json.toString());
                }
            }
            ArrayList<ResourceStatus> arrayList = volumes;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Volume> listVolumes() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.listVolumes");
        try {
            Iterable<VolumeProduct> products = this.listVolumeProducts();
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            ArrayList<Volume> volumes = new ArrayList<Volume>();
            JSONObject json = method.getResource(SERVICE, this.getResource(), null, false);
            if (json != null && json.has("volumes")) {
                try {
                    JSONArray list = json.getJSONArray("volumes");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject v = list.getJSONObject(i);
                        Volume volume = this.toVolume(v, products);
                        if (volume == null) continue;
                        volumes.add(volume);
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("listVolumes(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for volumes in " + json.toString());
                }
            }
            ArrayList<Volume> arrayList = volumes;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.isSubscribed");
        try {
            boolean bl = ((NovaOpenStack)this.getProvider()).getAuthenticationContext().getServiceUrl(SERVICE) != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String volumeId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Volume.remove");
        try {
            long timeout = System.currentTimeMillis() + 600000L;
            Volume v = this.getVolume(volumeId);
            while (timeout > System.currentTimeMillis()) {
                if (v == null) {
                    return;
                }
                if (!VolumeState.PENDING.equals((Object)v.getCurrentState())) break;
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    v = this.getVolume(volumeId);
                }
                catch (Throwable ignore) {}
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.deleteResource(SERVICE, this.getResource(), volumeId, null);
            v = this.getVolume(volumeId);
            timeout = System.currentTimeMillis() + 600000L;
            while (timeout > System.currentTimeMillis()) {
                if (v == null || v.getCurrentState().equals((Object)VolumeState.DELETED)) {
                    return;
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    v = this.getVolume(volumeId);
                }
                catch (Throwable ignore) {}
            }
            logger.warn((Object)("Volume remove op accepted but still available: current state - " + v.getCurrentState()));
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String volumeId = null;
            if (json.has("id")) {
                volumeId = json.getString("id");
            }
            if (volumeId == null) {
                return null;
            }
            VolumeState state = VolumeState.PENDING;
            if (json.has("status")) {
                String status = json.getString("status");
                if (status.equalsIgnoreCase("available")) {
                    state = VolumeState.AVAILABLE;
                } else if (status.equalsIgnoreCase("creating")) {
                    state = VolumeState.PENDING;
                } else if (status.equalsIgnoreCase("error")) {
                    state = VolumeState.PENDING;
                } else if (status.equals("in-use")) {
                    state = VolumeState.AVAILABLE;
                } else if (status.equals("attaching")) {
                    state = VolumeState.PENDING;
                } else {
                    logger.warn((Object)("DEBUG: Unknown OpenStack Cinder volume state: " + status));
                }
            }
            return new ResourceStatus(volumeId, (Object)state);
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private Volume toVolume(@Nullable JSONObject json, @Nonnull Iterable<VolumeProduct> types) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String snapshotId;
            long created;
            String description;
            String name;
            String region = this.getContext().getRegionId();
            String dataCenter = region + "-a";
            String volumeId = null;
            if (json.has("id")) {
                volumeId = json.getString("id");
            }
            if (volumeId == null) {
                return null;
            }
            String string = name = json.has("displayName") ? json.getString("displayName") : null;
            if (name == null) {
                String string2 = name = json.has("display_name") ? json.getString("display_name") : null;
                if (name == null) {
                    name = volumeId;
                }
            }
            String string3 = description = json.has("displayDescription") ? json.getString("displayDescription") : null;
            if (description == null) {
                String string4 = description = json.has("display_description") ? json.getString("display_description") : null;
                if (description == null) {
                    description = name;
                }
            }
            long l = created = json.has("createdAt") ? ((NovaOpenStack)this.getProvider()).parseTimestamp(json.getString("createdAt")) : -1L;
            if (created < 1L) {
                created = json.has("created_at") ? ((NovaOpenStack)this.getProvider()).parseTimestamp(json.getString("created_at")) : -1L;
            }
            int size = 0;
            if (json.has("size")) {
                size = json.getInt("size");
            }
            String productId = null;
            if (json.has("volume_type")) {
                productId = json.getString("volume_type");
            } else if (json.has("volumeType")) {
                productId = json.getString("volumeType");
            }
            String vmId = null;
            String deviceId = null;
            if (json.has("attachments")) {
                JSONArray servers = json.getJSONArray("attachments");
                for (int i = 0; i < servers.length(); ++i) {
                    JSONObject ob = servers.getJSONObject(i);
                    if (ob.has("serverId")) {
                        vmId = ob.getString("serverId");
                    } else if (ob.has("server_id")) {
                        vmId = ob.getString("server_id");
                    }
                    if (ob.has("device")) {
                        deviceId = ob.getString("device");
                    }
                    if (vmId != null) break;
                }
            }
            String string5 = snapshotId = json.has("snapshotId") ? json.getString("snapshotId") : null;
            if (snapshotId == null) {
                snapshotId = json.has("snapshot_id") ? json.getString("snapshot_id") : null;
            }
            VolumeState currentState = VolumeState.PENDING;
            if (json.has("status")) {
                String status = json.getString("status");
                if (status.equalsIgnoreCase("available")) {
                    currentState = VolumeState.AVAILABLE;
                } else if (status.equalsIgnoreCase("creating")) {
                    currentState = VolumeState.PENDING;
                } else if (status.equalsIgnoreCase("error")) {
                    currentState = VolumeState.PENDING;
                } else if (status.equals("in-use")) {
                    currentState = VolumeState.AVAILABLE;
                } else if (status.equals("attaching")) {
                    currentState = VolumeState.PENDING;
                } else {
                    logger.warn((Object)("DEBUG: Unknown OpenStack Cinder volume state: " + status));
                }
            }
            Volume volume = new Volume();
            volume.setCreationTimestamp(created);
            volume.setCurrentState(currentState);
            volume.setDeviceId(deviceId);
            volume.setName(name);
            volume.setDescription(description);
            volume.setProviderDataCenterId(dataCenter);
            volume.setProviderRegionId(region);
            volume.setProviderSnapshotId(snapshotId);
            volume.setProviderVirtualMachineId(vmId);
            volume.setProviderVolumeId(volumeId);
            volume.setSize(new Storage((Number)size, (StorageUnit)Storage.GIGABYTE));
            if (productId != null) {
                VolumeProduct match = null;
                for (VolumeProduct prd : types) {
                    if (!productId.equals(prd.getProviderProductId())) continue;
                    match = prd;
                    break;
                }
                if (match == null) {
                    for (VolumeProduct prd : types) {
                        if (!productId.equals(prd.getName())) continue;
                        match = prd;
                        break;
                    }
                }
                if (match != null) {
                    volume.setProviderProductId(match.getProviderProductId());
                    volume.setType(match.getType());
                }
            }
            if (volume.getProviderProductId() == null) {
                volume.setProviderProductId(productId);
            }
            if (volume.getType() == null) {
                volume.setType(VolumeType.HDD);
            }
            return volume;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }
}

