/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.AbstractImageSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.openstack.nova.os.NovaException;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.util.APITrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NovaImage
extends AbstractImageSupport {
    private static final Logger logger = NovaOpenStack.getLogger(NovaImage.class, "std");

    NovaImage(NovaOpenStack provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return ((NovaOpenStack)this.getProvider()).getAuthenticationContext().getTenantId();
    }

    @Nullable
    public String getImageRef(@Nonnull String machineImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.getImageRef");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/images", machineImageId, true);
            if (ob == null) {
                String string = null;
                return string;
            }
            if (ob.has("image")) {
                JSONObject image = ob.getJSONObject("image");
                JSONArray links = image.getJSONArray("links");
                String def = null;
                for (int j = 0; j < links.length(); ++j) {
                    JSONObject link = links.getJSONObject(j);
                    if (link.getString("rel").equals("self")) {
                        String string = link.getString("href");
                        return string;
                    }
                    if (def != null) continue;
                    def = link.optString("href");
                }
                String string = def;
                return string;
            }
            String image = null;
            return image;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.capture");
        try {
            block33: {
                JSONObject result;
                HashMap<String, HashMap<String, Object>> json;
                VirtualMachine vm;
                NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
                HashMap<String, Object> action = new HashMap<String, Object>();
                action.put("name", options.getName());
                if (task != null) {
                    task.setStartTime(System.currentTimeMillis());
                }
                String vmId = options.getVirtualMachineId();
                Platform platform = null;
                if (vmId != null) {
                    long timeout = System.currentTimeMillis() + 600000L;
                    while (timeout > System.currentTimeMillis()) {
                        try {
                            String tag;
                            VirtualMachineSupport support;
                            ComputeServices services = this.getProvider().getComputeServices();
                            vm = null;
                            if (services != null && (support = services.getVirtualMachineSupport()) != null) {
                                vm = support.getVirtualMachine(vmId);
                            }
                            if (vm == null) {
                                throw new CloudException("No such virtual machine: " + vmId);
                            }
                            platform = vm.getPlatform();
                            if (!(VmState.PENDING.equals((Object)vm.getCurrentState()) || (tag = (String)vm.getTag("OS-EXT-STS:task_state")) != null && tag.equalsIgnoreCase("image_snapshot"))) {
                                break;
                            }
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ignore) {}
                    }
                }
                if (((NovaOpenStack)this.getProvider()).isPostCactus()) {
                    json = new HashMap<String, HashMap<String, Object>>();
                    HashMap<String, String> metaData = new HashMap<String, String>();
                    metaData.put("org.dasein.description", options.getDescription());
                    if (platform != null) {
                        metaData.put("org.dasein.platform", platform.name());
                    }
                    action.put("metadata", metaData);
                    json.put("createImage", action);
                    result = method.postServers("/servers", vmId, new JSONObject(json), true);
                } else {
                    json = new HashMap();
                    action.put("serverId", String.valueOf(vmId));
                    json.put("image", action);
                    result = method.postServers("/images", null, new JSONObject(json), true);
                }
                if (result != null && result.has("image")) {
                    try {
                        JSONObject img = result.getJSONObject("image");
                        MachineImage image = this.toImage(img);
                        if (image != null) {
                            if (task != null) {
                                task.completeWithResult((Object)image);
                            }
                            vm = image;
                            return vm;
                        }
                        break block33;
                    }
                    catch (JSONException e) {
                        throw new CloudException((Throwable)e);
                    }
                }
                if (result != null && result.has("location")) {
                    try {
                        long timeout = System.currentTimeMillis() + 1200000L;
                        String location = result.getString("location");
                        int idx = location.lastIndexOf(47);
                        if (idx > 0) {
                            location = location.substring(idx + 1);
                        }
                        while (timeout > System.currentTimeMillis()) {
                            MachineImage image = this.getImage(location);
                            if (image != null) {
                                if (task != null) {
                                    task.completeWithResult((Object)image);
                                }
                                MachineImage machineImage = image;
                                return machineImage;
                            }
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException ignore) {}
                        }
                    }
                    catch (JSONException e) {
                        throw new CloudException((Throwable)e);
                    }
                }
            }
            logger.error((Object)"No image was created by the imaging attempt, and no error was returned");
            throw new CloudException("No image was created");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.getImage");
        try {
            JSONObject server;
            MachineImage img;
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/images", providerImageId, true);
            if (ob == null) {
                MachineImage machineImage = null;
                return machineImage;
            }
            if (ob.has("image") && (img = this.toImage(server = ob.getJSONObject("image"))) != null) {
                MachineImage machineImage = img;
                return machineImage;
            }
            MachineImage machineImage = null;
            return machineImage;
        }
        finally {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.getImage");
        }
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        switch (cls) {
            case MACHINE: {
                return "machine image";
            }
            case KERNEL: {
                return "kernel image";
            }
            case RAMDISK: {
                return "ramdisk image";
            }
        }
        return "image";
    }

    public boolean hasPublicLibrary() {
        return true;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.isImageSharedWithPublic");
        try {
            MachineImage img = this.getImage(machineImageId);
            String ownerId = img != null ? img.getProviderOwnerId() : null;
            boolean bl = ownerId != null && !ownerId.equals(this.getTenantId());
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.isSubscribed");
        try {
            boolean bl = this.getProvider().testContext() != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(@Nonnull ImageClass cls) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImageStatus");
        try {
            if (!cls.equals((Object)ImageClass.MACHINE)) {
                List<ResourceStatus> list = Collections.emptyList();
                return list;
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/images", null, true);
            ArrayList<ResourceStatus> images = new ArrayList<ResourceStatus>();
            try {
                if (ob != null && ob.has("images")) {
                    JSONArray list = ob.getJSONArray("images");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject image = list.getJSONObject(i);
                        ResourceStatus img = this.toStatus(image);
                        if (img == null) continue;
                        images.add(img);
                    }
                }
            }
            catch (JSONException e) {
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for images: " + e.getMessage());
            }
            ArrayList<ResourceStatus> arrayList = images;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> listImages(@Nullable ImageFilterOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImages");
        try {
            String account;
            String string = account = options == null ? null : options.getAccountNumber();
            if (account == null) {
                if (options == null) {
                    options = ImageFilterOptions.getInstance().withAccountNumber(this.getTenantId());
                } else {
                    options.withAccountNumber(this.getTenantId());
                }
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/images", null, true);
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            try {
                if (ob != null && ob.has("images")) {
                    JSONArray list = ob.getJSONArray("images");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject image = list.getJSONObject(i);
                        MachineImage img = this.toImage(image);
                        if (img == null || !options.matches(img)) continue;
                        images.add(img);
                    }
                }
            }
            catch (JSONException e) {
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for images: " + e.getMessage());
            }
            ArrayList<MachineImage> arrayList = images;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        ArrayList<ImageClass> values = new ArrayList<ImageClass>();
        Collections.addAll(values, ImageClass.values());
        return values;
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageType.VOLUME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.remove");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            long timeout = System.currentTimeMillis() + 3600000L;
            while (true) {
                try {
                    method.deleteServers("/images", providerImageId);
                    return;
                }
                catch (NovaException e) {
                    if (e.getHttpCode() != 409) {
                        throw e;
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < timeout) continue;
                    APITrace.end();
                }
                break;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nonnull ImageFilterOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.searchPublicImages");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/images", null, true);
            ArrayList<MachineImage> images = new ArrayList<MachineImage>();
            String me = this.getTenantId();
            try {
                if (ob != null && ob.has("images")) {
                    JSONArray list = ob.getJSONArray("images");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject image = list.getJSONObject(i);
                        MachineImage img = this.toImage(image);
                        if (img == null || img.getProviderOwnerId().equals(me) || !options.matches(img)) continue;
                        images.add(img);
                    }
                }
            }
            catch (JSONException e) {
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for images: " + e.getMessage());
            }
            ArrayList<MachineImage> arrayList = images;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean supportsCustomImages() {
        return true;
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) throws CloudException, InternalException {
        return true;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return true;
    }

    @Nullable
    public MachineImage toImage(@Nullable JSONObject json) throws CloudException, InternalException {
        Logger logger = NovaOpenStack.getLogger(NovaImage.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + NovaImage.class.getName() + ".toImage(" + json + ")"));
        }
        try {
            String[] names;
            Platform p;
            if (json == null) {
                MachineImage machineImage = null;
                return machineImage;
            }
            String imageId = json.has("id") ? json.getString("id") : null;
            String name = json.has("name") ? json.getString("name") : null;
            String description = json.has("description") ? json.getString("description") : null;
            JSONObject md = json.has("metadata") ? json.getJSONObject("metadata") : null;
            Architecture architecture = Architecture.I64;
            Platform platform = Platform.UNKNOWN;
            String owner = ((NovaOpenStack)this.getProvider()).getCloudProvider().getDefaultImageOwner(this.getTenantId());
            if (md != null) {
                Platform p2;
                if (description == null && md.has("org.dasein.description")) {
                    description = md.getString("org.dasein.description");
                }
                if (md.has("org.dasein.platform")) {
                    try {
                        platform = Platform.valueOf((String)md.getString("org.dasein.platform"));
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                String[] akeys = new String[]{"arch", "architecture", "org.openstack__1__architecture", "com.hp__1__architecture"};
                String a = null;
                for (String key : akeys) {
                    if (md.has(key) && !md.isNull(key) && (a = md.getString(key)) != null) break;
                }
                if (a != null) {
                    if ((a = a.toLowerCase()).contains("32")) {
                        architecture = Architecture.I32;
                    } else if (a.contains("sparc")) {
                        architecture = Architecture.SPARC;
                    } else if (a.contains("power")) {
                        architecture = Architecture.POWER;
                    }
                }
                if (md.has("os_type") && !md.isNull("os_type") && !(p2 = Platform.guess((String)md.getString("os_type"))).equals((Object)Platform.UNKNOWN)) {
                    if (platform.equals((Object)Platform.UNKNOWN)) {
                        platform = p2;
                    } else if (platform.equals((Object)Platform.UNIX) && !p2.equals((Object)Platform.UNIX)) {
                        platform = p2;
                    }
                }
                if (md.has("owner") && !md.isNull("owner")) {
                    owner = md.getString("owner");
                } else if (md.has("image_type") && !md.isNull("image_type") && md.getString("image_type").equals("base")) {
                    owner = "--public--";
                } else if (md.has("image_type") && !md.isNull("image_type") && md.getString("image_type").equals("snapshot")) {
                    owner = this.getTenantId();
                }
            }
            long created = json.has("created") ? ((NovaOpenStack)this.getProvider()).parseTimestamp(json.getString("created")) : -1L;
            MachineImageState currentState = MachineImageState.PENDING;
            if (json.has("status")) {
                String s = json.getString("status").toLowerCase();
                if (s.equals("saving")) {
                    currentState = MachineImageState.PENDING;
                } else if (s.equals("active") || s.equals("queued") || s.equals("preparing")) {
                    currentState = MachineImageState.ACTIVE;
                } else if (s.equals("deleting")) {
                    currentState = MachineImageState.PENDING;
                } else {
                    if (s.equals("failed")) {
                        MachineImage i$ = null;
                        return i$;
                    }
                    logger.warn((Object)("toImage(): Unknown image status: " + s));
                    currentState = MachineImageState.PENDING;
                }
            }
            if (imageId == null) {
                MachineImage s = null;
                return s;
            }
            if (name == null) {
                name = imageId;
            }
            if (description == null) {
                description = name;
            }
            if (platform.equals((Object)Platform.UNKNOWN)) {
                platform = Platform.guess((String)(name + " " + description));
            } else if (platform.equals((Object)Platform.UNIX) && !(p = Platform.guess((String)(name + " " + description))).equals((Object)Platform.UNKNOWN)) {
                platform = p;
            }
            MachineImage image = MachineImage.getMachineImageInstance((String)owner, (String)this.getContext().getRegionId(), (String)imageId, (MachineImageState)currentState, (String)name, (String)description, (Architecture)architecture, (Platform)platform).createdAt(created);
            if (md != null && (names = JSONObject.getNames((JSONObject)md)) != null && names.length > 0) {
                for (String key : names) {
                    String value = md.getString(key);
                    if (value == null) continue;
                    image.setTag(key, value);
                }
            }
            MachineImage machineImage = image;
            return machineImage;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + NovaImage.class.getName() + ".toImage()"));
            }
        }
    }

    @Nullable
    public ResourceStatus toStatus(@Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        String owner = ((NovaOpenStack)this.getProvider()).getCloudProvider().getDefaultImageOwner(this.getTenantId());
        MachineImageState state = MachineImageState.PENDING;
        String id = null;
        try {
            JSONObject md;
            if (json.has("id")) {
                id = json.getString("id");
            }
            if (id == null) {
                return null;
            }
            JSONObject jSONObject = md = json.has("metadata") ? json.getJSONObject("metadata") : null;
            if (md != null && md.has("owner") && !md.isNull("owner")) {
                owner = md.getString("owner");
            } else if (md != null && md.has("image_type") && !md.isNull("image_type") && md.getString("image_type").equals("base")) {
                owner = "--public--";
            } else if (md != null && md.has("image_type") && !md.isNull("image_type") && md.getString("image_type").equals("snapshot")) {
                owner = this.getTenantId();
            }
            if (json.has("status")) {
                String s = json.getString("status").toLowerCase();
                if (s.equals("saving")) {
                    state = MachineImageState.PENDING;
                } else if (s.equals("active") || s.equals("queued") || s.equals("preparing")) {
                    state = MachineImageState.ACTIVE;
                } else if (s.equals("deleting")) {
                    state = MachineImageState.PENDING;
                } else {
                    if (s.equals("failed")) {
                        return null;
                    }
                    state = MachineImageState.PENDING;
                }
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        if (!owner.equals(this.getTenantId())) {
            return null;
        }
        return new ResourceStatus(id, (Object)state);
    }
}

