/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.ext.hp.cdn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.platform.CDNSupport;
import org.dasein.cloud.platform.Distribution;
import org.dasein.cloud.util.APITrace;

public class HPCDN
implements CDNSupport {
    private static final Logger logger = NovaOpenStack.getLogger(HPCDN.class, "std");
    public static final String SERVICE = "hpext:cdn";
    public static final String RESOURCE = null;
    private NovaOpenStack provider;

    public HPCDN(NovaOpenStack cloud) {
        this.provider = cloud;
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return this.provider.getAuthenticationContext().getTenantId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String create(@Nonnull String origin, @Nonnull String name, boolean active, String ... aliases) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.create");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            method.putHPCDN(origin);
            String string = origin;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@Nonnull String distributionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.delete");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            method.deleteHPCDN(distributionId);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Distribution getDistribution(@Nonnull String distributionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.getDistribution");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            Distribution distribution = this.toDistribution(ctx, distributionId);
            return distribution;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForDistribution(@Nonnull Locale locale) {
        return "container";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.isSubscribed");
        try {
            boolean bl = this.provider.getProviderName().equals("HP") && this.provider.getAuthenticationContext().getServiceUrl(SERVICE) != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Distribution> list() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.list");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            String response = method.getHPCDN(null);
            ArrayList<Distribution> distributions = new ArrayList<Distribution>();
            try {
                if (response != null) {
                    String container;
                    BufferedReader reader = new BufferedReader(new StringReader(response));
                    while ((container = reader.readLine()) != null) {
                        Distribution d = this.toDistribution(ctx, container);
                        if (d == null) continue;
                        distributions.add(d);
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)("list(): I/O error parsing response: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidResponse", "I/O error parsing " + response);
            }
            ArrayList<Distribution> arrayList = distributions;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listDistributionStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.listDistributionStatus");
        try {
            NovaMethod method = new NovaMethod(this.provider);
            String response = method.getHPCDN(null);
            ArrayList<ResourceStatus> distributions = new ArrayList<ResourceStatus>();
            try {
                if (response != null) {
                    String container;
                    BufferedReader reader = new BufferedReader(new StringReader(response));
                    while ((container = reader.readLine()) != null) {
                        ResourceStatus d = this.toStatus(container);
                        if (d == null) continue;
                        distributions.add(d);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidResponse", "I/O error parsing " + response);
            }
            ArrayList<ResourceStatus> arrayList = distributions;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@Nonnull String distributionId, @Nonnull String name, boolean active, String ... aliases) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.update");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            NovaMethod method = new NovaMethod(this.provider);
            headers.put("X-CDN-Enabled", active ? "True" : "False");
            method.postHPCDN(distributionId, headers);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private Distribution toDistribution(@Nonnull ProviderContext ctx, @Nullable String container) throws CloudException, InternalException {
        String dns;
        if (container == null) {
            return null;
        }
        NovaMethod method = new NovaMethod(this.provider);
        Map<String, String> headers = method.headResource(SERVICE, RESOURCE, container);
        if (headers == null) {
            return null;
        }
        String enabled = null;
        String uriString = null;
        for (String key : headers.keySet()) {
            if (key.equalsIgnoreCase("X-CDN-Enabled")) {
                enabled = headers.get(key);
                continue;
            }
            if (!key.equalsIgnoreCase("X-CDN-URI")) continue;
            uriString = headers.get(key);
        }
        if (uriString == null) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            dns = uri.getHost();
            if (uri.getPort() > 0) {
                if (dns.startsWith("https:") && uri.getPort() != 443) {
                    dns = dns + ":" + uri.getPort();
                }
                if (dns.startsWith("http:") && uri.getPort() != 80) {
                    dns = dns + ":" + uri.getPort();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new CloudException((Throwable)e);
        }
        Distribution distribution = new Distribution();
        distribution.setName(container);
        distribution.setActive(enabled != null && enabled.equalsIgnoreCase("true"));
        distribution.setAliases(new String[0]);
        distribution.setDeployed(enabled != null && enabled.equalsIgnoreCase("true"));
        distribution.setDnsName(dns);
        distribution.setLocation(uriString);
        distribution.setLogDirectory(null);
        distribution.setProviderDistributionId(container);
        distribution.setProviderOwnerId(this.getTenantId());
        return distribution;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable String container) throws CloudException, InternalException {
        if (container == null) {
            return null;
        }
        NovaMethod method = new NovaMethod(this.provider);
        Map<String, String> headers = method.headResource(SERVICE, RESOURCE, container);
        if (headers == null) {
            return null;
        }
        String enabled = null;
        String uriString = null;
        for (String key : headers.keySet()) {
            if (key.equalsIgnoreCase("X-CDN-Enabled")) {
                enabled = headers.get(key);
                continue;
            }
            if (!key.equalsIgnoreCase("X-CDN-URI")) continue;
            uriString = headers.get(key);
        }
        if (uriString == null) {
            return null;
        }
        return new ResourceStatus(container, (Object)(enabled != null && enabled.equalsIgnoreCase("true") ? 1 : 0));
    }
}

