/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.ext.rackspace.cdn;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.platform.CDNSupport;
import org.dasein.cloud.platform.Distribution;
import org.dasein.cloud.util.APITrace;

public class RackspaceCDN
implements CDNSupport {
    public static final String SERVICE = "rax:object-cdn";
    public static final String RESOURCE = null;
    private NovaOpenStack provider;

    public RackspaceCDN(NovaOpenStack provider) {
        this.provider = provider;
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return this.provider.getAuthenticationContext().getTenantId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String create(@Nonnull String origin, @Nonnull String name, boolean active, String ... aliases) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.create");
        try {
            HashMap<String, String> customHeaders = new HashMap<String, String>();
            customHeaders.put("X-Log-Retention", "True");
            customHeaders.put("X-CDN-Enabled", "True");
            NovaMethod method = new NovaMethod(this.provider);
            method.putResourceHeaders(SERVICE, RESOURCE, origin, customHeaders);
            String string = origin;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@Nonnull String distributionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.delete");
        try {
            HashMap<String, String> customHeaders = new HashMap<String, String>();
            customHeaders.put("X-Log-Retention", "True");
            customHeaders.put("X-CDN-Enabled", "False");
            NovaMethod method = new NovaMethod(this.provider);
            method.putResourceHeaders(SERVICE, RESOURCE, distributionId, customHeaders);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Distribution getDistribution(@Nonnull String distributionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.getDistribution");
        try {
            Distribution distribution;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            Map<String, String> metaData = method.headResource(SERVICE, RESOURCE, distributionId);
            if (metaData == null) {
                Distribution distribution2 = null;
                return distribution2;
            }
            Distribution distribution3 = new Distribution();
            distribution3.setAliases(new String[0]);
            String dnsName = null;
            String cdnUri = null;
            boolean enabled = false;
            for (String key : metaData.keySet()) {
                if (key.equalsIgnoreCase("X-CDN-Enabled")) {
                    String value = metaData.get(key);
                    enabled = value != null && value.equalsIgnoreCase("true");
                    continue;
                }
                if (key.equalsIgnoreCase("X-CDN-SSL-URI")) {
                    dnsName = metaData.get(key);
                    continue;
                }
                if (!key.equalsIgnoreCase("X-CDN-URI")) continue;
                cdnUri = metaData.get(key);
            }
            distribution3.setActive(enabled);
            distribution3.setDeployed(enabled);
            String prefix = "http://";
            if (dnsName == null) {
                dnsName = cdnUri;
                if (dnsName == null) {
                    distribution = null;
                    return distribution;
                }
                if (dnsName.startsWith("http://")) {
                    dnsName = dnsName.substring("http://".length());
                }
            } else if (dnsName.startsWith("https://")) {
                dnsName = dnsName.substring("https://".length());
                prefix = "https://";
            }
            distribution3.setDnsName(dnsName);
            distribution3.setLocation(prefix + distribution3.getDnsName() + "/" + distributionId);
            distribution3.setLogDirectory(null);
            distribution3.setLogName(null);
            distribution3.setName(distributionId);
            distribution3.setProviderDistributionId(distributionId);
            distribution3.setProviderOwnerId(this.getTenantId());
            distribution = distribution3;
            return distribution;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForDistribution(@Nonnull Locale locale) {
        return "distribution";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.isSubscribed");
        try {
            boolean bl = this.provider.getProviderName().equals("Rackspace") && this.provider.getAuthenticationContext().getServiceUrl(SERVICE) != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Distribution> list() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.list");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            ArrayList<Distribution> distributions = new ArrayList<Distribution>();
            NovaMethod method = new NovaMethod(this.provider);
            String[] list = method.getItemList(SERVICE, RESOURCE, false);
            if (list != null) {
                for (String container : list) {
                    Distribution d = this.toDistribution(ctx, container);
                    if (d == null) continue;
                    distributions.add(d);
                }
            }
            ArrayList<Distribution> arrayList = distributions;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listDistributionStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.listDistributionStatus");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            ArrayList<ResourceStatus> distributions = new ArrayList<ResourceStatus>();
            NovaMethod method = new NovaMethod(this.provider);
            String[] list = method.getItemList(SERVICE, RESOURCE, false);
            if (list != null) {
                for (String container : list) {
                    ResourceStatus d = this.toStatus(container);
                    if (d == null) continue;
                    distributions.add(d);
                }
            }
            ArrayList<ResourceStatus> arrayList = distributions;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@Nonnull String distributionId, @Nonnull String name, boolean active, String ... aliases) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"CDN.update");
        try {
            HashMap<String, String> customHeaders = new HashMap<String, String>();
            customHeaders.put("X-Log-Retention", "True");
            customHeaders.put("X-CDN-Enabled", active ? "True" : "False");
            NovaMethod method = new NovaMethod(this.provider);
            method.putResourceHeaders(SERVICE, RESOURCE, distributionId, customHeaders);
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private Distribution toDistribution(@Nonnull ProviderContext ctx, @Nullable String container) throws CloudException, InternalException {
        String dns;
        if (container == null) {
            return null;
        }
        NovaMethod method = new NovaMethod(this.provider);
        Map<String, String> headers = method.headResource(SERVICE, RESOURCE, container);
        if (headers == null) {
            return null;
        }
        String enabled = null;
        String uriString = null;
        for (String key : headers.keySet()) {
            if (key.equalsIgnoreCase("X-CDN-Enabled")) {
                enabled = headers.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("X-CDN-URI")) {
                if (uriString != null) continue;
                uriString = headers.get(key);
                continue;
            }
            if (!key.equalsIgnoreCase("X-CDN-SSL-URI")) continue;
            uriString = headers.get(key);
        }
        if (uriString == null) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            dns = uri.getHost();
            if (uri.getPort() > 0) {
                if (dns.startsWith("https:") && uri.getPort() != 443) {
                    dns = dns + ":" + uri.getPort();
                }
                if (dns.startsWith("http:") && uri.getPort() != 80) {
                    dns = dns + ":" + uri.getPort();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new CloudException((Throwable)e);
        }
        Distribution distribution = new Distribution();
        distribution.setName(container);
        distribution.setActive(enabled != null && enabled.equalsIgnoreCase("true"));
        distribution.setAliases(new String[0]);
        distribution.setDeployed(enabled != null && enabled.equalsIgnoreCase("true"));
        distribution.setDnsName(dns);
        distribution.setLocation(uriString);
        distribution.setLogDirectory(null);
        distribution.setProviderDistributionId(container);
        distribution.setProviderOwnerId(this.getTenantId());
        return distribution;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable String container) throws CloudException, InternalException {
        if (container == null) {
            return null;
        }
        NovaMethod method = new NovaMethod(this.provider);
        Map<String, String> headers = method.headResource(SERVICE, RESOURCE, container);
        if (headers == null) {
            return null;
        }
        String enabled = null;
        String uriString = null;
        for (String key : headers.keySet()) {
            if (key.equalsIgnoreCase("X-CDN-Enabled")) {
                enabled = headers.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("X-CDN-URI")) {
                if (uriString != null) continue;
                uriString = headers.get(key);
                continue;
            }
            if (!key.equalsIgnoreCase("X-CDN-SSL-URI")) continue;
            uriString = headers.get(key);
        }
        if (uriString == null) {
            return null;
        }
        return new ResourceStatus(container, (Object)(enabled != null && enabled.equalsIgnoreCase("true") ? 1 : 0));
    }
}

