/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.ext.rackspace.dns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.DNSRecord;
import org.dasein.cloud.network.DNSRecordType;
import org.dasein.cloud.network.DNSSupport;
import org.dasein.cloud.network.DNSZone;
import org.dasein.cloud.openstack.nova.os.NovaException;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.util.APITrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RackspaceCloudDNS
implements DNSSupport {
    private static final Logger logger = NovaOpenStack.getLogger(RackspaceCloudDNS.class, "std");
    private static final String RESOURCE = "/domains";
    private static final String SERVICE = "rax:dns";
    private NovaOpenStack provider;

    public RackspaceCloudDNS(NovaOpenStack provider) {
        this.provider = provider;
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return this.provider.getAuthenticationContext().getTenantId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public DNSRecord addDnsRecord(@Nonnull String providerDnsZoneId, @Nonnull DNSRecordType recordType, @Nonnull String name, @Nonnegative int ttl, String ... values) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.addDnsRecord");
        try {
            ProviderContext ctx;
            DNSZone zone = this.getDnsZone(providerDnsZoneId);
            if (zone == null) {
                throw new CloudException("No such zone: " + providerDnsZoneId);
            }
            if (recordType.equals((Object)DNSRecordType.A) || recordType.equals((Object)DNSRecordType.AAAA) || recordType.equals((Object)DNSRecordType.CNAME) || recordType.equals((Object)DNSRecordType.MX)) {
                if (name.endsWith(zone.getDomainName() + ".")) {
                    name = name.substring(0, name.length() - 1);
                } else if (!name.endsWith(zone.getDomainName())) {
                    name = name + "." + zone.getDomainName();
                }
            }
            if ((ctx = this.provider.getContext()) == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            DNSRecord lastRecord = null;
            for (String value : values) {
                if (value == null) continue;
                NovaMethod method = new NovaMethod(this.provider);
                HashMap wrapper = new HashMap();
                ArrayList records = new ArrayList();
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put("name", name);
                record.put("data", value);
                record.put("type", recordType.name());
                record.put("ttl", ttl > 0 ? ttl : 3600);
                records.add(record);
                wrapper.put("records", records);
                JSONObject response = method.postString(SERVICE, RESOURCE, providerDnsZoneId + "/records", new JSONObject(wrapper), false);
                try {
                    if (response == null || !response.has("jobId") || (response = this.waitForJob(response.getString("jobId"))) == null || !response.has("records")) continue;
                    JSONArray list = response.getJSONArray("records");
                    for (int i = 0; i < list.length(); ++i) {
                        DNSRecord r = this.toRecord(ctx, zone, list.getJSONObject(i));
                        if (r == null) continue;
                        lastRecord = r;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("createDnsZone(): JSON error parsing response: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidResponse", "JSON error parsing " + response);
                }
            }
            if (lastRecord == null) {
                logger.error((Object)"addDnsRecord(): No record was created, but no error specified");
                throw new CloudException("No record was created, but no error specified");
            }
            DNSRecord dNSRecord = lastRecord;
            return dNSRecord;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public String createDnsZone(@Nonnull String domainName, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.createDnsZone");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            HashMap wrapper = new HashMap();
            ArrayList domains = new ArrayList();
            HashMap<String, String> domain = new HashMap<String, String>();
            domain.put("name", domainName);
            domain.put("comment", description);
            domain.put("emailAddress", "postmaster@" + domainName);
            domains.add(domain);
            wrapper.put("domains", domains);
            JSONObject response = method.postString(SERVICE, RESOURCE, null, new JSONObject(wrapper), false);
            try {
                if (response != null && response.has("jobId") && (response = this.waitForJob(response.getString("jobId"))) != null && response.has("domains")) {
                    JSONArray list = response.getJSONArray("domains");
                    for (int i = 0; i < list.length(); ++i) {
                        DNSZone zone = this.toZone(ctx, list.getJSONObject(i));
                        if (zone == null) continue;
                        String string = zone.getProviderDnsZoneId();
                        return string;
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("createDnsZone(): JSON error parsing response: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidResponse", "JSON error parsing " + response);
            }
            logger.error((Object)"createDnsZone(): No zone was created, but no error specified");
            throw new CloudException("No zone was created, but no error specified");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private List<String> lookupRecord(DNSRecord record) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.lookupRecord");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject response = method.getResource(SERVICE, RESOURCE, record.getProviderZoneId() + "/records", false);
            if (response == null) {
                List<String> list = null;
                return list;
            }
            ArrayList<String> ids = new ArrayList<String>();
            try {
                if (response.has("records")) {
                    JSONArray list = response.getJSONArray("records");
                    for (int i = 0; i < list.length(); ++i) {
                        String id;
                        JSONObject item = list.getJSONObject(i);
                        if (item == null) continue;
                        String n = item.has("name") ? item.getString("name") : null;
                        String string = id = item.has("id") ? item.getString("id") : null;
                        if (n == null || id == null || !record.getName().equals(n) && !record.getName().equals(n + ".")) continue;
                        ids.add(id);
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("lookupRecord(): JSON error parsing response: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidResponse", "JSON error parsing " + response);
            }
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDnsRecords(DNSRecord ... dnsRecords) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.deleteDnsRecords");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            for (DNSRecord record : dnsRecords) {
                NovaMethod method = new NovaMethod(this.provider);
                List<String> ids = this.lookupRecord(record);
                for (String id : ids) {
                    method.deleteResource(SERVICE, RESOURCE, record.getProviderZoneId() + "/records/" + id, null);
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDnsZone(@Nonnull String providerDnsZoneId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.deleteDnsZone");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            method.deleteResource(SERVICE, RESOURCE, providerDnsZoneId, null);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DNSZone getDnsZone(@Nonnull String providerDnsZoneId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.getDnsZone");
        try {
            CompleteDNS dns = this.getCompleteDNS(providerDnsZoneId, false);
            DNSZone dNSZone = dns == null ? null : dns.domain;
            return dNSZone;
        }
        finally {
            APITrace.end();
        }
    }

    private void listSubdomains(@Nonnull ProviderContext ctx, @Nonnull List<DNSZone> intoList, @Nonnull DNSZone parent, @Nonnull JSONArray subdomains) throws CloudException, InternalException {
        try {
            for (int i = 0; i < subdomains.length(); ++i) {
                DNSZone z = this.toZone(ctx, subdomains.getJSONObject(i));
                if (z == null) continue;
                z.setNameservers(parent.getNameservers());
                intoList.add(z);
            }
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompleteDNS getCompleteDNS(@Nonnull String providerDnsZoneId, boolean withSubdomains) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(RackspaceCloudDNS.class, "std");
        if (std.isTraceEnabled()) {
            std.trace((Object)("ENTER: " + RackspaceCloudDNS.class.getName() + ".getCompleteDNS()"));
        }
        try {
            NovaMethod method;
            JSONObject response;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                std.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            String query = providerDnsZoneId + "?showRecords=true";
            if (withSubdomains) {
                query = query + "&showSubdomains=true";
            }
            if ((response = (method = new NovaMethod(this.provider)).getResource(SERVICE, RESOURCE, query, false)) == null) {
                CompleteDNS completeDNS = null;
                return completeDNS;
            }
            DNSZone zone = this.toZone(ctx, response);
            if (zone != null) {
                JSONObject subdomains;
                CompleteDNS dns = new CompleteDNS();
                dns.domain = zone;
                dns.subdomains = new ArrayList<DNSZone>();
                JSONObject jSONObject = subdomains = response.has("subdomains") ? response.getJSONObject("subdomains") : null;
                if (subdomains != null) {
                    JSONArray domains;
                    JSONArray jSONArray = domains = subdomains.has("domains") ? subdomains.getJSONArray("domains") : null;
                    if (domains != null) {
                        this.listSubdomains(ctx, dns.subdomains, zone, domains);
                    }
                }
                CompleteDNS completeDNS = dns;
                return completeDNS;
            }
            CompleteDNS completeDNS = null;
            return completeDNS;
        }
        finally {
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + RackspaceCloudDNS.class.getName() + ".getCompleteDNS()"));
            }
        }
    }

    @Nonnull
    public String getProviderTermForRecord(@Nonnull Locale locale) {
        return "record";
    }

    @Nonnull
    public String getProviderTermForZone(@Nonnull Locale locale) {
        return "domain";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<DNSRecord> listDnsRecords(@Nonnull String providerDnsZoneId, @Nullable DNSRecordType forType, @Nullable String name) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.listDnsRecords");
        try {
            DNSZone zone = this.getDnsZone(providerDnsZoneId);
            if (zone == null) {
                throw new CloudException("No such zone: " + providerDnsZoneId);
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject response = method.getResource(SERVICE, RESOURCE, providerDnsZoneId + "/records", false);
            if (response == null) {
                List<DNSRecord> list = Collections.emptyList();
                return list;
            }
            ArrayList<DNSRecord> records = new ArrayList<DNSRecord>();
            try {
                int count = 0;
                int total = 0;
                if (response.has("totalEntries")) {
                    total = response.getInt("totalEntries");
                }
                while (response != null) {
                    int current = 0;
                    if (response.has("records")) {
                        JSONArray list = response.getJSONArray("records");
                        current = list.length();
                        count += current;
                        for (int i = 0; i < list.length(); ++i) {
                            DNSRecord record = this.toRecord(ctx, zone, list.getJSONObject(i));
                            if (record == null || forType != null && !forType.equals((Object)record.getType()) || name != null && !name.equals(record.getName())) continue;
                            records.add(record);
                        }
                    }
                    response = null;
                    if (current <= 0 || count >= total) continue;
                    response = method.getResource(SERVICE, RESOURCE, providerDnsZoneId + "/records?offset=" + count, false);
                }
            }
            catch (JSONException e) {
                logger.error((Object)("listDnsRecords(): JSON error parsing response: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidResponse", "JSON error parsing " + response);
            }
            ArrayList<DNSRecord> arrayList = records;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listDnsZoneStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.listDnsZoneStatus");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject response = method.getResource(SERVICE, RESOURCE, null, false);
            if (response == null) {
                List<ResourceStatus> list = Collections.emptyList();
                return list;
            }
            ArrayList<ResourceStatus> zones = new ArrayList<ResourceStatus>();
            try {
                int count = 0;
                int total = 0;
                if (response.has("totalEntries")) {
                    total = response.getInt("totalEntries");
                }
                while (response != null) {
                    int current = 0;
                    if (response.has("domains")) {
                        JSONArray list = response.getJSONArray("domains");
                        current = list.length();
                        count += current;
                        for (int i = 0; i < list.length(); ++i) {
                            JSONObject item = list.getJSONObject(i);
                            if (item == null || !item.has("id")) continue;
                            zones.add(new ResourceStatus(item.getString("id"), (Object)true));
                        }
                    }
                    response = null;
                    if (current <= 0 || count >= total) continue;
                    response = method.getResource(SERVICE, RESOURCE, "?offset=" + count, false);
                }
            }
            catch (JSONException e) {
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidResponse", "JSON error parsing " + response);
            }
            ArrayList<ResourceStatus> arrayList = zones;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<DNSZone> listDnsZones() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.listDnsZones");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject response = method.getResource(SERVICE, RESOURCE, null, false);
            if (response == null) {
                List<DNSZone> list = Collections.emptyList();
                return list;
            }
            ArrayList<DNSZone> zones = new ArrayList<DNSZone>();
            try {
                int count = 0;
                int total = 0;
                if (response.has("totalEntries")) {
                    total = response.getInt("totalEntries");
                }
                while (response != null) {
                    int current = 0;
                    if (response.has("domains")) {
                        JSONArray list = response.getJSONArray("domains");
                        current = list.length();
                        count += current;
                        for (int i = 0; i < list.length(); ++i) {
                            CompleteDNS dns;
                            JSONObject item = list.getJSONObject(i);
                            if (item == null || !item.has("id") || (dns = this.getCompleteDNS(item.getString("id"), true)) == null) continue;
                            zones.add(dns.domain);
                            zones.addAll(dns.subdomains);
                        }
                    }
                    response = null;
                    if (current <= 0 || count >= total) continue;
                    response = method.getResource(SERVICE, RESOURCE, "?offset=" + count, false);
                }
            }
            catch (JSONException e) {
                logger.error((Object)("listDnsZones(): JSON error parsing response: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidResponse", "JSON error parsing " + response);
            }
            ArrayList<DNSZone> arrayList = zones;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DNS.isSubscribed");
        try {
            boolean bl = this.provider.getCloudName().contains("Rackspace") && this.provider.getAuthenticationContext().getServiceUrl(SERVICE) != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private DNSRecord toRecord(@Nonnull ProviderContext ctx, @Nonnull DNSZone zone, @Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String[] stringArray;
            String type;
            String name;
            String recordId;
            String string = recordId = json.has("id") ? json.getString("id") : null;
            if (recordId == null) {
                return null;
            }
            String string2 = name = json.has("name") ? json.getString("name") : null;
            if (name == null) {
                return null;
            }
            if (name.endsWith(zone.getDomainName())) {
                name = name + ".";
            }
            DNSRecordType recordType = DNSRecordType.A;
            String string3 = type = json.has("type") ? json.getString("type") : null;
            if (type != null) {
                recordType = DNSRecordType.valueOf((String)type.toUpperCase());
            }
            String data = json.has("data") ? json.getString("data") : null;
            int ttl = json.has("ttl") ? json.getInt("ttl") : 3600;
            DNSRecord record = new DNSRecord();
            record.setName(name);
            record.setProviderZoneId(zone.getProviderDnsZoneId());
            record.setTtl(ttl);
            record.setType(recordType);
            if (data == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = data;
            }
            record.setValues(stringArray);
            return record;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private DNSZone toZone(@Nonnull ProviderContext ctx, @Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String description;
            String name;
            String zoneId;
            String string = zoneId = json.has("id") ? json.getString("id") : null;
            if (zoneId == null) {
                return null;
            }
            String string2 = name = json.has("name") ? json.getString("name") : null;
            if (name == null) {
                return null;
            }
            String string3 = description = json.has("comment") ? json.getString("comment") : null;
            if (description == null) {
                description = name;
            }
            JSONArray nameservers = json.has("nameservers") ? json.getJSONArray("nameservers") : null;
            DNSZone zone = new DNSZone();
            zone.setDescription(description);
            zone.setDomainName(name);
            zone.setName(name);
            zone.setProviderDnsZoneId(zoneId);
            zone.setProviderOwnerId(this.getTenantId());
            if (nameservers != null) {
                String[] ns = new String[nameservers.length()];
                for (int i = 0; i < nameservers.length(); ++i) {
                    JSONObject ob = nameservers.getJSONObject(i);
                    if (!ob.has("name")) continue;
                    ns[i] = ob.getString("name");
                }
                zone.setNameservers(ns);
            } else {
                zone.setNameservers(new String[0]);
            }
            return zone;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    private JSONObject waitForJob(String jobId) throws CloudException, InternalException {
        long timeout = System.currentTimeMillis() + 1200000L;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context exists for this request");
        }
        while (System.currentTimeMillis() < timeout) {
            try {
                String status;
                NovaMethod method = new NovaMethod(this.provider);
                JSONObject response = method.getResource(SERVICE, "/status", jobId + "?showDetails=true", false);
                if (response == null) {
                    throw new CloudException("Job disappeared");
                }
                String string = status = response.has("status") ? response.getString("status") : null;
                if (status == null) {
                    throw new CloudException("No job status");
                }
                if (status.equalsIgnoreCase("completed")) {
                    if (response.has("response")) {
                        return response.getJSONObject("response");
                    }
                } else if (status.equalsIgnoreCase("error")) {
                    if (response.has("error")) {
                        JSONObject error = response.getJSONObject("error");
                        if (error == null) {
                            throw new CloudException("Unknown error");
                        }
                        int code = error.has("code") ? error.getInt("code") : 418;
                        throw new NovaException(NovaException.parseException(code, error.toString()));
                    }
                    throw new CloudException("Unknown error");
                }
            }
            catch (JSONException e) {
                throw new CloudException("Invalid JSON from server: " + e.getMessage());
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ignore) {}
        }
        throw new CloudException("Operation timed out");
    }

    private static class CompleteDNS {
        public DNSZone domain;
        public List<DNSZone> subdomains;

        private CompleteDNS() {
        }
    }
}

