/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.ext.rackspace.lb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.network.AbstractLoadBalancerSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbEndpointState;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LbListener;
import org.dasein.cloud.network.LbPersistence;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerCreateOptions;
import org.dasein.cloud.network.LoadBalancerEndpoint;
import org.dasein.cloud.network.LoadBalancerState;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.openstack.nova.os.NovaException;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RackspaceLoadBalancers
extends AbstractLoadBalancerSupport<NovaOpenStack> {
    private static final Logger logger = NovaOpenStack.getLogger(RackspaceLoadBalancers.class, "std");
    public static final String RESOURCE = "/loadbalancers";
    public static final String SERVICE = "rax:load-balancer";
    private NovaOpenStack provider;
    private static transient Collection<LbAlgorithm> supportedAlgorithms;

    public RackspaceLoadBalancers(NovaOpenStack provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return ((NovaOpenStack)this.getProvider()).getAuthenticationContext().getTenantId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIPEndpoints(@Nonnull String toLoadBalancerId, String ... ipAddresses) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.addIPEndpoints");
        try {
            LbListener[] listeners;
            ArrayList nodes = new ArrayList();
            LoadBalancer lb = this.getLoadBalancer(toLoadBalancerId);
            int port = -1;
            if (lb == null) {
                logger.error((Object)("No such load balancer: " + toLoadBalancerId));
                throw new CloudException("No such load balancer: " + toLoadBalancerId);
            }
            long timeout = System.currentTimeMillis() + 300000L;
            while (timeout > System.currentTimeMillis()) {
                block22: {
                    if (lb == null) {
                        return;
                    }
                    if (!LoadBalancerState.PENDING.equals((Object)lb.getCurrentState())) break;
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    try {
                        lb = this.getLoadBalancer(toLoadBalancerId);
                        if (lb != null) break block22;
                        return;
                    }
                    catch (Throwable ignore) {
                        continue;
                    }
                }
                if (LoadBalancerState.PENDING.equals((Object)lb.getCurrentState())) continue;
                break;
            }
            if ((listeners = lb.getListeners()) != null && listeners.length > 0 && (port = listeners[0].getPrivatePort()) == -1) {
                port = listeners[0].getPublicPort();
            }
            if (port == -1) {
                if (lb.getPublicPorts() != null && lb.getPublicPorts().length > 0) {
                    port = lb.getPublicPorts()[0];
                }
                if (port == -1) {
                    logger.error((Object)"Could not determine a proper private port for mapping");
                    throw new CloudException("No port understanding exists for this load balancer");
                }
            }
            for (String address : ipAddresses) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Adding " + address + "..."));
                }
                HashMap<String, Object> node = new HashMap<String, Object>();
                node.put("address", address);
                node.put("condition", "ENABLED");
                node.put("port", port);
                nodes.add(node);
            }
            if (!nodes.isEmpty()) {
                HashMap json = new HashMap();
                json.put("nodes", nodes);
                NovaMethod method = new NovaMethod(this.provider);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Calling cloud...");
                }
                method.postString(SERVICE, RESOURCE, toLoadBalancerId + "/nodes", new JSONObject(json), false);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Done.");
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServers(@Nonnull String toLoadBalancerId, String ... serverIdsToAdd) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.addServers");
        try {
            LbListener[] listeners;
            ArrayList nodes = new ArrayList();
            LoadBalancer lb = this.getLoadBalancer(toLoadBalancerId);
            int port = -1;
            if (lb == null) {
                logger.error((Object)("addServers(): No such load balancer: " + toLoadBalancerId));
                throw new CloudException("No such load balancer: " + toLoadBalancerId);
            }
            long timeout = System.currentTimeMillis() + 300000L;
            while (timeout > System.currentTimeMillis()) {
                block27: {
                    if (lb == null) {
                        return;
                    }
                    if (!LoadBalancerState.PENDING.equals((Object)lb.getCurrentState())) break;
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    try {
                        lb = this.getLoadBalancer(toLoadBalancerId);
                        if (lb != null) break block27;
                        return;
                    }
                    catch (Throwable ignore) {
                        continue;
                    }
                }
                if (LoadBalancerState.PENDING.equals((Object)lb.getCurrentState())) continue;
                break;
            }
            if ((listeners = lb.getListeners()) != null && listeners.length > 0 && (port = listeners[0].getPrivatePort()) == -1) {
                port = listeners[0].getPublicPort();
            }
            if (port == -1) {
                if (lb.getPublicPorts() != null && lb.getPublicPorts().length > 0) {
                    port = lb.getPublicPorts()[0];
                }
                if (port == -1) {
                    logger.error((Object)"addServers(): Could not determine a proper private port for mapping");
                    throw new CloudException("No port understanding exists for this load balancer");
                }
            }
            for (String id : serverIdsToAdd) {
                RawAddress[] possibles;
                VirtualMachine vm;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("addServers(): Adding " + id + "..."));
                }
                if ((vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(id)) == null) {
                    logger.error((Object)("addServers(): Failed to add " + id + " because it does not exist"));
                    throw new CloudException("No such server: " + id);
                }
                String address = null;
                if (vm.getProviderRegionId().equals(this.provider.getContext().getRegionId())) {
                    possibles = vm.getPrivateAddresses();
                    String string = address = possibles != null && possibles.length > 0 ? possibles[0].getIpAddress() : null;
                }
                if (address == null) {
                    possibles = vm.getPublicAddresses();
                    String string = address = possibles != null && possibles.length > 0 ? possibles[0].getIpAddress() : null;
                }
                if (address == null) {
                    logger.error((Object)"addServers(): No address exists for mapping the load balancer to this server");
                    throw new CloudException("The virtual machine " + id + " has no mappable addresses");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("addServers(): Mapping IP is: " + address));
                }
                HashMap<String, Object> node = new HashMap<String, Object>();
                node.put("address", address);
                node.put("condition", "ENABLED");
                node.put("port", port);
                nodes.add(node);
            }
            if (!nodes.isEmpty()) {
                HashMap json = new HashMap();
                json.put("nodes", nodes);
                NovaMethod method = new NovaMethod(this.provider);
                if (logger.isTraceEnabled()) {
                    logger.debug((Object)"addServers(): Calling cloud...");
                }
                method.postString(SERVICE, RESOURCE, toLoadBalancerId + "/nodes", new JSONObject(json), false);
                if (logger.isTraceEnabled()) {
                    logger.debug((Object)"addServers(): Done.");
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Deprecated
    @Nonnull
    public String create(@Nonnull String name, @Nonnull String description, @Nullable String addressId, @Nullable String[] dataCenterIds, @Nullable LbListener[] listeners, @Nullable String[] serverIds) throws CloudException, InternalException {
        LoadBalancerCreateOptions options = addressId == null ? LoadBalancerCreateOptions.getInstance((String)name, (String)description) : LoadBalancerCreateOptions.getInstance((String)name, (String)description, (String)addressId);
        if (dataCenterIds != null) {
            options.limitedTo(dataCenterIds);
        }
        if (listeners != null) {
            options.havingListeners(listeners);
        }
        if (serverIds != null) {
            options.withVirtualMachines(serverIds);
        }
        return this.createLoadBalancer(options);
    }

    @Nonnull
    public String createLoadBalancer(@Nonnull LoadBalancerCreateOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.create");
        try {
            block28: {
                JSONObject result;
                LbListener[] listeners = options.getListeners();
                if (listeners == null || listeners.length < 1) {
                    logger.error((Object)"create(): Call failed to specify any listeners");
                    throw new CloudException("Rackspace requires exactly one listener");
                }
                HashMap<String, Object> lb = new HashMap<String, Object>();
                lb.put("name", options.getName());
                lb.put("port", listeners[0].getPublicPort());
                if (listeners[0].getNetworkProtocol().equals((Object)LbProtocol.HTTP)) {
                    lb.put("protocol", "HTTP");
                } else if (listeners[0].getNetworkProtocol().equals((Object)LbProtocol.HTTPS)) {
                    lb.put("protocol", "HTTPS");
                } else if (listeners[0].getNetworkProtocol().equals((Object)LbProtocol.RAW_TCP)) {
                    lb.put("protocol", this.matchProtocol(listeners[0].getPublicPort()));
                } else {
                    logger.error((Object)("Invalid protocol: " + listeners[0].getNetworkProtocol()));
                    throw new CloudException("Unsupported protocol: " + listeners[0].getNetworkProtocol());
                }
                if (listeners[0].getAlgorithm().equals((Object)LbAlgorithm.LEAST_CONN)) {
                    lb.put("algorithm", "LEAST_CONNECTIONS");
                } else if (listeners[0].getAlgorithm().equals((Object)LbAlgorithm.ROUND_ROBIN)) {
                    lb.put("algorithm", "ROUND_ROBIN");
                } else {
                    logger.error((Object)("create(): Invalid algorithm: " + listeners[0].getAlgorithm()));
                    throw new CloudException("Unsupported algorithm: " + listeners[0].getAlgorithm());
                }
                ArrayList ips = new ArrayList();
                HashMap<String, String> ip = new HashMap<String, String>();
                ip.put("type", "PUBLIC");
                ips.add(ip);
                lb.put("virtualIps", ips);
                ArrayList nodes = new ArrayList();
                LoadBalancerEndpoint[] endpoints = options.getEndpoints();
                if (endpoints != null) {
                    TreeSet<String> addresses = new TreeSet<String>();
                    for (LoadBalancerEndpoint endpoint : endpoints) {
                        String address = null;
                        if (endpoint.getEndpointType().equals((Object)LbEndpointType.IP)) {
                            address = endpoint.getEndpointValue();
                        } else {
                            VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(endpoint.getEndpointValue());
                            if (vm != null) {
                                RawAddress[] tmp;
                                if (vm.getProviderRegionId().equals(this.provider.getContext().getRegionId()) && (tmp = vm.getPrivateAddresses()) != null && tmp.length > 0) {
                                    address = tmp[0].getIpAddress();
                                }
                                if (address == null && (tmp = vm.getPublicAddresses()) != null && tmp.length > 0) {
                                    address = tmp[0].getIpAddress();
                                }
                            }
                        }
                        if (address == null || addresses.contains(address)) continue;
                        HashMap<String, Object> node = new HashMap<String, Object>();
                        node.put("address", address);
                        node.put("condition", "ENABLED");
                        node.put("port", listeners[0].getPrivatePort());
                        nodes.add(node);
                        addresses.add(address);
                    }
                }
                if (nodes.isEmpty()) {
                    logger.error((Object)"create(): Rackspace requires at least one node assignment");
                    throw new CloudException("Rackspace requires at least one node assignment");
                }
                lb.put("nodes", nodes);
                HashMap<String, HashMap<String, Object>> json = new HashMap<String, HashMap<String, Object>>();
                json.put("loadBalancer", lb);
                NovaMethod method = new NovaMethod(this.provider);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"create(): Posting new load balancer data...");
                }
                if ((result = method.postString(SERVICE, RESOURCE, null, new JSONObject(json), false)) == null) {
                    logger.error((Object)"create(): Method executed successfully, but no load balancer was created");
                    throw new CloudException("Method executed successfully, but no load balancer was created");
                }
                try {
                    JSONObject ob;
                    if (!result.has("loadBalancer") || (ob = result.getJSONObject("loadBalancer")) == null) break block28;
                    String string = ob.getString("id");
                    return string;
                }
                catch (JSONException e) {
                    logger.error((Object)("create(): Failed to identify a load balancer ID in the cloud response: " + e.getMessage()));
                    throw new CloudException("Failed to identify a load balancer ID in the cloud response: " + e.getMessage());
                }
            }
            logger.error((Object)"create(): Method executed successfully, but no load balancer was found in JSON");
            throw new CloudException("Method executed successfully, but no load balancer was found in JSON");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<LbEndpointType> listSupportedEndpointTypes() throws CloudException, InternalException {
        ArrayList<LbEndpointType> types = new ArrayList<LbEndpointType>();
        types.add(LbEndpointType.IP);
        types.add(LbEndpointType.VM);
        return types;
    }

    private String matchProtocol(int port) throws CloudException, InternalException {
        NovaMethod method = new NovaMethod(this.provider);
        JSONObject ob = method.getResource(SERVICE, RESOURCE, "protocols", false);
        if (ob == null) {
            return "TCP";
        }
        if (ob.has("protocols")) {
            try {
                JSONArray list = ob.getJSONArray("protocols");
                for (int i = 0; i < list.length(); ++i) {
                    JSONObject p = list.getJSONObject(i);
                    if (!p.has("port") || p.getInt("port") != port) continue;
                    return p.getString("name");
                }
            }
            catch (JSONException e) {
                throw new CloudException("Unable to parse protocols from Rackspace: " + e.getMessage());
            }
        }
        return "TCP";
    }

    @Nullable
    public LoadBalancer getLoadBalancer(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.getLoadBalancer");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getResource(SERVICE, RESOURCE, loadBalancerId, false);
            if (ob == null) {
                LoadBalancer loadBalancer = null;
                return loadBalancer;
            }
            Iterable<VirtualMachine> vms = this.provider.getComputeServices().getVirtualMachineSupport().listVirtualMachines();
            try {
                LoadBalancer lb;
                if (ob.has("loadBalancer") && (lb = this.toLoadBalancer(ob.getJSONObject("loadBalancer"), vms)) != null) {
                    LoadBalancer loadBalancer = lb;
                    return loadBalancer;
                }
                lb = null;
                return lb;
            }
            catch (JSONException e) {
                logger.error((Object)("listLoadBalancers(): Unable to identify expected values in JSON: " + e.getMessage()));
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for load balancers: " + e.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public LoadBalancerAddressType getAddressType() throws CloudException, InternalException {
        return LoadBalancerAddressType.IP;
    }

    public int getMaxPublicPorts() throws CloudException, InternalException {
        return 1;
    }

    @Nonnull
    public String getProviderTermForLoadBalancer(@Nonnull Locale locale) {
        return "load balancer";
    }

    @Nonnull
    public Iterable<LoadBalancerEndpoint> listEndpoints(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listEndpoints");
        try {
            JSONObject json;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getResource(SERVICE, RESOURCE, loadBalancerId, false);
            if (ob == null) {
                List<LoadBalancerEndpoint> list = Collections.emptyList();
                return list;
            }
            if (ob.has("loadBalancer") && !ob.isNull("loadBalancer") && (json = ob.getJSONObject("loadBalancer")).has("nodes")) {
                ArrayList<LoadBalancerEndpoint> endpoints = new ArrayList<LoadBalancerEndpoint>();
                JSONArray arr = json.getJSONArray("nodes");
                for (int i = 0; i < arr.length(); ++i) {
                    LbEndpointState state = LbEndpointState.ACTIVE;
                    JSONObject item = arr.getJSONObject(i);
                    if (item.has("condition") && !item.getString("condition").equalsIgnoreCase("enabled")) {
                        state = LbEndpointState.INACTIVE;
                    }
                    if (!item.has("address") || item.isNull("address")) continue;
                    String addr = item.getString("address");
                    VirtualMachine node = null;
                    block8: for (VirtualMachine vm : ((NovaOpenStack)this.getProvider()).getComputeServices().getVirtualMachineSupport().listVirtualMachines()) {
                        RawAddress[] addrs;
                        for (RawAddress a : addrs = vm.getPublicAddresses()) {
                            if (!addr.equals(a.getIpAddress())) continue;
                            node = vm;
                            break;
                        }
                        if (node != null) continue;
                        for (RawAddress a : addrs = vm.getPrivateAddresses()) {
                            if (!addr.equals(a.getIpAddress())) continue;
                            node = vm;
                            continue block8;
                        }
                    }
                    if (node != null) {
                        endpoints.add(LoadBalancerEndpoint.getInstance((LbEndpointType)LbEndpointType.VM, (String)node.getProviderVirtualMachineId(), (LbEndpointState)state));
                        continue;
                    }
                    endpoints.add(LoadBalancerEndpoint.getInstance((LbEndpointType)LbEndpointType.IP, (String)addr, (LbEndpointState)state));
                }
                ArrayList<LoadBalancerEndpoint> arrayList = endpoints;
                return arrayList;
            }
            json = Collections.emptyList();
            return json;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<LoadBalancerEndpoint> listEndpoints(@Nonnull String loadBalancerId, @Nonnull LbEndpointType type, String ... values) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listEndpoints");
        try {
            JSONObject json;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getResource(SERVICE, RESOURCE, loadBalancerId, false);
            if (ob == null) {
                List<LoadBalancerEndpoint> list = Collections.emptyList();
                return list;
            }
            if (ob.has("loadBalancer") && !ob.isNull("loadBalancer") && (json = ob.getJSONObject("loadBalancer")).has("nodes")) {
                ArrayList<LoadBalancerEndpoint> endpoints = new ArrayList<LoadBalancerEndpoint>();
                JSONArray arr = json.getJSONArray("nodes");
                for (int i = 0; i < arr.length(); ++i) {
                    LbEndpointState state = LbEndpointState.ACTIVE;
                    JSONObject item = arr.getJSONObject(i);
                    if (item.has("condition") && !item.getString("condition").equalsIgnoreCase("enabled")) {
                        state = LbEndpointState.INACTIVE;
                    }
                    if (!item.has("address") || item.isNull("address")) continue;
                    String addr = item.getString("address");
                    VirtualMachine node = null;
                    block8: for (VirtualMachine vm : ((NovaOpenStack)this.getProvider()).getComputeServices().getVirtualMachineSupport().listVirtualMachines()) {
                        RawAddress[] addrs;
                        for (RawAddress a : addrs = vm.getPublicAddresses()) {
                            if (!addr.equals(a.getIpAddress())) continue;
                            node = vm;
                            break;
                        }
                        if (node != null) continue;
                        for (RawAddress a : addrs = vm.getPrivateAddresses()) {
                            if (!addr.equals(a.getIpAddress())) continue;
                            node = vm;
                            continue block8;
                        }
                    }
                    if (node != null && type.equals((Object)LbEndpointType.VM)) {
                        boolean included = true;
                        if (values.length > 0) {
                            included = false;
                            for (String value : values) {
                                if (!value.equals(node.getProviderVirtualMachineId())) continue;
                                included = true;
                                break;
                            }
                        }
                        if (!included) continue;
                        endpoints.add(LoadBalancerEndpoint.getInstance((LbEndpointType)LbEndpointType.VM, (String)node.getProviderVirtualMachineId(), (LbEndpointState)state));
                        continue;
                    }
                    if (node != null || !type.equals((Object)LbEndpointType.IP)) continue;
                    boolean included = true;
                    if (values.length > 0) {
                        included = false;
                        for (String value : values) {
                            if (!value.equals(addr)) continue;
                            included = true;
                            break;
                        }
                    }
                    if (!included) continue;
                    endpoints.add(LoadBalancerEndpoint.getInstance((LbEndpointType)LbEndpointType.IP, (String)addr, (LbEndpointState)LbEndpointState.ACTIVE));
                }
                ArrayList<LoadBalancerEndpoint> arrayList = endpoints;
                return arrayList;
            }
            json = Collections.emptyList();
            return json;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<ResourceStatus> listLoadBalancerStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listLoadBalancerStatus");
        try {
            JSONArray lbs;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getResource(SERVICE, RESOURCE, null, false);
            if (ob == null) {
                List<ResourceStatus> list = Collections.emptyList();
                return list;
            }
            ArrayList<ResourceStatus> loadBalancers = new ArrayList<ResourceStatus>();
            if (ob.has("loadBalancers") && (lbs = ob.getJSONArray("loadBalancers")).length() > 0) {
                for (int i = 0; i < lbs.length(); ++i) {
                    ResourceStatus lb;
                    JSONObject actual;
                    JSONObject tmp = lbs.getJSONObject(i);
                    if (!tmp.has("id") || (actual = method.getResource(SERVICE, RESOURCE, tmp.getString("id"), false)) == null || !actual.has("loadBalancer") || (lb = this.toStatus(actual.getJSONObject("loadBalancer"))) == null) continue;
                    loadBalancers.add(lb);
                }
            }
            ArrayList<ResourceStatus> arrayList = loadBalancers;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<LbAlgorithm> listSupportedAlgorithms() throws CloudException, InternalException {
        if (supportedAlgorithms == null) {
            ArrayList<LbAlgorithm> algorithms = new ArrayList<LbAlgorithm>();
            algorithms.add(LbAlgorithm.ROUND_ROBIN);
            algorithms.add(LbAlgorithm.LEAST_CONN);
            supportedAlgorithms = Collections.unmodifiableList(algorithms);
        }
        return supportedAlgorithms;
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    @Nonnull
    public Iterable<LbProtocol> listSupportedProtocols() throws CloudException, InternalException {
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"lbProtocols", LbProtocol.class, (CacheLevel)CacheLevel.REGION_ACCOUNT);
        Iterable protocols = cache.get(this.getContext());
        if (protocols != null) {
            return protocols;
        }
        NovaMethod method = new NovaMethod(this.provider);
        JSONObject ob = method.getResource(SERVICE, RESOURCE, "protocols", false);
        if (ob == null || !ob.has("protocols") || ob.isNull("protocols")) {
            return Collections.singletonList(LbProtocol.RAW_TCP);
        }
        ArrayList<LbProtocol> list = new ArrayList<LbProtocol>();
        list.add(LbProtocol.RAW_TCP);
        try {
            JSONArray matches = ob.getJSONArray("protocols");
            for (int i = 0; i < matches.length(); ++i) {
                String name;
                JSONObject p = matches.getJSONObject(i);
                String string = name = p.has("name") && !p.isNull("name") ? p.getString("name") : null;
                if (name == null) continue;
                if (name.equalsIgnoreCase("http")) {
                    list.add(LbProtocol.HTTP);
                    continue;
                }
                if (!name.equalsIgnoreCase("https")) continue;
                list.add(LbProtocol.HTTPS);
            }
        }
        catch (JSONException e) {
            throw new CloudException("Unable to parse protocols from Rackspace: " + e.getMessage());
        }
        cache.put(this.getContext(), list);
        return list;
    }

    @Nonnull
    public Requirement identifyEndpointsOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyListenersOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public boolean isAddressAssignedByProvider() throws CloudException, InternalException {
        return true;
    }

    public boolean isDataCenterLimited() throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.testContext() != null;
    }

    @Nonnull
    public Iterable<LoadBalancer> listLoadBalancers() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listLoadBalancers");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getResource(SERVICE, RESOURCE, null, false);
            try {
                JSONArray lbs;
                ArrayList<LoadBalancer> loadBalancers = new ArrayList<LoadBalancer>();
                if (ob.has("loadBalancers") && (lbs = ob.getJSONArray("loadBalancers")).length() > 0) {
                    Iterable<VirtualMachine> vms = this.provider.getComputeServices().getVirtualMachineSupport().listVirtualMachines();
                    for (int i = 0; i < lbs.length(); ++i) {
                        LoadBalancer lb;
                        JSONObject actual;
                        JSONObject tmp = lbs.getJSONObject(i);
                        if (!tmp.has("id") || (actual = method.getResource(SERVICE, RESOURCE, tmp.getString("id"), false)) == null || !actual.has("loadBalancer") || (lb = this.toLoadBalancer(actual.getJSONObject("loadBalancer"), vms)) == null) continue;
                        loadBalancers.add(lb);
                    }
                }
                ArrayList<LoadBalancer> arrayList = loadBalancers;
                return arrayList;
            }
            catch (JSONException e) {
                logger.error((Object)("listLoadBalancers(): Unable to identify expected values in JSON: " + e.getMessage()));
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for load balancers: " + e.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Deprecated
    public void remove(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        this.removeLoadBalancer(loadBalancerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadBalancer(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.removeLoadBalancer");
        try {
            long timeout = System.currentTimeMillis() + 300000L;
            while (timeout > System.currentTimeMillis()) {
                LoadBalancer lb;
                block18: {
                    lb = this.getLoadBalancer(loadBalancerId);
                    if (lb != null) break block18;
                    return;
                }
                try {
                    if (!LoadBalancerState.PENDING.equals((Object)lb.getCurrentState())) {
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {}
            }
            NovaMethod method = new NovaMethod(this.provider);
            timeout = System.currentTimeMillis() + 3600000L;
            while (true) {
                try {
                    method.deleteResource(SERVICE, RESOURCE, loadBalancerId, null);
                    return;
                }
                catch (NovaException e) {
                    if (e.getHttpCode() != 409 || e.getHttpCode() == 422) {
                        throw e;
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < timeout) continue;
                    APITrace.end();
                }
                break;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Node> getNodes(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.getNodes");
        try {
            ArrayList<Node> nodes = new ArrayList<Node>();
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject response = method.getResource(SERVICE, RESOURCE, loadBalancerId + "/nodes", false);
            if (response != null && response.has("nodes")) {
                try {
                    JSONArray arr = response.getJSONArray("nodes");
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject node = arr.getJSONObject(i);
                        Node n = new Node();
                        n.nodeId = node.getString("id");
                        n.address = node.getString("address");
                        nodes.add(n);
                    }
                }
                catch (JSONException e) {
                    throw new CloudException("Unable to read nodes: " + e.getMessage());
                }
            }
            ArrayList<Node> arrayList = nodes;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private Collection<String> mapIPs(@Nonnull String loadBalancerId, @Nullable String[] addresses) throws CloudException, InternalException {
        TreeSet<String> nodeIds = new TreeSet<String>();
        if (addresses != null && addresses.length > 0) {
            Collection<Node> nodes = this.getNodes(loadBalancerId);
            block0: for (String address : addresses) {
                for (Node n : nodes) {
                    if (!n.address.equals(address)) continue;
                    nodeIds.add(n.nodeId);
                    continue block0;
                }
            }
        }
        return nodeIds;
    }

    @Nonnull
    private Collection<String> mapNodes(@Nonnull ProviderContext ctx, @Nonnull String loadBalancerId, @Nullable String[] serverIds) throws CloudException, InternalException {
        TreeSet<String> nodeIds = new TreeSet<String>();
        if (serverIds != null && serverIds.length > 0) {
            Collection<Node> nodes = this.getNodes(loadBalancerId);
            block0: for (String serverId : serverIds) {
                RawAddress[] addrs;
                VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(serverId);
                if (vm == null) continue;
                boolean there = false;
                if (vm.getProviderRegionId().equals(ctx.getRegionId())) {
                    for (RawAddress addr : addrs = vm.getPrivateAddresses()) {
                        for (Node n : nodes) {
                            if (!n.address.equals(addr.getIpAddress())) continue;
                            nodeIds.add(n.nodeId);
                            there = true;
                            break;
                        }
                        if (there) break;
                    }
                }
                if (there) continue;
                for (RawAddress addr : addrs = vm.getPublicAddresses()) {
                    for (Node n : nodes) {
                        if (!n.address.equals(addr.getIpAddress())) continue;
                        nodeIds.add(n.nodeId);
                        there = true;
                        break;
                    }
                    if (there) continue block0;
                }
            }
        }
        return nodeIds;
    }

    public void removeDataCenters(@Nonnull String fromLoadBalancerId, String ... dataCenterIdsToRemove) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No data center constraints in Rackspace");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIPEndpoints(@Nonnull String fromLoadBalancerId, String ... addresses) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.removeIPEndpoints");
        try {
            LoadBalancer lb = this.getLoadBalancer(fromLoadBalancerId);
            if (lb == null || LoadBalancerState.TERMINATED.equals((Object)lb.getCurrentState())) {
                throw new CloudException("No such load balancer: " + fromLoadBalancerId);
            }
            while (LoadBalancerState.PENDING.equals((Object)lb.getCurrentState())) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if ((lb = this.getLoadBalancer(fromLoadBalancerId)) != null && !LoadBalancerState.TERMINATED.equals((Object)lb.getCurrentState())) continue;
                throw new CloudException("No such load balancer: " + fromLoadBalancerId);
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            Collection<String> nodeIds = this.mapIPs(fromLoadBalancerId, addresses);
            if (nodeIds.size() < 1) {
                return;
            }
            StringBuilder nodeString = new StringBuilder();
            for (String id : nodeIds) {
                if (nodeString.length() > 0) {
                    nodeString.append("&");
                }
                nodeString.append("id=");
                nodeString.append(id);
            }
            NovaMethod method = new NovaMethod(this.provider);
            method.deleteResource(SERVICE, RESOURCE, fromLoadBalancerId + "/nodes?" + nodeString.toString(), null);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServers(@Nonnull String fromLoadBalancerId, String ... serverIdsToRemove) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.removeServers");
        try {
            LoadBalancer lb = this.getLoadBalancer(fromLoadBalancerId);
            if (lb == null || LoadBalancerState.TERMINATED.equals((Object)lb.getCurrentState())) {
                throw new CloudException("No such load balancer: " + fromLoadBalancerId);
            }
            while (LoadBalancerState.PENDING.equals((Object)lb.getCurrentState())) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if ((lb = this.getLoadBalancer(fromLoadBalancerId)) != null && !LoadBalancerState.TERMINATED.equals((Object)lb.getCurrentState())) continue;
                throw new CloudException("No such load balancer: " + fromLoadBalancerId);
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            Collection<String> nodeIds = this.mapNodes(ctx, fromLoadBalancerId, serverIdsToRemove);
            if (nodeIds.size() < 1) {
                return;
            }
            StringBuilder nodeString = new StringBuilder();
            for (String id : nodeIds) {
                if (nodeString.length() > 0) {
                    nodeString.append("&");
                }
                nodeString.append("id=");
                nodeString.append(id);
            }
            NovaMethod method = new NovaMethod(this.provider);
            method.deleteResource(SERVICE, RESOURCE, fromLoadBalancerId + "/nodes?" + nodeString.toString(), null);
        }
        finally {
            APITrace.end();
        }
    }

    public boolean supportsAddingEndpoints() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsMonitoring() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsMultipleTrafficTypes() throws CloudException, InternalException {
        return false;
    }

    @Nullable
    private LoadBalancer toLoadBalancer(@Nullable JSONObject json, @Nullable Iterable<VirtualMachine> possibleNodes) throws InternalException, CloudException {
        if (json == null) {
            return null;
        }
        try {
            JSONObject ob;
            String[] dataCenterIds = new String[]{this.getContext().getRegionId() + "-a"};
            String owner = this.getTenantId();
            String regionId = this.getContext().getRegionId();
            String id = json.has("id") && !json.isNull("id") ? json.getString("id") : null;
            String name = json.has("name") && !json.isNull("name") ? json.getString("name") : null;
            long created = 0L;
            if (id == null) {
                return null;
            }
            if (regionId == null) {
                throw new CloudException("No region was set for this request");
            }
            if (name == null) {
                name = id;
            }
            if (json.has("created") && !json.isNull("created") && (ob = json.getJSONObject("created")).has("time") && !ob.isNull("time")) {
                created = this.provider.parseTimestamp(ob.getString("time"));
            }
            LoadBalancerState state = LoadBalancerState.PENDING;
            if (json.has("status") && !json.isNull("status")) {
                String s = json.getString("status").toLowerCase();
                state = s.equalsIgnoreCase("active") ? LoadBalancerState.ACTIVE : (s.equalsIgnoreCase("pending_delete") || s.equalsIgnoreCase("deleted") ? LoadBalancerState.TERMINATED : LoadBalancerState.PENDING);
            }
            String address = null;
            if (json.has("virtualIps")) {
                JSONArray arr = json.getJSONArray("virtualIps");
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject ob2 = arr.getJSONObject(i);
                    if (!ob2.has("ipVersion") || !ob2.getString("ipVersion").equalsIgnoreCase("ipv4") || !ob2.has("address")) continue;
                    address = ob2.getString("address");
                    break;
                }
            }
            if (address == null) {
                return null;
            }
            ArrayList<String> nodes = new ArrayList<String>();
            int privatePort = -1;
            if (json.has("nodes")) {
                JSONArray arr = json.getJSONArray("nodes");
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject ob3 = arr.getJSONObject(i);
                    if (ob3.has("address")) {
                        String addr = ob3.getString("address");
                        VirtualMachine node = null;
                        if (possibleNodes != null) {
                            block4: for (VirtualMachine vm : possibleNodes) {
                                RawAddress[] addrs;
                                for (RawAddress a : addrs = vm.getPublicAddresses()) {
                                    if (!addr.equals(a.getIpAddress())) continue;
                                    node = vm;
                                    break;
                                }
                                if (node != null) continue;
                                for (RawAddress a : addrs = vm.getPrivateAddresses()) {
                                    if (!addr.equals(a.getIpAddress())) continue;
                                    node = vm;
                                    continue block4;
                                }
                            }
                        }
                        if (node == null) continue;
                        nodes.add(node.getProviderVirtualMachineId());
                        continue;
                    }
                    if (!ob3.has("port")) continue;
                    privatePort = ob3.getInt("port");
                }
            }
            int port = -1;
            if (json.has("port")) {
                port = json.getInt("port");
                if (privatePort == -1) {
                    privatePort = port;
                }
            }
            int[] ports = new int[]{port};
            LbProtocol protocol = LbProtocol.RAW_TCP;
            if (json.has("protocol")) {
                String p = json.getString("protocol");
                if (p.equals("HTTP")) {
                    protocol = LbProtocol.HTTP;
                } else if (p.equals("HTTPS")) {
                    protocol = LbProtocol.HTTPS;
                } else if (p.equals("AJP")) {
                    protocol = LbProtocol.AJP;
                }
            }
            LbAlgorithm algorithm = LbAlgorithm.ROUND_ROBIN;
            if (json.has("algorithm")) {
                String a = json.getString("algorithm").toLowerCase();
                if (a.equals("round_robin")) {
                    algorithm = LbAlgorithm.ROUND_ROBIN;
                } else if (a.equals("least_connections")) {
                    algorithm = LbAlgorithm.LEAST_CONN;
                }
            }
            LoadBalancer lb = LoadBalancer.getInstance((String)owner, (String)regionId, (String)id, (LoadBalancerState)state, (String)name, (String)(name + " [" + address + "]"), (LoadBalancerAddressType)LoadBalancerAddressType.IP, (String)address, (int[])ports).createdAt(created);
            lb.operatingIn(dataCenterIds);
            lb.supportingTraffic(new IPVersion[]{IPVersion.IPV4});
            lb.withListeners(new LbListener[]{LbListener.getInstance((LbAlgorithm)algorithm, (LbPersistence)LbPersistence.NONE, (LbProtocol)protocol, (int)port, (int)privatePort)});
            if (!nodes.isEmpty()) {
                lb.setProviderServerIds(nodes.toArray(new String[nodes.size()]));
            }
            return lb;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject json) throws JSONException, CloudException {
        String id;
        if (json == null) {
            return null;
        }
        String string = id = json.has("id") ? json.getString("id") : null;
        if (id == null || id.length() < 1) {
            return null;
        }
        LoadBalancerState state = LoadBalancerState.PENDING;
        if (json.has("status")) {
            String s = json.getString("status").toLowerCase();
            state = s.equals("active") ? LoadBalancerState.ACTIVE : (s.equalsIgnoreCase("pending_delete") || s.equalsIgnoreCase("deleted") ? LoadBalancerState.TERMINATED : LoadBalancerState.PENDING);
        }
        return new ResourceStatus(id, (Object)state);
    }

    private static class Node {
        public String nodeId;
        public String address;

        private Node() {
        }
    }
}

