/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AddressType;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.openstack.nova.os.NovaException;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.util.APITrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NovaFloatingIP
implements IpAddressSupport {
    private static final Logger logger = NovaOpenStack.getLogger(NovaFloatingIP.class, "std");
    public static final String QUANTIUM_TARGET = "/floating-ips";
    public static final String NOVA_TARGET = "/os-floating-ips";
    private NovaOpenStack provider;
    private static volatile List<IPVersion> versions;

    NovaFloatingIP(NovaOpenStack cloud) {
        this.provider = cloud;
    }

    private String getEndpoint() {
        return NOVA_TARGET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(@Nonnull String addressId, @Nonnull String serverId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"IpAddress.assign");
        try {
            HashMap json = new HashMap();
            HashMap<String, String> action = new HashMap<String, String>();
            IpAddress addr = this.getIpAddress(addressId);
            if (addr == null) {
                throw new CloudException("No such IP address: " + addressId);
            }
            action.put("address", addr.getRawAddress().getIpAddress());
            json.put("addFloatingIp", action);
            NovaMethod method = new NovaMethod(this.provider);
            method.postServers("/servers", serverId, new JSONObject(json), true);
        }
        finally {
            APITrace.end();
        }
    }

    public void assignToNetworkInterface(@Nonnull String addressId, @Nonnull String nicId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Network interfaces are not currently supported");
    }

    @Nonnull
    public String forward(@Nonnull String addressId, int publicPort, @Nonnull Protocol protocol, int privatePort, @Nonnull String onServerId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("IP forwarding is not currently supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IpAddress getIpAddress(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"IpAddress.getIpAddress");
        try {
            JSONObject json;
            IpAddress addr;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getServers(this.getEndpoint(), addressId, false);
            if (ob == null) {
                IpAddress ipAddress = null;
                return ipAddress;
            }
            if (ob.has("floating_ip") && (addr = this.toIP(ctx, json = ob.getJSONObject("floating_ip"))) != null) {
                IpAddress ipAddress = addr;
                return ipAddress;
            }
            IpAddress ipAddress = null;
            return ipAddress;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForIpAddress(@Nonnull Locale locale) {
        return "floating IP";
    }

    @Nonnull
    public Requirement identifyVlanForVlanIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isAssigned(@Nonnull AddressType type) {
        return type.equals((Object)AddressType.PUBLIC) || type.equals((Object)AddressType.PRIVATE);
    }

    public boolean isAssigned(@Nonnull IPVersion version) throws CloudException, InternalException {
        return this.getVersions().contains(version);
    }

    public boolean isAssignablePostLaunch(@Nonnull IPVersion version) throws CloudException, InternalException {
        return this.getVersions().contains(version);
    }

    public boolean isForwarding() {
        return false;
    }

    public boolean isForwarding(IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isRequestable(@Nonnull AddressType type) {
        return type.equals((Object)AddressType.PUBLIC) || type.equals((Object)AddressType.PRIVATE);
    }

    public boolean isRequestable(@Nonnull IPVersion version) throws CloudException, InternalException {
        return this.getVersions().contains(version);
    }

    private boolean verifySupport() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"IpAddress.verifySupport");
        try {
            NovaMethod method = new NovaMethod(this.provider);
            try {
                method.getServers(this.getEndpoint(), null, false);
                boolean bl = true;
                return bl;
            }
            catch (CloudException e) {
                block7: {
                    if (e.getHttpCode() != 404) break block7;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"IpAddress.isSubscribed");
        try {
            if (this.provider.getMajorVersion() > 1 && this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed()) {
                boolean bl = this.verifySupport();
                return bl;
            }
            if (this.provider.getMajorVersion() == 1 && this.provider.getMinorVersion() >= 1 && this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed()) {
                boolean bl = this.verifySupport();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<IpAddress> listPrivateIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IpAddress> listPublicIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return this.listIpPool(IPVersion.IPV4, unassignedOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<IpAddress> listIpPool(@Nonnull IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"IpAddress.listIpPool");
        try {
            if (!this.getVersions().contains(version)) {
                List<IpAddress> list = Collections.emptyList();
                return list;
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getServers(this.getEndpoint(), null, false);
            ArrayList<IpAddress> addresses = new ArrayList<IpAddress>();
            try {
                if (ob != null && ob.has("floating_ips")) {
                    JSONArray list = ob.getJSONArray("floating_ips");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject json = list.getJSONObject(i);
                        try {
                            IpAddress addr = this.toIP(ctx, json);
                            if (addr == null || unassignedOnly && addr.getServerId() != null) continue;
                            addresses.add(addr);
                            continue;
                        }
                        catch (JSONException e) {
                            logger.error((Object)("Invalid JSON from cloud: " + e.getMessage()));
                            throw new CloudException("Invalid JSON from cloud: " + e.getMessage());
                        }
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("list(): Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for floating IP in " + ob.toString());
            }
            ArrayList<IpAddress> arrayList = addresses;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listIpPoolStatus(@Nonnull IPVersion version) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"IpAddress.listIpPoolStatus");
        try {
            if (!this.getVersions().contains(version)) {
                List<ResourceStatus> list = Collections.emptyList();
                return list;
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getServers(this.getEndpoint(), null, false);
            ArrayList<ResourceStatus> addresses = new ArrayList<ResourceStatus>();
            try {
                if (ob != null && ob.has("floating_ips")) {
                    JSONArray list = ob.getJSONArray("floating_ips");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject json = list.getJSONObject(i);
                        try {
                            ResourceStatus addr = this.toStatus(json);
                            if (addr == null) continue;
                            addresses.add(addr);
                            continue;
                        }
                        catch (JSONException e) {
                            throw new CloudException("Invalid JSON from cloud: " + e.getMessage());
                        }
                    }
                }
            }
            catch (JSONException e) {
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for floating IP in " + ob.toString());
            }
            ArrayList<ResourceStatus> arrayList = addresses;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<IpForwardingRule> listRules(@Nonnull String addressId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    private Collection<IPVersion> getVersions() {
        if (versions == null) {
            ArrayList<IPVersion> tmp = new ArrayList<IPVersion>();
            tmp.add(IPVersion.IPV4);
            versions = Collections.unmodifiableList(tmp);
        }
        return versions;
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return this.getVersions();
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFromPool(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"IpAddress.releaseFromPool");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            long timeout = System.currentTimeMillis() + 3600000L;
            while (true) {
                try {
                    method.deleteServers(this.getEndpoint(), addressId);
                    return;
                }
                catch (NovaException e) {
                    if (e.getHttpCode() != 409) {
                        throw e;
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < timeout) continue;
                    APITrace.end();
                }
                break;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFromServer(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"IpAddress.releaseFromServer");
        try {
            HashMap json = new HashMap();
            HashMap<String, String> action = new HashMap<String, String>();
            IpAddress addr = this.getIpAddress(addressId);
            if (addr == null) {
                throw new CloudException("No such IP address: " + addressId);
            }
            String serverId = addr.getServerId();
            if (serverId == null) {
                throw new CloudException("IP address " + addressId + " is not attached to a server");
            }
            action.put("address", addr.getRawAddress().getIpAddress());
            json.put("removeFloatingIp", action);
            NovaMethod method = new NovaMethod(this.provider);
            method.postServers("/servers", serverId, new JSONObject(json), true);
        }
        finally {
            APITrace.end();
        }
    }

    private Iterable<String> listPools() throws CloudException, InternalException {
        NovaMethod method = new NovaMethod(this.provider);
        JSONObject ob = method.getServers("/os-floating-ip-pools", null, false);
        ArrayList<String> pools = new ArrayList<String>();
        ArrayList<String> tmp = new ArrayList<String>();
        try {
            if (ob != null && ob.has("floating_ip_pools")) {
                JSONArray list = ob.getJSONArray("floating_ip_pools");
                for (int i = 0; i < list.length(); ++i) {
                    JSONObject p = list.getJSONObject(i);
                    if (!p.has("name")) continue;
                    String n = p.getString("name");
                    if (n.equals("default")) {
                        pools.add(n);
                        continue;
                    }
                    tmp.add(n);
                }
                pools.addAll(tmp);
            }
        }
        catch (JSONException e) {
            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for IP address");
        }
        return pools;
    }

    @Nonnull
    public String request(@Nonnull AddressType typeOfAddress) throws InternalException, CloudException {
        if (typeOfAddress.equals((Object)AddressType.PRIVATE)) {
            throw new OperationNotSupportedException("Requesting private IP addresses is not supported by OpenStack");
        }
        return this.request(IPVersion.IPV4);
    }

    @Nonnull
    public String request(@Nonnull IPVersion version) throws InternalException, CloudException {
        try {
            return this.request(version, null);
        }
        catch (NovaException e) {
            if (e.getHttpCode() == 404) {
                for (String pool : this.listPools()) {
                    try {
                        return this.request(version, pool);
                    }
                    catch (CloudException ignore) {
                    }
                }
            }
            throw e;
        }
    }

    @Nonnull
    private String request(@Nonnull IPVersion version, @Nullable String pool) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"IpAddress.request");
        try {
            JSONObject result;
            if (!this.getVersions().contains(version)) {
                throw new OperationNotSupportedException("Cannot request an IPv6 IP address at this time");
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            HashMap<String, String> wrapper = new HashMap<String, String>();
            if (pool != null) {
                wrapper.put("pool", pool);
            }
            NovaMethod method = new NovaMethod(this.provider);
            if (pool != null) {
                wrapper.put("pool", pool);
            }
            if ((result = method.postServers(this.getEndpoint(), null, new JSONObject(wrapper), false)) != null && result.has("floating_ip")) {
                try {
                    JSONObject ob = result.getJSONObject("floating_ip");
                    IpAddress addr = this.toIP(ctx, ob);
                    if (addr != null) {
                        String string = addr.getProviderIpAddressId();
                        return string;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("create(): Unable to understand create response: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"create(): No IP address was created by the create attempt, and no error was returned");
            throw new CloudException("No IP address was created");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version) throws InternalException, CloudException {
        throw new OperationNotSupportedException(this.provider.getCloudName() + " does not support static IP addresses for VLANs");
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version, @Nonnull String vlanId) throws InternalException, CloudException {
        throw new OperationNotSupportedException(this.provider.getCloudName() + " does not support static IP addresses for VLANs");
    }

    public void stopForward(@Nonnull String ruleId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Forwarding not supported");
    }

    public boolean supportsVLANAddresses(@Nonnull IPVersion ofVersion) throws InternalException, CloudException {
        return false;
    }

    private IpAddress toIP(ProviderContext ctx, JSONObject json) throws JSONException {
        String server;
        if (json == null) {
            return null;
        }
        String regionId = ctx.getRegionId();
        IpAddress address = new IpAddress();
        if (regionId != null) {
            address.setRegionId(regionId);
        }
        address.setServerId(null);
        address.setProviderLoadBalancerId(null);
        address.setAddressType(AddressType.PUBLIC);
        String id = json.has("id") && !json.isNull("id") ? json.getString("id") : null;
        String ip = json.has("ip") && !json.isNull("ip") ? json.getString("ip") : null;
        String string = server = json.has("instance_id") && !json.isNull("instance_id") ? json.getString("instance_id") : null;
        if (id != null) {
            address.setIpAddressId(id);
        }
        if (server != null) {
            address.setServerId(server);
        }
        if (ip != null) {
            address.setAddress(ip);
        }
        if (id == null || ip == null) {
            return null;
        }
        address.setVersion(IPVersion.IPV4);
        return address;
    }

    private ResourceStatus toStatus(JSONObject json) throws JSONException {
        String id;
        if (json == null) {
            return null;
        }
        Boolean available = null;
        String string = id = json.has("id") ? json.getString("id") : null;
        if (json.has("instance_id")) {
            String instance = json.getString("instance_id");
            available = instance == null || instance.length() <= 0;
        }
        if (id == null) {
            return null;
        }
        return new ResourceStatus(id, (Object)(available == null ? true : available));
    }
}

