/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.NameRules;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.openstack.nova.os.AuthenticationContext;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.SwiftMethod;
import org.dasein.cloud.storage.AbstractBlobStoreSupport;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.FileTransfer;
import org.dasein.cloud.util.APITrace;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class SwiftBlobStore
extends AbstractBlobStoreSupport {
    private static final Logger logger = NovaOpenStack.getLogger(SwiftBlobStore.class, "std");
    public static final int MAX_BUCKETS = 100;
    public static final int MAX_OBJECTS = -1;
    public static final Storage<Byte> MAX_OBJECT_SIZE = new Storage((Number)5000000000L, (StorageUnit)Storage.BYTE);
    private NovaOpenStack provider = null;

    SwiftBlobStore(@Nonnull NovaOpenStack provider) {
        this.provider = provider;
    }

    public boolean allowsNestedBuckets() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsRootObjects() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsPublicSharing() throws CloudException, InternalException {
        return false;
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public Blob createBucket(@Nonnull String bucketName, boolean findFreeName) throws InternalException, CloudException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBucket(@Nonnull String name) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.createBucket");
        try {
            try {
                SwiftMethod method = new SwiftMethod(this.provider);
                method.put(name);
            }
            catch (RuntimeException e) {
                logger.error((Object)("Could not create bucket: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean exists(@Nonnull String bucketName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"exists");
        try {
            SwiftMethod method = new SwiftMethod(this.provider);
            for (String container : method.get(null)) {
                if (!container.equals(bucketName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            logger.error((Object)("Could not retrieve file info for " + bucketName + ": " + e.getMessage()));
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBucket(@Nonnull String bucketName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.getBucket");
        try {
            for (Blob blob : this.list(null)) {
                String name;
                if (!blob.isContainer() || (name = blob.getBucketName()) == null || !name.equals(bucketName)) continue;
                Blob blob2 = blob;
                return blob2;
            }
            Blob blob = null;
            return blob;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getObject(@Nullable String bucketName, @Nonnull String objectName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.getObject");
        try {
            if (bucketName == null) {
                Blob blob = null;
                return blob;
            }
            for (Blob blob : this.list(bucketName)) {
                String name = blob.getObjectName();
                if (name == null || !name.equals(objectName)) continue;
                Blob blob2 = blob;
                return blob2;
            }
            Blob blob = null;
            return blob;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Storage<Byte> getObjectSize(@Nullable String bucket, @Nullable String object) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.getObjectSize");
        try {
            if (bucket == null) {
                throw new CloudException("Requested object size for object in null bucket");
            }
            if (object == null) {
                Storage<Byte> storage = null;
                return storage;
            }
            SwiftMethod method = new SwiftMethod(this.provider);
            Map<String, String> metaData = method.head(bucket, object);
            if (metaData == null) {
                Storage<Byte> storage = null;
                return storage;
            }
            long len = this.getMetaDataLength(metaData);
            if (len < 0L) {
                Storage<Byte> storage = null;
                return storage;
            }
            Storage storage = new Storage((Number)len, (StorageUnit)Storage.BYTE);
            return storage;
        }
        finally {
            APITrace.end();
        }
    }

    public int getMaxBuckets() throws CloudException, InternalException {
        return 100;
    }

    @Nonnull
    private String findFreeName(@Nonnull String bucket) throws InternalException, CloudException {
        String rawName;
        String prefix;
        int idx = bucket.lastIndexOf(".");
        if (idx == -1) {
            prefix = null;
            bucket = rawName = bucket;
        } else {
            prefix = bucket.substring(0, idx);
            rawName = bucket.substring(idx + 1);
            bucket = prefix + "." + rawName;
        }
        while (this.exists(bucket)) {
            idx = rawName.lastIndexOf("-");
            if (idx == -1) {
                rawName = rawName + "-1";
            } else if (idx == rawName.length() - 1) {
                rawName = rawName + "1";
            } else {
                String postfix = rawName.substring(idx + 1);
                try {
                    int x = Integer.parseInt(postfix) + 1;
                    rawName = rawName.substring(0, idx) + "-" + x;
                }
                catch (NumberFormatException e) {
                    rawName = rawName + "-1";
                }
            }
            if (prefix == null) {
                bucket = rawName;
                continue;
            }
            bucket = prefix + "." + rawName;
        }
        return bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void get(@Nullable String bucket, @Nonnull String location, @Nonnull File toFile, @Nullable FileTransfer transfer) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.get");
        try {
            if (bucket == null) {
                throw new OperationNotSupportedException("No such object: " + bucket + "/" + location);
            }
            if (toFile.exists() && !toFile.delete()) {
                throw new InternalException("File already exists that cannot be overwritten.");
            }
            SwiftMethod method = new SwiftMethod(this.provider);
            InputStream input = method.get(bucket, location);
            if (input == null) {
                throw new CloudException("No such object: " + bucket + "/" + location);
            }
            try {
                this.copy(input, new FileOutputStream(toFile), transfer);
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public Storage<Byte> getMaxObjectSize() {
        return MAX_OBJECT_SIZE;
    }

    public int getMaxObjectsPerBucket() throws CloudException, InternalException {
        return -1;
    }

    private long getMetaDataLength(@Nonnull Map<String, String> meta) {
        return this.getMetaDataLong("Content-Length", meta);
    }

    private long getMetaDataLong(@Nonnull String key, @Nonnull Map<String, String> meta) {
        if (!meta.containsKey(key)) {
            return -1L;
        }
        String val = meta.get(key);
        return val == null ? -1L : Long.parseLong(val);
    }

    @Nonnull
    public String getProviderTermForBucket(@Nonnull Locale locale) {
        return "bucket";
    }

    @Nonnull
    public String getProviderTermForObject(@Nonnull Locale locale) {
        return "object";
    }

    public boolean isPublic(@Nullable String bucket, @Nullable String object) throws CloudException, InternalException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.isSubscribed");
        try {
            AuthenticationContext ctx = this.provider.getAuthenticationContext();
            String endpoint = ctx.getStorageUrl();
            boolean bl = endpoint != null && endpoint.startsWith("http");
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Collection<Blob> list(final @Nullable String bucket) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was specified for this request");
        }
        final String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region ID was specified");
        }
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<Blob>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
                try {
                    APITrace.begin((CloudProvider)SwiftBlobStore.this.provider, (String)"Blob.list");
                    try {
                        SwiftBlobStore.this.list(regionId, bucket, (Jiterator<Blob>)iterator);
                    }
                    finally {
                        APITrace.end();
                    }
                }
                finally {
                    SwiftBlobStore.this.provider.release();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    private void list(@Nonnull String regionId, @Nullable String bucket, @Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
        if (bucket == null) {
            this.loadBuckets(regionId, iterator);
        } else {
            this.loadObjects(regionId, bucket, iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBuckets(@Nonnull String regionId, @Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
        Logger logger = NovaOpenStack.getLogger(SwiftBlobStore.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + SwiftBlobStore.class.getName() + ".loadBuckets(" + regionId + "," + iterator + ")"));
        }
        try {
            List<String> containers;
            SwiftMethod method = new SwiftMethod(this.provider);
            try {
                containers = method.get(null);
            }
            catch (RuntimeException e) {
                logger.error((Object)("Could not load buckets: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            for (String container : containers) {
                iterator.push((Object)Blob.getInstance((String)regionId, (String)("/" + container), (String)container, (long)0L));
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + SwiftBlobStore.class.getName() + ".loadBuckets()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObjects(@Nonnull String regionId, @Nonnull String bucketName, @Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
        Logger logger = NovaOpenStack.getLogger(SwiftBlobStore.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + SwiftBlobStore.class.getName() + ".loadFiles(" + bucketName + "," + iterator + ")"));
        }
        try {
            List<String> files;
            SwiftMethod method = new SwiftMethod(this.provider);
            try {
                files = bucketName == null ? method.get(null) : method.get(bucketName);
            }
            catch (RuntimeException e) {
                logger.error((Object)("Could not list files in " + bucketName + ": " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            for (String info : files) {
                Map<String, String> metaData = method.head(bucketName, info);
                iterator.push((Object)Blob.getInstance((String)regionId, (String)("/" + bucketName + "/" + info), (String)bucketName, (String)info, (long)0L, (Storage)new Storage((Number)this.getMetaDataLength(metaData), (StorageUnit)Storage.BYTE)));
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + SwiftBlobStore.class.getName() + ".loadFiles()"));
            }
        }
    }

    public void makePublic(@Nonnull String bucket) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Swift does not support bucket sharing");
    }

    public void makePublic(@Nullable String bucket, @Nullable String object) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Swift does not support object sharing");
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(@Nullable String sourceBucket, @Nullable String object, @Nullable String targetBucket) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.move");
        try {
            if (sourceBucket == null) {
                throw new CloudException("No source bucket was specified");
            }
            if (targetBucket == null) {
                throw new CloudException("No target bucket was specified");
            }
            if (object == null) {
                throw new CloudException("No source object was specified");
            }
            this.copy(sourceBucket, object, targetBucket, object);
            this.removeObject(sourceBucket, object);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(@Nullable String bucket, @Nonnull String object, @Nonnull File file) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.put");
        try {
            if (bucket == null) {
                throw new OperationNotSupportedException("A bucket must be specified for Swift");
            }
            SwiftMethod method = new SwiftMethod(this.provider);
            try {
                method.put(bucket, object, null, new FileInputStream(file));
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(@Nullable String bucket, @Nonnull String object, @Nonnull String content) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.put");
        try {
            try {
                File tmp = File.createTempFile(object, ".txt");
                try {
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(tmp)));
                    writer.print(content);
                    writer.flush();
                    writer.close();
                    this.put(bucket, object, tmp);
                }
                finally {
                    if (!tmp.delete()) {
                        logger.warn((Object)("Unable to delete temp file: " + tmp));
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)("Failed to write file: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBucket(@Nonnull String bucket) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.removeBucket");
        try {
            SwiftMethod method = new SwiftMethod(this.provider);
            method.delete(bucket);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(@Nullable String bucket, @Nonnull String name) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.removeObject");
        try {
            if (bucket == null) {
                throw new OperationNotSupportedException("Swift does not support root objects");
            }
            SwiftMethod method = new SwiftMethod(this.provider);
            method.delete(bucket, name);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String renameBucket(@Nonnull String oldName, @Nonnull String newName, boolean findFreeName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.renameBucket");
        try {
            Blob bucket = this.createBucket(newName, findFreeName);
            block7: for (Blob file : this.list(oldName)) {
                int retries = 10;
                while (true) {
                    --retries;
                    try {
                        this.move(oldName, file.getObjectName(), bucket.getBucketName());
                        continue block7;
                    }
                    catch (CloudException e) {
                        if (retries < 1) {
                            throw e;
                        }
                        try {
                            Thread.sleep((long)retries * 10000L);
                        }
                        catch (InterruptedException ignore) {}
                        continue;
                    }
                    break;
                }
            }
            boolean ok = true;
            for (Blob file : this.list(oldName)) {
                if (file == null) continue;
                ok = false;
            }
            if (ok) {
                this.removeBucket(oldName);
            }
            String string = newName;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameObject(@Nullable String bucket, @Nonnull String object, @Nonnull String newName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.removeObject");
        try {
            if (bucket == null) {
                throw new CloudException("No bucket was specified");
            }
            this.copy(bucket, object, bucket, newName);
            this.removeObject(bucket, object);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Blob upload(@Nonnull File source, @Nullable String bucket, @Nonnull String fileName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.upload");
        try {
            if (bucket == null) {
                throw new OperationNotSupportedException("No bucket was specified for this request");
            }
            if (!this.exists(bucket)) {
                this.createBucket(bucket, false);
            }
            this.put(bucket, fileName, source);
            Blob blob = this.getObject(bucket, fileName);
            return blob;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public NameRules getBucketNameRules() throws CloudException, InternalException {
        return NameRules.getInstance((int)1, (int)255, (boolean)false, (boolean)true, (boolean)true, (char[])new char[]{'-', '.'});
    }

    @Nonnull
    public NameRules getObjectNameRules() throws CloudException, InternalException {
        return NameRules.getInstance((int)1, (int)255, (boolean)false, (boolean)true, (boolean)true, (char[])new char[]{'-', '.', ',', '#', '+'});
    }
}

