/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.openstack.nova.os.AuthenticationContext;
import org.dasein.cloud.openstack.nova.os.NovaException;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.OpenStackProvider;
import org.dasein.cloud.util.APITrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractMethod {
    protected NovaOpenStack provider;

    public AbstractMethod(NovaOpenStack provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized AuthenticationContext authenticate() throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".authenticate()"));
        }
        try {
            AuthenticationContext auth;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("Unable to authenticate due to lack of context");
            }
            String endpoint = ctx.getEndpoint();
            if (endpoint == null) {
                throw new CloudException("No authentication endpoint");
            }
            if (endpoint.startsWith("ks:")) {
                endpoint = endpoint.substring(3);
                auth = this.authenticateKeystone(endpoint);
            } else if (endpoint.startsWith("st:")) {
                endpoint = endpoint.substring(3);
                auth = this.authenticateStandard(endpoint);
            } else if (endpoint.endsWith("1.0") || endpoint.endsWith("1.0/") || endpoint.endsWith("1.1") || endpoint.endsWith("1.1/")) {
                auth = this.authenticateStandard(endpoint);
                if (auth == null) {
                    auth = this.authenticateSwift(endpoint);
                }
                if (auth == null) {
                    auth = this.authenticateKeystone(endpoint);
                }
            } else {
                auth = this.authenticateKeystone(endpoint);
                if (auth == null) {
                    auth = this.authenticateStandard(endpoint);
                }
                if (auth == null) {
                    auth = this.authenticateSwift(endpoint);
                }
            }
            AuthenticationContext authenticationContext = auth;
            return authenticationContext;
        }
        finally {
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".authenticate()"));
            }
        }
    }

    @Nullable
    private AuthenticationContext authenticateKeystone(@Nonnull String endpoint) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".authenticateKeystone(" + endpoint + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("KEYSTONE --------------------------------------------------------> " + endpoint));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            HttpResponse response;
            String accessPublic = null;
            String accessPrivate = null;
            String account = null;
            try {
                List fields = this.provider.getContextRequirements().getConfigurableValues();
                for (ContextRequirements.Field f : fields) {
                    if (f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) {
                        byte[][] keyPair = (byte[][])this.provider.getContext().getConfigurationValue(f);
                        accessPublic = new String(keyPair[0], "utf-8");
                        accessPrivate = new String(keyPair[1], "utf-8");
                        continue;
                    }
                    if (!f.type.equals((Object)ContextRequirements.FieldType.TEXT)) continue;
                    account = (String)this.provider.getContext().getConfigurationValue(f);
                }
            }
            catch (UnsupportedEncodingException e) {
                std.error((Object)("authenticateKeystone(): Unable to read access credentials: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            if (std.isInfoEnabled()) {
                std.info((Object)"authenticateKeystone(): Attempting keystone authentication...");
            }
            HashMap<String, Object> json = new HashMap<String, Object>();
            HashMap<String, String> credentials = new HashMap<String, String>();
            if (this.provider.getCloudProvider().equals((Object)OpenStackProvider.HP)) {
                if (std.isInfoEnabled()) {
                    std.info((Object)"HP authentication");
                }
                credentials.put("accessKey", accessPublic);
                credentials.put("secretKey", accessPrivate);
                json.put("apiAccessKeyCredentials", credentials);
            } else if (this.provider.getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
                if (std.isInfoEnabled()) {
                    std.info((Object)"Rackspace authentication");
                }
                credentials.put("username", accessPublic);
                credentials.put("apiKey", accessPrivate);
                json.put("RAX-KSKEY:apiKeyCredentials", credentials);
            } else {
                if (std.isInfoEnabled()) {
                    std.info((Object)"Standard authentication");
                }
                credentials.put("username", accessPublic);
                credentials.put("password", accessPrivate);
                json.put("passwordCredentials", credentials);
            }
            if (std.isDebugEnabled()) {
                std.debug((Object)("authenticateKeystone(): tenantId=" + account));
            }
            if (!this.provider.getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
                String acct = account;
                if (this.provider.getCloudProvider().equals((Object)OpenStackProvider.HP)) {
                    json.put("tenantId", acct);
                } else if (acct.length() == 32) {
                    json.put("tenantId", acct);
                } else {
                    json.put("tenantName", acct);
                }
            }
            HashMap<String, HashMap<String, Object>> jsonAuth = new HashMap<String, HashMap<String, Object>>();
            jsonAuth.put("auth", json);
            client = this.getClient();
            HttpPost post = new HttpPost(endpoint + "/tokens");
            post.addHeader("Content-Type", "application/json");
            if (wire.isDebugEnabled()) {
                wire.debug((Object)post.getRequestLine().toString());
                for (Header header : post.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            String payload = new JSONObject(jsonAuth).toString();
            try {
                post.setEntity((HttpEntity)new StringEntity(payload == null ? "" : payload, "application/json", "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e);
            }
            try {
                wire.debug((Object)EntityUtils.toString((HttpEntity)post.getEntity()));
            }
            catch (IOException ignore) {
                // empty catch block
            }
            wire.debug((Object)"");
            try {
                APITrace.trace((CloudProvider)this.provider, (String)"POST authenticateKeystone");
                response = client.execute((HttpUriRequest)post);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            if (code != 200) {
                if (code == 401 || code == 405) {
                    std.warn((Object)"authenticateKeystone(): Authentication failed");
                    AuthenticationContext len$ = null;
                    return len$;
                }
                std.error((Object)("authenticateKeystone(): Expected OK, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    items = new NovaException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: /tokens";
                }
                std.error((Object)("authenticateKeystone(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            String data = null;
            try {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    data = EntityUtils.toString((HttpEntity)entity);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)data);
                        wire.debug((Object)"");
                    }
                }
            }
            catch (IOException e) {
                std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            if (data != null && !data.trim().equals("")) {
                String tenantId;
                String id;
                JSONArray catalog;
                if (std.isInfoEnabled()) {
                    std.info((Object)"authenticateKeystone(): Keystone authentication successful");
                }
                try {
                    JSONObject t;
                    JSONObject rj = new JSONObject(data);
                    JSONObject auth = rj.getJSONObject("access");
                    JSONObject token = auth.getJSONObject("token");
                    catalog = auth.getJSONArray("serviceCatalog");
                    id = token.has("id") ? token.getString("id") : null;
                    String string = tenantId = token.has("tenantId") && !token.isNull("tenantId") ? token.getString("tenantId") : null;
                    if (tenantId == null && token.has("tenant") && !token.isNull("tenant") && (t = token.getJSONObject("tenant")).has("id") && !t.isNull("id")) {
                        tenantId = t.getString("id");
                    }
                }
                catch (JSONException e) {
                    std.error((Object)("authenticateKeystone(): Invalid response from server: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                if (tenantId == null) {
                    tenantId = account;
                }
                if (id != null) {
                    HashMap<String, Map<String, String>> services = new HashMap<String, Map<String, String>>();
                    HashMap bestVersion = new HashMap();
                    String myRegionId = this.provider.getContext().getRegionId();
                    if (std.isDebugEnabled()) {
                        std.debug((Object)("authenticateKeystone(): myRegionId=" + myRegionId));
                    }
                    if (std.isInfoEnabled()) {
                        std.info((Object)"authenticateKeystone(): Processing service catalog...");
                    }
                    for (int i = 0; i < catalog.length(); ++i) {
                        try {
                            JSONObject service = catalog.getJSONObject(i);
                            String type = service.getString("type");
                            JSONArray endpoints = service.getJSONArray("endpoints");
                            if (std.isDebugEnabled()) {
                                std.debug((Object)("authenticateKeystone(): type=" + type));
                            }
                            for (int j = 0; j < endpoints.length(); ++j) {
                                String regionId;
                                JSONObject test = endpoints.getJSONObject(j);
                                String url = test.getString("publicURL");
                                if (std.isDebugEnabled()) {
                                    std.debug((Object)("authenticateKeystone(): endpoint[" + j + "]=" + url));
                                }
                                if (url == null) continue;
                                String version = test.optString("versionId");
                                if (version == null || version.equals("")) {
                                    std.debug((Object)("No versionId parameter... Parsing URL " + url + " for best guess.  (vSadTrombone)"));
                                    Pattern p = Pattern.compile("/v(.+?)/|/v(.+?)$");
                                    Matcher m = p.matcher(url);
                                    if (m.find()) {
                                        version = m.group(1);
                                        if (version == null) {
                                            version = m.group(2);
                                        }
                                    } else {
                                        version = "1.0";
                                    }
                                }
                                if (std.isDebugEnabled()) {
                                    std.debug((Object)("authenticateKeystone(): version[" + j + "]=" + version));
                                }
                                if (!NovaOpenStack.isSupported(version)) continue;
                                String string = regionId = test.has("region") ? test.getString("region") : null;
                                if (std.isDebugEnabled()) {
                                    std.debug((Object)("authenticateKeystone(): region[" + j + "]=" + regionId));
                                }
                                Map<String, String> map = services.get(type);
                                HashMap<String, String> verMap = (HashMap<String, String>)bestVersion.get(type);
                                if (map == null) {
                                    map = new HashMap<String, String>();
                                    verMap = new HashMap<String, String>();
                                    if (std.isInfoEnabled()) {
                                        std.info((Object)("authenticateKeystone(): Putting (" + type + "," + map + ") into services."));
                                    }
                                    services.put(type, map);
                                    bestVersion.put(type, verMap);
                                }
                                if (regionId == null & version.equals("1.0") && !this.provider.getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
                                    std.warn((Object)("authenticateKeystone(): No region defined, making one up based on the URL: " + url));
                                    regionId = this.toRegion(url);
                                    std.warn((Object)("authenticateKeystone(): Fabricated region is: " + regionId));
                                } else if (regionId == null && (type.equals("compute") || type.equals("object-store"))) {
                                    std.warn((Object)"authenticateKeystone(): No region defined for Rackspace, assuming it is pre-OpenStack and skipping");
                                    continue;
                                }
                                if (std.isDebugEnabled()) {
                                    std.debug((Object)("authenticateKeystone(): finalRegionId=" + regionId));
                                }
                                if (std.isInfoEnabled()) {
                                    std.info((Object)("authenticateKeystone(): Comparing " + version + " against " + (String)verMap.get(type)));
                                }
                                if (verMap.get(type) == null || this.compareVersions(version, (String)verMap.get(type)) >= 0) {
                                    if (std.isInfoEnabled()) {
                                        std.info((Object)("authenticateKeystone(): Putting (" + regionId + "," + url + ") into the " + type + " map."));
                                    }
                                    verMap.put(type, version);
                                    map.put(regionId, url);
                                } else {
                                    std.warn((Object)("authenticateKeystone(): Skipping lower version url " + url + " for " + type + " map."));
                                }
                                if (myRegionId != null) continue;
                                myRegionId = regionId;
                                if (!std.isInfoEnabled()) continue;
                                std.info((Object)("authenticateKeystone(): myRegionId now " + myRegionId));
                            }
                            continue;
                        }
                        catch (JSONException e) {
                            std.error((Object)("authenticateKeystone(): Failed to read JSON from server: " + e.getMessage()));
                            e.printStackTrace();
                            throw new CloudException((Throwable)e);
                        }
                    }
                    if (std.isDebugEnabled()) {
                        std.debug((Object)("services=" + services));
                    }
                    if (this.provider.getCloudProvider().equals((Object)OpenStackProvider.HP) && this.provider.getContext().getAccountNumber().equals("66565797737008")) {
                        HashMap<String, String> endpoints = new HashMap<String, String>();
                        endpoints.put("region-a.geo-1", "https://region-a.geo-1.dbaas-mysql.hpcloudsvc.com:8779/v1.0/66565797737008");
                        services.put("hpext:database", endpoints);
                    }
                    AuthenticationContext authenticationContext = new AuthenticationContext(myRegionId, id, tenantId, services, null);
                    return authenticationContext;
                }
            }
            throw new CloudException("No authentication tokens were provided");
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".authenticateKeystone()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("KEYSTONE --------------------------------------------------------> " + endpoint));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private AuthenticationContext authenticateStandard(@Nonnull String endpointUrls) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".authenticateStandard(" + endpointUrls + ")"));
        }
        try {
            String accessPublic = null;
            String accessPrivate = null;
            String account = null;
            try {
                List fields = this.provider.getContextRequirements().getConfigurableValues();
                for (ContextRequirements.Field f : fields) {
                    if (f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) {
                        byte[][] keyPair = (byte[][])this.provider.getContext().getConfigurationValue(f);
                        accessPublic = new String(keyPair[0], "utf-8");
                        accessPrivate = new String(keyPair[1], "utf-8");
                        continue;
                    }
                    if (!f.type.equals((Object)ContextRequirements.FieldType.TEXT)) continue;
                    account = (String)this.provider.getContext().getConfigurationValue(f);
                }
            }
            catch (UnsupportedEncodingException e) {
                std.error((Object)("authenticateKeystone(): Unable to read access credentials: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            String[] endpoints = endpointUrls.indexOf(44) > 0 ? endpointUrls.split(",") : new String[]{endpointUrls};
            HashMap<String, Map<String, String>> services = new HashMap<String, Map<String, String>>();
            String authToken = null;
            String myRegion = this.provider.getContext().getRegionId();
            String tenantId = account;
            for (String endpoint : endpoints) {
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("STANDARD --------------------------------------------------------> " + endpoint));
                    wire.debug((Object)"");
                }
                HttpClient client = null;
                try {
                    Map<String, String> map;
                    HttpResponse response;
                    ProviderContext ctx = this.provider.getContext();
                    client = this.getClient();
                    HttpGet get = new HttpGet(endpoint);
                    get.addHeader("Content-Type", "application/json");
                    get.addHeader("X-Auth-User", accessPublic);
                    get.addHeader("X-Auth-Key", accessPrivate);
                    get.addHeader("X-Auth-Project-Id", account);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)get.getRequestLine().toString());
                        for (Header header : get.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                    try {
                        APITrace.trace((CloudProvider)this.provider, (String)"GET authenticateStandard");
                        response = client.execute((HttpUriRequest)get);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)response.getStatusLine().toString());
                            for (Header header : response.getAllHeaders()) {
                                wire.debug((Object)(header.getName() + ": " + header.getValue()));
                            }
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        std.error((Object)("I/O error from server communications: " + e.getMessage()));
                        e.printStackTrace();
                        throw new InternalException((Throwable)e);
                    }
                    int code = response.getStatusLine().getStatusCode();
                    std.debug((Object)("HTTP STATUS: " + code));
                    if (code != 204) {
                        String data;
                        block49: {
                            if (code == 403 || code == 401) {
                                AuthenticationContext len$ = null;
                                return len$;
                            }
                            std.error((Object)("authenticateStandard(): Expected NO CONTENT for an authentication request, got " + code));
                            data = null;
                            try {
                                HttpEntity entity = response.getEntity();
                                if (entity == null) break block49;
                                data = EntityUtils.toString((HttpEntity)entity);
                                if (wire.isDebugEnabled()) {
                                    wire.debug((Object)data);
                                    wire.debug((Object)"");
                                }
                            }
                            catch (IOException e) {
                                std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                                e.printStackTrace();
                                throw new CloudException((Throwable)e);
                            }
                        }
                        if (code == 500 && data.contains("<faultstring>")) {
                            AuthenticationContext e = null;
                            return e;
                        }
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)response);
                        }
                        wire.debug((Object)"");
                        NovaException.ExceptionItems items = NovaException.parseException(code, data);
                        if (items.type.equals((Object)CloudErrorType.AUTHENTICATION)) {
                            Header header;
                            header = null;
                            return header;
                        }
                        std.error((Object)("authenticateStandard(): [" + code + " : " + items.message + "] " + items.details));
                        throw new NovaException(items);
                    }
                    String cdnUrl = null;
                    String computeUrl = null;
                    String objectUrl = null;
                    String thisRegion = this.toRegion(endpoint);
                    if (myRegion == null) {
                        myRegion = thisRegion;
                    }
                    for (Header h : response.getAllHeaders()) {
                        if (h.getName().equalsIgnoreCase("x-auth-token") && myRegion.equals(thisRegion)) {
                            authToken = h.getValue().trim();
                            continue;
                        }
                        if (h.getName().equalsIgnoreCase("x-server-management-url")) {
                            String url = h.getValue().trim();
                            if (url.endsWith("/")) {
                                url = url.substring(0, url.length() - 1);
                            }
                            if (endpoint.endsWith("v1.0")) {
                                url = url + "/v1.0";
                            }
                            computeUrl = url;
                            continue;
                        }
                        if (h.getName().equalsIgnoreCase("x-storage-url")) {
                            objectUrl = h.getValue().trim();
                            continue;
                        }
                        if (!h.getName().equalsIgnoreCase("x-cdn-management-url")) continue;
                        cdnUrl = h.getValue().trim();
                    }
                    if (computeUrl != null) {
                        map = services.get("compute");
                        if (map == null) {
                            map = new HashMap<String, String>();
                            map.put(thisRegion, computeUrl);
                        }
                        services.put("compute", map);
                    }
                    if (objectUrl != null) {
                        map = services.get("object-store");
                        if (map == null) {
                            map = new HashMap<String, String>();
                            map.put(thisRegion, objectUrl);
                        }
                        services.put("object-store", map);
                    }
                    if (cdnUrl == null) continue;
                    map = services.get("cdn");
                    if (map == null) {
                        map = new HashMap<String, String>();
                        map.put(thisRegion, cdnUrl);
                    }
                    services.put("cdn", map);
                }
                finally {
                    if (client != null) {
                        client.getConnectionManager().shutdown();
                    }
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)"");
                        wire.debug((Object)("STANDARD --------------------------------------------------------> " + endpoint));
                    }
                }
            }
            if (authToken == null) {
                std.warn((Object)"authenticateStandard(): No authentication token in response");
                throw new CloudException("No authentication token in cloud response");
            }
            AuthenticationContext authenticationContext = new AuthenticationContext(myRegion, authToken, tenantId, services, null);
            return authenticationContext;
        }
        finally {
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".authenticateStandard()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AuthenticationContext authenticateSwift(@Nonnull String endpoint) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".authenticate()"));
        }
        String accessPublic = null;
        String accessPrivate = null;
        String accountNum = null;
        try {
            List fields = this.provider.getContextRequirements().getConfigurableValues();
            for (ContextRequirements.Field f : fields) {
                if (f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) {
                    byte[][] keyPair = (byte[][])this.provider.getContext().getConfigurationValue(f);
                    accessPublic = new String(keyPair[0], "utf-8");
                    accessPrivate = new String(keyPair[1], "utf-8");
                    continue;
                }
                if (!f.type.equals((Object)ContextRequirements.FieldType.TEXT)) continue;
                accountNum = (String)this.provider.getContext().getConfigurationValue(f);
            }
        }
        catch (UnsupportedEncodingException e) {
            std.error((Object)("authenticateKeystone(): Unable to read access credentials: " + e.getMessage()));
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        String tenantId = accountNum;
        String authToken = null;
        String storageToken = null;
        String thisRegion = this.toRegion(endpoint);
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("--------------------------------------------------------> " + endpoint));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            HttpResponse response;
            String pk;
            client = this.getClient();
            HttpGet get = new HttpGet(endpoint);
            ProviderContext ctx = this.provider.getContext();
            String account = accessPublic.length() < 1 ? accountNum : ((pk = accessPublic).equals("-----") ? accountNum : accountNum + ":" + accessPublic);
            get.addHeader("Content-Type", "application/json");
            get.addHeader("X-Auth-User", account);
            get.addHeader("X-Auth-Key", accessPrivate);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)get.getRequestLine().toString());
                for (Header header : get.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            try {
                APITrace.trace((CloudProvider)this.provider, (String)"GET authenticateSwift");
                response = client.execute((HttpUriRequest)get);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            if (code != 204 && code != 200) {
                if (code == 403 || code == 401) {
                    AuthenticationContext len$ = null;
                    return len$;
                }
                std.error((Object)("authenticate(): Expected NO CONTENT for an authentication request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items.type.equals((Object)CloudErrorType.AUTHENTICATION)) {
                    Header header;
                    header = null;
                    return header;
                }
                std.error((Object)("authenticate(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            HashMap<String, Map<String, String>> services = new HashMap<String, Map<String, String>>();
            for (Header h : response.getAllHeaders()) {
                Map<String, String> map;
                if (h.getName().equalsIgnoreCase("x-auth-token")) {
                    authToken = h.getValue().trim();
                    continue;
                }
                if (h.getName().equalsIgnoreCase("x-server-management-url")) {
                    map = services.get("compute");
                    if (map == null) {
                        map = new HashMap<String, String>();
                        map.put(thisRegion, h.getValue().trim());
                    }
                    services.put("compute", map);
                    continue;
                }
                if (h.getName().equalsIgnoreCase("x-storage-url")) {
                    map = services.get("object-store");
                    if (map == null) {
                        map = new HashMap<String, String>();
                        map.put(thisRegion, h.getValue().trim());
                    }
                    services.put("object-store", map);
                    continue;
                }
                if (h.getName().equalsIgnoreCase("x-cdn-management-url")) {
                    map = services.get("cdn");
                    if (map == null) {
                        map = new HashMap<String, String>();
                        map.put(thisRegion, h.getValue().trim());
                    }
                    services.put("cdn", map);
                    continue;
                }
                if (!h.getName().equalsIgnoreCase("x-storage-token")) continue;
                storageToken = h.getValue().trim();
            }
            if (authToken == null) {
                std.warn((Object)"authenticate(): No authentication token in response");
                throw new CloudException("No authentication token in cloud response");
            }
            AuthenticationContext authenticationContext = new AuthenticationContext(thisRegion, authToken, tenantId, services, storageToken);
            return authenticationContext;
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".authenticate()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("--------------------------------------------------------> " + endpoint));
            }
        }
    }

    public void deleteResource(@Nonnull String service, @Nonnull String resource, @Nonnull String resourceId, String suffix) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl(service);
        if (endpoint == null) {
            throw new CloudException("No " + service + " endpoint exists");
        }
        resource = suffix == null ? resource + "/" + resourceId : resource + "/" + resourceId + "/" + suffix;
        this.delete(context.getAuthToken(), endpoint, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".delete(" + authToken + "," + endpoint + "," + resource + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("--------------------------------------------------------> " + endpoint + resource));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            HttpResponse response;
            client = this.getClient();
            HttpDelete delete = new HttpDelete(endpoint + resource);
            delete.addHeader("Content-Type", "application/json");
            delete.addHeader("X-Auth-Token", authToken);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)delete.getRequestLine().toString());
                for (Header header : delete.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            try {
                APITrace.trace((CloudProvider)this.provider, (String)("DELETE " + this.toAPIResource(resource)));
                response = client.execute((HttpUriRequest)delete);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            if (code != 204 && code != 202) {
                std.error((Object)("delete(): Expected NO CONTENT for DELETE request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    items = new NovaException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                std.error((Object)("delete(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            wire.debug((Object)"");
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".delete()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("--------------------------------------------------------> " + endpoint + resource));
            }
        }
    }

    @Nullable
    public JSONArray getList(@Nonnull String service, @Nonnull String resource, boolean suffix) throws CloudException, InternalException {
        String response;
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl(service);
        if (endpoint == null) {
            throw new CloudException("No " + service + " URL has been established in " + context.getMyRegion());
        }
        if (suffix) {
            resource = resource + "/detail";
        }
        if ((response = this.getString(context.getAuthToken(), endpoint, resource)) == null) {
            return null;
        }
        try {
            return new JSONArray(response);
        }
        catch (JSONException e) {
            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", response);
        }
    }

    @Nullable
    public String[] getItemList(@Nonnull String service, @Nonnull String resource, boolean suffix) throws CloudException, InternalException {
        String response;
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl(service);
        if (endpoint == null) {
            throw new CloudException("No " + service + " URL has been established in " + context.getMyRegion());
        }
        if (suffix) {
            resource = resource + "/detail";
        }
        if ((response = this.getString(context.getAuthToken(), endpoint, resource)) == null) {
            return null;
        }
        if (response.length() < 1) {
            return new String[0];
        }
        String[] items = response.split("\n");
        if (items == null || items.length < 1) {
            return new String[]{response.trim()};
        }
        for (int i = 0; i < items.length; ++i) {
            items[i] = items[i].trim();
        }
        return items;
    }

    @Nullable
    public JSONObject getResource(@Nonnull String service, @Nonnull String resource, @Nullable String resourceId, boolean suffix) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl(service);
        if (endpoint == null) {
            throw new CloudException("No " + service + " URL has been established in " + context.getMyRegion());
        }
        if (resourceId != null) {
            resource = resourceId.startsWith("?") ? resource + resourceId : resource + "/" + resourceId;
        } else if (suffix) {
            resource = resource + "/detail";
        }
        String response = this.getString(context.getAuthToken(), endpoint, resource);
        if (response == null) {
            return null;
        }
        try {
            return new JSONObject(response);
        }
        catch (JSONException e) {
            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String getString(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".getString(" + authToken + "," + endpoint + "," + resource + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("--------------------------------------------------------> " + endpoint + resource));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            String string;
            HttpResponse response;
            client = this.getClient();
            HttpGet get = new HttpGet(resource == null ? endpoint : endpoint + resource);
            get.addHeader("Content-Type", "application/json");
            get.addHeader("X-Auth-Token", authToken);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)get.getRequestLine().toString());
                for (Header header : get.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            try {
                APITrace.trace((CloudProvider)this.provider, (String)("GET " + this.toAPIResource(resource)));
                response = client.execute((HttpUriRequest)get);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            if (code == 404) {
                String len$ = null;
                return len$;
            }
            if (code == 400) {
                std.error((Object)("Expected OK for GET request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                try {
                    JSONObject err = new JSONObject(data).getJSONObject("badRequest");
                    String msg = err.getString("message");
                    if (msg.contains("id should be integer")) {
                        String string2 = null;
                        return string2;
                    }
                }
                catch (JSONException e) {
                    // empty catch block
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    string = null;
                    return string;
                }
                if (this.provider.getMajorVersion() == 1 && this.provider.getMinorVersion() == 0 && items.message != null && (items.message.contains("not found") || items.message.contains("unknown"))) {
                    string = null;
                    return string;
                }
                std.error((Object)("getString(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            if (code != 204 && code != 200 && code != 203) {
                std.error((Object)("Expected OK for GET request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    string = null;
                    return string;
                }
                if (this.provider.getMajorVersion() == 1 && this.provider.getMinorVersion() == 0 && items.message != null && (items.message.contains("not found") || items.message.contains("unknown"))) {
                    string = null;
                    return string;
                }
                std.error((Object)("getString(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            String data = null;
            try {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    data = EntityUtils.toString((HttpEntity)entity);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)data);
                        wire.debug((Object)"");
                    }
                }
            }
            catch (IOException e) {
                std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            String string3 = data;
            return string3;
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".getString()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("--------------------------------------------------------> " + endpoint + resource));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected InputStream getStream(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".getStream(" + authToken + "," + endpoint + "," + resource + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("--------------------------------------------------------> " + endpoint + resource));
            wire.debug((Object)"");
        }
        try {
            HttpResponse response;
            HttpClient client = this.getClient();
            HttpGet get = new HttpGet(endpoint + resource);
            get.addHeader("Content-Type", "application/json");
            get.addHeader("X-Auth-Token", authToken);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)get.getRequestLine().toString());
                for (Header header : get.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            try {
                APITrace.trace((CloudProvider)this.provider, (String)("GET " + this.toAPIResource(resource)));
                response = client.execute((HttpUriRequest)get);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            if (code == 404) {
                InputStream len$ = null;
                return len$;
            }
            if (code != 200 && code != 203) {
                std.error((Object)("Expected OK for GET request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                std.error((Object)("getStream(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            InputStream input = null;
            try {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    input = entity.getContent();
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)" ---- BINARY DATA ---- ");
                        wire.debug((Object)"");
                    }
                }
            }
            catch (IOException e) {
                std.error((Object)("getStream(): Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                if (std.isTraceEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"---> Binary Data <---");
            }
            wire.debug((Object)"");
            InputStream inputStream = input;
            return inputStream;
        }
        finally {
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".getStream()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("--------------------------------------------------------> " + endpoint + resource));
            }
        }
    }

    @Nonnull
    protected HttpClient getClient() throws CloudException, InternalException {
        int targetPort;
        URI uri;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was defined for this request");
        }
        String endpoint = ctx.getEndpoint();
        if (endpoint == null) {
            throw new CloudException("No cloud endpoint was defined");
        }
        boolean ssl = endpoint.startsWith("https");
        try {
            uri = new URI(endpoint);
            targetPort = uri.getPort();
            if (targetPort < 1) {
                targetPort = ssl ? 443 : 80;
            }
        }
        catch (URISyntaxException e) {
            throw new CloudException((Throwable)e);
        }
        HttpHost targetHost = new HttpHost(uri.getHost(), targetPort, uri.getScheme());
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"");
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPort = p.getProperty("proxyPort");
            if (proxyHost != null) {
                int port = 0;
                if (proxyPort != null && proxyPort.length() > 0) {
                    port = Integer.parseInt(proxyPort);
                }
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port, ssl ? "https" : "http"));
            }
        }
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        if (this.provider.isInsecure()) {
            try {
                client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        return true;
                    }
                }, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER)));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return client;
    }

    @Nullable
    public Map<String, String> headResource(@Nonnull String service, @Nullable String resource, @Nullable String resourceId) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl(service);
        if (endpoint == null) {
            throw new CloudException("No " + service + " URL has been established in " + context.getMyRegion());
        }
        if (resource == null && resourceId == null) {
            resource = "/";
        } else if (resource == null) {
            resource = "/" + resourceId;
        } else if (resourceId != null) {
            resource = resource + "/" + resourceId;
        }
        return this.head(context.getAuthToken(), endpoint, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Map<String, String> head(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".head(" + authToken + "," + endpoint + "," + resource + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("--------------------------------------------------------> " + endpoint + resource));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            HttpResponse response;
            client = this.getClient();
            HttpHead head = new HttpHead(endpoint + resource);
            head.addHeader("X-Auth-Token", authToken);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)head.getRequestLine().toString());
                for (Header header : head.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            try {
                APITrace.trace((CloudProvider)this.provider, (String)("HEAD " + this.toAPIResource(resource)));
                response = client.execute((HttpUriRequest)head);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            if (code != 204 && code != 200) {
                if (code == 404) {
                    Map<String, String> len$ = null;
                    return len$;
                }
                std.error((Object)("Expected OK for HEAD request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    Header header;
                    header = null;
                    return header;
                }
                std.error((Object)("head(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (Header h : response.getAllHeaders()) {
                map.put(h.getName().trim(), h.getValue().trim());
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".head()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("--------------------------------------------------------> " + endpoint + resource));
            }
        }
    }

    public void postResourceHeaders(String service, String resource, String resourceId, Map<String, String> headers) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl(service);
        if (endpoint == null) {
            throw new CloudException("No " + service + " has been established in " + context.getMyRegion());
        }
        if (resourceId == null) {
            throw new InternalException("No container was specified");
        }
        this.postHeaders(context.getAuthToken(), endpoint, resource + "/" + resourceId, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String postHeaders(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource, @Nonnull Map<String, String> customHeaders) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".postString(" + authToken + "," + endpoint + "," + resource + "," + customHeaders + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            int code;
            HttpResponse response;
            block40: {
                client = this.getClient();
                HttpPost post = new HttpPost(endpoint + resource);
                post.addHeader("Content-Type", "application/json");
                post.addHeader("X-Auth-Token", authToken);
                if (customHeaders != null) {
                    for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                        String val = entry.getValue() == null ? "" : entry.getValue();
                        post.addHeader(entry.getKey(), val);
                    }
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)post.getRequestLine().toString());
                    for (Header header : post.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
                try {
                    APITrace.trace((CloudProvider)this.provider, (String)("POST " + this.toAPIResource(resource)));
                    response = client.execute((HttpUriRequest)post);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    std.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                code = response.getStatusLine().getStatusCode();
                std.debug((Object)("HTTP STATUS: " + code));
                if (code == 413 || code == 414) {
                    String data = null;
                    try {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            data = EntityUtils.toString((HttpEntity)entity);
                            if (wire.isDebugEnabled()) {
                                wire.debug((Object)data);
                                wire.debug((Object)"");
                            }
                        }
                    }
                    catch (IOException e) {
                        std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                        e.printStackTrace();
                        throw new CloudException((Throwable)e);
                    }
                    try {
                        JSONObject ob;
                        if (data == null || !(ob = new JSONObject(data)).has("overLimit") || !(ob = ob.getJSONObject("overLimit")).has("retryAfter")) break block40;
                        int min = ob.getInt("retryAfter");
                        if (min < 1) {
                            throw new CloudException(CloudErrorType.CAPACITY, 413, "Over Limit", ob.has("message") ? ob.getString("message") : "Over Limit");
                        }
                        try {
                            Thread.sleep(60000L * (long)min);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        String string = this.postHeaders(authToken, endpoint, resource, customHeaders);
                        return string;
                    }
                    catch (JSONException e) {
                        throw new CloudException((Throwable)e);
                    }
                }
            }
            if (code != 202 && code != 204) {
                std.error((Object)("postString(): Expected ACCEPTED for POST request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    items = new NovaException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                std.error((Object)("postString(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            if (code == 202) {
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                if (data != null && !data.trim().equals("")) {
                    String string = data;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".postString()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            }
        }
    }

    @Nullable
    public JSONObject postString(@Nonnull String service, @Nonnull String resource, @Nullable String resourceId, @Nonnull String extra, @Nonnull JSONObject body) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl(service);
        if (endpoint == null) {
            throw new CloudException("No " + service + " endpoint exists");
        }
        String response = this.postString(context.getAuthToken(), endpoint, resource + "/" + resourceId + "/" + extra, body.toString());
        if (response == null) {
            return null;
        }
        try {
            return new JSONObject(response);
        }
        catch (JSONException e) {
            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", response);
        }
    }

    @Nullable
    public JSONObject postString(@Nonnull String service, @Nonnull String resource, @Nullable String resourceId, @Nonnull JSONObject body, boolean suffix) throws CloudException, InternalException {
        String endpoint;
        AuthenticationContext context = this.provider.getAuthenticationContext();
        if (resourceId != null) {
            resource = resource + "/" + (suffix ? resourceId + "/action" : resourceId);
        }
        if ((endpoint = context.getServiceUrl(service)) == null) {
            throw new CloudException("No " + service + " endpoint exists");
        }
        String response = this.postString(context.getAuthToken(), endpoint, resource, body.toString());
        if (response == null) {
            return null;
        }
        try {
            return new JSONObject(response);
        }
        catch (JSONException e) {
            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String postString(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource, @Nonnull String payload) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".postString(" + authToken + "," + endpoint + "," + resource + "," + payload + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            int code;
            HttpResponse response;
            block46: {
                client = this.getClient();
                HttpPost post = new HttpPost(endpoint + resource);
                post.addHeader("Content-Type", "application/json");
                post.addHeader("X-Auth-Token", authToken);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)post.getRequestLine().toString());
                    for (Header header : post.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
                if (payload != null) {
                    try {
                        post.setEntity((HttpEntity)new StringEntity(payload == null ? "" : payload, "application/json", "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new InternalException((Throwable)e);
                    }
                    try {
                        wire.debug((Object)EntityUtils.toString((HttpEntity)post.getEntity()));
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    wire.debug((Object)"");
                }
                try {
                    APITrace.trace((CloudProvider)this.provider, (String)("POST " + this.toAPIResource(resource)));
                    response = client.execute((HttpUriRequest)post);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    std.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                code = response.getStatusLine().getStatusCode();
                std.debug((Object)("HTTP STATUS: " + code));
                if (code == 413 || code == 414) {
                    String data = null;
                    try {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            data = EntityUtils.toString((HttpEntity)entity);
                            if (wire.isDebugEnabled()) {
                                wire.debug((Object)data);
                                wire.debug((Object)"");
                            }
                        }
                    }
                    catch (IOException e) {
                        std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                        e.printStackTrace();
                        throw new CloudException((Throwable)e);
                    }
                    try {
                        JSONObject ob;
                        if (data == null || !(ob = new JSONObject(data)).has("overLimit") || !(ob = ob.getJSONObject("overLimit")).has("retryAfter")) break block46;
                        int min = ob.getInt("retryAfter");
                        if (min < 1) {
                            throw new CloudException(CloudErrorType.CAPACITY, 413, "Over Limit", ob.has("message") ? ob.getString("message") : "Over Limit");
                        }
                        try {
                            Thread.sleep(60000L * (long)min);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        String ignore = this.postString(authToken, endpoint, resource, payload);
                        return ignore;
                    }
                    catch (JSONException e) {
                        throw new CloudException((Throwable)e);
                    }
                }
            }
            if (code != 200 && code != 202 && code != 204 && code != 201) {
                std.error((Object)("postString(): Expected OK, ACCEPTED, or NO CONTENT for POST request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    items = new NovaException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                std.error((Object)("postString(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            if (code != 204) {
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                if (data != null && !data.trim().equals("")) {
                    String e = data;
                    return e;
                }
                if (code == 202) {
                    Header[] headers;
                    for (Header h : headers = response.getAllHeaders()) {
                        if (!h.getName().equalsIgnoreCase("Location")) continue;
                        String string = "{\"location\" : \"" + h.getValue().trim() + "\"}";
                        return string;
                    }
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".postString()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String postStream(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource, @Nonnull String md5Hash, @Nonnull InputStream stream) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".postStream(" + authToken + "," + endpoint + "," + resource + "," + md5Hash + ",INPUTSTREAM)"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            String data;
            HttpResponse response;
            client = this.getClient();
            HttpPost post = new HttpPost(endpoint + resource);
            post.addHeader("Content-Type", "application/octet-stream");
            post.addHeader("X-Auth-Token", authToken);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)post.getRequestLine().toString());
                for (Header header : post.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            post.setEntity((HttpEntity)new InputStreamEntity(stream, -1L));
            wire.debug((Object)" ---- BINARY DATA ---- ");
            wire.debug((Object)"");
            try {
                APITrace.trace((CloudProvider)this.provider, (String)("POST " + this.toAPIResource(resource)));
                response = client.execute((HttpUriRequest)post);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            String responseHash = null;
            for (Header h : post.getAllHeaders()) {
                if (!h.getName().equalsIgnoreCase("ETag")) continue;
                responseHash = h.getValue();
            }
            if (responseHash != null && md5Hash != null && !responseHash.equals(md5Hash)) {
                throw new CloudException("MD5 hash values do not match, probably data corruption");
            }
            if (code != 202 && code != 204) {
                std.error((Object)("postStream(): Expected ACCEPTED or NO CONTENT for POST request, got " + code));
                data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    items = new NovaException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                std.error((Object)("postString(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            wire.debug((Object)"");
            if (code == 202) {
                data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                if (data != null && !data.trim().equals("")) {
                    String string = data;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + NovaOpenStack.class.getName() + ".postStream()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            }
        }
    }

    public void putResourceHeaders(@Nonnull String service, @Nullable String resource, @Nullable String resourceId, @Nonnull Map<String, String> headers) throws CloudException, InternalException {
        AuthenticationContext context = this.provider.getAuthenticationContext();
        String endpoint = context.getServiceUrl(service);
        if (endpoint == null) {
            throw new CloudException("No " + service + " has been established in " + context.getMyRegion());
        }
        if (resource == null && resourceId == null) {
            resource = "/";
        } else if (resource == null) {
            resource = "/" + resourceId;
        } else if (resourceId != null) {
            resource = resource + "/" + resourceId;
        }
        this.putHeaders(context.getAuthToken(), endpoint, resource, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected String putHeaders(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource, @Nonnull Map<String, String> customHeaders) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".putHeaders(" + authToken + "," + endpoint + "," + resource + "," + customHeaders + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            HttpResponse response;
            client = this.getClient();
            HttpPut put = new HttpPut(endpoint + resource);
            put.addHeader("Content-Type", "application/json");
            put.addHeader("X-Auth-Token", authToken);
            if (customHeaders != null) {
                for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                    String val = entry.getValue() == null ? "" : entry.getValue();
                    put.addHeader(entry.getKey(), val);
                }
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)put.getRequestLine().toString());
                for (Header header : put.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            try {
                APITrace.trace((CloudProvider)this.provider, (String)("PUT " + this.toAPIResource(resource)));
                response = client.execute((HttpUriRequest)put);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            if (code != 201 && code != 202 && code != 204) {
                std.error((Object)("putString(): Expected CREATED, ACCEPTED, or NO CONTENT for put request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    items = new NovaException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                std.error((Object)("putString(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            if (code == 202 || code == 201) {
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                if (data != null && !data.trim().equals("")) {
                    String string = data;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".putString()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String putString(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource, @Nullable String payload) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".putString(" + authToken + "," + endpoint + "," + resource + "," + payload + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            HttpResponse response;
            client = this.getClient();
            HttpPut put = new HttpPut(endpoint + resource);
            put.addHeader("Content-Type", "application/json");
            put.addHeader("X-Auth-Token", authToken);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)put.getRequestLine().toString());
                for (Header header : put.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            if (payload != null) {
                try {
                    put.setEntity((HttpEntity)new StringEntity(payload == null ? "" : payload, "application/json", "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalException((Throwable)e);
                }
                try {
                    wire.debug((Object)EntityUtils.toString((HttpEntity)put.getEntity()));
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                wire.debug((Object)"");
            }
            try {
                APITrace.trace((CloudProvider)this.provider, (String)("PUT " + this.toAPIResource(resource)));
                response = client.execute((HttpUriRequest)put);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            if (code != 201 && code != 202 && code != 204) {
                std.error((Object)("putString(): Expected CREATED, ACCEPTED, or NO CONTENT for put request, got " + code));
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    items = new NovaException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                std.error((Object)("putString(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            if (code == 202 || code == 201) {
                String data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                if (data != null && !data.trim().equals("")) {
                    String string = data;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + AbstractMethod.class.getName() + ".putString()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String putStream(@Nonnull String authToken, @Nonnull String endpoint, @Nonnull String resource, @Nullable String md5Hash, @Nonnull InputStream stream) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        Logger wire = NovaOpenStack.getLogger(NovaOpenStack.class, "wire");
        if (std.isTraceEnabled()) {
            std.trace((Object)("enter - " + AbstractMethod.class.getName() + ".putStream(" + authToken + "," + endpoint + "," + resource + "," + md5Hash + ",INPUTSTREAM)"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            String data;
            HttpResponse response;
            client = this.getClient();
            HttpPut put = new HttpPut(endpoint + resource);
            put.addHeader("Content-Type", "application/octet-stream");
            put.addHeader("X-Auth-Token", authToken);
            if (md5Hash != null) {
                put.addHeader("ETag", md5Hash);
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)put.getRequestLine().toString());
                for (Header header : put.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            put.setEntity((HttpEntity)new InputStreamEntity(stream, -1L, ContentType.APPLICATION_OCTET_STREAM));
            wire.debug((Object)" ---- BINARY DATA ---- ");
            wire.debug((Object)"");
            try {
                APITrace.trace((CloudProvider)this.provider, (String)("PUT " + this.toAPIResource(resource)));
                response = client.execute((HttpUriRequest)put);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header header : response.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                std.error((Object)("I/O error from server communications: " + e.getMessage()));
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            int code = response.getStatusLine().getStatusCode();
            std.debug((Object)("HTTP STATUS: " + code));
            String responseHash = null;
            for (Header h : put.getAllHeaders()) {
                if (!h.getName().equalsIgnoreCase("ETag")) continue;
                responseHash = h.getValue();
            }
            if (responseHash != null && md5Hash != null && !responseHash.equals(md5Hash)) {
                throw new CloudException("MD5 hash values do not match, probably data corruption");
            }
            if (code != 201 && code != 202 && code != 204) {
                std.error((Object)("putStream(): Expected CREATED, ACCEPTED, or NO CONTENT for PUT request, got " + code));
                data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                NovaException.ExceptionItems items = NovaException.parseException(code, data);
                if (items == null) {
                    items = new NovaException.ExceptionItems();
                    items.code = 404;
                    items.type = CloudErrorType.COMMUNICATION;
                    items.message = "itemNotFound";
                    items.details = "No such object: " + resource;
                }
                std.error((Object)("putStream(): [" + code + " : " + items.message + "] " + items.details));
                throw new NovaException(items);
            }
            if (code == 202) {
                data = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        data = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)data);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    std.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                if (data != null && !data.trim().equals("")) {
                    String string = data;
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + NovaOpenStack.class.getName() + ".putStream()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("---------------------------------------------------------------------------------" + endpoint + resource));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private String toRegion(@Nonnull String endpoint) {
        Logger logger = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + AbstractMethod.class.getName() + ".toRegion(" + endpoint + ")"));
        }
        try {
            String host;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Looking up official region for " + endpoint));
            }
            try {
                URI uri = new URI(endpoint);
                host = uri.getHost();
            }
            catch (URISyntaxException e) {
                host = endpoint;
            }
            String[] parts = host.split("\\.");
            String regionId = parts.length < 3 ? host : (parts.length == 3 ? parts[0] : parts[0] + "." + parts[1]);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("regionId=" + regionId));
            }
            String string = regionId;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + AbstractMethod.class.getName() + ".toRegion()"));
            }
        }
    }

    @Nonnegative
    private int compareVersions(@Nullable String ver1, @Nullable String ver2) throws InternalException {
        Logger logger = NovaOpenStack.getLogger(NovaOpenStack.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + AbstractMethod.class.getName() + ".compareVersions(" + ver1 + "," + ver2 + ")"));
        }
        int result = 0;
        if (ver1 == null && ver2 == null) {
            return 0;
        }
        if (ver1 == null) {
            ver1 = "1.0";
        } else if (ver2 == null) {
            ver2 = "1.0";
        }
        try {
            String majorStr1 = ver1.contains(".") ? ver1.substring(0, ver1.indexOf(".")) : ver1;
            String minorStr1 = ver1.contains(".") ? ver1.substring(ver1.indexOf(".") + 1) : "0";
            String majorStr2 = ver2.contains(".") ? ver2.substring(0, ver2.indexOf(".")) : ver2;
            String minorStr2 = ver2.contains(".") ? ver2.substring(ver2.indexOf(".") + 1) : "0";
            int major1 = Integer.parseInt(majorStr1);
            int minor1 = Integer.parseInt(minorStr1);
            int major2 = Integer.parseInt(majorStr2);
            int minor2 = Integer.parseInt(minorStr2);
            result = major1 - major2;
            if (result == 0) {
                result = minor1 - minor2;
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + AbstractMethod.class.getName() + ".compareVersions(" + ver1 + "," + ver2 + ") = " + result));
            }
        }
        return result;
    }

    @Nonnull
    private String toAPIResource(@Nonnull String resource) {
        if (resource == null || resource.equals("/") || resource.length() < 2) {
            return resource;
        }
        while (resource.startsWith("/")) {
            if (resource.equals("/")) {
                return "/";
            }
            resource = resource.substring(1);
        }
        int idx = resource.indexOf("/");
        if (idx > 0) {
            return resource.substring(0, idx);
        }
        return resource;
    }
}

