/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.dc.Jurisdiction;
import org.dasein.cloud.dc.Region;

public class AuthenticationContext {
    private String authToken;
    private Map<String, Map<String, String>> endpoints;
    private String myRegion;
    private String storageToken;
    private String tenantId;

    public AuthenticationContext(@Nonnull String regionId, @Nonnull String token, @Nonnull String tenantId, @Nonnull Map<String, Map<String, String>> services, @Nullable String storageToken) {
        this.myRegion = regionId;
        this.authToken = token;
        this.endpoints = services;
        this.tenantId = tenantId;
        this.storageToken = storageToken;
    }

    @Nonnull
    public String getAuthToken() {
        return this.authToken;
    }

    @Nullable
    public String getComputeUrl() {
        Map<String, String> map = this.endpoints.get("compute");
        if (map == null) {
            return null;
        }
        return map.get(this.myRegion);
    }

    @Nullable
    public String getNetworkUrl() {
        return this.getServiceUrl("network");
    }

    public String getStorageToken() {
        if (this.storageToken == null) {
            return this.getAuthToken();
        }
        return this.storageToken;
    }

    @Nullable
    public String getStorageUrl() {
        return this.getServiceUrl("object-store");
    }

    @Nonnull
    public String getTenantId() {
        return this.tenantId;
    }

    @Nonnull
    public String getMyRegion() {
        return this.myRegion;
    }

    @Nullable
    public String getServiceUrl(String service) {
        Map<String, String> map = this.endpoints.get(service);
        if (map == null) {
            return null;
        }
        String endpoint = null;
        for (String key : map.keySet()) {
            if (this.myRegion == null) {
                this.myRegion = key;
            }
            if (key == null) {
                endpoint = map.get(null);
                continue;
            }
            if (key.equals(this.myRegion)) {
                return map.get(this.myRegion);
            }
            if (!this.myRegion.endsWith(key)) continue;
            endpoint = map.get(key);
        }
        return endpoint;
    }

    @Nonnull
    public Collection<Region> listRegions() {
        Map<String, String> map = this.endpoints.get("compute");
        if (map == null) {
            map = this.endpoints.get("object-store");
        }
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<Region> regions = new ArrayList<Region>();
        for (String regionId : map.keySet()) {
            Region region = new Region();
            region.setActive(true);
            region.setAvailable(true);
            region.setJurisdiction(Jurisdiction.US.name());
            region.setName(regionId);
            region.setProviderRegionId(regionId);
            regions.add(region);
        }
        return regions;
    }
}

