/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os;

import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.json.JSONException;
import org.json.JSONObject;

public class NovaException
extends CloudException {
    private static final long serialVersionUID = -9188123825416917437L;

    public static ExceptionItems parseException(int code, String json) {
        ExceptionItems items = new ExceptionItems();
        items.code = code;
        items.type = CloudErrorType.GENERAL;
        items.message = "unknown";
        items.details = "The cloud returned an error code with explanation: ";
        if (json != null) {
            try {
                JSONObject ob = new JSONObject(json);
                if (code == 400 && ob.has("badRequest")) {
                    ob = ob.getJSONObject("badRequest");
                }
                if (code == 413 && ob.has("overLimit")) {
                    ob = ob.getJSONObject("overLimit");
                }
                if (ob.has("message")) {
                    items.message = ob.getString("message");
                    items.message = items.message == null ? "unknown" : items.message.trim();
                }
                if (items.message.equals("unknown")) {
                    String[] names;
                    for (String key : names = JSONObject.getNames((JSONObject)ob)) {
                        try {
                            JSONObject msg = ob.getJSONObject(key);
                            if (!msg.has("message") || msg.isNull("message")) continue;
                            items.message = msg.getString("message");
                        }
                        catch (JSONException e) {
                            items.message = ob.getString(key);
                        }
                    }
                }
                items.details = ob.has("details") ? items.details + ob.getString("details") : items.details + "[" + code + "] " + items.message;
                String t = items.message.toLowerCase().trim();
                if (code == 413) {
                    items.type = CloudErrorType.THROTTLING;
                } else if (t.startsWith("addresslimitexceeded") || t.startsWith("ramlimitexceeded")) {
                    items.type = CloudErrorType.QUOTA;
                } else if (t.equals("unauthorized")) {
                    items.type = CloudErrorType.AUTHENTICATION;
                } else if (t.equals("serviceunavailable")) {
                    items.type = CloudErrorType.CAPACITY;
                } else if (t.equals("badrequest") || t.equals("badmediatype") || t.equals("badmethod") || t.equals("notimplemented")) {
                    items.type = CloudErrorType.COMMUNICATION;
                } else if (t.equals("overlimit")) {
                    items.type = CloudErrorType.QUOTA;
                } else if (t.equals("servercapacityunavailable")) {
                    items.type = CloudErrorType.CAPACITY;
                } else if (t.equals("itemnotfound")) {
                    return null;
                }
            }
            catch (JSONException e) {
                NovaOpenStack.getLogger(NovaException.class, "std").warn((Object)("parseException(): Invalid JSON in cloud response: " + json));
                items.details = json;
            }
        }
        return items;
    }

    public NovaException(ExceptionItems items) {
        super(items.type, items.code, items.message, items.details);
    }

    public NovaException(CloudErrorType type, int code, String message, String details) {
        super(type, code, message, details);
    }

    public static class ExceptionItems {
        public CloudErrorType type;
        public int code;
        public String message;
        public String details;
    }
}

