/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os;

import javax.annotation.Nonnull;
import org.dasein.cloud.compute.VirtualMachine;

public enum OpenStackProvider {
    DELL,
    DREAMHOST,
    HP,
    IBM,
    METACLOUD,
    RACKSPACE,
    OTHER;


    public static OpenStackProvider getProvider(@Nonnull String name) {
        if (name.equalsIgnoreCase("dell")) {
            return DELL;
        }
        if (name.equalsIgnoreCase("dreamhost")) {
            return DREAMHOST;
        }
        if (name.equalsIgnoreCase("hp")) {
            return HP;
        }
        if (name.equalsIgnoreCase("ibm")) {
            return IBM;
        }
        if (name.equalsIgnoreCase("metacloud")) {
            return METACLOUD;
        }
        if (name.equalsIgnoreCase("rackspace")) {
            return RACKSPACE;
        }
        return OTHER;
    }

    public boolean supportsPauseUnpause(@Nonnull VirtualMachine vm) {
        switch (this) {
            case HP: 
            case RACKSPACE: 
            case METACLOUD: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsStartStop(@Nonnull VirtualMachine vm) {
        switch (this) {
            case RACKSPACE: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsSuspendResume(@Nonnull VirtualMachine vm) {
        switch (this) {
            case HP: 
            case RACKSPACE: {
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public String getDefaultImageOwner(@Nonnull String tenantId) {
        switch (this) {
            case RACKSPACE: {
                return tenantId;
            }
        }
        return "--public--";
    }
}

