/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.compute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.AbstractSnapshotSupport;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.SnapshotCapabilities;
import org.dasein.cloud.compute.SnapshotCreateOptions;
import org.dasein.cloud.compute.SnapshotFilterOptions;
import org.dasein.cloud.compute.SnapshotState;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.compute.CinderSnapshotCapabilities;
import org.dasein.cloud.util.APITrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CinderSnapshot
extends AbstractSnapshotSupport {
    private static final Logger logger = NovaOpenStack.getLogger(CinderSnapshot.class, "std");
    public static final String SERVICE = "volume";
    private volatile transient CinderSnapshotCapabilities capabilities;

    public CinderSnapshot(NovaOpenStack provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return ((NovaOpenStack)this.getProvider()).getAuthenticationContext().getTenantId();
    }

    @Nonnull
    private String getResource() {
        return "/snapshots";
    }

    @Nonnull
    public String createSnapshot(@Nonnull SnapshotCreateOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.createSnapshot");
        try {
            String volumeId = options.getVolumeId();
            if (volumeId == null) {
                throw new OperationNotSupportedException("Snapshot copying is not supported in " + this.getProvider().getCloudName());
            }
            HashMap wrapper = new HashMap();
            HashMap<String, String> json = new HashMap<String, String>();
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            json.put("volume_id", volumeId);
            json.put("display_name", options.getName());
            json.put("display_description", options.getDescription());
            json.put("force", "True");
            wrapper.put("snapshot", json);
            JSONObject result = method.postString(SERVICE, this.getResource(), null, new JSONObject(wrapper), true);
            if (result != null && result.has("snapshot")) {
                try {
                    Snapshot snapshot = this.toSnapshot(result.getJSONObject("snapshot"));
                    if (snapshot != null) {
                        String string = snapshot.getProviderSnapshotId();
                        return string;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("create(): Unable to understand create response: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"snapshot(): No snapshot was created by the create attempt, and no error was returned");
            throw new CloudException("No snapshot was created");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public SnapshotCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new CinderSnapshotCapabilities((NovaOpenStack)this.getProvider());
        }
        return this.capabilities;
    }

    @Nonnull
    public String getProviderTermForSnapshot(@Nonnull Locale locale) {
        return "snapshot";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Snapshot getSnapshot(@Nonnull String snapshotId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.getSnapshot");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getResource(SERVICE, this.getResource(), snapshotId, true);
            if (ob == null) {
                Snapshot snapshot = null;
                return snapshot;
            }
            if (ob.has("snapshot")) {
                Snapshot snapshot = this.toSnapshot(ob.getJSONObject("snapshot"));
                return snapshot;
            }
            Snapshot snapshot = null;
            return snapshot;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listSnapshotStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.listSnapshotStatus");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            ArrayList<ResourceStatus> snapshots = new ArrayList<ResourceStatus>();
            JSONObject json = method.getResource(SERVICE, this.getResource(), null, false);
            if (json != null && json.has("snapshots")) {
                try {
                    JSONArray list = json.getJSONArray("snapshots");
                    for (int i = 0; i < list.length(); ++i) {
                        ResourceStatus snapshot = this.toStatus(list.getJSONObject(i));
                        if (snapshot == null) continue;
                        snapshots.add(snapshot);
                    }
                }
                catch (JSONException e) {
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for snapshots in " + json.toString());
                }
            }
            ArrayList<ResourceStatus> arrayList = snapshots;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isPublic(@Nonnull String snapshotId) throws InternalException, CloudException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.isSubscribed");
        try {
            boolean bl = ((NovaOpenStack)this.getProvider()).getAuthenticationContext().getServiceUrl(SERVICE) != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Snapshot> listSnapshots() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.listSnapshots");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
            JSONObject json = method.getResource(SERVICE, this.getResource(), null, false);
            if (json != null && json.has("snapshots")) {
                try {
                    JSONArray list = json.getJSONArray("snapshots");
                    for (int i = 0; i < list.length(); ++i) {
                        Snapshot snapshot = this.toSnapshot(list.getJSONObject(i));
                        if (snapshot == null) continue;
                        snapshots.add(snapshot);
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("listSnapshots(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for snapshots in " + json.toString());
                }
            }
            ArrayList<Snapshot> arrayList = snapshots;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String snapshotId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.remove");
        try {
            long timeout = System.currentTimeMillis() + 900000L;
            while (System.currentTimeMillis() < timeout) {
                Snapshot s;
                block18: {
                    s = this.getSnapshot(snapshotId);
                    if (s != null && !s.getCurrentState().equals((Object)SnapshotState.DELETED)) break block18;
                    return;
                }
                try {
                    if (s.getCurrentState().equals((Object)SnapshotState.AVAILABLE)) {
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {}
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.deleteResource(SERVICE, this.getResource(), snapshotId, null);
            timeout = System.currentTimeMillis() + 300000L;
            while (System.currentTimeMillis() < timeout) {
                try {
                    Snapshot s = this.getSnapshot(snapshotId);
                    if (s == null || s.getCurrentState().equals((Object)SnapshotState.DELETED)) {
                        return;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {}
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Snapshot> searchSnapshots(@Nonnull SnapshotFilterOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.searchSnapshots");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
            JSONObject json = method.getResource(SERVICE, this.getResource(), null, false);
            if (json != null && json.has("snapshots")) {
                try {
                    JSONArray list = json.getJSONArray("snapshots");
                    for (int i = 0; i < list.length(); ++i) {
                        Snapshot snapshot = this.toSnapshot(list.getJSONObject(i));
                        if (snapshot == null || !options.matches(snapshot, null)) continue;
                        snapshots.add(snapshot);
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("searchSnapshots(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for snapshots in " + json.toString());
                }
            }
            ArrayList<Snapshot> arrayList = snapshots;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private Snapshot toSnapshot(@Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            long created;
            String status;
            String volumeId;
            String description;
            String name;
            String snapshotId;
            String string = snapshotId = json.has("id") ? json.getString("id") : null;
            if (snapshotId == null) {
                return null;
            }
            String regionId = this.getContext().getRegionId();
            String string2 = name = json.has("displayName") ? json.getString("displayName") : null;
            if (name == null) {
                String string3 = name = json.has("display_name") ? json.getString("display_name") : null;
                if (name == null) {
                    name = snapshotId;
                }
            }
            String string4 = description = json.has("displayDescription") ? json.getString("displayDescription") : null;
            if (description == null) {
                String string5 = description = json.has("display_description") ? json.getString("display_description") : null;
                if (description == null) {
                    description = name;
                }
            }
            String string6 = volumeId = json.has("volumeId") ? json.getString("volumeId") : null;
            if (volumeId == null) {
                volumeId = json.has("volume_id") ? json.getString("volume_id") : null;
            }
            SnapshotState currentState = SnapshotState.PENDING;
            String string7 = status = json.has("status") ? json.getString("status") : null;
            if (status != null) {
                if (status.equalsIgnoreCase("deleted")) {
                    currentState = SnapshotState.DELETED;
                } else if (status.equalsIgnoreCase("available")) {
                    currentState = SnapshotState.AVAILABLE;
                } else if (status.equalsIgnoreCase("creating")) {
                    currentState = SnapshotState.PENDING;
                } else {
                    logger.warn((Object)("DEBUG: Unknown OpenStack snapshot state: " + status));
                }
            }
            long l = created = json.has("createdAt") ? ((NovaOpenStack)this.getProvider()).parseTimestamp(json.getString("createdAt")) : -1L;
            if (created < 1L) {
                created = json.has("created_at") ? ((NovaOpenStack)this.getProvider()).parseTimestamp(json.getString("created_at")) : -1L;
            }
            int size = json.has("size") ? json.getInt("size") : 0;
            Snapshot snapshot = new Snapshot();
            snapshot.setCurrentState(currentState);
            snapshot.setDescription(description);
            snapshot.setName(name);
            snapshot.setOwner(this.getTenantId());
            snapshot.setProviderSnapshotId(snapshotId);
            snapshot.setRegionId(regionId);
            snapshot.setSizeInGb(size);
            snapshot.setSnapshotTimestamp(created);
            snapshot.setVolumeId(volumeId);
            return snapshot;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String status;
            String snapshotId;
            String string = snapshotId = json.has("id") ? json.getString("id") : null;
            if (snapshotId == null) {
                return null;
            }
            SnapshotState state = SnapshotState.PENDING;
            String string2 = status = json.has("status") ? json.getString("status") : null;
            if (status != null) {
                if (status.equalsIgnoreCase("deleted")) {
                    state = SnapshotState.DELETED;
                } else if (status.equalsIgnoreCase("available")) {
                    state = SnapshotState.AVAILABLE;
                } else if (status.equalsIgnoreCase("creating")) {
                    state = SnapshotState.PENDING;
                } else {
                    logger.warn((Object)("DEBUG: Unknown OpenStack snapshot state: " + status));
                }
            }
            return new ResourceStatus(snapshotId, (Object)state);
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }
}

