/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VolumeCapabilities;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class CinderVolumeCapabilities
extends AbstractCapabilities<NovaOpenStack>
implements VolumeCapabilities {
    public CinderVolumeCapabilities(@Nonnull NovaOpenStack provider) {
        super((CloudProvider)provider);
    }

    public boolean canAttach(VmState vmState) throws InternalException, CloudException {
        return true;
    }

    public boolean canDetach(VmState vmState) throws InternalException, CloudException {
        return true;
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return -2;
    }

    @Nullable
    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1024, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        if (((NovaOpenStack)this.getProvider()).isRackspace()) {
            return new Storage((Number)100, (StorageUnit)Storage.GIGABYTE);
        }
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "volume";
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return ((NovaOpenStack)this.getProvider()).isHP() ? Requirement.NONE : Requirement.OPTIONAL;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        ArrayList<String> list = new ArrayList<String>();
        if (platform.isWindows()) {
            if (((NovaOpenStack)this.getProvider()).isHP()) {
                list.add("/dev/vdf");
                list.add("/dev/vdg");
                list.add("/dev/vdh");
                list.add("/dev/vdi");
                list.add("/dev/vdj");
            } else {
                list.add("/dev/xvdf");
                list.add("/dev/xvdg");
                list.add("/dev/xvdh");
                list.add("/dev/xvdi");
                list.add("/dev/xvdj");
            }
        } else {
            list.add("/dev/vdf");
            list.add("/dev/vdg");
            list.add("/dev/vdh");
            list.add("/dev/vdi");
            list.add("/dev/vdj");
        }
        return list;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Requirement requiresVMOnCreate() throws InternalException, CloudException {
        return Requirement.NONE;
    }
}

