/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.compute;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.AbstractVMSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.openstack.nova.os.NovaException;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.OpenStackProvider;
import org.dasein.cloud.openstack.nova.os.compute.NovaServerCapabilities;
import org.dasein.cloud.openstack.nova.os.network.NovaNetworkServices;
import org.dasein.cloud.openstack.nova.os.network.Quantum;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NovaServer
extends AbstractVMSupport<NovaOpenStack> {
    private static final Logger logger = NovaOpenStack.getLogger(NovaServer.class, "std");
    public static final String SERVICE = "compute";
    private volatile transient NovaServerCapabilities capabilities;

    NovaServer(NovaOpenStack provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return ((NovaOpenStack)this.getProvider()).getAuthenticationContext().getTenantId();
    }

    @Nonnull
    public VirtualMachineCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new NovaServerCapabilities((NovaOpenStack)this.getProvider());
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String getConsoleOutput(@Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getConsoleOutput");
        try {
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + vmId);
            }
            HashMap json = new HashMap();
            json.put("os-getConsoleOutput", new HashMap());
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            String console = method.postServersForString("/servers", vmId, new JSONObject(json), true);
            String string = console == null ? "" : console;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getProduct");
        try {
            for (VirtualMachineProduct product : this.listProducts(Architecture.I64)) {
                if (!product.getProviderProductId().equals(productId)) continue;
                VirtualMachineProduct virtualMachineProduct = product;
                return virtualMachineProduct;
            }
            VirtualMachineProduct virtualMachineProduct = null;
            return virtualMachineProduct;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getVirtualMachine");
        try {
            Iterable<Object> networks;
            List<IpAddress> ipv6;
            List<IpAddress> ipv4;
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/servers", vmId, true);
            if (ob == null) {
                VirtualMachine virtualMachine = null;
                return virtualMachine;
            }
            NovaNetworkServices services = ((NovaOpenStack)this.getProvider()).getNetworkServices();
            if (services != null) {
                IpAddressSupport support = services.getIpAddressSupport();
                if (support != null) {
                    ipv4 = support.listIpPool(IPVersion.IPV4, false);
                    ipv6 = support.listIpPool(IPVersion.IPV6, false);
                } else {
                    ipv6 = Collections.emptyList();
                    ipv4 = ipv6;
                }
                VLANSupport vs = services.getVlanSupport();
                networks = vs != null ? vs.listVlans() : Collections.emptyList();
            } else {
                ipv6 = Collections.emptyList();
                ipv4 = ipv6;
                networks = Collections.emptyList();
            }
            try {
                JSONObject server;
                VirtualMachine vm;
                if (ob.has("server") && (vm = this.toVirtualMachine(server = ob.getJSONObject("server"), ipv4, ipv6, networks)) != null) {
                    VirtualMachine virtualMachine = vm;
                    return virtualMachine;
                }
            }
            catch (JSONException e) {
                logger.error((Object)("getVirtualMachine(): Unable to identify expected values in JSON: " + e.getMessage()));
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for servers");
            }
            VirtualMachine virtualMachine = null;
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.isSubscribed");
        try {
            boolean bl = ((NovaOpenStack)this.getProvider()).testContext() != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.launch");
        try {
            Quantum support;
            NovaNetworkServices services;
            MachineImage targetImage = ((NovaOpenStack)this.getProvider()).getComputeServices().getImageSupport().getImage(options.getMachineImageId());
            if (targetImage == null) {
                throw new CloudException("No such machine image: " + options.getMachineImageId());
            }
            HashMap wrapper = new HashMap();
            HashMap<String, Object> json = new HashMap<String, Object>();
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            json.put("name", options.getHostName());
            if (options.getUserData() != null) {
                try {
                    json.put("user_data", Base64.encodeBase64String((byte[])options.getUserData().getBytes("utf-8")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            if (((NovaOpenStack)this.getProvider()).getMinorVersion() == 0 && ((NovaOpenStack)this.getProvider()).getMajorVersion() == 1) {
                json.put("imageId", String.valueOf(options.getMachineImageId()));
                json.put("flavorId", options.getStandardProductId());
            } else {
                if (((NovaOpenStack)this.getProvider()).getProviderName().equals("HP")) {
                    json.put("imageRef", options.getMachineImageId());
                } else {
                    json.put("imageRef", ((NovaOpenStack)this.getProvider()).getComputeServices().getImageSupport().getImageRef(options.getMachineImageId()));
                }
                json.put("flavorRef", this.getFlavorRef(options.getStandardProductId()));
            }
            if (options.getVlanId() != null && ((NovaOpenStack)this.getProvider()).isRackspace()) {
                ArrayList vlans = new ArrayList();
                HashMap<String, String> vlan = new HashMap<String, String>();
                vlan.put("uuid", options.getVlanId());
                vlans.add(vlan);
                json.put("networks", vlans);
            } else if (options.getVlanId() != null && !((NovaOpenStack)this.getProvider()).isRackspace() && (services = ((NovaOpenStack)this.getProvider()).getNetworkServices()) != null && (support = services.getVlanSupport()) != null) {
                ArrayList vlans = new ArrayList();
                HashMap<String, String> vlan = new HashMap<String, String>();
                try {
                    vlan.put("port", support.createPort(options.getVlanId(), options.getHostName()));
                    vlans.add(vlan);
                    json.put("networks", vlans);
                }
                catch (CloudException e) {
                    if (e.getHttpCode() != 403) {
                        throw new CloudException(e.getMessage());
                    }
                    logger.warn((Object)"Unable to create port - trying to launch into general network");
                    Subnet subnet = support.getSubnet(options.getVlanId());
                    vlan.put("uuid", subnet.getProviderVlanId());
                    vlans.add(vlan);
                    json.put("networks", vlans);
                }
            }
            if (options.getBootstrapKey() != null) {
                json.put("key_name", options.getBootstrapKey());
            }
            if (options.getFirewallIds().length > 0) {
                ArrayList firewalls = new ArrayList();
                for (String id : options.getFirewallIds()) {
                    FirewallSupport support2;
                    NovaNetworkServices services2 = ((NovaOpenStack)this.getProvider()).getNetworkServices();
                    Firewall firewall = null;
                    if (services2 != null && (support2 = services2.getFirewallSupport()) != null) {
                        firewall = support2.getFirewall(id);
                    }
                    if (firewall == null) continue;
                    HashMap<String, String> fw = new HashMap<String, String>();
                    fw.put("name", firewall.getName());
                    firewalls.add(fw);
                }
                json.put("security_groups", firewalls);
            }
            if (!targetImage.getPlatform().equals((Object)Platform.UNKNOWN)) {
                options.withMetaData("org.dasein.platform", (Object)targetImage.getPlatform().name());
            }
            options.withMetaData("org.dasein.description", (Object)options.getDescription());
            json.put("metadata", options.getMetaData());
            wrapper.put("server", json);
            JSONObject result = method.postServers("/servers", null, new JSONObject(wrapper), true);
            if (result.has("server")) {
                try {
                    List<IpAddress> ips = Collections.emptyList();
                    List<VLAN> nets = Collections.emptyList();
                    JSONObject server = result.getJSONObject("server");
                    VirtualMachine vm = this.toVirtualMachine(server, ips, ips, nets);
                    if (vm != null) {
                        VirtualMachine virtualMachine = vm;
                        return virtualMachine;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("launch(): Unable to understand launch response: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"launch(): No server was created by the launch attempt, and no error was returned");
            throw new CloudException("No virtual machine was launched");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private Iterable<String> listFirewalls(@Nonnull String vmId, @Nonnull JSONObject server) throws InternalException, CloudException {
        try {
            if (server.has("security_groups")) {
                FirewallSupport support;
                NovaNetworkServices services = ((NovaOpenStack)this.getProvider()).getNetworkServices();
                Collection<Object> firewalls = null;
                if (services != null && (support = services.getFirewallSupport()) != null) {
                    firewalls = support.list();
                }
                if (firewalls == null) {
                    firewalls = Collections.emptyList();
                }
                JSONArray groups = server.getJSONArray("security_groups");
                ArrayList<String> results = new ArrayList<String>();
                for (int i = 0; i < groups.length(); ++i) {
                    String name;
                    JSONObject group = groups.getJSONObject(i);
                    String id = group.has("id") ? group.getString("id") : null;
                    String string = name = group.has("name") ? group.getString("name") : null;
                    if (id == null && name == null) continue;
                    for (Firewall firewall : firewalls) {
                        if (id != null) {
                            if (!id.equals(firewall.getProviderFirewallId())) continue;
                            results.add(id);
                            continue;
                        }
                        if (!name.equals(firewall.getName())) continue;
                        results.add(firewall.getProviderFirewallId());
                    }
                }
                return results;
            }
            ArrayList<String> results = new ArrayList<String>();
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/os-security-groups/servers", vmId + "/os-security-groups", true);
            if (ob != null && ob.has("security_groups")) {
                JSONArray groups = ob.getJSONArray("security_groups");
                for (int i = 0; i < groups.length(); ++i) {
                    JSONObject group = groups.getJSONObject(i);
                    if (!group.has("id")) continue;
                    results.add(group.getString("id"));
                }
            }
            return results;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listFirewalls");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/servers", vmId, true);
            if (ob == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            if (ob.has("server")) {
                JSONObject server = ob.getJSONObject("server");
                Iterable<String> iterable = this.listFirewalls(vmId, server);
                return iterable;
            }
            try {
                throw new CloudException("No such server: " + vmId);
            }
            catch (JSONException e) {
                logger.error((Object)("listFirewalls(): Unable to identify expected values in JSON: " + e.getMessage()));
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for servers");
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Iterable<FlavorRef> listFlavors() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listFlavors");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"flavorRefs", FlavorRef.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
            Iterable refs = cache.get(this.getContext());
            if (refs != null) {
                Iterable iterable = refs;
                return iterable;
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/flavors", null, true);
            ArrayList<FlavorRef> flavors = new ArrayList<FlavorRef>();
            try {
                if (ob != null && ob.has("flavors")) {
                    JSONArray list = ob.getJSONArray("flavors");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject p = list.getJSONObject(i);
                        FlavorRef ref = new FlavorRef();
                        if (!p.has("id")) continue;
                        ref.id = p.getString("id");
                        if (p.has("links")) {
                            JSONArray links = p.getJSONArray("links");
                            ref.links = new String[links.length()][];
                            for (int j = 0; j < links.length(); ++j) {
                                JSONObject link = links.getJSONObject(j);
                                ref.links[j] = new String[2];
                                if (link.has("rel")) {
                                    ref.links[j][0] = link.getString("rel");
                                }
                                if (!link.has("href")) continue;
                                ref.links[j][1] = link.getString("href");
                            }
                        } else {
                            ref.links = new String[0][];
                        }
                        ref.product = this.toProduct(p);
                        if (ref.product == null) continue;
                        flavors.add(ref);
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("listProducts(): Unable to identify expected values in JSON: " + e.getMessage()));
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for flavors: " + e.getMessage());
            }
            cache.put(this.getContext(), flavors);
            ArrayList<FlavorRef> arrayList = flavors;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public String getFlavorRef(@Nonnull String flavorId) throws InternalException, CloudException {
        for (FlavorRef ref : this.listFlavors()) {
            if (!ref.id.equals(flavorId)) continue;
            String def = null;
            for (String[] link : ref.links) {
                if (link[0] != null && link[0].equals("self") && link[1] != null) {
                    return link[1];
                }
                if (def != null || link[1] == null) continue;
                def = link[1];
            }
            return def;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull Architecture architecture) throws InternalException, CloudException {
        if (!architecture.equals((Object)Architecture.I32) && !architecture.equals((Object)Architecture.I64)) {
            return Collections.emptyList();
        }
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listProducts");
        try {
            ArrayList<VirtualMachineProduct> products = new ArrayList<VirtualMachineProduct>();
            for (FlavorRef flavor : this.listFlavors()) {
                products.add(flavor.product);
            }
            ArrayList<VirtualMachineProduct> arrayList = products;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listVirtualMachineStatus");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/servers", null, true);
            ArrayList<ResourceStatus> servers = new ArrayList<ResourceStatus>();
            try {
                if (ob != null && ob.has("servers")) {
                    JSONArray list = ob.getJSONArray("servers");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject server = list.getJSONObject(i);
                        ResourceStatus vm = this.toStatus(server);
                        if (vm == null) continue;
                        servers.add(vm);
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("listVirtualMachines(): Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for servers in " + ob.toString());
            }
            ArrayList<ResourceStatus> arrayList = servers;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listVirtualMachines");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/servers", null, true);
            ArrayList<VirtualMachine> servers = new ArrayList<VirtualMachine>();
            List<IpAddress> ipv4 = Collections.emptyList();
            List<IpAddress> ipv6 = Collections.emptyList();
            List<VLAN> nets = Collections.emptyList();
            NovaNetworkServices services = ((NovaOpenStack)this.getProvider()).getNetworkServices();
            if (services != null) {
                VLANSupport vs;
                IpAddressSupport support = services.getIpAddressSupport();
                if (support != null) {
                    ipv4 = support.listIpPool(IPVersion.IPV4, false);
                    ipv6 = support.listIpPool(IPVersion.IPV6, false);
                }
                if ((vs = services.getVlanSupport()) != null) {
                    nets = vs.listVlans();
                }
            }
            try {
                if (ob != null && ob.has("servers")) {
                    JSONArray list = ob.getJSONArray("servers");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject server = list.getJSONObject(i);
                        VirtualMachine vm = this.toVirtualMachine(server, ipv4, ipv6, nets);
                        if (vm == null) continue;
                        servers.add(vm);
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("listVirtualMachines(): Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for servers in " + ob.toString());
            }
            ArrayList<VirtualMachine> arrayList = servers;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.pause");
        try {
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + vmId);
            }
            if (!this.supportsPauseUnpause(vm)) {
                throw new OperationNotSupportedException("Pause/unpause is not supported in " + ((NovaOpenStack)this.getProvider()).getCloudName());
            }
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("pause", null);
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.postServers("/servers", vmId, new JSONObject(json), true);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.resume");
        try {
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + vmId);
            }
            if (!this.supportsSuspendResume(vm)) {
                throw new OperationNotSupportedException("Suspend/resume is not supported in " + ((NovaOpenStack)this.getProvider()).getCloudName());
            }
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("resume", null);
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.postServers("/servers", vmId, new JSONObject(json), true);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.start");
        try {
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + vmId);
            }
            if (!this.supportsStartStop(vm)) {
                throw new OperationNotSupportedException("Start/stop is not supported in " + ((NovaOpenStack)this.getProvider()).getCloudName());
            }
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("os-start", null);
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.postServers("/servers", vmId, new JSONObject(json), true);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Nonnull String vmId, boolean force) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.stop");
        try {
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + vmId);
            }
            if (!this.supportsStartStop(vm)) {
                throw new OperationNotSupportedException("Start/stop is not supported in " + ((NovaOpenStack)this.getProvider()).getCloudName());
            }
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("os-stop", null);
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.postServers("/servers", vmId, new JSONObject(json), true);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.suspend");
        try {
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + vmId);
            }
            if (!this.supportsSuspendResume(vm)) {
                throw new OperationNotSupportedException("Suspend/resume is not supported in " + ((NovaOpenStack)this.getProvider()).getCloudName());
            }
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("suspend", null);
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.postServers("/servers", vmId, new JSONObject(json), true);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.unpause");
        try {
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + vmId);
            }
            if (!this.supportsPauseUnpause(vm)) {
                throw new OperationNotSupportedException("Pause/unpause is not supported in " + ((NovaOpenStack)this.getProvider()).getCloudName());
            }
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("unpause", null);
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.postServers("/servers", vmId, new JSONObject(json), true);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(@Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.reboot");
        try {
            HashMap json = new HashMap();
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("type", "HARD");
            json.put("reboot", action);
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            method.postServers("/servers", vmId, new JSONObject(json), true);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(@Nonnull String vmId, @Nullable String explanation) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.terminate");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            long timeout = System.currentTimeMillis() + 3600000L;
            while (true) {
                try {
                    method.deleteServers("/servers", vmId);
                    return;
                }
                catch (NovaException e) {
                    if (e.getHttpCode() != 409) {
                        throw e;
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < timeout) continue;
                    APITrace.end();
                }
                break;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private VirtualMachineProduct toProduct(@Nullable JSONObject json) throws JSONException, InternalException, CloudException {
        if (json == null) {
            return null;
        }
        VirtualMachineProduct product = new VirtualMachineProduct();
        if (json.has("id")) {
            product.setProviderProductId(json.getString("id"));
        }
        if (json.has("name")) {
            product.setName(json.getString("name"));
        }
        if (json.has("description")) {
            product.setDescription(json.getString("description"));
        }
        if (json.has("ram")) {
            product.setRamSize(new Storage((Number)json.getInt("ram"), (StorageUnit)Storage.MEGABYTE));
        }
        if (json.has("disk")) {
            product.setRootVolumeSize(new Storage((Number)json.getInt("disk"), (StorageUnit)Storage.GIGABYTE));
        }
        product.setCpuCount(1);
        if (product.getProviderProductId() == null) {
            return null;
        }
        if (product.getName() == null) {
            product.setName(product.getProviderProductId());
        }
        if (product.getDescription() == null) {
            product.setDescription(product.getName());
        }
        return product;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject server) throws JSONException, InternalException, CloudException {
        if (server == null) {
            return null;
        }
        String serverId = null;
        if (server.has("id")) {
            serverId = server.getString("id");
        }
        if (serverId == null) {
            return null;
        }
        VmState state = VmState.PENDING;
        if (server.has("status")) {
            String s = server.getString("status").toLowerCase();
            if (s.equals("active")) {
                state = VmState.RUNNING;
            } else if (s.equals("build")) {
                state = VmState.PENDING;
            } else if (s.equals("deleted")) {
                state = VmState.TERMINATED;
            } else if (s.equals("suspended")) {
                state = VmState.SUSPENDED;
            } else if (s.equalsIgnoreCase("paused")) {
                state = VmState.PAUSED;
            } else if (s.equalsIgnoreCase("stopped") || s.equalsIgnoreCase("shutoff")) {
                state = VmState.STOPPED;
            } else if (s.equalsIgnoreCase("stopping")) {
                state = VmState.STOPPING;
            } else if (s.equalsIgnoreCase("pausing")) {
                state = VmState.PAUSING;
            } else if (s.equalsIgnoreCase("suspending")) {
                state = VmState.SUSPENDING;
            } else {
                if (s.equals("error")) {
                    return null;
                }
                if (s.equals("reboot") || s.equals("hard_reboot")) {
                    state = VmState.REBOOTING;
                } else {
                    logger.warn((Object)("toVirtualMachine(): Unknown server state: " + s));
                    state = VmState.PENDING;
                }
            }
        }
        return new ResourceStatus(serverId, (Object)state);
    }

    @Nullable
    private VirtualMachine toVirtualMachine(@Nullable JSONObject server, @Nonnull Iterable<IpAddress> ipv4, @Nonnull Iterable<IpAddress> ipv6, @Nonnull Iterable<VLAN> networks) throws JSONException, InternalException, CloudException {
        JSONObject img;
        if (server == null) {
            return null;
        }
        VirtualMachine vm = new VirtualMachine();
        String description = null;
        vm.setCurrentState(VmState.RUNNING);
        vm.setArchitecture(Architecture.I64);
        vm.setClonable(false);
        vm.setCreationTimestamp(-1L);
        vm.setImagable(false);
        vm.setLastBootTimestamp(-1L);
        vm.setLastPauseTimestamp(-1L);
        vm.setPausable(false);
        vm.setPersistent(true);
        vm.setPlatform(Platform.UNKNOWN);
        vm.setRebootable(true);
        vm.setProviderOwnerId(this.getTenantId());
        if (((NovaOpenStack)this.getProvider()).getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
            vm.setPersistent(false);
        }
        if (server.has("id")) {
            vm.setProviderVirtualMachineId(server.getString("id"));
        }
        if (server.has("name")) {
            vm.setName(server.getString("name"));
        }
        if (server.has("description") && !server.isNull("description")) {
            description = server.getString("description");
        }
        if (server.has("kernel_id")) {
            vm.setProviderKernelImageId(server.getString("kernel_id"));
        }
        if (server.has("ramdisk_id")) {
            vm.setProviderRamdiskImageId(server.getString("ramdisk_id"));
        }
        JSONObject md = server.has("metadata") && !server.isNull("metadata") ? server.getJSONObject("metadata") : null;
        HashMap<String, String> map = new HashMap<String, String>();
        boolean imaging = false;
        if (md != null) {
            String[] keys;
            if (md.has("org.dasein.description") && vm.getDescription() == null) {
                description = md.getString("org.dasein.description");
            } else if (md.has("Server Label")) {
                description = md.getString("Server Label");
            }
            if (md.has("org.dasein.platform")) {
                try {
                    vm.setPlatform(Platform.valueOf((String)md.getString("org.dasein.platform")));
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if ((keys = JSONObject.getNames((JSONObject)md)) != null) {
                for (String key : keys) {
                    String value = md.getString(key);
                    if (value == null) continue;
                    map.put(key, value);
                }
            }
        }
        if (server.has("OS-EXT-STS:task_state") && !server.isNull("OS-EXT-STS:task_state")) {
            String t = server.getString("OS-EXT-STS:task_state");
            map.put("OS-EXT-STS:task_state", t);
            imaging = t.equalsIgnoreCase("image_snapshot");
        }
        if (description == null) {
            if (vm.getName() == null) {
                vm.setName(vm.getProviderVirtualMachineId());
            }
            vm.setDescription(vm.getName());
        } else {
            vm.setDescription(description);
        }
        if (server.has("hostId")) {
            map.put("host", server.getString("hostId"));
        }
        vm.setTags(map);
        if (server.has("image") && (img = server.getJSONObject("image")).has("id")) {
            vm.setProviderMachineImageId(img.getString("id"));
        }
        if (server.has("flavor")) {
            JSONObject f = server.getJSONObject("flavor");
            if (f.has("id")) {
                vm.setProductId(f.getString("id"));
            }
        } else if (server.has("flavorId")) {
            vm.setProductId(server.getString("flavorId"));
        }
        if (server.has("adminPass")) {
            vm.setRootPassword(server.getString("adminPass"));
        }
        if (server.has("key_name")) {
            vm.setProviderShellKeyIds(new String[]{server.getString("key_name")});
        }
        if (server.has("status")) {
            String s = server.getString("status").toLowerCase();
            if (s.equals("active")) {
                vm.setCurrentState(VmState.RUNNING);
            } else if (s.startsWith("build")) {
                vm.setCurrentState(VmState.PENDING);
            } else if (s.equals("deleted")) {
                vm.setCurrentState(VmState.TERMINATED);
            } else if (s.equals("suspended")) {
                vm.setCurrentState(VmState.SUSPENDED);
            } else if (s.equalsIgnoreCase("paused")) {
                vm.setCurrentState(VmState.PAUSED);
            } else if (s.equalsIgnoreCase("stopped") || s.equalsIgnoreCase("shutoff")) {
                vm.setCurrentState(VmState.STOPPED);
            } else if (s.equalsIgnoreCase("stopping")) {
                vm.setCurrentState(VmState.STOPPING);
            } else if (s.equalsIgnoreCase("pausing")) {
                vm.setCurrentState(VmState.PAUSING);
            } else if (s.equalsIgnoreCase("suspending")) {
                vm.setCurrentState(VmState.SUSPENDING);
            } else {
                if (s.equals("error")) {
                    return null;
                }
                if (s.equals("reboot") || s.equals("hard_reboot")) {
                    vm.setCurrentState(VmState.REBOOTING);
                } else {
                    logger.warn((Object)("toVirtualMachine(): Unknown server state: " + s));
                    vm.setCurrentState(VmState.PENDING);
                }
            }
        }
        if (vm.getCurrentState().equals((Object)VmState.RUNNING) && imaging) {
            vm.setCurrentState(VmState.PENDING);
        }
        if (server.has("created")) {
            vm.setCreationTimestamp(((NovaOpenStack)this.getProvider()).parseTimestamp(server.getString("created")));
        }
        if (server.has("addresses")) {
            RawAddress[] raw;
            JSONObject addrs = server.getJSONObject("addresses");
            String[] names = JSONObject.getNames((JSONObject)addrs);
            if (names != null && names.length > 0) {
                ArrayList<RawAddress> pub = new ArrayList<RawAddress>();
                ArrayList<RawAddress> priv = new ArrayList<RawAddress>();
                block3: for (String name : names) {
                    JSONArray arr = addrs.getJSONArray(name);
                    String subnet = null;
                    for (int i = 0; i < arr.length(); ++i) {
                        RawAddress addr = null;
                        if (((NovaOpenStack)this.getProvider()).getMinorVersion() == 0 && ((NovaOpenStack)this.getProvider()).getMajorVersion() == 1) {
                            addr = new RawAddress(arr.getString(i).trim(), IPVersion.IPV4);
                        } else {
                            JSONObject a = arr.getJSONObject(i);
                            if (a.has("version") && a.getInt("version") == 4 && a.has("addr")) {
                                subnet = a.getString("addr");
                                addr = new RawAddress(a.getString("addr"), IPVersion.IPV4);
                            } else if (a.has("version") && a.getInt("version") == 6 && a.has("addr")) {
                                subnet = a.getString("addr");
                                addr = new RawAddress(a.getString("addr"), IPVersion.IPV6);
                            }
                        }
                        if (addr == null) continue;
                        if (addr.isPublicIpAddress()) {
                            pub.add(addr);
                            continue;
                        }
                        priv.add(addr);
                    }
                    if (vm.getProviderVlanId() != null || name.equals("public") || name.equals("private") || name.equals("nova_fixed")) continue;
                    for (VLAN network : networks) {
                        if (!network.getName().equals(name)) continue;
                        vm.setProviderVlanId(network.getProviderVlanId());
                        NovaNetworkServices services = ((NovaOpenStack)this.getProvider()).getNetworkServices();
                        VLANSupport support = services.getVlanSupport();
                        Iterable subnets = support.listSubnets(network.getProviderVlanId());
                        for (Subnet sub : subnets) {
                            SubnetUtils utils = new SubnetUtils(sub.getCidr());
                            if (!utils.getInfo().isInRange(subnet)) continue;
                            vm.setProviderSubnetId(sub.getProviderSubnetId());
                            continue block3;
                        }
                    }
                }
                vm.setPublicAddresses(pub.toArray(new RawAddress[pub.size()]));
                vm.setPrivateAddresses(priv.toArray(new RawAddress[priv.size()]));
            }
            if ((raw = vm.getPublicAddresses()) != null) {
                block7: for (RawAddress addr : vm.getPublicAddresses()) {
                    if (addr.getVersion().equals((Object)IPVersion.IPV4)) {
                        for (IpAddress a : ipv4) {
                            if (!a.getRawAddress().getIpAddress().equals(addr.getIpAddress())) continue;
                            vm.setProviderAssignedIpAddressId(a.getProviderIpAddressId());
                            continue block7;
                        }
                        continue;
                    }
                    if (!addr.getVersion().equals((Object)IPVersion.IPV6)) continue;
                    for (IpAddress a : ipv6) {
                        if (!a.getRawAddress().getIpAddress().equals(addr.getIpAddress())) continue;
                        vm.setProviderAssignedIpAddressId(a.getProviderIpAddressId());
                        continue block7;
                    }
                }
            }
            if (vm.getProviderAssignedIpAddressId() == null) {
                for (IpAddress addr : ipv4) {
                    String serverId = addr.getServerId();
                    if (serverId == null || !serverId.equals(vm.getProviderVirtualMachineId())) continue;
                    vm.setProviderAssignedIpAddressId(addr.getProviderIpAddressId());
                    break;
                }
                if (vm.getProviderAssignedIpAddressId() == null) {
                    for (IpAddress addr : ipv6) {
                        String serverId = addr.getServerId();
                        if (serverId == null || !addr.getServerId().equals(vm.getProviderVirtualMachineId())) continue;
                        vm.setProviderAssignedIpAddressId(addr.getProviderIpAddressId());
                        break;
                    }
                }
            }
            vm.setProviderRegionId(this.getContext().getRegionId());
            vm.setProviderDataCenterId(vm.getProviderRegionId() + "-a");
            vm.setTerminationTimestamp(-1L);
            if (vm.getProviderVirtualMachineId() == null) {
                return null;
            }
            if (vm.getProviderAssignedIpAddressId() == null) {
                for (IpAddress addr : ipv6) {
                    if (!addr.getServerId().equals(vm.getProviderVirtualMachineId())) continue;
                    vm.setProviderAssignedIpAddressId(addr.getProviderIpAddressId());
                    break;
                }
            }
        }
        vm.setProviderRegionId(this.getContext().getRegionId());
        vm.setProviderDataCenterId(vm.getProviderRegionId() + "-a");
        vm.setTerminationTimestamp(-1L);
        if (vm.getProviderVirtualMachineId() == null) {
            return null;
        }
        if (vm.getName() == null) {
            vm.setName(vm.getProviderVirtualMachineId());
        }
        if (vm.getDescription() == null) {
            vm.setDescription(vm.getName());
        }
        vm.setImagable(vm.getCurrentState().equals((Object)VmState.RUNNING));
        vm.setRebootable(vm.getCurrentState().equals((Object)VmState.RUNNING));
        if (vm.getPlatform().equals((Object)Platform.UNKNOWN)) {
            MachineImage img2;
            Platform p = Platform.guess((String)(vm.getName() + " " + vm.getDescription()));
            if (p.equals((Object)Platform.UNKNOWN) && (img2 = ((NovaOpenStack)this.getProvider()).getComputeServices().getImageSupport().getImage(vm.getProviderMachineImageId())) != null) {
                p = img2.getPlatform();
            }
            vm.setPlatform(p);
        }
        if (((NovaOpenStack)this.getProvider()).getProviderName().equalsIgnoreCase("RACKSPACE")) {
            vm.setProviderFirewallIds(null);
        } else {
            Iterable<String> fwIds = this.listFirewalls(vm.getProviderVirtualMachineId(), server);
            int count = 0;
            for (String id : fwIds) {
                ++count;
            }
            String[] ids = new String[count];
            int i = 0;
            for (String id : fwIds) {
                ids[i++] = id;
            }
            vm.setProviderFirewallIds(ids);
        }
        return vm;
    }

    public static class FlavorRef {
        public String id;
        public String[][] links;
        VirtualMachineProduct product;

        public String toString() {
            return this.id + " -> " + this.product;
        }
    }
}

