/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.compute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.identity.ShellKeySupport;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.identity.NovaIdentityServices;
import org.dasein.cloud.openstack.nova.os.network.NovaNetworkServices;
import org.dasein.cloud.util.NamingConstraints;

public class NovaServerCapabilities
extends AbstractCapabilities<NovaOpenStack>
implements VirtualMachineCapabilities {
    private transient Collection<Architecture> architectures;

    public NovaServerCapabilities(@Nonnull NovaOpenStack cloud) {
        super((CloudProvider)cloud);
    }

    public boolean canAlter(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canClone(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canPause(@Nonnull VmState fromState) throws CloudException, InternalException {
        boolean canPause = ((NovaOpenStack)this.getProvider()).getCloudProvider().supportsPauseUnpause(null);
        if (canPause) {
            return !fromState.equals((Object)VmState.PAUSED);
        }
        return canPause;
    }

    public boolean canReboot(@Nonnull VmState fromState) throws CloudException, InternalException {
        return true;
    }

    public boolean canResume(@Nonnull VmState fromState) throws CloudException, InternalException {
        boolean canResume = ((NovaOpenStack)this.getProvider()).getCloudProvider().supportsSuspendResume(null);
        if (canResume) {
            return !fromState.equals((Object)VmState.RUNNING);
        }
        return canResume;
    }

    public boolean canStart(@Nonnull VmState fromState) throws CloudException, InternalException {
        boolean canStart = ((NovaOpenStack)this.getProvider()).getCloudProvider().supportsStartStop(null);
        if (canStart) {
            return !fromState.equals((Object)VmState.RUNNING);
        }
        return canStart;
    }

    public boolean canStop(@Nonnull VmState fromState) throws CloudException, InternalException {
        boolean canStop = ((NovaOpenStack)this.getProvider()).getCloudProvider().supportsStartStop(null);
        if (canStop) {
            return !fromState.equals((Object)VmState.STOPPED);
        }
        return canStop;
    }

    public boolean canSuspend(@Nonnull VmState fromState) throws CloudException, InternalException {
        boolean canSuspend = ((NovaOpenStack)this.getProvider()).getCloudProvider().supportsSuspendResume(null);
        if (canSuspend) {
            return !fromState.equals((Object)VmState.SUSPENDED);
        }
        return canSuspend;
    }

    public boolean canTerminate(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.TERMINATED);
    }

    public boolean canUnpause(@Nonnull VmState fromState) throws CloudException, InternalException {
        boolean canUnpause = ((NovaOpenStack)this.getProvider()).getCloudProvider().supportsPauseUnpause(null);
        if (canUnpause) {
            return !fromState.equals((Object)VmState.RUNNING);
        }
        return canUnpause;
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -2;
    }

    public int getCostFactor(@Nonnull VmState state) throws CloudException, InternalException {
        return 100;
    }

    @Nonnull
    public String getProviderTermForVirtualMachine(@Nonnull Locale locale) throws CloudException, InternalException {
        return "server";
    }

    @Nullable
    public VMScalingCapabilities getVerticalScalingCapabilities() throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public NamingConstraints getVirtualMachineNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)100);
    }

    @Nonnull
    public Requirement identifyDataCenterLaunchRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return cls.equals((Object)ImageClass.MACHINE) ? Requirement.REQUIRED : Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement(Platform platform) throws CloudException, InternalException {
        NovaIdentityServices services = ((NovaOpenStack)this.getProvider()).getIdentityServices();
        if (services == null) {
            return Requirement.NONE;
        }
        ShellKeySupport support = services.getShellKeySupport();
        if (support == null) {
            return Requirement.NONE;
        }
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifySubnetRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        NovaNetworkServices services = ((NovaOpenStack)this.getProvider()).getNetworkServices();
        if (services == null) {
            return Requirement.NONE;
        }
        VLANSupport support = services.getVlanSupport();
        if (support == null || !support.isSubscribed()) {
            return Requirement.NONE;
        }
        return Requirement.REQUIRED;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return true;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        if (this.architectures == null) {
            ArrayList<Architecture> a = new ArrayList<Architecture>();
            a.add(Architecture.I32);
            a.add(Architecture.I64);
            this.architectures = Collections.unmodifiableList(a);
        }
        return this.architectures;
    }
}

