/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.ext.hp.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.TimeWindow;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.platform.ConfigurationParameter;
import org.dasein.cloud.platform.Database;
import org.dasein.cloud.platform.DatabaseConfiguration;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.platform.DatabaseProduct;
import org.dasein.cloud.platform.DatabaseSnapshot;
import org.dasein.cloud.platform.DatabaseSnapshotState;
import org.dasein.cloud.platform.DatabaseState;
import org.dasein.cloud.platform.RelationalDatabaseSupport;
import org.dasein.cloud.util.APITrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HPRDBMS
implements RelationalDatabaseSupport {
    private static final Logger logger = NovaOpenStack.getLogger(HPRDBMS.class, "std");
    public static final String RESOURCE = "/instances";
    public static final String SNAPSHOTS = "/snapshots";
    public static final String SERVICE = "hpext:database";
    private NovaOpenStack provider;

    public HPRDBMS(NovaOpenStack provider) {
        this.provider = provider;
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return this.provider.getAuthenticationContext().getTenantId();
    }

    public void addAccess(String providerDatabaseId, String sourceCidr) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Access management is not yet supported");
    }

    public void alterDatabase(String providerDatabaseId, boolean applyImmediately, String productSize, int storageInGigabytes, String configurationId, String newAdminUser, String newAdminPassword, int newPort, int snapshotRetentionInDays, TimeWindow preferredMaintenanceWindow, TimeWindow preferredBackupWindow) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not able to alter databases yet");
    }

    @Nonnull
    public String createFromScratch(@Nonnull String dataSourceName, @Nonnull DatabaseProduct product, @Nonnull String databaseVersion, @Nonnull String withAdminUser, @Nonnull String withAdminPassword, int hostPort) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.createFromScratch");
        try {
            HashMap<String, String> type;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            HashMap wrapper = new HashMap();
            HashMap<String, Object> json = new HashMap<String, Object>();
            NovaMethod method = new NovaMethod(this.provider);
            json.put("flavorRef", this.getFlavorRef(product.getProductSize()));
            json.put("name", dataSourceName);
            json.put("port", hostPort > 0 ? hostPort : 3306);
            if (product.getEngine().isMySQL()) {
                type = new HashMap<String, String>();
                type.put("name", "mysql");
                if (databaseVersion != null) {
                    type.put("version", databaseVersion);
                } else if (product.getEngine().equals((Object)DatabaseEngine.MYSQL51)) {
                    type.put("version", "5.1");
                } else if (product.getEngine().equals((Object)DatabaseEngine.MYSQL50)) {
                    type.put("version", "5.0");
                } else {
                    type.put("version", "5.5");
                }
            } else {
                throw new CloudException("Unsupported database product: " + product);
            }
            json.put("dbtype", type);
            wrapper.put("instance", json);
            JSONObject result = method.postString(SERVICE, RESOURCE, null, new JSONObject(wrapper), true);
            if (result != null && result.has("instance")) {
                try {
                    Database db = this.toDatabase(ctx, result.getJSONObject("instance"));
                    if (db != null) {
                        String string = db.getProviderDatabaseId();
                        return string;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("createFromScratch(): Unable to understand create response: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"createFromScratch(): No database was created by the create attempt, and no error was returned");
            throw new CloudException("No database was created");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFromLatest(String dataSourceName, String providerDatabaseId, String productSize, String providerDataCenterId, int hostPort) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.createFromLatest");
        try {
            DatabaseSnapshot snapshot = null;
            for (DatabaseSnapshot s : this.listSnapshots(providerDatabaseId)) {
                if (snapshot != null && s.getSnapshotTimestamp() <= snapshot.getSnapshotTimestamp()) continue;
                snapshot = s;
            }
            if (snapshot == null) {
                throw new CloudException("No snapshots exist from which to create a new database instance");
            }
            String string = this.createFromSnapshot(dataSourceName, providerDatabaseId, snapshot.getProviderSnapshotId(), productSize, providerDataCenterId, hostPort);
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    public String createFromSnapshot(String dataSourceName, String providerDatabaseId, String providerDbSnapshotId, String productSize, String providerDataCenterId, int hostPort) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.createFromSnapshot");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            HashMap wrapper = new HashMap();
            HashMap<String, Object> json = new HashMap<String, Object>();
            NovaMethod method = new NovaMethod(this.provider);
            json.put("flavorRef", this.getFlavorRef(productSize));
            json.put("name", dataSourceName);
            json.put("port", hostPort > 0 ? hostPort : 3306);
            json.put("snapshotId", providerDbSnapshotId);
            wrapper.put("instance", json);
            JSONObject result = method.postString(SERVICE, RESOURCE, null, new JSONObject(wrapper), true);
            if (result != null && result.has("instance")) {
                try {
                    Database db = this.toDatabase(ctx, result.getJSONObject("instance"));
                    if (db != null) {
                        String string = db.getProviderDatabaseId();
                        return string;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("createFromSnapshot(): Unable to understand create response: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"createFromSnapshot(): No database was created by the create attempt, and no error was returned");
            throw new CloudException("No database was created");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFromTimestamp(String dataSourceName, String providerDatabaseId, long beforeTimestamp, String productSize, String providerDataCenterId, int hostPort) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.createFromTimestamp");
        try {
            DatabaseSnapshot snapshot = null;
            for (DatabaseSnapshot s : this.listSnapshots(providerDatabaseId)) {
                if (s.getSnapshotTimestamp() >= beforeTimestamp || snapshot != null && s.getSnapshotTimestamp() <= snapshot.getSnapshotTimestamp()) continue;
                snapshot = s;
            }
            if (snapshot == null) {
                throw new CloudException("No snapshots exist from which to create a new database instance");
            }
            String string = this.createFromSnapshot(dataSourceName, providerDatabaseId, snapshot.getProviderSnapshotId(), productSize, providerDataCenterId, hostPort);
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public DatabaseConfiguration getConfiguration(@Nonnull String providerConfigurationId) throws CloudException, InternalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Database getDatabase(@Nonnull String providerDatabaseId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getDatabase");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getResource(SERVICE, RESOURCE, providerDatabaseId, false);
            if (ob == null) {
                Database database = null;
                return database;
            }
            if (ob.has("instance")) {
                Database database = this.toDatabase(ctx, ob.getJSONObject("instance"));
                return database;
            }
            Database database = null;
            return database;
        }
        finally {
            APITrace.end();
        }
    }

    public Iterable<DatabaseEngine> getDatabaseEngines() throws CloudException, InternalException {
        return Collections.singletonList(DatabaseEngine.MYSQL55);
    }

    @Nullable
    public String getDefaultVersion(@Nonnull DatabaseEngine forEngine) throws CloudException, InternalException {
        if (forEngine.isMySQL()) {
            return "5.5";
        }
        return null;
    }

    public Iterable<String> getSupportedVersions(DatabaseEngine forEngine) throws CloudException, InternalException {
        if (forEngine.isMySQL()) {
            return Collections.singletonList("5.5");
        }
        return Collections.emptyList();
    }

    @Nullable
    public DatabaseProduct getDatabaseProduct(String flavor) throws CloudException, InternalException {
        boolean hasSize = flavor.contains(":");
        for (DatabaseEngine engine : DatabaseEngine.values()) {
            for (DatabaseProduct product : this.getDatabaseProducts(engine)) {
                if (hasSize && product.getProductSize().equals(flavor)) {
                    return product;
                }
                if (hasSize || !product.getProductSize().startsWith(flavor)) continue;
                return product;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<DatabaseProduct> getDatabaseProducts(DatabaseEngine forEngine) throws CloudException, InternalException {
        if (DatabaseEngine.MYSQL55.equals((Object)forEngine)) {
            Logger std = NovaOpenStack.getLogger(HPRDBMS.class, "std");
            if (std.isTraceEnabled()) {
                std.trace((Object)("ENTER: " + HPRDBMS.class.getName() + ".getDatabaseProducts()"));
            }
            try {
                ProviderContext ctx = this.provider.getContext();
                if (ctx == null) {
                    std.error((Object)"No context exists for this request");
                    throw new InternalException("No context exists for this request");
                }
                NovaMethod method = new NovaMethod(this.provider);
                JSONObject json = method.getResource(SERVICE, "/flavors", null, false);
                ArrayList<DatabaseProduct> products = new ArrayList<DatabaseProduct>();
                if (json != null && json.has("flavors")) {
                    try {
                        JSONArray flavors = json.getJSONArray("flavors");
                        for (int i = 0; i < flavors.length(); ++i) {
                            JSONObject flavor = flavors.getJSONObject(i);
                            if (flavor == null) continue;
                            for (int size : new int[]{2, 5, 10, 20, 25, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200, 250, 300, 400, 500, 600, 700, 800, 900, 1000}) {
                                DatabaseProduct product = this.toProduct(ctx, size, flavor);
                                if (product == null) continue;
                                products.add(product);
                            }
                        }
                    }
                    catch (JSONException e) {
                        std.error((Object)("getDatabaseProducts(): Unable to identify expected values in JSON: " + e.getMessage()));
                        e.printStackTrace();
                        throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for flavors in " + json.toString());
                    }
                }
                ArrayList<DatabaseProduct> arrayList = products;
                return arrayList;
            }
            finally {
                if (std.isTraceEnabled()) {
                    std.trace((Object)("exit - " + HPRDBMS.class.getName() + ".getDatabaseProducts()"));
                }
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String getFlavorRef(@Nonnull String productId) throws CloudException, InternalException {
        Logger std = NovaOpenStack.getLogger(HPRDBMS.class, "std");
        if (std.isTraceEnabled()) {
            std.trace((Object)("ENTER: " + HPRDBMS.class.getName() + ".getFlavorRef(" + productId + ")"));
        }
        try {
            NovaMethod method;
            JSONObject json;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                std.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            int idx = productId.indexOf(":");
            if (idx > -1) {
                productId = productId.substring(0, idx);
            }
            if ((json = (method = new NovaMethod(this.provider)).getResource(SERVICE, "/flavors", productId, false)) != null && json.has("flavor")) {
                try {
                    JSONArray links;
                    JSONObject flavor = json.getJSONObject("flavor");
                    if (flavor.has("links") && (links = flavor.getJSONArray("links")) != null) {
                        for (int i = 0; i < links.length(); ++i) {
                            String rel;
                            JSONObject link = links.getJSONObject(i);
                            if (!link.has("rel") || (rel = link.getString("rel")) == null || !rel.equalsIgnoreCase("self")) continue;
                            String string = link.getString("href");
                            return string;
                        }
                    }
                }
                catch (JSONException e) {
                    std.error((Object)("getFlavorRef(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for flavors in " + json.toString());
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (std.isTraceEnabled()) {
                std.trace((Object)("exit - " + HPRDBMS.class.getName() + ".getFlavorRef()"));
            }
        }
    }

    public String getProviderTermForDatabase(Locale locale) {
        return "database";
    }

    public String getProviderTermForSnapshot(Locale locale) {
        return "snapshot";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseSnapshot getSnapshot(String providerDbSnapshotId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getSnapshot");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getResource(SERVICE, SNAPSHOTS, providerDbSnapshotId, false);
            if (ob == null) {
                DatabaseSnapshot databaseSnapshot = null;
                return databaseSnapshot;
            }
            if (ob.has("snapshot")) {
                DatabaseSnapshot databaseSnapshot = this.toSnapshot(ctx, ob.getJSONObject("snapshot"));
                return databaseSnapshot;
            }
            DatabaseSnapshot databaseSnapshot = null;
            return databaseSnapshot;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.isSubscribed");
        try {
            boolean bl = this.provider.getAuthenticationContext().getServiceUrl(SERVICE) != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSupportsFirewallRules() {
        return false;
    }

    public boolean isSupportsHighAvailability() throws CloudException, InternalException {
        return false;
    }

    public boolean isSupportsLowAvailability() throws CloudException, InternalException {
        return true;
    }

    public boolean isSupportsMaintenanceWindows() {
        return false;
    }

    public boolean isSupportsSnapshots() {
        return true;
    }

    public Iterable<String> listAccess(String toProviderDatabaseId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public Iterable<DatabaseConfiguration> listConfigurations() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listDatabaseStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.listDatabaseStatus");
        try {
            NovaMethod method = new NovaMethod(this.provider);
            ArrayList<ResourceStatus> databases = new ArrayList<ResourceStatus>();
            JSONObject json = method.getResource(SERVICE, RESOURCE, null, false);
            if (json != null && json.has("instances")) {
                try {
                    JSONArray list = json.getJSONArray("instances");
                    for (int i = 0; i < list.length(); ++i) {
                        ResourceStatus db = this.toStatus(list.getJSONObject(i));
                        if (db == null) continue;
                        databases.add(db);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for instances in " + json.toString());
                }
            }
            ArrayList<ResourceStatus> arrayList = databases;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Database> listDatabases() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.listDatabases");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            ArrayList<Database> databases = new ArrayList<Database>();
            JSONObject json = method.getResource(SERVICE, RESOURCE, null, false);
            if (json != null && json.has("instances")) {
                try {
                    JSONArray list = json.getJSONArray("instances");
                    for (int i = 0; i < list.length(); ++i) {
                        Database db = this.toDatabase(ctx, list.getJSONObject(i));
                        if (db == null) continue;
                        databases.add(db);
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("listDatabases(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for instances in " + json.toString());
                }
            }
            ArrayList<Database> arrayList = databases;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public Collection<ConfigurationParameter> listParameters(String forProviderConfigurationId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<DatabaseSnapshot> listSnapshots(String forOptionalProviderDatabaseId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.listSnapshots");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            ArrayList<DatabaseSnapshot> snapshots = new ArrayList<DatabaseSnapshot>();
            JSONObject json = method.getResource(SERVICE, SNAPSHOTS, null, false);
            if (json != null && json.has("snapshots")) {
                try {
                    JSONArray list = json.getJSONArray("snapshots");
                    for (int i = 0; i < list.length(); ++i) {
                        DatabaseSnapshot snapshot = this.toSnapshot(ctx, list.getJSONObject(i));
                        if (snapshot == null) continue;
                        snapshots.add(snapshot);
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("listSnapshots(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for snapshots in " + json.toString());
                }
            }
            ArrayList<DatabaseSnapshot> arrayList = snapshots;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void removeConfiguration(String providerConfigurationId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No configuration management yet exists");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabase(String providerDatabaseId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.removeDatabase");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            method.deleteResource(SERVICE, RESOURCE, providerDatabaseId, null);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSnapshot(String providerSnapshotId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.removeSnapshot");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            method.deleteResource(SERVICE, SNAPSHOTS, providerSnapshotId, null);
        }
        finally {
            APITrace.end();
        }
    }

    public void resetConfiguration(String providerConfigurationId, String ... parameters) throws CloudException, InternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(String providerDatabaseId, boolean blockUntilDone) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.restart");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            method.postResourceHeaders(SERVICE, RESOURCE, providerDatabaseId + "/restart", new HashMap<String, String>());
        }
        finally {
            APITrace.end();
        }
    }

    public void revokeAccess(String providerDatabaseId, String sourceCide) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No access management yet exists");
    }

    public void updateConfiguration(String providerConfigurationId, ConfigurationParameter ... parameters) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No configuration management yet exists");
    }

    public DatabaseSnapshot snapshot(String providerDatabaseId, String name) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.snapshot");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            HashMap wrapper = new HashMap();
            HashMap<String, String> json = new HashMap<String, String>();
            NovaMethod method = new NovaMethod(this.provider);
            json.put("name", name);
            json.put("instanceId", providerDatabaseId);
            wrapper.put("snapshot", json);
            JSONObject result = method.postString(SERVICE, SNAPSHOTS, null, new JSONObject(wrapper), true);
            if (result != null && result.has("snapshot")) {
                try {
                    DatabaseSnapshot snapshot = this.toSnapshot(ctx, result.getJSONObject("snapshot"));
                    if (snapshot != null) {
                        DatabaseSnapshot databaseSnapshot = snapshot;
                        return databaseSnapshot;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("snapshot(): Unable to understand create response: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"snapshot(): No snapshot was created by the create attempt, and no error was returned");
            throw new CloudException("No snapshot was created");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private Database toDatabase(@Nonnull ProviderContext ctx, @Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        String regionId = ctx.getRegionId();
        try {
            String flavor;
            JSONObject c;
            String status;
            String name;
            String dbId;
            String string = dbId = json.has("id") ? json.getString("id") : null;
            if (dbId == null) {
                return null;
            }
            String string2 = name = json.has("name") ? json.getString("name") : null;
            if (name == null) {
                name = "RDBMS MySQL #" + dbId;
            }
            DatabaseState currentState = DatabaseState.PENDING;
            String string3 = status = json.has("status") ? json.getString("status") : null;
            if (status != null) {
                if (status.equalsIgnoreCase("BUILD") || status.equalsIgnoreCase("building")) {
                    currentState = DatabaseState.PENDING;
                } else if (status.equalsIgnoreCase("AVAILABLE")) {
                    currentState = DatabaseState.AVAILABLE;
                } else if (status.equalsIgnoreCase("running")) {
                    currentState = DatabaseState.AVAILABLE;
                } else {
                    System.out.println("DEBUG OS DB STATE: " + status);
                }
            }
            long created = json.has("created") ? this.provider.parseTimestamp(json.getString("created")) : -1L;
            String hostname = json.has("hostname") ? json.getString("hostname") : null;
            String user = null;
            if (json.has("credential") && (c = json.getJSONObject("credential")).has("username")) {
                user = c.getString("username");
            }
            String string4 = flavor = json.has("flavorRef") ? json.getString("flavorRef") : null;
            if (flavor == null) {
                JSONObject f;
                JSONObject jSONObject = f = json.has("flavor") ? json.getJSONObject("flavor") : null;
                if (f != null && f.has("id")) {
                    flavor = f.getString("id");
                }
            } else {
                int idx = flavor.lastIndexOf("/");
                if (idx > -1) {
                    flavor = flavor.substring(idx + 1);
                }
            }
            int port = json.has("port") ? json.getInt("port") : 3306;
            DatabaseEngine engine = DatabaseEngine.MYSQL55;
            if (json.has("dbtype")) {
                JSONObject t = json.getJSONObject("dbtype");
                String db = "mysql";
                String version = "5.5";
                if (t.has("name")) {
                    db = t.getString("name");
                }
                if (t.has("version")) {
                    version = t.getString("version");
                }
                if (db.equalsIgnoreCase("mysql")) {
                    if (!version.startsWith("5.5")) {
                        if (version.startsWith("5.1")) {
                            engine = DatabaseEngine.MYSQL51;
                        } else if (version.startsWith("5.0")) {
                            engine = DatabaseEngine.MYSQL50;
                        } else {
                            System.out.println("DEBUG OS UNKNOWN MYSQL VERSION " + version);
                            engine = DatabaseEngine.MYSQL;
                        }
                    }
                } else {
                    System.out.println("DEBUG OS UNKNOWN DB: " + db + " " + version);
                }
            }
            DatabaseProduct product = flavor == null ? null : this.getDatabaseProduct(flavor);
            Database database = new Database();
            database.setAdminUser(user);
            database.setAllocatedStorageInGb(product == null ? 0 : product.getStorageInGigabytes());
            database.setCreationTimestamp(created);
            database.setCurrentState(currentState);
            database.setEngine(engine);
            database.setHighAvailability(false);
            database.setHostName(hostname);
            database.setHostPort(port);
            database.setName(name);
            database.setProductSize(flavor);
            database.setProviderDatabaseId(dbId);
            database.setProviderDataCenterId(regionId + "-a");
            database.setProviderOwnerId(this.getTenantId());
            database.setProviderRegionId(regionId);
            return database;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private DatabaseSnapshot toSnapshot(@Nonnull ProviderContext ctx, @Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String status;
            String snapshotId;
            String regionId = ctx.getRegionId();
            String string = snapshotId = json.has("id") ? json.getString("id") : null;
            if (snapshotId == null) {
                return null;
            }
            String dbId = json.has("instanceId") ? json.getString("instanceId") : null;
            DatabaseSnapshotState currentState = DatabaseSnapshotState.CREATING;
            String string2 = status = json.has("status") ? json.getString("status") : null;
            if (status != null) {
                if (status.equalsIgnoreCase("building")) {
                    currentState = DatabaseSnapshotState.CREATING;
                } else if (status.equalsIgnoreCase("available")) {
                    currentState = DatabaseSnapshotState.AVAILABLE;
                } else if (status.equalsIgnoreCase("deleted")) {
                    currentState = DatabaseSnapshotState.DELETED;
                } else {
                    System.out.println("DEBUG OS DBSNAP STATE: " + status);
                }
            }
            long created = json.has("created") ? this.provider.parseTimestamp(json.getString("created")) : -1L;
            DatabaseSnapshot snapshot = new DatabaseSnapshot();
            snapshot.setProviderSnapshotId(snapshotId);
            snapshot.setProviderRegionId(regionId);
            snapshot.setCurrentState(currentState);
            snapshot.setProviderDatabaseId(dbId);
            snapshot.setProviderOwnerId(this.getTenantId());
            snapshot.setSnapshotTimestamp(created);
            snapshot.setStorageInGigabytes(0);
            snapshot.setAdminUser(null);
            return snapshot;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private DatabaseProduct toProduct(@Nonnull ProviderContext ctx, @Nonnegative int size, @Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String id;
            String string = id = json.has("id") ? json.getString("id") : null;
            if (id == null) {
                return null;
            }
            String name = json.has("name") ? json.getString("name") : null;
            name = name == null ? id + " (" + size + " GB)" : name + " [" + size + " GB]";
            id = id + ":" + size;
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new InternalException("No region is associated with this request");
            }
            DatabaseProduct product = new DatabaseProduct(id, name);
            if (regionId.equals("LON")) {
                product.setCurrency("GBP");
            } else {
                product.setCurrency("USD");
            }
            product.setEngine(DatabaseEngine.MYSQL55);
            product.setHighAvailability(false);
            product.setProviderDataCenterId(regionId + "-1");
            product.setStandardHourlyRate(0.0f);
            product.setStandardIoRate(0.0f);
            product.setStandardStorageRate(0.0f);
            product.setStorageInGigabytes(size);
            return product;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String status;
            String dbId;
            String string = dbId = json.has("id") ? json.getString("id") : null;
            if (dbId == null) {
                return null;
            }
            DatabaseState currentState = DatabaseState.PENDING;
            String string2 = status = json.has("status") ? json.getString("status") : null;
            if (status != null) {
                if (status.equalsIgnoreCase("BUILD") || status.equalsIgnoreCase("building")) {
                    currentState = DatabaseState.PENDING;
                } else if (status.equalsIgnoreCase("AVAILABLE")) {
                    currentState = DatabaseState.AVAILABLE;
                } else if (status.equalsIgnoreCase("running")) {
                    currentState = DatabaseState.AVAILABLE;
                } else {
                    System.out.println("DEBUG OS DB STATE: " + status);
                }
            }
            return new ResourceStatus(dbId, (Object)currentState);
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }
}

