/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.ext.rackspace.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.TimeWindow;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.platform.ConfigurationParameter;
import org.dasein.cloud.platform.Database;
import org.dasein.cloud.platform.DatabaseConfiguration;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.platform.DatabaseProduct;
import org.dasein.cloud.platform.DatabaseSnapshot;
import org.dasein.cloud.platform.DatabaseState;
import org.dasein.cloud.platform.RelationalDatabaseSupport;
import org.dasein.cloud.util.APITrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RackspaceRDBMS
implements RelationalDatabaseSupport {
    private static final Logger logger = NovaOpenStack.getLogger(RackspaceRDBMS.class, "std");
    public static final String RESOURCE = "/instances";
    public static final String SERVICE = "rax:database";
    private NovaOpenStack provider;

    public RackspaceRDBMS(NovaOpenStack provider) {
        this.provider = provider;
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return this.provider.getAuthenticationContext().getTenantId();
    }

    public void addAccess(String providerDatabaseId, String sourceCidr) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Access management is not yet supported");
    }

    public void alterDatabase(String providerDatabaseId, boolean applyImmediately, String productSize, int storageInGigabytes, String configurationId, String newAdminUser, String newAdminPassword, int newPort, int snapshotRetentionInDays, TimeWindow preferredMaintenanceWindow, TimeWindow preferredBackupWindow) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not able to alter databases yet");
    }

    @Nonnull
    public String createFromScratch(@Nonnull String dataSourceName, @Nonnull DatabaseProduct product, @Nonnull String databaseVersion, @Nonnull String withAdminUser, @Nonnull String withAdminPassword, int hostPort) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.createFromScratch");
        try {
            int size;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            HashMap wrapper = new HashMap();
            HashMap<String, Object> json = new HashMap<String, Object>();
            NovaMethod method = new NovaMethod(this.provider);
            HashMap<String, String> database = new HashMap<String, String>();
            database.put("name", dataSourceName);
            ArrayList<HashMap<String, String>> dblist = new ArrayList<HashMap<String, String>>();
            dblist.add(database);
            json.put("databases", dblist);
            String[] parts = product.getProductSize().split(":");
            String id = parts[0];
            json.put("flavorRef", this.getFlavorRef(id));
            json.put("name", dataSourceName);
            if (withAdminUser != null && withAdminPassword != null) {
                ArrayList users = new ArrayList();
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("name", withAdminUser);
                entry.put("password", withAdminPassword);
                ArrayList dbaccess = new ArrayList();
                HashMap<String, String> oneDb = new HashMap<String, String>();
                oneDb.put("name", dataSourceName);
                dbaccess.add(oneDb);
                entry.put("databases", dbaccess);
                users.add(entry);
                json.put("users", users);
            }
            if ((size = product.getStorageInGigabytes()) < 1) {
                size = 5;
            }
            HashMap<String, String> volume = new HashMap<String, String>();
            volume.put("size", String.valueOf(size));
            json.put("volume", volume);
            if (hostPort != 3306) {
                json.put("port", hostPort > 0 ? hostPort : 3306);
            }
            wrapper.put("instance", json);
            JSONObject result = method.postString(SERVICE, RESOURCE, null, new JSONObject(wrapper), true);
            if (result != null && result.has("instance")) {
                try {
                    Database db = this.toDatabase(ctx, result.getJSONObject("instance"));
                    if (db != null) {
                        String string = db.getProviderDatabaseId();
                        return string;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("createFromScratch(): Unable to understand create response: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"createFromScratch(): No database was created by the create attempt, and no error was returned");
            throw new CloudException("No database was created");
        }
        finally {
            APITrace.end();
        }
    }

    public String createFromLatest(String dataSourceName, String providerDatabaseId, String productSize, String providerDataCenterId, int hostPort) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Rackspace does not support snapshots");
    }

    public String createFromSnapshot(String dataSourceName, String providerDatabaseId, String providerDbSnapshotId, String productSize, String providerDataCenterId, int hostPort) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Rackspace does not support snapshots");
    }

    public String createFromTimestamp(String dataSourceName, String providerDatabaseId, long beforeTimestamp, String productSize, String providerDataCenterId, int hostPort) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Rackspace does not support snapshots");
    }

    @Nullable
    public DatabaseConfiguration getConfiguration(@Nonnull String providerConfigurationId) throws CloudException, InternalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Database getDatabase(@Nonnull String providerDatabaseId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getDatabase");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getResource(SERVICE, RESOURCE, providerDatabaseId, false);
            if (ob == null) {
                Database database = null;
                return database;
            }
            if (ob.has("instance")) {
                Database database = this.toDatabase(ctx, ob.getJSONObject("instance"));
                return database;
            }
            Database database = null;
            return database;
        }
        finally {
            APITrace.end();
        }
    }

    public Iterable<DatabaseEngine> getDatabaseEngines() throws CloudException, InternalException {
        return Collections.singletonList(DatabaseEngine.MYSQL55);
    }

    @Nullable
    public String getDefaultVersion(@Nonnull DatabaseEngine forEngine) throws CloudException, InternalException {
        if (forEngine.isMySQL()) {
            return "5.5";
        }
        return null;
    }

    public Iterable<String> getSupportedVersions(DatabaseEngine forEngine) throws CloudException, InternalException {
        if (forEngine.isMySQL()) {
            return Collections.singletonList("5.5");
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DatabaseProduct getDatabaseProduct(@Nonnull String flavor) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getDatabaseProduct");
        try {
            NovaMethod method;
            JSONObject json;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            int idx = flavor.indexOf(":");
            int size = 5;
            if (idx > -1) {
                size = Integer.parseInt(flavor.substring(idx + 1));
                flavor = flavor.substring(0, idx);
            }
            if ((json = (method = new NovaMethod(this.provider)).getResource(SERVICE, "/flavors", flavor, false)) != null && json.has("flavor")) {
                try {
                    DatabaseProduct databaseProduct = this.toProduct(ctx, size, json.getJSONObject("flavor"));
                    return databaseProduct;
                }
                catch (JSONException e) {
                    logger.error((Object)("getDatabaseProduct(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for flavors in " + json.toString());
                }
            }
            DatabaseProduct databaseProduct = null;
            return databaseProduct;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<DatabaseProduct> getDatabaseProducts(DatabaseEngine forEngine) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getDatabaseProducts");
        try {
            if (DatabaseEngine.MYSQL55.equals((Object)forEngine)) {
                Logger std = NovaOpenStack.getLogger(RackspaceRDBMS.class, "std");
                if (std.isTraceEnabled()) {
                    std.trace((Object)("ENTER: " + RackspaceRDBMS.class.getName() + ".getDatabaseProducts()"));
                }
                try {
                    ProviderContext ctx = this.provider.getContext();
                    if (ctx == null) {
                        std.error((Object)"No context exists for this request");
                        throw new InternalException("No context exists for this request");
                    }
                    NovaMethod method = new NovaMethod(this.provider);
                    JSONObject json = method.getResource(SERVICE, "/flavors", null, false);
                    ArrayList<DatabaseProduct> products = new ArrayList<DatabaseProduct>();
                    if (json != null && json.has("flavors")) {
                        try {
                            JSONArray flavors = json.getJSONArray("flavors");
                            for (int i = 0; i < flavors.length(); ++i) {
                                JSONObject flavor = flavors.getJSONObject(i);
                                if (flavor == null) continue;
                                for (int size : new int[]{2, 5, 10, 20, 25, 30, 40, 50, 60, 70, 80, 90, 100, 150}) {
                                    DatabaseProduct product = this.toProduct(ctx, size, flavor);
                                    if (product == null) continue;
                                    products.add(product);
                                }
                            }
                        }
                        catch (JSONException e) {
                            std.error((Object)("getDatabaseProducts(): Unable to identify expected values in JSON: " + e.getMessage()));
                            e.printStackTrace();
                            throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for flavors in " + json.toString());
                        }
                    }
                    ArrayList<DatabaseProduct> arrayList = products;
                    return arrayList;
                }
                finally {
                    if (std.isTraceEnabled()) {
                        std.trace((Object)("exit - " + RackspaceRDBMS.class.getName() + ".getDatabaseProducts()"));
                    }
                }
            }
            List<DatabaseProduct> list = Collections.emptyList();
            return list;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String getFlavorRef(@Nonnull String productId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.getFlavorRef");
        try {
            NovaMethod method;
            JSONObject json;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            int idx = productId.indexOf(":");
            if (idx > -1) {
                productId = productId.substring(0, idx);
            }
            if ((json = (method = new NovaMethod(this.provider)).getResource(SERVICE, "/flavors", productId, false)) != null && json.has("flavor")) {
                try {
                    JSONArray links;
                    JSONObject flavor = json.getJSONObject("flavor");
                    if (flavor.has("links") && (links = flavor.getJSONArray("links")) != null) {
                        for (int i = 0; i < links.length(); ++i) {
                            String rel;
                            JSONObject link = links.getJSONObject(i);
                            if (!link.has("rel") || (rel = link.getString("rel")) == null || !rel.equalsIgnoreCase("self")) continue;
                            String string = link.getString("href");
                            return string;
                        }
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("getFlavorRef(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for flavors in " + json.toString());
                }
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    public String getProviderTermForDatabase(Locale locale) {
        return "database";
    }

    public String getProviderTermForSnapshot(Locale locale) {
        return "snapshot";
    }

    public DatabaseSnapshot getSnapshot(String providerDbSnapshotId) throws CloudException, InternalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.isSubscribed");
        try {
            boolean bl = this.provider.getAuthenticationContext().getServiceUrl(SERVICE) != null;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSupportsFirewallRules() {
        return false;
    }

    public boolean isSupportsHighAvailability() throws CloudException, InternalException {
        return false;
    }

    public boolean isSupportsLowAvailability() throws CloudException, InternalException {
        return true;
    }

    public boolean isSupportsMaintenanceWindows() {
        return false;
    }

    public boolean isSupportsSnapshots() {
        return false;
    }

    public Iterable<String> listAccess(String toProviderDatabaseId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public Iterable<DatabaseConfiguration> listConfigurations() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listDatabaseStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.listDatabaseStatus");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            ArrayList<ResourceStatus> databases = new ArrayList<ResourceStatus>();
            JSONObject json = method.getResource(SERVICE, RESOURCE, null, false);
            if (json != null && json.has("instances")) {
                try {
                    JSONArray list = json.getJSONArray("instances");
                    for (int i = 0; i < list.length(); ++i) {
                        ResourceStatus db = this.toStatus(list.getJSONObject(i));
                        if (db == null) continue;
                        databases.add(db);
                    }
                }
                catch (JSONException e) {
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for instances in " + json.toString());
                }
            }
            ArrayList<ResourceStatus> arrayList = databases;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Database> listDatabases() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.listDatabases");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            ArrayList<Database> databases = new ArrayList<Database>();
            JSONObject json = method.getResource(SERVICE, RESOURCE, null, false);
            if (json != null && json.has("instances")) {
                try {
                    JSONArray list = json.getJSONArray("instances");
                    for (int i = 0; i < list.length(); ++i) {
                        Database db = this.toDatabase(ctx, list.getJSONObject(i));
                        if (db == null) continue;
                        databases.add(db);
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("listDatabases(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for instances in " + json.toString());
                }
            }
            ArrayList<Database> arrayList = databases;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public Collection<ConfigurationParameter> listParameters(String forProviderConfigurationId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public Iterable<DatabaseSnapshot> listSnapshots(String forOptionalProviderDatabaseId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public void removeConfiguration(String providerConfigurationId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No configuration management yet exists");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabase(String providerDatabaseId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.removeDatabase");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            method.deleteResource(SERVICE, RESOURCE, providerDatabaseId, null);
            long timeout = System.currentTimeMillis() + 300000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    Database db = this.getDatabase(providerDatabaseId);
                    if (db == null || DatabaseState.DELETED.equals((Object)db.getCurrentState())) {
                        return;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (Throwable ignore) {}
            }
        }
        finally {
            APITrace.end();
        }
    }

    public void removeSnapshot(String providerSnapshotId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Rackspace does not support snapshots");
    }

    public void resetConfiguration(String providerConfigurationId, String ... parameters) throws CloudException, InternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(String providerDatabaseId, boolean blockUntilDone) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"RDBMS.restart");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            HashMap wrapper = new HashMap();
            wrapper.put("restart", new HashMap());
            method.postString(SERVICE, RESOURCE, "action", new JSONObject(wrapper), false);
        }
        finally {
            APITrace.end();
        }
    }

    public void revokeAccess(String providerDatabaseId, String sourceCide) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No access management yet exists");
    }

    public void updateConfiguration(String providerConfigurationId, ConfigurationParameter ... parameters) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No configuration management yet exists");
    }

    public DatabaseSnapshot snapshot(String providerDatabaseId, String name) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Rackspace does not support database snapshots");
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private Database toDatabase(@Nonnull ProviderContext ctx, @Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        String regionId = ctx.getRegionId();
        try {
            JSONObject v;
            JSONObject f;
            String status;
            String name;
            String dbId;
            String string = dbId = json.has("id") ? json.getString("id") : null;
            if (dbId == null) {
                return null;
            }
            String string2 = name = json.has("name") ? json.getString("name") : null;
            if (name == null) {
                name = "RDBMS MySQL #" + dbId;
            }
            DatabaseState currentState = DatabaseState.PENDING;
            String string3 = status = json.has("status") ? json.getString("status") : null;
            if (status != null) {
                if (status.equalsIgnoreCase("BUILD") || status.equalsIgnoreCase("building")) {
                    currentState = DatabaseState.PENDING;
                } else if (status.equalsIgnoreCase("ACTIVE") || status.equalsIgnoreCase("AVAILABLE")) {
                    currentState = DatabaseState.AVAILABLE;
                } else if (status.equalsIgnoreCase("RESIZE")) {
                    currentState = DatabaseState.MODIFYING;
                } else if (status.equalsIgnoreCase("SHUTDOWN")) {
                    currentState = DatabaseState.RESTARTING;
                } else if (status.equalsIgnoreCase("BLOCKED")) {
                    currentState = DatabaseState.PENDING;
                } else {
                    System.out.println("DEBUG OS Rackspace DB STATE: " + status);
                }
            }
            long created = json.has("created") ? this.provider.parseTimestamp(json.getString("created")) : -1L;
            String hostname = json.has("hostname") ? json.getString("hostname") : null;
            String flavor = null;
            if (json.has("flavor") && (f = json.getJSONObject("flavor")) != null && f.has("id")) {
                flavor = f.getString("id");
            }
            int size = 0;
            if (json.has("volume") && (v = json.getJSONObject("volume")) != null && v.has("size")) {
                size = v.getInt("size");
            }
            int port = json.has("port") ? json.getInt("port") : 3306;
            Database database = new Database();
            database.setAdminUser(null);
            database.setAllocatedStorageInGb(size);
            database.setCreationTimestamp(created);
            database.setCurrentState(currentState);
            database.setEngine(DatabaseEngine.MYSQL55);
            database.setHighAvailability(false);
            database.setHostName(hostname);
            database.setHostPort(port);
            database.setName(name);
            database.setProductSize(flavor + ":" + size);
            database.setProviderDatabaseId(dbId);
            database.setProviderDataCenterId(regionId + "-a");
            database.setProviderOwnerId(this.getTenantId());
            database.setProviderRegionId(regionId);
            return database;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private DatabaseProduct toProduct(@Nonnull ProviderContext ctx, @Nonnegative int size, @Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String id;
            String string = id = json.has("id") ? json.getString("id") : null;
            if (id == null) {
                return null;
            }
            String name = json.has("name") ? json.getString("name") : null;
            name = name == null ? id + " (" + size + " GB)" : name + " [" + size + " GB]";
            id = id + ":" + size;
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new InternalException("No region is associated with this request");
            }
            DatabaseProduct product = new DatabaseProduct(id, name);
            if (regionId.equals("LON")) {
                product.setCurrency("GBP");
            } else {
                product.setCurrency("USD");
            }
            product.setEngine(DatabaseEngine.MYSQL55);
            product.setHighAvailability(false);
            product.setProviderDataCenterId(regionId + "-1");
            product.setStandardHourlyRate(0.0f);
            product.setStandardIoRate(0.0f);
            product.setStandardStorageRate(0.0f);
            product.setStorageInGigabytes(size);
            return product;
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject json) throws CloudException, InternalException {
        if (json == null) {
            return null;
        }
        try {
            String status;
            String dbId;
            String string = dbId = json.has("id") ? json.getString("id") : null;
            if (dbId == null) {
                return null;
            }
            DatabaseState currentState = DatabaseState.PENDING;
            String string2 = status = json.has("status") ? json.getString("status") : null;
            if (status != null) {
                if (status.equalsIgnoreCase("BUILD") || status.equalsIgnoreCase("building")) {
                    currentState = DatabaseState.PENDING;
                } else if (status.equalsIgnoreCase("ACTIVE") || status.equalsIgnoreCase("AVAILABLE")) {
                    currentState = DatabaseState.AVAILABLE;
                } else if (status.equalsIgnoreCase("RESIZE")) {
                    currentState = DatabaseState.MODIFYING;
                } else if (status.equalsIgnoreCase("SHUTDOWN")) {
                    currentState = DatabaseState.RESTARTING;
                } else if (status.equalsIgnoreCase("BLOCKED")) {
                    currentState = DatabaseState.PENDING;
                } else {
                    System.out.println("DEBUG OS Rackspace DB STATE: " + status);
                }
            }
            return new ResourceStatus(dbId, (Object)currentState);
        }
        catch (JSONException e) {
            throw new CloudException((Throwable)e);
        }
    }
}

