/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.ext.rackspace.lb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LbPersistence;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerCapabilities;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RackspaceLBCapabilities
extends AbstractCapabilities<NovaOpenStack>
implements LoadBalancerCapabilities {
    public static final String RESOURCE = "/loadbalancers";
    public static final String SERVICE = "rax:load-balancer";
    private static transient Collection<LbAlgorithm> supportedAlgorithms;

    public RackspaceLBCapabilities(@Nonnull NovaOpenStack provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    public LoadBalancerAddressType getAddressType() throws CloudException, InternalException {
        return LoadBalancerAddressType.IP;
    }

    public int getMaxPublicPorts() throws CloudException, InternalException {
        return 1;
    }

    @Nonnull
    public String getProviderTermForLoadBalancer(@Nonnull Locale locale) {
        return "load balancer";
    }

    public boolean healthCheckRequiresLoadBalancer() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Requirement identifyEndpointsOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyListenersOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public boolean isAddressAssignedByProvider() throws CloudException, InternalException {
        return true;
    }

    public boolean isDataCenterLimited() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<LbAlgorithm> listSupportedAlgorithms() throws CloudException, InternalException {
        if (supportedAlgorithms == null) {
            ArrayList<LbAlgorithm> algorithms = new ArrayList<LbAlgorithm>();
            algorithms.add(LbAlgorithm.ROUND_ROBIN);
            algorithms.add(LbAlgorithm.LEAST_CONN);
            supportedAlgorithms = Collections.unmodifiableList(algorithms);
        }
        return supportedAlgorithms;
    }

    @Nonnull
    public Iterable<LbEndpointType> listSupportedEndpointTypes() throws CloudException, InternalException {
        ArrayList<LbEndpointType> types = new ArrayList<LbEndpointType>();
        types.add(LbEndpointType.IP);
        types.add(LbEndpointType.VM);
        return types;
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    @Nonnull
    public Iterable<LbPersistence> listSupportedPersistenceOptions() throws CloudException, InternalException {
        return Collections.singletonList(LbPersistence.NONE);
    }

    @Nonnull
    public Iterable<LbProtocol> listSupportedProtocols() throws CloudException, InternalException {
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"lbProtocols", LbProtocol.class, (CacheLevel)CacheLevel.REGION_ACCOUNT);
        Iterable protocols = cache.get(this.getContext());
        if (protocols != null) {
            return protocols;
        }
        NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
        JSONObject ob = method.getResource(SERVICE, RESOURCE, "protocols", false);
        if (ob == null || !ob.has("protocols") || ob.isNull("protocols")) {
            return Collections.singletonList(LbProtocol.RAW_TCP);
        }
        ArrayList<LbProtocol> list = new ArrayList<LbProtocol>();
        list.add(LbProtocol.RAW_TCP);
        try {
            JSONArray matches = ob.getJSONArray("protocols");
            for (int i = 0; i < matches.length(); ++i) {
                String name;
                JSONObject p = matches.getJSONObject(i);
                String string = name = p.has("name") && !p.isNull("name") ? p.getString("name") : null;
                if (name == null) continue;
                if (name.equalsIgnoreCase("http")) {
                    list.add(LbProtocol.HTTP);
                    continue;
                }
                if (!name.equalsIgnoreCase("https")) continue;
                list.add(LbProtocol.HTTPS);
            }
        }
        catch (JSONException e) {
            throw new CloudException("Unable to parse protocols from Rackspace: " + e.getMessage());
        }
        cache.put(this.getContext(), list);
        return list;
    }

    public boolean supportsAddingEndpoints() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsMonitoring() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsMultipleTrafficTypes() throws CloudException, InternalException {
        return false;
    }
}

