/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.identity;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.identity.SSHKeypair;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.identity.ShellKeySupport;
import org.dasein.cloud.openstack.nova.os.NovaException;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.util.APITrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NovaKeypair
implements ShellKeySupport {
    private static final Logger logger = NovaOpenStack.getLogger(NovaKeypair.class, "std");
    private NovaOpenStack provider;

    NovaKeypair(@Nonnull NovaOpenStack cloud) {
        this.provider = cloud;
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return this.provider.getAuthenticationContext().getTenantId();
    }

    @Nonnull
    public SSHKeypair createKeypair(@Nonnull String name) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Keypair.createKeypair");
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            logger.error((Object)"No context exists for this request");
            throw new InternalException("No context exists for this request");
        }
        HashMap wrapper = new HashMap();
        HashMap<String, String> json = new HashMap<String, String>();
        NovaMethod method = new NovaMethod(this.provider);
        json.put("name", name);
        wrapper.put("keypair", json);
        JSONObject result = method.postServers("/os-keypairs", null, new JSONObject(wrapper), false);
        if (result != null && result.has("keypair")) {
            try {
                JSONObject ob = result.getJSONObject("keypair");
                SSHKeypair kp = this.toKeypair(ctx, ob);
                if (kp == null) {
                    throw new CloudException("No matching keypair was generated from " + ob.toString());
                }
                SSHKeypair sSHKeypair = kp;
                return sSHKeypair;
            }
            catch (JSONException e) {
                logger.error((Object)("createKeypair(): Unable to understand create response: " + e.getMessage()));
                if (logger.isTraceEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        logger.error((Object)"createKeypair(): No keypair was created by the create attempt, and no error was returned");
        throw new CloudException("No keypair was created");
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKeypair(@Nonnull String keypairId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Keypair.deleteKeypair");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            long timeout = System.currentTimeMillis() + 3600000L;
            while (true) {
                try {
                    method.deleteServers("/os-keypairs", keypairId);
                    return;
                }
                catch (NovaException e) {
                    if (e.getHttpCode() != 409) {
                        throw e;
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < timeout) continue;
                    APITrace.end();
                }
                break;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getFingerprint(@Nonnull String keypairId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Keypair.getFingerprint");
        try {
            SSHKeypair kp = this.getKeypair(keypairId);
            String string = kp == null ? null : kp.getFingerprint();
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    public Requirement getKeyImportSupport() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nullable
    public SSHKeypair getKeypair(@Nonnull String keypairId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Keypair.getKeypair");
        try {
            JSONArray list;
            block11: {
                ProviderContext ctx = this.provider.getContext();
                if (ctx == null) {
                    logger.error((Object)"No context exists for this request");
                    throw new InternalException("No context exists for this request");
                }
                NovaMethod method = new NovaMethod(this.provider);
                JSONObject ob = method.getServers("/os-keypairs", null, false);
                try {
                    if (ob == null || !ob.has("keypairs")) break block11;
                    list = ob.getJSONArray("keypairs");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject json = list.getJSONObject(i);
                        try {
                            JSONObject kp;
                            SSHKeypair k;
                            if (!json.has("keypair") || (k = this.toKeypair(ctx, kp = json.getJSONObject("keypair"))) == null || !keypairId.equals(k.getProviderKeypairId())) continue;
                            SSHKeypair sSHKeypair = k;
                            return sSHKeypair;
                        }
                        catch (JSONException e) {
                            logger.error((Object)("Invalid JSON from cloud: " + e.getMessage()));
                            throw new CloudException("Invalid JSON from cloud: " + e.getMessage());
                        }
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("list(): Unable to identify expected values in JSON: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for keypair in " + ob.toString());
                }
            }
            list = null;
            return list;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForKeypair(@Nonnull Locale locale) {
        return "keypair";
    }

    @Nonnull
    public SSHKeypair importKeypair(@Nonnull String name, @Nonnull String publicKey) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Keypair.importKeypair");
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            logger.error((Object)"No context exists for this request");
            throw new InternalException("No context exists for this request");
        }
        HashMap wrapper = new HashMap();
        HashMap<String, String> json = new HashMap<String, String>();
        NovaMethod method = new NovaMethod(this.provider);
        json.put("name", name);
        json.put("public_key", publicKey);
        wrapper.put("keypair", json);
        JSONObject result = method.postServers("/os-keypairs", null, new JSONObject(wrapper), false);
        if (result != null && result.has("keypair")) {
            try {
                JSONObject ob = result.getJSONObject("keypair");
                SSHKeypair kp = this.toKeypair(ctx, ob);
                if (kp == null) {
                    throw new CloudException("No matching keypair was generated from " + ob.toString());
                }
                SSHKeypair sSHKeypair = kp;
                return sSHKeypair;
            }
            catch (JSONException e) {
                logger.error((Object)("importKeypair(): Unable to understand create response: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        logger.error((Object)"importKeypair(): No keypair was created by the create attempt, and no error was returned");
        throw new CloudException("No keypair was created");
        finally {
            APITrace.end();
        }
    }

    private boolean verifySupport() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Keypair.verifySupport");
        try {
            NovaMethod method = new NovaMethod(this.provider);
            try {
                method.getServers("/os-keypairs", null, false);
                boolean bl = true;
                return bl;
            }
            catch (CloudException e) {
                block7: {
                    if (e.getHttpCode() != 404) break block7;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Keypair.isSubscribed");
        try {
            boolean bl = this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed() && this.verifySupport();
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<SSHKeypair> list() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Keypair.list");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                logger.error((Object)"No context exists for this request");
                throw new InternalException("No context exists for this request");
            }
            NovaMethod method = new NovaMethod(this.provider);
            JSONObject ob = method.getServers("/os-keypairs", null, false);
            ArrayList<SSHKeypair> keypairs = new ArrayList<SSHKeypair>();
            try {
                if (ob != null && ob.has("keypairs")) {
                    JSONArray list = ob.getJSONArray("keypairs");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject json = list.getJSONObject(i);
                        try {
                            if (!json.has("keypair")) continue;
                            JSONObject kp = json.getJSONObject("keypair");
                            keypairs.add(this.toKeypair(ctx, kp));
                            continue;
                        }
                        catch (JSONException e) {
                            logger.error((Object)("Invalid JSON from cloud: " + e.getMessage()));
                            throw new CloudException("Invalid JSON from cloud: " + e.getMessage());
                        }
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("list(): Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for keypair in " + ob.toString());
            }
            ArrayList<SSHKeypair> arrayList = keypairs;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private SSHKeypair toKeypair(@Nonnull ProviderContext ctx, @Nullable JSONObject json) throws InternalException, CloudException {
        if (json == null) {
            return null;
        }
        try {
            SSHKeypair kp = new SSHKeypair();
            String name = null;
            if (json.has("private_key")) {
                kp.setPrivateKey(json.getString("private_key").getBytes("utf-8"));
            }
            if (json.has("public_key")) {
                kp.setPublicKey(json.getString("public_key"));
            }
            if (json.has("fingerprint")) {
                kp.setFingerprint(json.getString("fingerprint"));
            }
            if (json.has("name")) {
                name = json.getString("name");
            }
            if (name == null) {
                return null;
            }
            kp.setName(name);
            kp.setProviderKeypairId(name);
            kp.setProviderOwnerId(this.getTenantId());
            String regionId = ctx.getRegionId();
            kp.setProviderRegionId(regionId == null ? "" : regionId);
            return kp;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
    }
}

