/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.network.IPAddressCapabilities;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;

public class FloatingIPCapabilities
extends AbstractCapabilities<NovaOpenStack>
implements IPAddressCapabilities {
    private static volatile List<IPVersion> versions;

    public FloatingIPCapabilities(@Nonnull NovaOpenStack provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    public String getProviderTermForIpAddress(@Nonnull Locale locale) {
        return "floating IP";
    }

    @Nonnull
    public Requirement identifyVlanForVlanIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isAssigned(@Nonnull IPVersion version) throws CloudException, InternalException {
        return this.getVersions().contains(version);
    }

    public boolean canBeAssigned(@Nonnull VmState vmState) throws CloudException, InternalException {
        return true;
    }

    public boolean isAssignablePostLaunch(@Nonnull IPVersion version) throws CloudException, InternalException {
        return this.getVersions().contains(version);
    }

    public boolean isForwarding(IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isRequestable(@Nonnull IPVersion version) throws CloudException, InternalException {
        return this.getVersions().contains(version);
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return this.getVersions();
    }

    public boolean supportsVLANAddresses(@Nonnull IPVersion ofVersion) throws InternalException, CloudException {
        return false;
    }

    private Collection<IPVersion> getVersions() {
        if (versions == null) {
            ArrayList<IPVersion> tmp = new ArrayList<IPVersion>();
            tmp.add(IPVersion.IPV4);
            versions = Collections.unmodifiableList(tmp);
        }
        return versions;
    }
}

