/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.network;

import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.VLANCapabilities;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.network.Quantum;

public class NetworkCapabilities
extends AbstractCapabilities<NovaOpenStack>
implements VLANCapabilities {
    public NetworkCapabilities(@Nonnull NovaOpenStack cloud) {
        super((CloudProvider)cloud);
    }

    public boolean allowsNewNetworkInterfaceCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsNewVlanCreation() throws CloudException, InternalException {
        return true;
    }

    public boolean allowsNewRoutingTableCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsNewSubnetCreation() throws CloudException, InternalException {
        Quantum q = new Quantum((NovaOpenStack)this.getProvider());
        return q.getNetworkType().equals((Object)Quantum.QuantumType.QUANTUM);
    }

    public boolean allowsMultipleTrafficTypesOverSubnet() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsMultipleTrafficTypesOverVlan() throws CloudException, InternalException {
        return true;
    }

    public int getMaxNetworkInterfaceCount() throws CloudException, InternalException {
        return -2;
    }

    public int getMaxVlanCount() throws CloudException, InternalException {
        return -2;
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "network interface";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "subnet";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "network";
    }

    @Nonnull
    public Requirement getRoutingTableSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement getSubnetSupport() throws CloudException, InternalException {
        Quantum q = new Quantum((NovaOpenStack)this.getProvider());
        return q.getNetworkType().equals((Object)Quantum.QuantumType.QUANTUM) ? Requirement.REQUIRED : Requirement.NONE;
    }

    @Nonnull
    public Requirement identifySubnetDCRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isNetworkInterfaceSupportEnabled() throws CloudException, InternalException {
        return false;
    }

    public boolean isSubnetDataCenterConstrained() throws CloudException, InternalException {
        return false;
    }

    public boolean isVlanDataCenterConstrained() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    public boolean supportsInternetGatewayCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsRawAddressRouting() throws CloudException, InternalException {
        return false;
    }
}

