/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.network;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.network.AbstractNetworkServices;
import org.dasein.cloud.network.DNSSupport;
import org.dasein.cloud.network.LoadBalancerSupport;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.OpenStackProvider;
import org.dasein.cloud.openstack.nova.os.ext.rackspace.dns.RackspaceCloudDNS;
import org.dasein.cloud.openstack.nova.os.ext.rackspace.lb.RackspaceLoadBalancers;
import org.dasein.cloud.openstack.nova.os.network.NovaFloatingIP;
import org.dasein.cloud.openstack.nova.os.network.NovaSecurityGroup;
import org.dasein.cloud.openstack.nova.os.network.Quantum;

public class NovaNetworkServices
extends AbstractNetworkServices {
    private NovaOpenStack provider;

    public NovaNetworkServices(@Nonnull NovaOpenStack cloud) {
        this.provider = cloud;
    }

    @Nullable
    public DNSSupport getDnsSupport() {
        if (this.provider.getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
            return new RackspaceCloudDNS(this.provider);
        }
        return null;
    }

    @Nullable
    public NovaSecurityGroup getFirewallSupport() {
        if (this.provider.getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
            return null;
        }
        return new NovaSecurityGroup(this.provider);
    }

    @Nullable
    public NovaFloatingIP getIpAddressSupport() {
        if (this.provider.getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
            return null;
        }
        return new NovaFloatingIP(this.provider);
    }

    @Nullable
    public LoadBalancerSupport getLoadBalancerSupport() {
        if (this.provider.getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
            return new RackspaceLoadBalancers(this.provider);
        }
        return null;
    }

    @Nullable
    public Quantum getVlanSupport() {
        return new Quantum(this.provider);
    }
}

