/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.network.AbstractFirewallSupport;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallCapabilities;
import org.dasein.cloud.network.FirewallCreateOptions;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTarget;
import org.dasein.cloud.network.RuleTargetType;
import org.dasein.cloud.openstack.nova.os.NovaException;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.network.SecurityGroupCapabilities;
import org.dasein.cloud.util.APITrace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NovaSecurityGroup
extends AbstractFirewallSupport {
    private static final Logger logger = NovaOpenStack.getLogger(NovaSecurityGroup.class, "std");
    private volatile transient SecurityGroupCapabilities capabilities;

    NovaSecurityGroup(NovaOpenStack cloud) {
        super((CloudProvider)cloud);
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return ((NovaOpenStack)this.getProvider()).getAuthenticationContext().getTenantId();
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull RuleTarget sourceEndpoint, @Nonnull Protocol protocol, @Nonnull RuleTarget destinationEndpoint, int beginPort, int endPort, @Nonnegative int precedence) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.authorize");
        if (direction.equals((Object)Direction.EGRESS)) {
            throw new OperationNotSupportedException(this.getProvider().getCloudName() + " does not support egress rules.");
        }
        HashMap wrapper = new HashMap();
        HashMap<String, Object> json = new HashMap<String, Object>();
        NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
        json.put("ip_protocol", protocol.name().toLowerCase());
        json.put("from_port", beginPort);
        json.put("to_port", endPort);
        json.put("parent_group_id", firewallId);
        switch (sourceEndpoint.getRuleTargetType()) {
            case CIDR: {
                if (sourceEndpoint.getCidr().indexOf("/") == -1) {
                    json.put("cidr", sourceEndpoint.getCidr() + "/32");
                    break;
                }
                json.put("cidr", sourceEndpoint.getCidr());
                break;
            }
            case VLAN: {
                throw new OperationNotSupportedException("Cannot target VLANs with firewall rules");
            }
            case VM: {
                throw new OperationNotSupportedException("Cannot target virtual machines with firewall rules");
            }
            case GLOBAL: {
                Firewall targetGroup = this.getFirewall(sourceEndpoint.getProviderFirewallId());
                if (targetGroup == null) {
                    throw new CloudException("No such source endpoint firewall: " + sourceEndpoint.getProviderFirewallId());
                }
                json.put("group_id", targetGroup.getProviderFirewallId());
            }
        }
        wrapper.put("security_group_rule", json);
        JSONObject result = method.postServers("/os-security-group-rules", null, new JSONObject(wrapper), false);
        if (result != null && result.has("security_group_rule")) {
            try {
                JSONObject rule = result.getJSONObject("security_group_rule");
                String string = rule.getString("id");
                return string;
            }
            catch (JSONException e) {
                logger.error((Object)("Invalid JSON returned from rule creation: " + e.getMessage()));
                throw new CloudException((Throwable)e);
            }
        }
        logger.error((Object)"authorize(): No firewall rule was created by the create attempt, and no error was returned");
        throw new CloudException("No firewall rule was created");
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String create(@Nonnull FirewallCreateOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.create");
        try {
            if (options.getProviderVlanId() != null) {
                throw new OperationNotSupportedException("Creating IP addresses in VLANs is not supported");
            }
            HashMap wrapper = new HashMap();
            HashMap<String, String> json = new HashMap<String, String>();
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            json.put("name", options.getName());
            json.put("description", options.getDescription());
            wrapper.put("security_group", json);
            JSONObject result = method.postServers("/os-security-groups", null, new JSONObject(wrapper), false);
            if (result != null && result.has("security_group")) {
                try {
                    String id;
                    JSONObject ob = result.getJSONObject("security_group");
                    Firewall fw = this.toFirewall(ob);
                    if (fw != null && (id = fw.getProviderFirewallId()) != null) {
                        String string = id;
                        return string;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("create(): Unable to understand create response: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"create(): No firewall was created by the create attempt, and no error was returned");
            throw new CloudException("No firewall was created");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@Nonnull String firewallId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.delete");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            long timeout = System.currentTimeMillis() + 3600000L;
            while (true) {
                try {
                    method.deleteServers("/os-security-groups", firewallId);
                    return;
                }
                catch (NovaException e) {
                    if (e.getHttpCode() != 409) {
                        throw e;
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < timeout) continue;
                    APITrace.end();
                }
                break;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public FirewallCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new SecurityGroupCapabilities((NovaOpenStack)this.getProvider());
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Firewall getFirewall(@Nonnull String firewallId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.getFirewall");
        try {
            JSONObject json;
            Firewall fw;
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/os-security-groups", firewallId, false);
            if (ob == null) {
                Firewall firewall = null;
                return firewall;
            }
            if (ob.has("security_group") && (fw = this.toFirewall(json = ob.getJSONObject("security_group"))) != null) {
                Firewall firewall = fw;
                return firewall;
            }
            Firewall firewall = null;
            return firewall;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "security group";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<FirewallRule> getRules(@Nonnull String firewallId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.getRules");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/os-security-groups", firewallId, false);
            if (ob == null) {
                Collection<FirewallRule> collection = null;
                return collection;
            }
            if (ob.has("security_group")) {
                JSONObject json = ob.getJSONObject("security_group");
                if (!json.has("rules")) {
                    List<FirewallRule> list = Collections.emptyList();
                    return list;
                }
                ArrayList<FirewallRule> rules = new ArrayList<FirewallRule>();
                JSONArray arr = json.getJSONArray("rules");
                Collection<Firewall> myFirewalls = null;
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject range;
                    JSONObject rule = arr.getJSONObject(i);
                    int startPort = -1;
                    int endPort = -1;
                    Protocol protocol = null;
                    String ruleId = null;
                    if (rule.has("id") && !rule.isNull("id")) {
                        ruleId = rule.getString("id");
                    }
                    if (ruleId == null) continue;
                    RuleTarget sourceEndpoint = null;
                    if (rule.has("ip_range") && !rule.isNull("ip_range") && (range = rule.getJSONObject("ip_range")).has("cidr") && !range.isNull("cidr")) {
                        sourceEndpoint = RuleTarget.getCIDR((String)range.getString("cidr"));
                    }
                    if (rule.has("group") && !rule.isNull("group")) {
                        String id;
                        JSONObject g = rule.getJSONObject("group");
                        String string = id = g.has("id") && !g.isNull("id") ? g.getString("id") : null;
                        if (id != null) {
                            sourceEndpoint = RuleTarget.getGlobal(id);
                        } else {
                            String o;
                            String string2 = o = g.has("tenant_id") && !g.isNull("tenant_id") ? g.getString("tenant_id") : null;
                            if (this.getTenantId().equals(o)) {
                                String n;
                                String string3 = n = g.has("name") && !g.isNull("name") ? g.getString("name") : null;
                                if (n != null) {
                                    if (myFirewalls == null) {
                                        myFirewalls = this.list();
                                    }
                                    for (Firewall fw : myFirewalls) {
                                        if (!fw.getName().equals(n)) continue;
                                        sourceEndpoint = RuleTarget.getGlobal((String)fw.getProviderFirewallId());
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (sourceEndpoint == null) continue;
                    if (rule.has("from_port") && !rule.isNull("from_port")) {
                        startPort = rule.getInt("from_port");
                    }
                    if (rule.has("to_port") && !rule.isNull("to_port")) {
                        endPort = rule.getInt("to_port");
                    }
                    if (startPort == -1 && endPort != -1) {
                        startPort = endPort;
                    } else if (endPort == -1 && startPort != -1) {
                        endPort = startPort;
                    }
                    if (startPort > endPort) {
                        int s = startPort;
                        startPort = endPort;
                        endPort = s;
                    }
                    if (rule.has("ip_protocol")) {
                        String p = null;
                        if (!rule.isNull("ip_protocol")) {
                            p = rule.getString("ip_protocol");
                        }
                        protocol = p == null || p.equalsIgnoreCase("null") ? Protocol.ANY : Protocol.valueOf((String)p.toUpperCase());
                    }
                    if (protocol == null) {
                        protocol = Protocol.TCP;
                    }
                    rules.add(FirewallRule.getInstance((String)ruleId, (String)firewallId, (RuleTarget)sourceEndpoint, (Direction)Direction.INGRESS, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)RuleTarget.getGlobal((String)firewallId), (int)startPort, (int)endPort));
                }
                ArrayList<FirewallRule> arrayList = rules;
                return arrayList;
            }
            Collection<FirewallRule> collection = null;
            return collection;
        }
        finally {
            APITrace.end();
        }
    }

    private boolean verifySupport() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.verifySupport");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            try {
                method.getServers("/os-security-groups", null, false);
                boolean bl = true;
                return bl;
            }
            catch (CloudException e) {
                block7: {
                    if (e.getHttpCode() != 404) break block7;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.isSubscribed");
        try {
            if (((NovaOpenStack)this.getProvider()).getMajorVersion() > 1 && ((NovaOpenStack)this.getProvider()).getComputeServices().getVirtualMachineSupport().isSubscribed()) {
                boolean bl = this.verifySupport();
                return bl;
            }
            if (((NovaOpenStack)this.getProvider()).getMajorVersion() == 1 && ((NovaOpenStack)this.getProvider()).getMinorVersion() >= 1 && ((NovaOpenStack)this.getProvider()).getComputeServices().getVirtualMachineSupport().isSubscribed()) {
                boolean bl = this.verifySupport();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Firewall> list() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.list");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/os-security-groups", null, false);
            ArrayList<Firewall> firewalls = new ArrayList<Firewall>();
            try {
                if (ob != null && ob.has("security_groups")) {
                    JSONArray list = ob.getJSONArray("security_groups");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject json = list.getJSONObject(i);
                        Firewall fw = this.toFirewall(json);
                        if (fw == null) continue;
                        firewalls.add(fw);
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("list(): Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for security groups in " + ob.toString());
            }
            ArrayList<Firewall> arrayList = firewalls;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listFirewallStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.listFirewallStatus");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = method.getServers("/os-security-groups", null, false);
            ArrayList<ResourceStatus> firewalls = new ArrayList<ResourceStatus>();
            try {
                if (ob != null && ob.has("security_groups")) {
                    JSONArray list = ob.getJSONArray("security_groups");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject json = list.getJSONObject(i);
                        try {
                            ResourceStatus fw = this.toStatus(json);
                            if (fw == null) continue;
                            firewalls.add(fw);
                            continue;
                        }
                        catch (JSONException e) {
                            throw new CloudException("Invalid JSON from cloud: " + e.getMessage());
                        }
                    }
                }
            }
            catch (JSONException e) {
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for security groups in " + ob.toString());
            }
            ArrayList<ResourceStatus> arrayList = firewalls;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(RuleTargetType.GLOBAL);
    }

    @Nonnull
    public Iterable<Direction> listSupportedDirections(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Direction.INGRESS);
    }

    @Nonnull
    public Iterable<Permission> listSupportedPermissions(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Permission.ALLOW);
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        ArrayList<RuleTargetType> list = new ArrayList<RuleTargetType>();
        list.add(RuleTargetType.CIDR);
        list.add(RuleTargetType.GLOBAL);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revoke(@Nonnull String providerFirewallRuleId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.revoke");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            long timeout = System.currentTimeMillis() + 3600000L;
            while (true) {
                try {
                    method.deleteServers("/os-security-group-rules", providerFirewallRuleId);
                    return;
                }
                catch (NovaException e) {
                    if (e.getHttpCode() != 409) {
                        throw e;
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < timeout) continue;
                    APITrace.end();
                }
                break;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Deprecated
    public void revoke(@Nonnull String firewallId, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, Direction.INGRESS, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    @Deprecated
    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    @Deprecated
    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String source, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, permission, source, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String source, @Nonnull Protocol protocol, @Nonnull RuleTarget target, int beginPort, int endPort) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.revoke");
        try {
            if (direction.equals((Object)Direction.EGRESS)) {
                throw new OperationNotSupportedException(this.getProvider().getCloudName() + " does not support egress rules.");
            }
            FirewallRule targetRule = null;
            for (FirewallRule rule : this.getRules(firewallId)) {
                boolean matches;
                RuleTarget rt;
                RuleTarget t = rule.getSourceEndpoint();
                if (t.getRuleTargetType().equals((Object)RuleTargetType.CIDR) && source.equals(t.getCidr())) {
                    rt = rule.getDestinationEndpoint();
                    if (!target.getRuleTargetType().equals((Object)rt.getRuleTargetType())) continue;
                    matches = false;
                    switch (rt.getRuleTargetType()) {
                        case CIDR: {
                            matches = target.getCidr().equals(rt.getCidr());
                            break;
                        }
                        case GLOBAL: {
                            matches = target.getProviderFirewallId().equals(rt.getProviderFirewallId());
                            break;
                        }
                        case VLAN: {
                            matches = target.getProviderVlanId().equals(rt.getProviderVlanId());
                            break;
                        }
                        case VM: {
                            matches = target.getProviderVirtualMachineId().equals(rt.getProviderVirtualMachineId());
                        }
                    }
                    if (!matches || !rule.getProtocol().equals((Object)protocol) || !rule.getPermission().equals((Object)permission) || !rule.getDirection().equals((Object)direction) || rule.getStartPort() != beginPort || rule.getEndPort() != endPort) continue;
                    targetRule = rule;
                    break;
                }
                if (!t.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL) || !source.equals(t.getProviderFirewallId())) continue;
                rt = rule.getDestinationEndpoint();
                if (!target.getRuleTargetType().equals((Object)rt.getRuleTargetType())) continue;
                matches = false;
                switch (rt.getRuleTargetType()) {
                    case CIDR: {
                        matches = target.getCidr().equals(rt.getCidr());
                        break;
                    }
                    case GLOBAL: {
                        matches = target.getProviderFirewallId().equals(rt.getProviderFirewallId());
                        break;
                    }
                    case VLAN: {
                        matches = target.getProviderVlanId().equals(rt.getProviderVlanId());
                        break;
                    }
                    case VM: {
                        matches = target.getProviderVirtualMachineId().equals(rt.getProviderVirtualMachineId());
                    }
                }
                if (!matches || !rule.getProtocol().equals((Object)protocol) || !rule.getPermission().equals((Object)permission) || !rule.getDirection().equals((Object)direction) || rule.getStartPort() != beginPort || rule.getEndPort() != endPort) continue;
                targetRule = rule;
                break;
            }
            if (targetRule == null) {
                throw new CloudException("No such firewall rule");
            }
            this.revoke(targetRule.getProviderRuleId());
        }
        finally {
            APITrace.end();
        }
    }

    public boolean supportsFirewallSources() throws CloudException, InternalException {
        return true;
    }

    @Nullable
    private Firewall toFirewall(@Nonnull JSONObject json) throws CloudException, InternalException {
        try {
            Firewall fw = new Firewall();
            String id = null;
            String name = null;
            fw.setActive(true);
            fw.setAvailable(true);
            fw.setProviderVlanId(null);
            String regionId = this.getContext().getRegionId();
            fw.setRegionId(regionId == null ? "" : regionId);
            if (json.has("id")) {
                id = json.getString("id");
            }
            if (json.has("name")) {
                name = json.getString("name");
            }
            if (json.has("description")) {
                fw.setDescription(json.getString("description"));
            }
            if (id == null) {
                return null;
            }
            fw.setProviderFirewallId(id);
            if (name == null) {
                name = id;
            }
            fw.setName(name);
            if (fw.getDescription() == null) {
                fw.setDescription(name);
            }
            return fw;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nonnull JSONObject json) throws JSONException {
        String id = null;
        if (json.has("id")) {
            id = json.getString("id");
        }
        if (id == null) {
            return null;
        }
        return new ResourceStatus(id, (Object)true);
    }
}

