/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.network.AbstractVLANSupport;
import org.dasein.cloud.network.AllocationPool;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.Networkable;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.SubnetCreateOptions;
import org.dasein.cloud.network.SubnetState;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANCapabilities;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.openstack.nova.os.NovaMethod;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;
import org.dasein.cloud.openstack.nova.os.OpenStackProvider;
import org.dasein.cloud.openstack.nova.os.network.NetworkCapabilities;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Quantum
extends AbstractVLANSupport {
    private static final Logger logger = NovaOpenStack.getLogger(Quantum.class, "std");
    private String networkVersionId = null;
    private volatile transient NetworkCapabilities capabilities;

    public Quantum(@Nonnull NovaOpenStack provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    public VLANCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new NetworkCapabilities((NovaOpenStack)this.getProvider());
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuantumType getNetworkType() throws CloudException, InternalException {
        Object b;
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"quantumness", QuantumType.class, (CacheLevel)CacheLevel.CLOUD);
        Iterable it = cache.get(this.getContext());
        if (it != null && (b = it.iterator()).hasNext()) {
            return (QuantumType)((Object)b.next());
        }
        try {
            JSONObject ob;
            if (((NovaOpenStack)this.getProvider()).getCloudProvider().equals((Object)OpenStackProvider.RACKSPACE)) {
                cache.put(this.getContext(), Collections.singletonList(QuantumType.RACKSPACE));
                b = QuantumType.RACKSPACE;
                return b;
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            try {
                ob = method.getNetworks(this.getNetworkResourceVersion() + QuantumType.QUANTUM.getNetworkResource(), null, false);
                if (ob != null && ob.has("networks")) {
                    cache.put(this.getContext(), Collections.singletonList(QuantumType.QUANTUM));
                    QuantumType quantumType = QuantumType.QUANTUM;
                    return quantumType;
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                ob = method.getServers("QuantumType.NOVA.getNetworkResource()", null, false);
                if (ob != null && ob.has("networks")) {
                    cache.put(this.getContext(), Collections.singletonList(QuantumType.NOVA));
                    QuantumType quantumType = QuantumType.NOVA;
                    return quantumType;
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            QuantumType quantumType = QuantumType.NONE;
            return quantumType;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private String getTenantId() throws CloudException, InternalException {
        return ((NovaOpenStack)this.getProvider()).getAuthenticationContext().getTenantId();
    }

    @Nonnull
    public String createPort(@Nonnull String subnetId, @Nonnull String vmName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.createPort");
        try {
            Subnet subnet = this.getSubnet(subnetId);
            if (subnet == null) {
                VLAN vlan = this.getVlan(subnetId);
                if (vlan != null) {
                    throw new CloudException("Cannot launch into the network without a subnet");
                }
                throw new CloudException("Invalid id no network or subnet found for " + subnetId);
            }
            HashMap wrapper = new HashMap();
            HashMap<String, Object> json = new HashMap<String, Object>();
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            json.put("name", "Port for " + vmName);
            json.put("network_id", subnet.getProviderVlanId());
            ArrayList ips = new ArrayList();
            HashMap<String, String> ip = new HashMap<String, String>();
            ip.put("subnet_id", subnetId);
            ips.add(ip);
            json.put("fixed_ips", ips);
            wrapper.put("port", json);
            JSONObject result = null;
            result = this.getNetworkType().equals((Object)QuantumType.QUANTUM) ? method.postNetworks(this.getPortResource(), null, new JSONObject(wrapper), false) : method.postServers(this.getNetworkResource() + "/" + subnet.getProviderVlanId() + "/ports", null, new JSONObject(wrapper), false);
            if (result != null && result.has("port")) {
                try {
                    JSONObject ob = result.getJSONObject("port");
                    if (ob.has("id")) {
                        String string = ob.getString("id");
                        return string;
                    }
                }
                catch (JSONException e) {
                    logger.error((Object)("Unable to understand create response: " + e.getMessage()));
                    throw new CloudException((Throwable)e);
                }
            }
            logger.error((Object)"No port was created by the create attempt, and no error was returned");
            throw new CloudException("No port was created");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Subnet createSubnet(@Nonnull SubnetCreateOptions options) throws CloudException, InternalException {
        if (!this.getCapabilities().allowsNewSubnetCreation()) {
            throw new OperationNotSupportedException("Subnets are not currently implemented for " + this.getProvider().getCloudName());
        }
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.createSubnet");
        VLAN vlan = this.getVlan(options.getProviderVlanId());
        if (vlan == null) {
            throw new CloudException("No such VLAN: " + options.getProviderVlanId());
        }
        HashMap wrapper = new HashMap();
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> md = new HashMap<String, String>();
        NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
        json.put("name", options.getName());
        json.put("cidr", options.getCidr());
        json.put("network_id", vlan.getProviderVlanId());
        IPVersion[] versions = options.getSupportedTraffic();
        if (versions.length < 1) {
            json.put("ip_version", "4");
        } else if (versions[0].equals((Object)IPVersion.IPV6)) {
            json.put("ip_version", "6");
        } else {
            json.put("ip_version", "4");
        }
        if (!this.getNetworkType().equals((Object)QuantumType.QUANTUM)) {
            md.put("org.dasein.description", options.getDescription());
            json.put("metadata", md);
        }
        wrapper.put("subnet", json);
        JSONObject result = null;
        result = this.getNetworkType().equals((Object)QuantumType.QUANTUM) ? method.postNetworks(this.getSubnetResource(), null, new JSONObject(wrapper), false) : method.postServers(this.getSubnetResource(), null, new JSONObject(wrapper), false);
        if (result != null && result.has("subnet")) {
            try {
                JSONObject ob = result.getJSONObject("subnet");
                Subnet subnet = this.toSubnet(result.getJSONObject("subnet"), vlan);
                if (subnet == null) {
                    throw new CloudException("No matching subnet was generated from " + ob.toString());
                }
                Subnet subnet2 = subnet;
                return subnet2;
            }
            catch (JSONException e) {
                logger.error((Object)("Unable to understand create response: " + e.getMessage()));
                throw new CloudException((Throwable)e);
            }
        }
        logger.error((Object)"No subnet was created by the create attempt, and no error was returned");
        throw new CloudException("No subnet was created");
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VLAN createVlan(@Nonnull String cidr, @Nonnull String name, @Nonnull String description, @Nonnull String domainName, @Nonnull String[] dnsServers, @Nonnull String[] ntpServers) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.createVlan");
        HashMap wrapper = new HashMap();
        HashMap<String, Object> json = new HashMap<String, Object>();
        HashMap<String, String> md = new HashMap<String, String>();
        NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
        if (!this.getNetworkType().equals((Object)QuantumType.QUANTUM)) {
            int i;
            md.put("org.dasein.description", description);
            md.put("org.dasein.domain", domainName);
            if (dnsServers != null && dnsServers.length > 0) {
                for (i = 0; i < dnsServers.length; ++i) {
                    md.put("org.dasein.dns." + (i + 1), dnsServers[i]);
                }
            }
            if (ntpServers != null && ntpServers.length > 0) {
                for (i = 0; i < ntpServers.length; ++i) {
                    md.put("org.dasein.ntp." + (i + 1), ntpServers[i]);
                }
            }
            json.put("metadata", md);
            json.put("label", name);
            json.put("cidr", cidr);
            wrapper.put("network", json);
        } else {
            json.put("name", name);
            wrapper.put("network", json);
        }
        JSONObject result = null;
        result = this.getNetworkType().equals((Object)QuantumType.QUANTUM) ? method.postNetworks(this.getNetworkResource(), null, new JSONObject(wrapper), false) : method.postServers(this.getNetworkResource(), null, new JSONObject(wrapper), false);
        if (result != null && result.has("network")) {
            try {
                JSONObject ob = result.getJSONObject("network");
                VLAN vlan = this.toVLAN(result.getJSONObject("network"));
                if (vlan == null) {
                    throw new CloudException("No matching network was generated from " + ob.toString());
                }
                VLAN vLAN = vlan;
                return vLAN;
            }
            catch (JSONException e) {
                logger.error((Object)("Unable to understand create response: " + e.getMessage()));
                throw new CloudException((Throwable)e);
            }
        }
        logger.error((Object)"No VLAN was created by the create attempt, and no error was returned");
        throw new CloudException("No VLAN was created");
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private String getNetworkResource() throws CloudException, InternalException {
        QuantumType type = this.getNetworkType();
        if (type.equals((Object)QuantumType.QUANTUM)) {
            return this.getNetworkResourceVersion() + QuantumType.QUANTUM.getNetworkResource();
        }
        return type.getNetworkResource();
    }

    @Nonnull
    private String getNetworkResourceVersion() throws CloudException, InternalException {
        if (this.networkVersionId == null) {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            try {
                JSONObject ob = method.getNetworks(null, null, false);
                if (ob != null && ob.has("versions")) {
                    JSONArray versions = ob.getJSONArray("versions");
                    for (int i = 0; i < versions.length(); ++i) {
                        String versionId;
                        String status;
                        JSONObject version = versions.getJSONObject(i);
                        if (!version.has("status") || version.isNull("status") || !(status = version.getString("status")).equalsIgnoreCase("current") || !version.has("id") || version.isNull("id")) continue;
                        this.networkVersionId = versionId = version.getString("id");
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.networkVersionId;
    }

    @Nonnull
    private String getSubnetResource() throws CloudException, InternalException {
        QuantumType type = this.getNetworkType();
        if (type.equals((Object)QuantumType.QUANTUM)) {
            return this.getNetworkResourceVersion() + QuantumType.QUANTUM.getSubnetResource();
        }
        return type.getSubnetResource();
    }

    @Nonnull
    private String getPortResource() throws CloudException, InternalException {
        QuantumType type = this.getNetworkType();
        if (type.equals((Object)QuantumType.QUANTUM)) {
            return this.getNetworkResourceVersion() + QuantumType.QUANTUM.getPortResource();
        }
        return type.getSubnetResource();
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "network interface";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "subnet";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "network";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subnet getSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.getSubnet");
        try {
            if (!this.getNetworkType().equals((Object)QuantumType.QUANTUM)) {
                Subnet subnet = null;
                return subnet;
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = null;
            ob = this.getNetworkType().equals((Object)QuantumType.QUANTUM) ? method.getNetworks(this.getSubnetResource(), subnetId, false) : method.getServers(this.getSubnetResource(), subnetId, false);
            try {
                Subnet subnet;
                if (ob != null && ob.has("subnet") && (subnet = this.toSubnet(ob.getJSONObject("subnet"), null)) != null) {
                    Subnet subnet2 = subnet;
                    return subnet2;
                }
            }
            catch (JSONException e) {
                logger.error((Object)("Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for subnet in " + ob.toString());
            }
            Subnet subnet = null;
            return subnet;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VLAN getVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.getVlan");
        try {
            if (vlanId.equals("00000000-0000-0000-0000-000000000000") || vlanId.equals("11111111-1111-1111-1111-111111111111")) {
                VLAN vLAN = super.getVlan(vlanId);
                return vLAN;
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = null;
            ob = this.getNetworkType().equals((Object)QuantumType.QUANTUM) ? method.getNetworks(this.getNetworkResource(), vlanId, false) : method.getServers(this.getNetworkResource(), vlanId, false);
            try {
                VLAN v;
                if (ob != null && ob.has("network") && (v = this.toVLAN(ob.getJSONObject("network"))) != null) {
                    VLAN vLAN = v;
                    return vLAN;
                }
            }
            catch (JSONException e) {
                logger.error((Object)("Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for networks in " + ob.toString());
            }
            VLAN vLAN = null;
            return vLAN;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public String getAttachedInternetGatewayId(@Nonnull String vlanId) throws CloudException, InternalException {
        return null;
    }

    @Nullable
    public InternetGateway getInternetGatewayById(@Nonnull String gatewayId) throws CloudException, InternalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.isSubscribed");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = null;
            ob = this.getNetworkType().equals((Object)QuantumType.QUANTUM) ? method.getNetworks(this.getNetworkResource(), null, false) : method.getServers(this.getNetworkResource(), null, false);
            boolean bl = ob != null && ob.has("networks");
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Collection<InternetGateway> listInternetGateways(@Nullable String vlanId) throws CloudException, InternalException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Networkable> listResources(@Nonnull String inVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listResources");
        try {
            VirtualMachineSupport vmSupport;
            ArrayList<Networkable> list = new ArrayList<Networkable>();
            ComputeServices services = this.getProvider().getComputeServices();
            if (services != null && (vmSupport = services.getVirtualMachineSupport()) != null) {
                for (VirtualMachine vm : vmSupport.listVirtualMachines()) {
                    if (!inVlanId.equals(vm.getProviderVlanId())) continue;
                    list.add((Networkable)vm);
                }
            }
            ArrayList<Networkable> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Subnet> listSubnets(@Nonnull String inVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listSubnets");
        try {
            if (!this.getNetworkType().equals((Object)QuantumType.QUANTUM)) {
                List<Subnet> list = Collections.emptyList();
                return list;
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = null;
            ob = this.getNetworkType().equals((Object)QuantumType.QUANTUM) ? method.getNetworks(this.getSubnetResource(), null, false) : method.getServers(this.getSubnetResource(), null, false);
            ArrayList<Subnet> subnets = new ArrayList<Subnet>();
            try {
                if (ob != null && ob.has("subnets")) {
                    JSONArray list = ob.getJSONArray("subnets");
                    for (int i = 0; i < list.length(); ++i) {
                        Subnet subnet = this.toSubnet(list.getJSONObject(i), null);
                        if (subnet == null || !subnet.getProviderVlanId().equals(inVlanId)) continue;
                        subnets.add(subnet);
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for subnets in " + ob.toString());
            }
            ArrayList<Subnet> arrayList = subnets;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVlanStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listVlanStatus");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = null;
            ob = this.getNetworkType().equals((Object)QuantumType.QUANTUM) ? method.getNetworks(this.getNetworkResource(), null, false) : method.getServers(this.getNetworkResource(), null, false);
            ArrayList<ResourceStatus> networks = new ArrayList<ResourceStatus>();
            try {
                if (ob != null && ob.has("networks")) {
                    JSONArray list = ob.getJSONArray("networks");
                    for (int i = 0; i < list.length(); ++i) {
                        JSONObject net = list.getJSONObject(i);
                        ResourceStatus status = this.toStatus(net);
                        if (status == null || status.getProviderResourceId().equals("00000000-0000-0000-0000-000000000000") || status.getProviderResourceId().equals("11111111-1111-1111-1111-111111111111")) continue;
                        networks.add(status);
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for networks in " + ob.toString());
            }
            ArrayList<ResourceStatus> arrayList = networks;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listVlans");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            JSONObject ob = null;
            ob = this.getNetworkType().equals((Object)QuantumType.QUANTUM) ? method.getNetworks(this.getNetworkResource(), null, false) : method.getServers(this.getNetworkResource(), null, false);
            ArrayList<VLAN> networks = new ArrayList<VLAN>();
            try {
                if (ob != null && ob.has("networks")) {
                    JSONArray list = ob.getJSONArray("networks");
                    for (int i = 0; i < list.length(); ++i) {
                        VLAN v = this.toVLAN(list.getJSONObject(i));
                        if (v == null || v.getProviderVlanId().equals("00000000-0000-0000-0000-000000000000") || v.getProviderVlanId().equals("11111111-1111-1111-1111-111111111111")) continue;
                        networks.add(v);
                    }
                }
            }
            catch (JSONException e) {
                logger.error((Object)("Unable to identify expected values in JSON: " + e.getMessage()));
                e.printStackTrace();
                throw new CloudException(CloudErrorType.COMMUNICATION, 200, "invalidJson", "Missing JSON element for networks in " + ob.toString());
            }
            ArrayList<VLAN> arrayList = networks;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void removeInternetGatewayById(@Nonnull String id) throws CloudException, InternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubnet(String subnetId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.removeSubnet");
        try {
            if (!this.getNetworkType().equals((Object)QuantumType.QUANTUM)) {
                throw new OperationNotSupportedException("Cannot remove subnets in an OpenStack network of type: " + (Object)((Object)this.getNetworkType()));
            }
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            if (this.getNetworkType().equals((Object)QuantumType.QUANTUM)) {
                method.deleteNetworks(this.getSubnetResource(), subnetId);
            } else {
                method.deleteServers(this.getSubnetResource(), subnetId);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVlan(String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.removeVlan");
        try {
            NovaMethod method = new NovaMethod((NovaOpenStack)this.getProvider());
            if (this.getNetworkType().equals((Object)QuantumType.QUANTUM)) {
                method.deleteNetworks(this.getNetworkResource(), vlanId);
            } else {
                method.deleteServers(this.getNetworkResource(), vlanId);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private VLANState toState(@Nonnull String s) {
        if (s.equalsIgnoreCase("active")) {
            return VLANState.AVAILABLE;
        }
        if (s.equalsIgnoreCase("build")) {
            return VLANState.PENDING;
        }
        return VLANState.PENDING;
    }

    @Nullable
    private ResourceStatus toStatus(@Nonnull JSONObject network) throws CloudException, InternalException {
        try {
            String id;
            String string = id = network.has("id") ? network.getString("id") : null;
            if (id == null) {
                return null;
            }
            VLANState s = network.has("status") ? this.toState(network.getString("status")) : VLANState.AVAILABLE;
            return new ResourceStatus(id, (Object)s);
        }
        catch (JSONException e) {
            throw new CloudException("Invalid JSON from cloud: " + e.getMessage());
        }
    }

    @Nullable
    private Subnet toSubnet(@Nonnull JSONObject json, @Nullable VLAN vlan) throws CloudException, InternalException {
        try {
            JSONArray p;
            String version;
            JSONObject md;
            String[] names;
            if (vlan == null) {
                String vlanId;
                String string = vlanId = json.has("network_id") ? json.getString("network_id") : null;
                if (vlanId == null) {
                    return null;
                }
                vlan = this.getVlan(vlanId);
                if (vlan == null) {
                    return null;
                }
            }
            if (!json.has("id")) {
                return null;
            }
            String subnetId = json.getString("id");
            String cidr = json.has("cidr") ? json.getString("cidr") : vlan.getCidr();
            String name = json.has("name") ? json.getString("name") : null;
            String description = json.has("description") ? json.getString("description") : null;
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (json.has("metadata") && (names = JSONObject.getNames((JSONObject)(md = json.getJSONObject("metadata")))) != null && names.length > 0) {
                for (String n : names) {
                    String value = md.getString(n);
                    if (value == null) continue;
                    metadata.put(n, value);
                    if (n.equals("org.dasein.description") && description == null) {
                        description = value;
                        continue;
                    }
                    if (!n.equals("org.dasein.name") || name != null) continue;
                    name = value;
                }
            }
            if (name == null) {
                name = subnetId + " - " + cidr;
            }
            if (description == null) {
                description = name;
            }
            IPVersion traffic = IPVersion.IPV4;
            if (json.has("ip_version") && (version = json.getString("ip_version")).equals("6")) {
                traffic = IPVersion.IPV6;
            }
            Subnet subnet = Subnet.getInstance((String)vlan.getProviderOwnerId(), (String)vlan.getProviderRegionId(), (String)vlan.getProviderVlanId(), (String)subnetId, (SubnetState)SubnetState.AVAILABLE, (String)name, (String)description, (String)cidr).supportingTraffic(new IPVersion[]{traffic});
            Collection dc = this.getProvider().getDataCenterServices().listDataCenters(vlan.getProviderRegionId());
            subnet.constrainedToDataCenter(((DataCenter)dc.iterator().next()).getProviderDataCenterId());
            if (json.has("allocation_pools") && (p = json.getJSONArray("allocation_pools")).length() > 0) {
                AllocationPool[] pools = new AllocationPool[p.length()];
                for (int i = 0; i < p.length(); ++i) {
                    JSONObject ob = p.getJSONObject(i);
                    String start = null;
                    String end = null;
                    if (ob.has("start")) {
                        start = ob.getString("start");
                    }
                    if (ob.has("end")) {
                        end = ob.getString("end");
                    }
                    if (start == null) {
                        start = end;
                    } else if (end == null) {
                        end = start;
                    }
                    if (start == null) continue;
                    pools[i] = AllocationPool.getInstance((RawAddress)new RawAddress(start), (RawAddress)new RawAddress(end));
                }
                int count = 0;
                for (AllocationPool pool : pools) {
                    if (pool == null) continue;
                    ++count;
                }
                if (count != pools.length) {
                    ArrayList<AllocationPool> list = new ArrayList<AllocationPool>();
                    for (AllocationPool pool : pools) {
                        if (pool == null) continue;
                        list.add(pool);
                    }
                    pools = list.toArray(new AllocationPool[list.size()]);
                }
                subnet.havingAllocationPools(pools);
            }
            if (json.has("gateway_ip")) {
                subnet.usingGateway(new RawAddress(json.getString("gateway_ip")));
            }
            if (!metadata.isEmpty()) {
                for (Map.Entry entry : metadata.entrySet()) {
                    subnet.setTag((String)entry.getKey(), (String)entry.getValue());
                }
            }
            return subnet;
        }
        catch (JSONException e) {
            throw new CloudException("Invalid JSON from cloud: " + e.getMessage());
        }
    }

    @Nullable
    private VLAN toVLAN(@Nonnull JSONObject network) throws CloudException, InternalException {
        try {
            JSONObject md;
            String[] names;
            VLAN v = new VLAN();
            v.setProviderOwnerId(this.getTenantId());
            v.setCurrentState(VLANState.AVAILABLE);
            v.setProviderRegionId(this.getContext().getRegionId());
            Collection dc = this.getProvider().getDataCenterServices().listDataCenters(this.getContext().getRegionId());
            v.setProviderDataCenterId(((DataCenter)dc.iterator().next()).getProviderDataCenterId());
            if (network.has("id")) {
                v.setProviderVlanId(network.getString("id"));
            }
            if (network.has("name")) {
                v.setName(network.getString("name"));
            } else if (network.has("label")) {
                v.setName(network.getString("label"));
            }
            if (network.has("cidr")) {
                v.setCidr(network.getString("cidr"));
            }
            if (network.has("status")) {
                v.setCurrentState(this.toState(network.getString("status")));
            }
            if (network.has("metadata") && (names = JSONObject.getNames((JSONObject)(md = network.getJSONObject("metadata")))) != null && names.length > 0) {
                for (String n : names) {
                    ArrayList<String> real;
                    String value = md.getString(n);
                    if (value == null) continue;
                    v.setTag(n, value);
                    if (n.equals("org.dasein.description") && v.getDescription() == null) {
                        v.setDescription(value);
                        continue;
                    }
                    if (n.equals("org.dasein.domain") && v.getDomainName() == null) {
                        v.setDomainName(value);
                        continue;
                    }
                    if (n.startsWith("org.dasein.dns.") && !n.equals("org.dasein.dsn.") && v.getDnsServers().length < 1) {
                        ArrayList<String> dns = new ArrayList<String>();
                        try {
                            int idx = Integer.parseInt(n.substring("org.dasein.dns.".length() + 1));
                            dns.ensureCapacity(idx);
                            dns.set(idx - 1, value);
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                        real = new ArrayList<String>();
                        for (String item : dns) {
                            if (item == null) continue;
                            real.add(item);
                        }
                        v.setDnsServers(real.toArray(new String[real.size()]));
                        continue;
                    }
                    if (!n.startsWith("org.dasein.ntp.") || n.equals("org.dasein.ntp.") || v.getNtpServers().length >= 1) continue;
                    ArrayList<String> ntp = new ArrayList<String>();
                    try {
                        int idx = Integer.parseInt(n.substring("org.dasein.ntp.".length() + 1));
                        ntp.ensureCapacity(idx);
                        ntp.set(idx - 1, value);
                    }
                    catch (NumberFormatException ignore) {
                        // empty catch block
                    }
                    real = new ArrayList();
                    for (String item : ntp) {
                        if (item == null) continue;
                        real.add(item);
                    }
                    v.setNtpServers(real.toArray(new String[real.size()]));
                }
            }
            if (v.getProviderVlanId() == null) {
                return null;
            }
            if (v.getCidr() == null) {
                v.setCidr("0.0.0.0/0");
            }
            if (v.getName() == null) {
                v.setName(v.getCidr());
                if (v.getName() == null) {
                    v.setName(v.getProviderVlanId());
                }
            }
            if (v.getDescription() == null) {
                v.setDescription(v.getName());
            }
            v.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4, IPVersion.IPV6});
            return v;
        }
        catch (JSONException e) {
            throw new CloudException("Invalid JSON from cloud: " + e.getMessage());
        }
    }

    public static enum QuantumType {
        NONE,
        RACKSPACE,
        NOVA,
        QUANTUM;


        public String getNetworkResource() {
            switch (this) {
                case QUANTUM: {
                    return "/networks";
                }
                case RACKSPACE: {
                    return "/os-networksv2";
                }
                case NOVA: {
                    return "/os-networks";
                }
            }
            return "/networks";
        }

        public String getSubnetResource() {
            switch (this) {
                case QUANTUM: {
                    return "/subnets";
                }
            }
            return "/subnets";
        }

        public String getPortResource() {
            switch (this) {
                case QUANTUM: {
                    return "/ports";
                }
            }
            return "/ports";
        }
    }
}

