/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.openstack.nova.os.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.FirewallCapabilities;
import org.dasein.cloud.network.FirewallConstraints;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.RuleTargetType;
import org.dasein.cloud.openstack.nova.os.NovaOpenStack;

public class SecurityGroupCapabilities
extends AbstractCapabilities<NovaOpenStack>
implements FirewallCapabilities {
    public SecurityGroupCapabilities(@Nonnull NovaOpenStack provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    public FirewallConstraints getFirewallConstraintsForCloud() throws InternalException, CloudException {
        return FirewallConstraints.getInstance();
    }

    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "security group";
    }

    @Nonnull
    public Requirement identifyPrecedenceRequirement(boolean inVlan) throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isZeroPrecedenceHighest() throws InternalException, CloudException {
        return true;
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(RuleTargetType.GLOBAL);
    }

    @Nonnull
    public Iterable<Direction> listSupportedDirections(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Direction.INGRESS);
    }

    @Nonnull
    public Iterable<Permission> listSupportedPermissions(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Permission.ALLOW);
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        ArrayList<RuleTargetType> list = new ArrayList<RuleTargetType>();
        list.add(RuleTargetType.CIDR);
        list.add(RuleTargetType.GLOBAL);
        return list;
    }

    public boolean requiresRulesOnCreation() throws CloudException, InternalException {
        return false;
    }

    public Requirement requiresVLAN() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean supportsRules(@Nonnull Direction direction, @Nonnull Permission permission, boolean inVlan) throws CloudException, InternalException {
        return !inVlan && Direction.INGRESS.equals((Object)direction) && Permission.ALLOW.equals((Object)permission);
    }

    public boolean supportsFirewallCreation(boolean inVlan) throws CloudException, InternalException {
        return !inVlan;
    }

    public boolean supportsFirewallDeletion() throws CloudException, InternalException {
        return true;
    }
}

