/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.Cloud;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.test.ci.CIResources;
import org.dasein.cloud.test.compute.ComputeResources;
import org.dasein.cloud.test.identity.IdentityResources;
import org.dasein.cloud.test.network.NetworkResources;
import org.dasein.cloud.test.platform.PlatformResources;
import org.dasein.cloud.test.storage.StorageResources;
import org.dasein.cloud.util.APITrace;

public class DaseinTestManager {
    public static final String STATEFUL = "stateful";
    public static final String STATELESS = "stateless";
    public static final String REMOVED = "removed";
    private static HashMap<String, Integer> apiAudit = new HashMap();
    private static CIResources ciResources;
    private static ComputeResources computeResources;
    private static TreeSet<String> exclusions;
    private static IdentityResources identityResources;
    private static NetworkResources networkResources;
    private static PlatformResources platformResources;
    private static StorageResources storageResources;
    private static TreeSet<String> inclusions;
    private static int skipCount;
    private static int testCount;
    private static long testStart;
    private Logger logger;
    private String name;
    private String prefix;
    private CloudProvider provider;
    private long startTimestamp;
    private String suite;
    private String userName = "";

    @Nonnull
    public static CloudProvider constructProvider() {
        return DaseinTestManager.constructProvider(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static CloudProvider constructProvider(@Nullable String overrideAccount, @Nullable String overrideShared, @Nullable String overrideSecret) {
        String cname = System.getProperty("providerClass");
        CloudProvider provider = null;
        if (cname == null) {
            throw new RuntimeException("Invalid class name for provider: " + cname);
        }
        try {
            String prop;
            String account = "";
            String cloudName = "";
            String endpoint = "";
            String regionId = "";
            String providerName = "";
            String userName = "";
            String string = prop = overrideAccount == null ? System.getProperty("accountNumber") : overrideAccount;
            if (prop != null) {
                account = prop;
            }
            if ((prop = System.getProperty("cloudName")) != null) {
                cloudName = prop;
            }
            if ((prop = System.getProperty("endpoint")) != null) {
                endpoint = prop;
            }
            if ((prop = System.getProperty("providerName")) != null) {
                providerName = prop;
            }
            if ((prop = System.getProperty("regionId")) != null) {
                regionId = prop;
            }
            Cloud cloud = Cloud.register((String)providerName, (String)cloudName, (String)endpoint, Class.forName(cname));
            ContextRequirements requirements = cloud.buildProvider().getContextRequirements();
            List fields = requirements.getConfigurableValues();
            ArrayList<ProviderContext.Value> values = new ArrayList<ProviderContext.Value>(fields.size());
            for (ContextRequirements.Field f : fields) {
                if (f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) {
                    String secret;
                    String shared = overrideShared == null ? System.getProperty(f.name + "Shared") : overrideShared;
                    String string2 = secret = overrideSecret == null ? System.getProperty(f.name + "Secret") : overrideSecret;
                    if (shared != null && secret != null) {
                        boolean p12 = false;
                        byte[] p12Bytes = null;
                        if (f.name.contains("p12")) {
                            String p12Path = System.getProperty(f.name + "Shared");
                            File file = new File(p12Path);
                            p12Bytes = new byte[(int)file.length()];
                            FileInputStream ios = null;
                            try {
                                ios = new FileInputStream(file);
                                if (((InputStream)ios).read(p12Bytes) == -1) {
                                    throw new IOException("EOF reached while trying to read p12 certificate");
                                }
                                p12 = true;
                            }
                            catch (IOException ex) {
                            }
                            finally {
                                try {
                                    if (ios != null) {
                                        ((InputStream)ios).close();
                                    }
                                }
                                catch (IOException e) {}
                            }
                        }
                        if (p12) {
                            values.add(new ProviderContext.Value("p12Certificate", (Object)new byte[][]{p12Bytes, secret.getBytes()}));
                            continue;
                        }
                        values.add(ProviderContext.Value.parseValue((ContextRequirements.Field)f, (String[])new String[]{shared, secret}));
                        continue;
                    }
                    String error = String.format("Keypair fields are not set up correctly: %sShared = %s, %sSecret = %s. Check the Maven profile and pom.xml.", f.name, shared, f.name, secret);
                    Logger logger = Logger.getLogger(DaseinTestManager.class);
                    logger.fatal((Object)error);
                    throw new RuntimeException(error);
                }
                String value = System.getProperty(f.name);
                if (value != null && value.trim().length() > 0) {
                    values.add(ProviderContext.Value.parseValue((ContextRequirements.Field)f, (String[])new String[]{value}));
                    continue;
                }
                if (!f.required) continue;
                String error = String.format("%s field is missing, but declared as REQUIRED. Check the Maven profile and pom.xml.", f.name);
                Logger logger = Logger.getLogger(DaseinTestManager.class);
                logger.fatal((Object)error);
                throw new RuntimeException(error);
            }
            ProviderContext ctx = cloud.createContext(account, regionId, values.toArray(new ProviderContext.Value[0]));
            provider = ctx.connect();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("No such class: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (InternalException e) {
        }
        catch (CloudException e) {
            // empty catch block
        }
        return provider;
    }

    @Nullable
    public static ComputeResources getComputeResources() {
        return computeResources;
    }

    @Nullable
    public static String getDefaultDataCenterId(boolean stateless) {
        return computeResources == null ? null : computeResources.getTestDataCenterId(stateless);
    }

    @Nullable
    public static IdentityResources getIdentityResources() {
        return identityResources;
    }

    @Nullable
    public static NetworkResources getNetworkResources() {
        return networkResources;
    }

    @Nullable
    public static PlatformResources getPlatformResources() {
        return platformResources;
    }

    @Nullable
    public static StorageResources getStorageResources() {
        return storageResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Logger logger = Logger.getLogger(DaseinTestManager.class);
        logger.info((Object)"BEGIN Test Initialization ------------------------------------------------------------------------------");
        try {
            testStart = System.currentTimeMillis();
            CloudProvider cloudProvider = DaseinTestManager.constructProvider();
            storageResources = new StorageResources(cloudProvider);
            platformResources = new PlatformResources(cloudProvider);
            networkResources = new NetworkResources(cloudProvider);
            identityResources = new IdentityResources(cloudProvider);
            ciResources = new CIResources(cloudProvider);
            computeResources = new ComputeResources(cloudProvider);
            computeResources.init();
            String prop = System.getProperty("dasein.inclusions");
            if (prop != null && !prop.equals("")) {
                inclusions = new TreeSet();
                if (prop.contains(",")) {
                    for (String which : prop.split(",")) {
                        inclusions.add(which.toLowerCase());
                    }
                } else {
                    inclusions.add(prop.toLowerCase());
                }
            }
            if ((prop = System.getProperty("dasein.exclusions")) != null && !prop.equals("")) {
                exclusions = new TreeSet();
                if (prop.contains(",")) {
                    for (String which : prop.split(",")) {
                        exclusions.add(which.toLowerCase());
                    }
                } else {
                    exclusions.add(prop.toLowerCase());
                }
            }
            DaseinTestManager.out(logger, null, "Included", inclusions == null ? null : inclusions.toString());
            DaseinTestManager.out(logger, null, "Excluded", exclusions == null ? null : exclusions.toString());
            APITrace.report((String)"Init");
            APITrace.reset();
        }
        finally {
            logger.info((Object)"END Test Initialization ------------------------------------------------------------------------------");
            logger.info((Object)"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUp() {
        Logger logger = Logger.getLogger(DaseinTestManager.class);
        int provisioned = 0;
        int cleaned = 0;
        logger.info((Object)"");
        logger.info((Object)"BEGIN Test Clean Up ------------------------------------------------------------------------------");
        try {
            int count;
            APITrace.report((String)"Clean Up");
            if (ciResources != null) {
                count = ciResources.close();
                DaseinTestManager.out(logger, null, "CI Resources", String.valueOf(count));
                cleaned += count;
            }
            if (computeResources != null) {
                count = computeResources.close();
                DaseinTestManager.out(logger, null, "Compute Resources", String.valueOf(count));
                cleaned += count;
            }
            if (networkResources != null) {
                count = networkResources.close();
                DaseinTestManager.out(logger, null, "Network Resources", String.valueOf(count));
                cleaned += count;
            }
            if (identityResources != null) {
                count = identityResources.close();
                DaseinTestManager.out(logger, null, "Identity Resources", String.valueOf(count));
                cleaned += count;
            }
            if (platformResources != null) {
                count = platformResources.close();
                DaseinTestManager.out(logger, null, "Platform Resources", String.valueOf(count));
                cleaned += count;
            }
            if (storageResources != null) {
                count = storageResources.close();
                DaseinTestManager.out(logger, null, "Storage Resources", String.valueOf(count));
                cleaned += count;
            }
        }
        finally {
            logger.info((Object)"END Test Clean Up ------------------------------------------------------------------------------");
            logger.info((Object)"");
        }
        long duration = System.currentTimeMillis() - testStart;
        int minutes = (int)(duration / 60000L);
        float seconds = (float)(duration % 60000L) / 1000.0f;
        logger.info((Object)"");
        logger.info((Object)"All Tests Complete ------------------------------------------------------------------------------");
        logger.info((Object)"--------------- API Log ---------------");
        int total = 0;
        for (Map.Entry<String, Integer> entry : apiAudit.entrySet()) {
            DaseinTestManager.out(logger, null, "---> " + entry.getKey(), String.valueOf(entry.getValue()));
            total += entry.getValue().intValue();
        }
        DaseinTestManager.out(logger, null, "---> Total Calls", String.valueOf(total));
        logger.info((Object)"");
        logger.info((Object)"----------- Provisioning Log ----------");
        if (computeResources != null) {
            provisioned += computeResources.report();
        }
        if (ciResources != null) {
            provisioned += ciResources.report();
        }
        if (identityResources != null) {
            provisioned += identityResources.report();
        }
        if (networkResources != null) {
            provisioned += networkResources.report();
        }
        if (platformResources != null) {
            provisioned += platformResources.report();
        }
        if (storageResources != null) {
            provisioned += storageResources.report();
        }
        logger.info((Object)"");
        logger.info((Object)"--------------- Results ---------------");
        DaseinTestManager.out(logger, null, "Tests", String.valueOf(testCount));
        DaseinTestManager.out(logger, null, "Skipped", String.valueOf(skipCount));
        DaseinTestManager.out(logger, null, "Run", String.valueOf(testCount - skipCount));
        DaseinTestManager.out(logger, null, "Resources Provisioned", String.valueOf(provisioned));
        DaseinTestManager.out(logger, null, "Resources De-provisioned", String.valueOf(cleaned));
        DaseinTestManager.out(logger, null, "Duration", minutes + " minutes " + seconds + " seconds");
        logger.info((Object)"-------------------------------------------------------------------------------------------------");
    }

    public static void out(@Nonnull Logger logger, @Nullable String prefix, @Nonnull String key, @Nullable String value) {
        StringBuilder str = new StringBuilder();
        if (key.length() > 36) {
            str.append(key.substring(0, 36)).append(": ");
        } else {
            str.append(key).append(": ");
            while (str.length() < 38) {
                str.append(" ");
            }
        }
        if (prefix == null) {
            logger.info((Object)(str.toString() + value));
        } else {
            logger.info((Object)(prefix + str.toString() + value));
        }
    }

    public DaseinTestManager(@Nonnull Class<?> testClass) {
        this.logger = Logger.getLogger(testClass);
        this.suite = testClass.getSimpleName();
        this.provider = DaseinTestManager.constructProvider();
        this.changePrefix();
        String prop = System.getProperty("userName");
        if (prop != null) {
            this.userName = prop;
        }
    }

    public void begin(@Nonnull String name) {
        this.name = name;
        APITrace.report((String)"Setup");
        APITrace.reset();
        this.changePrefix();
        this.startTimestamp = System.currentTimeMillis();
        ++testCount;
        this.out("");
        this.out(">>> BEGIN ---------------------------------------------------------------------------------------------->>>");
    }

    private void changePrefix() {
        StringBuilder str = new StringBuilder();
        String s = this.suite.endsWith("Test") ? this.suite.substring(0, this.suite.length() - 4) : (this.suite.endsWith("Tests") ? this.suite.substring(0, this.suite.length() - 5) : this.suite);
        str.append(this.provider.getProviderName()).append("/").append(this.provider.getCloudName()).append(".").append(s);
        if (this.name != null) {
            str.append(".").append(this.name);
        }
        if (str.length() > 44) {
            this.prefix = str.substring(str.length() - 44) + "> ";
        } else {
            str.append("> ");
            while (str.length() < 46) {
                str.append(" ");
            }
            this.prefix = str.toString();
        }
    }

    public void close() {
        this.getProvider().close();
    }

    public void end() {
        String[] calls = APITrace.listApis((String)this.provider.getProviderName(), (String)this.provider.getCloudName());
        if (calls.length > 0) {
            this.out("---------- API Log ----------");
            int total = 0;
            for (String call : calls) {
                int count = (int)APITrace.getAPICountAcrossAccounts((String)this.provider.getProviderName(), (String)this.provider.getCloudName(), (String)call);
                if (apiAudit.containsKey(call)) {
                    apiAudit.put(call, count + apiAudit.get(call));
                } else {
                    apiAudit.put(call, count);
                }
                this.out("---> " + call, count);
                total += count;
            }
            this.out("---> Total Calls", total);
        }
        this.out("Duration", (float)(System.currentTimeMillis() - this.startTimestamp) / 1000.0f + " seconds");
        this.out("<<< END   ----------------------------------------------------------------------------------------------<<<");
        this.out("");
        APITrace.report((String)this.prefix);
        APITrace.reset();
        this.name = null;
        this.changePrefix();
    }

    @Nonnull
    public ProviderContext getContext() {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new RuntimeException("Provider context went away");
        }
        return ctx;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTestAnyFirewallId(@Nonnull String label, boolean provisionIfNull) {
        NetworkServices services = this.provider.getNetworkServices();
        if (services != null) {
            FirewallSupport support = services.getFirewallSupport();
            try {
                if (support != null && support.isSubscribed()) {
                    if (support.getCapabilities().supportsFirewallCreation(false)) {
                        return this.getTestGeneralFirewallId(label, provisionIfNull);
                    }
                    if (support.getCapabilities().supportsFirewallCreation(true)) {
                        return this.getTestVLANFirewallId(REMOVED, true, null);
                    }
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Blob getTestBucket(@Nonnull String label, boolean root, boolean provisionIfNull) {
        if (root) {
            return storageResources == null ? null : storageResources.getTestRootBucket(label, provisionIfNull, null);
        }
        return storageResources == null ? null : storageResources.getTestChildBucket(label, provisionIfNull, null, null);
    }

    @Nullable
    public String getTestDistributionId(@Nonnull String label, boolean provisionIfNull, @Nullable String origin) {
        return platformResources == null ? null : platformResources.getTestDistributionId(label, provisionIfNull, origin);
    }

    @Nullable
    public String getTestGeneralFirewallId(@Nonnull String label, boolean provisionIfNull) {
        return networkResources == null ? null : networkResources.getTestFirewallId(label, provisionIfNull, null);
    }

    @Nullable
    public String getTestGroupId(@Nonnull String label, boolean provisionIfNull) {
        return identityResources == null ? null : identityResources.getTestGroupId(label, provisionIfNull);
    }

    @Nullable
    public String getTestImageId(@Nonnull String label, boolean provisionIfNull) {
        return computeResources == null ? null : computeResources.getTestImageId(label, provisionIfNull);
    }

    @Nullable
    public String getTestKeypairId(@Nonnull String label, boolean provisionIfNull) {
        return identityResources == null ? null : identityResources.getTestKeypairId(label, provisionIfNull);
    }

    @Nullable
    public String getTestLoadBalancerId(@Nonnull String label, @Nonnull String lbNamePrefix, boolean provisionIfNull, boolean withHealthCheck) {
        return networkResources == null ? null : networkResources.getTestLoadBalancerId(label, lbNamePrefix, provisionIfNull, withHealthCheck);
    }

    @Nullable
    public String getTestLoadBalancerId(@Nonnull String label, @Nonnull String lbNamePrefix, boolean provisionIfNull) {
        return networkResources == null ? null : networkResources.getTestLoadBalancerId(label, lbNamePrefix, provisionIfNull, false);
    }

    @Nullable
    public String getTestSSLCertificateName(@Nonnull String label, boolean provisionIfNull) {
        return networkResources == null ? null : networkResources.getTestSSLCertificateName(label, provisionIfNull);
    }

    @Nullable
    public String getTestNetworkFirewallId(@Nonnull String label, boolean provisionIfNull, @Nullable String inVlanId) {
        return networkResources == null ? null : networkResources.getTestNetworkFirewallId(label, provisionIfNull, inVlanId);
    }

    @Nullable
    public Blob getTestObject(@Nonnull String label, boolean root, boolean provisionIfNull) {
        if (root) {
            return storageResources == null ? null : storageResources.getTestRootObject(label, provisionIfNull, null);
        }
        return storageResources == null ? null : storageResources.getTestChildObject(label, provisionIfNull, null, null);
    }

    @Nullable
    public String getTestQueueId(@Nonnull String label, boolean provisionIfNull) {
        return platformResources == null ? null : platformResources.getTestQueueId(label, provisionIfNull);
    }

    @Nullable
    public String getTestRDBMSId(@Nonnull String label, boolean provisionIfNull, @Nullable DatabaseEngine engine) {
        return platformResources == null ? null : platformResources.getTestRDBMSId(label, provisionIfNull, engine);
    }

    @Nullable
    public String getTestSnapshotId(@Nonnull String label, boolean provisionIfNull) {
        return computeResources == null ? null : computeResources.getTestSnapshotId(label, provisionIfNull);
    }

    @Nullable
    public String getTestStaticIpId(@Nonnull String label, boolean provisionIfNull, @Nullable IPVersion version, boolean forVLAN, @Nullable String vlanId) {
        return networkResources == null ? null : networkResources.getTestStaticIpId(label, provisionIfNull, version, forVLAN, vlanId);
    }

    @Nullable
    public String getTestSubnetId(@Nonnull String label, boolean provisionIfNull, @Nullable String vlanId, @Nullable String preferredDataCenterId) {
        return networkResources == null ? null : networkResources.getTestSubnetId(label, provisionIfNull, vlanId, preferredDataCenterId);
    }

    @Nullable
    public String getTestInternetGatewayId(@Nonnull String label, boolean provisionIfNull, @Nullable String vlanId, @Nullable String preferredDataCenterId) {
        return networkResources == null ? null : networkResources.getTestInternetGatewayId(label, provisionIfNull, vlanId, preferredDataCenterId);
    }

    @Nullable
    public String getTestTopicId(@Nonnull String label, boolean provisionIfNull) {
        return platformResources == null ? null : platformResources.getTestTopicId(label, provisionIfNull);
    }

    @Nullable
    public String getTestTopologyId(@Nonnull String label, boolean provisionIfNull) {
        return ciResources == null ? null : ciResources.getTestTopologyId(label, provisionIfNull);
    }

    @Nullable
    public String getTestUserId(@Nonnull String label, boolean provisionIfNull, @Nullable String preferredGroupId) {
        return identityResources == null ? null : identityResources.getTestUserId(label, provisionIfNull, preferredGroupId);
    }

    @Nullable
    public String getTestVLANFirewallId(@Nonnull String label, boolean provisionIfNull, @Nullable String inVlanId) {
        String id;
        if (inVlanId == null && (inVlanId = label.equals(STATELESS) ? this.getTestVLANId(STATELESS, false, null) : this.getTestVLANId(STATEFUL, true, null)) == null) {
            return null;
        }
        String string = id = networkResources == null ? null : networkResources.getTestFirewallId(label, provisionIfNull, inVlanId);
        if (id != null) {
            try {
                Firewall firewall = this.provider.getNetworkServices().getFirewallSupport().getFirewall(id);
                if (firewall == null) {
                    return null;
                }
                if (!inVlanId.equals(firewall.getProviderVlanId())) {
                    return this.getTestVLANFirewallId(label + "a", provisionIfNull, inVlanId);
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return id;
    }

    @Nullable
    public String getTestVLANId(@Nonnull String label, boolean provisionIfNull, @Nullable String preferredDataCenterId) {
        return networkResources == null ? null : networkResources.getTestVLANId(label, provisionIfNull, preferredDataCenterId);
    }

    @Nullable
    public String getTestRoutingTableId(@Nonnull String label, boolean provisionIfNull, @Nullable String vlanId, @Nullable String preferredDataCenterId) {
        return networkResources == null ? null : networkResources.getTestRoutingTableId(label, provisionIfNull, vlanId, preferredDataCenterId);
    }

    @Nullable
    public String getTestVMId(@Nonnull String label, @Nullable VmState desiredState, boolean provisionIfNull, @Nullable String preferredDataCenterId) {
        return this.getTestVMId(label, this.getUserName() + "-dsnvm", desiredState, provisionIfNull, preferredDataCenterId);
    }

    @Nullable
    public String getTestVMId(@Nonnull String label, @Nonnull String vmName, @Nullable VmState desiredState, boolean provisionIfNull, @Nullable String preferredDataCenterId) {
        if (computeResources == null) {
            return null;
        }
        return computeResources.getTestVmId(label, vmName, desiredState, provisionIfNull, preferredDataCenterId);
    }

    @Nullable
    public String getTestVLANVMId(@Nonnull String label, @Nullable VmState desiredState, @Nullable String vlanId, boolean provisionIfNull, @Nullable String preferredDataCenterId) {
        if (computeResources == null) {
            return null;
        }
        return computeResources.getTestVLANVmId(label, desiredState, vlanId, provisionIfNull, preferredDataCenterId);
    }

    @Nullable
    public String getTestVMProductId() {
        return computeResources == null ? null : computeResources.getTestVMProductId();
    }

    @Nullable
    public String getTestVolumeId(@Nonnull String label, boolean provisionIfNull, @Nullable VolumeFormat preferredFormat, @Nullable String preferredDataCenterId) {
        if (computeResources == null) {
            return null;
        }
        return computeResources.getTestVolumeId(label, provisionIfNull, preferredFormat, preferredDataCenterId);
    }

    @Nullable
    public String getTestVolumeProductId() {
        return computeResources == null ? null : computeResources.getTestVolumeProductId();
    }

    @Nullable
    public String getTestZoneId(@Nonnull String label, boolean provisionIfNull) {
        return networkResources == null ? null : networkResources.getTestZoneId(label, provisionIfNull);
    }

    @Nonnull
    public CloudProvider getProvider() {
        return this.provider;
    }

    public boolean isTestSkipped() {
        if (inclusions == null && exclusions == null) {
            return false;
        }
        String s = this.suite.toLowerCase();
        String t = this.name == null ? null : this.name.toLowerCase();
        Boolean suiteIncluded = null;
        Boolean testIncluded = null;
        if (inclusions != null) {
            if (inclusions.contains(s)) {
                suiteIncluded = true;
            }
            if (t != null && inclusions.contains(s + "." + t)) {
                testIncluded = true;
            }
            if (suiteIncluded == null && testIncluded == null) {
                this.skip();
                return true;
            }
        }
        if (exclusions != null) {
            if (t != null && exclusions.contains(s + "." + t)) {
                if (testIncluded == null || !testIncluded.booleanValue()) {
                    this.skip();
                    return true;
                }
                return false;
            }
            if (exclusions.contains(s)) {
                if (testIncluded != null && testIncluded.booleanValue()) {
                    return false;
                }
                if (suiteIncluded != null && suiteIncluded.booleanValue()) {
                    return false;
                }
            }
        }
        return false;
    }

    public void ok(@Nonnull String message) {
        this.logger.info((Object)(this.prefix + message + " (OK)"));
    }

    public void out(@Nonnull String message) {
        this.logger.info((Object)(this.prefix + message));
    }

    public void out(@Nonnull String key, boolean value) {
        this.out(key, String.valueOf(value));
    }

    public void out(@Nonnull String key, int value) {
        this.out(key, String.valueOf(value));
    }

    public void out(@Nonnull String key, long value) {
        this.out(key, String.valueOf(value));
    }

    public void out(@Nonnull String key, double value) {
        this.out(key, String.valueOf(value));
    }

    public void out(@Nonnull String key, float value) {
        this.out(key, String.valueOf(value));
    }

    public void out(@Nonnull String key, Object value) {
        this.out(key, value == null ? "null" : value.toString());
    }

    public void out(@Nonnull String key, @Nullable String value) {
        DaseinTestManager.out(this.logger, this.prefix, key, value);
    }

    public void skip() {
        ++skipCount;
        this.out("SKIPPING");
    }

    public void warn(@Nonnull String message) {
        this.logger.warn((Object)(this.prefix + "WARNING: " + message));
    }

    public String getUserName() {
        return this.userName;
    }
}

