/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.ci;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ci.CIServices;
import org.dasein.cloud.ci.ConvergedInfrastructure;
import org.dasein.cloud.ci.ConvergedInfrastructureSupport;
import org.dasein.cloud.ci.Topology;
import org.dasein.cloud.ci.TopologyState;
import org.dasein.cloud.ci.TopologySupport;
import org.dasein.cloud.test.DaseinTestManager;

public class CIResources {
    private static final Logger logger = Logger.getLogger(CIResources.class);
    private CloudProvider provider;
    private final HashMap<String, String> testInfrastructures = new HashMap();
    private final HashMap<String, String> testTopologies = new HashMap();

    public CIResources(@Nonnull CloudProvider provider) {
        this.provider = provider;
    }

    public int close() {
        CIServices ciServices = this.provider.getCIServices();
        int count = 0;
        if (ciServices != null) {
            TopologySupport tSupport;
            ConvergedInfrastructureSupport ciSupport = ciServices.getConvergedInfrastructureSupport();
            if (ciSupport != null) {
                for (Map.Entry<String, String> entry : this.testInfrastructures.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        ConvergedInfrastructure ci = ciSupport.getConvergedInfrastructure(entry.getValue());
                        if (ci != null) {
                            ciSupport.terminate(entry.getValue(), null);
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to de-provision test CI " + entry.getValue() + ": " + t.getMessage()));
                    }
                }
            }
            if ((tSupport = ciServices.getTopologySupport()) != null) {
                for (Map.Entry<String, String> entry : this.testTopologies.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        Topology t = tSupport.getTopology(entry.getValue());
                        if (t != null) {
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to de-provision test topology " + entry.getValue() + ": " + t.getMessage()));
                    }
                }
            }
        }
        return count;
    }

    @Nullable
    public String getTestTopologyId(@Nonnull String label, boolean provisionIfNull) {
        TopologySupport support;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testTopologies.entrySet()) {
                String id;
                if (entry.getKey().startsWith("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessTopology();
        }
        String id = this.testTopologies.get(label);
        if (id != null) {
            return id;
        }
        if (!provisionIfNull) {
            return null;
        }
        CIServices services = this.provider.getCIServices();
        if (services != null && (support = services.getTopologySupport()) != null) {
            try {
                return null;
            }
            catch (Throwable ignore) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private String findStatelessTopology() {
        CIServices services = this.provider.getCIServices();
        if (services != null) {
            TopologySupport support = services.getTopologySupport();
            try {
                if (support != null && support.isSubscribed()) {
                    Topology defaultTopology = null;
                    for (Topology t : support.listTopologies(null)) {
                        if (t.getCurrentState().equals((Object)TopologyState.ACTIVE)) {
                            defaultTopology = t;
                            break;
                        }
                        if (defaultTopology != null) continue;
                        defaultTopology = t;
                    }
                    if (defaultTopology != null) {
                        String id = defaultTopology.getProviderTopologyId();
                        this.testTopologies.put("stateless", id);
                        return id;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public int report() {
        boolean header = false;
        int count = 0;
        this.testInfrastructures.remove("stateless");
        if (!this.testInfrastructures.isEmpty()) {
            logger.info((Object)"Provisioned CI Resources:");
            header = true;
            count += this.testInfrastructures.size();
            DaseinTestManager.out(logger, null, "---> Infrastructures", this.testInfrastructures.size() + " " + this.testInfrastructures);
        }
        this.testTopologies.remove("stateless");
        if (!this.testTopologies.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned CI Resources:");
            }
            count += this.testTopologies.size();
            DaseinTestManager.out(logger, null, "---> Topologies", this.testTopologies.size() + " " + this.testTopologies);
        }
        return count;
    }
}

