/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.ci;

import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ci.CIServices;
import org.dasein.cloud.ci.Topology;
import org.dasein.cloud.ci.TopologySupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessTopologyTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testTopologyId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessTopologyTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.testTopologyId = tm.getTestTopologyId("stateless", false);
    }

    @After
    public void after() {
        tm.end();
    }

    private void assertTopology(@Nonnull Topology topology) {
        Assert.assertNotNull((String)"Topology ID may not be null", (Object)topology.getProviderTopologyId());
        Assert.assertNotNull((String)"Topology name may not be null", (Object)topology.getName());
        Assert.assertNotNull((String)"Topology description may not be null", (Object)topology.getDescription());
        Assert.assertNotNull((String)"Topology state may not be null", (Object)topology.getCurrentState());
        Assert.assertTrue((String)"Topology creation timestamp may not be negative", (topology.getCreationTimestamp() >= 0L ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Topology tags may not be null", (Object)topology.getTags());
        Assert.assertNotNull((String)"Owner ID may not be null", (Object)topology.getProviderOwnerId());
        Assert.assertNotNull((String)"Region ID may not be null", (Object)topology.getProviderRegionId());
        Iterable vms = topology.getVirtualMachines();
        Assert.assertNotNull((String)"VM list may not be null", (Object)vms);
        for (Topology.VMDevice vm : vms) {
            Assert.assertNotNull((String)"VM device ID may not be null", (Object)vm.getDeviceId());
            Assert.assertNotNull((String)"VM name may not be null", (Object)vm.getName());
            Assert.assertTrue((String)"VM CPU count must be non-negative and non-zero", (vm.getCpuCount() > 0 ? 1 : 0) != 0);
            Assert.assertNotNull((String)"VM memory must not be null", (Object)vm.getMemory());
            Assert.assertNotNull((String)"VM architecture must not be null", (Object)vm.getArchitecture());
            Assert.assertNotNull((String)"VM platform must not be null", (Object)vm.getPlatform());
            Assert.assertTrue((String)"VM capacity must be non-negative and non-zero", (vm.getCapacity() > 0 ? 1 : 0) != 0);
        }
        Iterable vlans = topology.getVLANs();
        Assert.assertNotNull((String)"VLAN list may not be null", (Object)vlans);
        for (Topology.VLANDevice vlan : vlans) {
            Assert.assertNotNull((String)"VLAN device ID may not be null", (Object)vlan.getDeviceId());
            Assert.assertNotNull((String)"VLAN name may not be null", (Object)vlan.getName());
        }
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        CIServices services = tm.getProvider().getCIServices();
        if (services != null) {
            TopologySupport support = services.getTopologySupport();
            if (support != null) {
                tm.out("Subscribed", support.isSubscribed());
                tm.out("Public Library", support.supportsPublicLibrary());
            } else {
                tm.ok(tm.getProvider().getCloudName() + " does not support topologies");
            }
        } else {
            tm.ok(tm.getProvider().getCloudName() + " does not support compute services");
        }
    }

    @Test
    public void getBogusTopology() throws CloudException, InternalException {
        CIServices services = tm.getProvider().getCIServices();
        if (services != null) {
            TopologySupport support = services.getTopologySupport();
            if (support != null) {
                Topology t = support.getTopology(UUID.randomUUID().toString());
                tm.out("Bogus Topology", t);
                Assert.assertNull((String)"Bogus topology was supposed to be none, but got a valid topology.", (Object)t);
            } else {
                tm.ok("No topology support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void getTopology() throws CloudException, InternalException {
        CIServices services = tm.getProvider().getCIServices();
        if (services != null) {
            TopologySupport support = services.getTopologySupport();
            if (support != null) {
                if (this.testTopologyId != null) {
                    Topology t = support.getTopology(this.testTopologyId);
                    tm.out("Topology", t);
                    Assert.assertNotNull((String)"Failed to find the test topology among possible images", (Object)t);
                } else if (!support.isSubscribed()) {
                    tm.warn("No topology ID was identified, so this test is not valid");
                } else {
                    Assert.fail((String)"No test topology exists for the getTopology test");
                }
            } else {
                tm.ok("No topology support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void topologyContent() throws CloudException, InternalException {
        CIServices services = tm.getProvider().getCIServices();
        if (services != null) {
            TopologySupport support = services.getTopologySupport();
            if (support != null) {
                if (this.testTopologyId != null) {
                    Map tags;
                    Iterable vlans;
                    Topology t = support.getTopology(this.testTopologyId);
                    Assert.assertNotNull((String)"Failed to find the test topology among possible topologies", (Object)t);
                    tm.out("Topology ID", t.getProviderTopologyId());
                    tm.out("Current State", t.getCurrentState());
                    tm.out("Name", t.getName());
                    tm.out("Created", new Date(t.getCreationTimestamp()));
                    tm.out("Owner Account", t.getProviderOwnerId());
                    tm.out("Region ID", t.getProviderRegionId());
                    tm.out("Data Center ID", t.getProviderDataCenterId());
                    Iterable vms = t.getVirtualMachines();
                    if (vms != null) {
                        int i = 1;
                        for (Topology.VMDevice vm : vms) {
                            tm.out("VM " + i + " Device ID", vm.getDeviceId());
                            tm.out("VM " + i + " Name", vm.getName());
                            tm.out("VM " + i + " Capacity", vm.getCapacity());
                            tm.out("VM " + i + " Architecture", vm.getArchitecture());
                            tm.out("VM " + i + " Platform", vm.getPlatform());
                            tm.out("VM " + i + " CPU Count", vm.getCpuCount());
                            tm.out("VM " + i + " Memory", vm.getMemory());
                            ++i;
                        }
                    }
                    if ((vlans = t.getVLANs()) != null) {
                        int i = 1;
                        for (Topology.VLANDevice vLANDevice : vlans) {
                            tm.out("VLAN " + i + " Device ID", vLANDevice.getDeviceId());
                            tm.out("VLAN " + i + " Name", vLANDevice.getName());
                            ++i;
                        }
                    }
                    if ((tags = t.getTags()) != null) {
                        for (Map.Entry entry : tags.entrySet()) {
                            tm.out("Tag " + (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    tm.out("Description", t.getDescription());
                    this.assertTopology(t);
                } else if (!support.isSubscribed()) {
                    tm.warn("No topology ID was identified, so this test is not valid");
                } else {
                    Assert.fail((String)"No test topology exists for the topologyContent test");
                }
            } else {
                tm.ok("No topology support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void listPrivateTopologies() throws CloudException, InternalException {
        CIServices services = tm.getProvider().getCIServices();
        if (services != null) {
            TopologySupport support = services.getTopologySupport();
            if (support != null) {
                Iterable topologies = support.listTopologies(null);
                int count = 0;
                Assert.assertNotNull((String)"listTopologies() must return a non-null list of topologies even if a private library is not supported", (Object)topologies);
                for (Topology t : topologies) {
                    ++count;
                    tm.out("Topology", t);
                }
                tm.out("Total Topology Count", count);
                for (Topology t : topologies) {
                    this.assertTopology(t);
                }
                if (count < 1) {
                    tm.warn("No topologies were provided so this test may not be valid");
                }
            } else {
                tm.ok("No topology support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }
}

