/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.cloud;

import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessAuthenticationTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private CloudProvider provider;
    private String initialAccount;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessAuthenticationTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        this.initialAccount = System.getProperty("accountNumber");
        this.provider = this.name.getMethodName().equals("invalidPassword") ? DaseinTestManager.constructProvider(null, null, "ThisCannotPossiblyBeASecretKey") : (this.name.getMethodName().equals("invalidAccount") ? DaseinTestManager.constructProvider("MyWibblesAreTribbles", null, null) : (this.name.getMethodName().equals("invalidSharedKey") ? DaseinTestManager.constructProvider(null, "MyWibblesAreTribbles", null) : DaseinTestManager.constructProvider()));
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void authenticate() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        String id = tm.getProvider().testContext();
        tm.out("Account", id);
        Assert.assertNotNull((String)"Connection test failed", (Object)id);
    }

    @Test
    public void invalidPassword() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        Assert.assertNull((String)"Connection succeeded with bad API secret", (Object)this.provider.testContext());
    }

    @Test
    public void invalidSharedKey() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        Assert.assertNull((String)"Connection succeeded with fake account", (Object)this.provider.testContext());
    }

    @Test
    public void invalidAccount() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        String accountNumber = this.provider.testContext();
        Assume.assumeNotNull((Object[])new Object[]{accountNumber});
        Assert.assertEquals((String)"Returned account number is not the same as the configured one", (Object)accountNumber, (Object)this.initialAccount);
    }
}

