/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.cloud;

import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.dc.ResourcePool;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatelessDCTests {
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String testDataCenterId;
    private String testResourcePoolId;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatelessDCTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        try {
            DataCenterServices services = tm.getProvider().getDataCenterServices();
            for (DataCenter dc : services.listDataCenters(tm.getContext().getRegionId())) {
                if (this.testDataCenterId != null && !dc.isActive()) continue;
                this.testDataCenterId = dc.getProviderDataCenterId();
            }
            if (this.name.getMethodName().contains("Pool") && services.getCapabilities().supportsResourcePools() && this.testDataCenterId != null) {
                for (ResourcePool rp : services.listResourcePools(this.testDataCenterId)) {
                    if (this.testResourcePoolId != null) continue;
                    this.testResourcePoolId = rp.getProvideResourcePoolId();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @After
    public void after() {
        tm.end();
    }

    @Test
    public void configuration() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        tm.out("DC Services", services);
        Assert.assertNotNull((String)"Data center services must be implemented for all clouds", (Object)services);
    }

    @Test
    public void checkMetaData() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        tm.out("Term for Region", services.getCapabilities().getProviderTermForRegion(Locale.getDefault()));
        tm.out("Term for DataCenter", services.getCapabilities().getProviderTermForDataCenter(Locale.getDefault()));
        Assert.assertNotNull((String)"The provider term for region may not be null", (Object)services.getCapabilities().getProviderTermForRegion(Locale.getDefault()));
        Assert.assertNotNull((String)"The provider term for data center may not be null", (Object)services.getCapabilities().getProviderTermForDataCenter(Locale.getDefault()));
    }

    @Test
    public void getBogusRegion() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        Region region = services.getRegion(UUID.randomUUID().toString());
        tm.out("Bogus Region", region);
        Assert.assertNull((String)"Dummy region must be null, but one was found", (Object)region);
    }

    @Test
    public void getRegion() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        Region region = services.getRegion(tm.getContext().getRegionId());
        tm.out("Region", region);
        Assert.assertNotNull((String)"Failed to find the region associated with the current operational context", (Object)region);
    }

    @Test
    public void regionContent() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        Region region = services.getRegion(tm.getContext().getRegionId());
        Assert.assertNotNull((String)"Failed to find the region associated with the current operational context", (Object)region);
        tm.out("Region ID", region.getProviderRegionId());
        tm.out("Active", region.isActive());
        tm.out("Available", region.isAvailable());
        tm.out("Name", region.getName());
        tm.out("Jurisdiction", region.getJurisdiction());
        Assert.assertNotNull((String)"Region ID may not be null", (Object)region.getProviderRegionId());
        Assert.assertNotNull((String)"Region name may not be null", (Object)region.getName());
        Assert.assertNotNull((String)"Region jurisdiction may not be null", (Object)region.getJurisdiction());
    }

    @Test
    public void listRegions() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        Collection regions = services.listRegions();
        boolean found = false;
        int count = 0;
        Assert.assertNotNull((String)"Null set of regions returned from listRegions()", (Object)regions);
        for (Region region : regions) {
            ++count;
            tm.out("Region", region);
            if (!region.getProviderRegionId().equals(tm.getContext().getRegionId())) continue;
            found = true;
        }
        tm.out("Total Region Count", count);
        Assert.assertTrue((String)"There must be at least one region", (count > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Did not find the context region ID among returned regions", (boolean)found);
    }

    @Test
    public void getBogusDataCenter() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        DataCenter dc = services.getDataCenter(UUID.randomUUID().toString());
        tm.out("Bogus Data Center", dc);
        Assert.assertNull((String)"Dummy data center must be null, but one was found", (Object)dc);
    }

    @Test
    public void getDataCenter() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        DataCenter dc = services.getDataCenter(this.testDataCenterId);
        tm.out("Data Center", dc);
        Assert.assertNotNull((String)"Failed to find the test data center", (Object)dc);
    }

    @Test
    public void dataCenterContent() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        DataCenter dc = services.getDataCenter(this.testDataCenterId);
        Assert.assertNotNull((String)"Failed to find the test data center", (Object)dc);
        tm.out("Data Center ID", dc.getProviderDataCenterId());
        tm.out("Active", dc.isActive());
        tm.out("Available", dc.isAvailable());
        tm.out("Name", dc.getName());
        tm.out("Region ID", dc.getRegionId());
        Assert.assertNotNull((String)"Data center ID must not be null", (Object)dc.getProviderDataCenterId());
        Assert.assertNotNull((String)"Data center name must not be null", (Object)dc.getName());
        Assert.assertEquals((String)"Data center should be in the current region", (Object)tm.getContext().getRegionId(), (Object)dc.getRegionId());
    }

    @Test
    public void listDataCenters() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        Collection dataCenters = services.listDataCenters(tm.getContext().getRegionId());
        boolean found = false;
        int count = 0;
        Assert.assertNotNull((String)"Null set of data centers returned from listDataCenters()", (Object)dataCenters);
        for (DataCenter dc : dataCenters) {
            ++count;
            tm.out("Data Center", dc);
            if (!dc.getProviderDataCenterId().equals(this.testDataCenterId)) continue;
            found = true;
        }
        tm.out("Total Data Center Count", count);
        Assert.assertTrue((String)"There must be at least one data center in this region", (count > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Did not find the test data center ID among returned data centers", (boolean)found);
    }

    @Test
    public void regionIntegrity() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        for (Region region : services.listRegions()) {
            if (!region.isActive()) continue;
            int count = 0;
            for (DataCenter dc : services.listDataCenters(region.getProviderRegionId())) {
                if (!dc.isActive()) continue;
                ++count;
            }
            tm.out("Data Centers in " + region, count);
            Assert.assertTrue((String)("An active region must have at least one active data center; " + region.getProviderRegionId() + " has none"), (count > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void getBogusResourcePool() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        if (services.getCapabilities().supportsResourcePools()) {
            ResourcePool rp = services.getResourcePool(UUID.randomUUID().toString());
            tm.out("Bogus Resource pool", rp);
            Assert.assertNull((String)"Dummy resource pool must be null, but one was found", (Object)rp);
        } else {
            tm.ok("Resource pools not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void getResourcePool() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        if (this.testResourcePoolId != null) {
            ResourcePool rp = services.getResourcePool(this.testResourcePoolId);
            tm.out("Resource Pool", rp + " [" + rp.getProvideResourcePoolId() + "]");
            Assert.assertNotNull((String)"Failed to find the test resource pool", (Object)rp);
        } else if (services.getCapabilities().supportsResourcePools()) {
            Assert.fail((String)"No test resource pool exists and thus no test for getResourcePool could be run");
        } else {
            tm.ok("Resource pools not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void resourcePoolContent() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        if (this.testResourcePoolId != null) {
            ResourcePool rp = services.getResourcePool(this.testResourcePoolId);
            Assert.assertNotNull((String)"Failed to find the test resource pool", (Object)rp);
            tm.out("Resource Pool ID", rp.getProvideResourcePoolId());
            tm.out("Name", rp.getName());
            tm.out("Data center ID", rp.getDataCenterId());
            tm.out("Available", rp.isAvailable());
            Assert.assertNotNull((String)"Resource Pool ID must not be null", (Object)rp.getProvideResourcePoolId());
            Assert.assertNotNull((String)"Resource Pool name must not be null", (Object)rp.getName());
            Assert.assertNotNull((String)"Data center id must not be null", (Object)rp.getDataCenterId());
        } else if (services.getCapabilities().supportsResourcePools()) {
            Assert.fail((String)"No test resource pool exists and thus no test for getResourcePool could be run");
        } else {
            tm.ok("Resource pools not supported in " + tm.getProvider().getCloudName());
        }
    }

    @Test
    public void listResourcePools() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        DataCenterServices services = tm.getProvider().getDataCenterServices();
        if (services.getCapabilities().supportsResourcePools()) {
            Collection resourcePools = services.listResourcePools(this.testDataCenterId);
            boolean found = false;
            int count = 0;
            Assert.assertNotNull((String)"Null set of resource pools returned from listResourcePools()", (Object)resourcePools);
            for (ResourcePool resourcePool : resourcePools) {
                ++count;
                tm.out("Resource Pool", resourcePool + " [" + resourcePool.getProvideResourcePoolId() + "]");
                if (!resourcePool.getProvideResourcePoolId().equals(this.testResourcePoolId)) continue;
                found = true;
            }
            tm.out("Total Resource Pool Count", count);
            Assert.assertTrue((String)"There must be at least one Resource Pool in this datacenter", (count > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Did not find the test Resource Pool ID among returned Resource Pools", (boolean)found);
        } else {
            tm.ok("Resource pools not supported in " + tm.getProvider().getCloudName());
        }
    }
}

