/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.SnapshotCreateOptions;
import org.dasein.cloud.compute.SnapshotState;
import org.dasein.cloud.compute.SnapshotSupport;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineProductFilterOptions;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeSupport;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.SubnetCreateOptions;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.test.DaseinTestManager;
import org.dasein.cloud.test.identity.IdentityResources;
import org.dasein.cloud.test.network.NetworkResources;
import org.dasein.util.uom.storage.Storage;

public class ComputeResources {
    private static final Logger logger = Logger.getLogger(ComputeResources.class);
    private static final Random random = new Random();
    private CloudProvider provider;
    private final Map<String, String> testMachineImages = new HashMap<String, String>();
    private final Map<String, String> testSnapshots = new HashMap<String, String>();
    private final Map<String, String> testVMs = new HashMap<String, String>();
    private final Map<String, String> testVolumes = new HashMap<String, String>();
    private String testDataCenterId;
    private Platform testImagePlatform;
    private String testVMProductId;
    private String testVolumeProductId;

    public ComputeResources(@Nonnull CloudProvider provider) {
        this.provider = provider;
    }

    public int report() {
        boolean header = false;
        int count = 0;
        this.testMachineImages.remove("stateless");
        if (!this.testMachineImages.isEmpty()) {
            logger.info((Object)"Provisioned Compute Resources:");
            header = true;
            count += this.testMachineImages.size();
            DaseinTestManager.out(logger, null, "---> Machine Images", this.testMachineImages.size() + " " + this.testMachineImages);
        }
        this.testSnapshots.remove("stateless");
        if (!this.testSnapshots.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Compute Resources:");
                header = true;
            }
            count += this.testSnapshots.size();
            DaseinTestManager.out(logger, null, "---> Snapshots", this.testSnapshots.size() + " " + this.testSnapshots);
        }
        this.testVMs.remove("stateless");
        if (!this.testVMs.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Compute Resources:");
                header = true;
            }
            count += this.testVMs.size();
            DaseinTestManager.out(logger, null, "---> Virtual Machines", this.testVMs.size() + " " + this.testVMs);
        }
        this.testVolumes.remove("stateless");
        if (!this.testVolumes.isEmpty()) {
            if (!header) {
                logger.info((Object)"Provisioned Compute Resources:");
            }
            count += this.testVolumes.size();
            DaseinTestManager.out(logger, null, "---> Volumes", this.testVolumes.size() + " " + this.testVolumes);
        }
        return count;
    }

    public int close() {
        ComputeServices computeServices = this.provider.getComputeServices();
        int count = 0;
        if (computeServices != null) {
            VolumeSupport volumeSupport;
            SnapshotSupport snapshotSupport;
            MachineImageSupport imageSupport;
            VirtualMachineSupport vmSupport = computeServices.getVirtualMachineSupport();
            if (vmSupport != null) {
                for (Map.Entry<String, String> entry : this.testVMs.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        VirtualMachine vm = vmSupport.getVirtualMachine(entry.getValue());
                        if (vm != null) {
                            vmSupport.terminate(entry.getValue());
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to de-provision test VM " + entry.getValue() + ": " + t.getMessage()));
                    }
                }
            }
            if ((imageSupport = computeServices.getImageSupport()) != null) {
                for (Map.Entry<String, String> entry : this.testMachineImages.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        MachineImage img = imageSupport.getImage(entry.getValue());
                        if (img != null) {
                            imageSupport.remove(entry.getValue());
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to de-provision test image " + entry.getValue() + ": " + t.getMessage()));
                    }
                }
            }
            if ((snapshotSupport = computeServices.getSnapshotSupport()) != null) {
                for (Map.Entry<String, String> entry : this.testSnapshots.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        Snapshot snapshot = snapshotSupport.getSnapshot(entry.getValue());
                        if (snapshot != null) {
                            snapshotSupport.remove(entry.getValue());
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to de-provision test snapshot " + entry.getValue() + " post-test: " + t.getMessage()));
                    }
                }
            }
            if ((volumeSupport = computeServices.getVolumeSupport()) != null) {
                Volume volume;
                for (Map.Entry<String, String> entry : this.testVolumes.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        volume = volumeSupport.getVolume(entry.getValue());
                        if (volume == null) continue;
                        volumeSupport.detach(entry.getValue(), true);
                    }
                    catch (Throwable ignore) {}
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                for (Map.Entry<String, String> entry : this.testVolumes.entrySet()) {
                    if (entry.getKey().equals("stateless")) continue;
                    try {
                        volume = volumeSupport.getVolume(entry.getValue());
                        if (volume != null) {
                            volumeSupport.remove(entry.getValue());
                            ++count;
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to de-provision test volume " + entry.getValue() + ": " + t.getMessage()));
                    }
                }
            }
        }
        return count;
    }

    @Nullable
    private String findStatelessSnapshot() {
        ComputeServices computeServices = this.provider.getComputeServices();
        if (computeServices != null) {
            SnapshotSupport support = computeServices.getSnapshotSupport();
            try {
                if (support != null && support.isSubscribed()) {
                    Snapshot defaultSnapshot = null;
                    for (Snapshot snapshot : support.listSnapshots()) {
                        if (snapshot.getCurrentState().equals((Object)SnapshotState.AVAILABLE)) {
                            defaultSnapshot = snapshot;
                            break;
                        }
                        if (defaultSnapshot != null) continue;
                        defaultSnapshot = snapshot;
                    }
                    if (defaultSnapshot != null) {
                        String id = defaultSnapshot.getProviderSnapshotId();
                        if (id != null) {
                            this.testSnapshots.put("stateless", id);
                        }
                        return id;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String getTestDataCenterId(boolean stateless) {
        if (this.testDataCenterId != null) {
            return this.testDataCenterId;
        }
        if (stateless) {
            try {
                DataCenter defaultDC = null;
                for (DataCenter dc : this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId())) {
                    if (defaultDC == null) {
                        defaultDC = dc;
                    }
                    if (!dc.isActive() || !dc.isAvailable()) continue;
                    return dc.getProviderDataCenterId();
                }
                if (defaultDC != null) {
                    return defaultDC.getProviderDataCenterId();
                }
            }
            catch (Throwable ignore) {}
        } else {
            VirtualMachineSupport support;
            ComputeServices services = this.provider.getComputeServices();
            if (services != null && (support = services.getVirtualMachineSupport()) != null) {
                try {
                    String id = this.provisionVM(support, "stateful", "Dasein Stateless VM", "dsnstfvm", null);
                    VirtualMachine vm = support.getVirtualMachine(id);
                    if (vm != null) {
                        this.testDataCenterId = vm.getProviderDataCenterId();
                        return this.testDataCenterId;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    public String getTestImageId(@Nonnull String label, boolean provisionIfNull) {
        String id = this.testMachineImages.get(label);
        if (id == null) {
            MachineImageSupport support;
            ComputeServices services;
            if (label.equals("stateless")) {
                for (Map.Entry<String, String> entry : this.testMachineImages.entrySet()) {
                    if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                    return id;
                }
                return null;
            }
            if (provisionIfNull && (services = this.provider.getComputeServices()) != null && (support = services.getImageSupport()) != null) {
                try {
                    return this.provisionImage(support, label, "dsnimg", null);
                }
                catch (Throwable ignore) {
                    return null;
                }
            }
        }
        return id;
    }

    @Nullable
    public String getTestSnapshotId(@Nonnull String label, boolean provisionIfNull) {
        SnapshotSupport support;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testSnapshots.entrySet()) {
                String id;
                if (entry.getKey().startsWith("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return this.findStatelessSnapshot();
        }
        String id = this.testSnapshots.get(label);
        if (id != null) {
            return id;
        }
        if (!provisionIfNull) {
            return null;
        }
        ComputeServices services = this.provider.getComputeServices();
        if (services != null && (support = services.getSnapshotSupport()) != null) {
            try {
                return this.provisionSnapshot(support, label, "dsnsnap" + System.currentTimeMillis() % 10000L, null);
            }
            catch (Throwable ignore) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public String getTestVmId(@Nonnull String label, @Nullable VmState desiredState, boolean provisionIfNull, @Nullable String preferredDataCenterId) {
        return this.getTestVmId(label, "dsnvm", desiredState, provisionIfNull, preferredDataCenterId);
    }

    @Nullable
    public String getTestVmId(@Nonnull String label, @Nonnull String vmName, @Nullable VmState desiredState, boolean provisionIfNull, @Nullable String preferredDataCenterId) {
        VirtualMachineSupport support;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testVMs.entrySet()) {
                String id;
                if (entry.getKey().startsWith("removed") || (id = entry.getValue()) == null) continue;
                try {
                    VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(id);
                    if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState())) continue;
                    return id;
                }
                catch (Throwable ignore) {
                }
            }
            return null;
        }
        String id = this.testVMs.get(label);
        if (id == null && !provisionIfNull) {
            return null;
        }
        ComputeServices services = this.provider.getComputeServices();
        if (services != null && (support = services.getVirtualMachineSupport()) != null) {
            try {
                VirtualMachine vm;
                VirtualMachine virtualMachine = vm = id == null ? null : support.getVirtualMachine(id);
                if ((vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState())) && provisionIfNull) {
                    id = this.provisionVM(support, label, "testvm-" + label, vmName, preferredDataCenterId);
                    vm = support.getVirtualMachine(id);
                }
                if (vm != null && desiredState != null) {
                    this.setState(support, vm, desiredState);
                }
                return id;
            }
            catch (Throwable t) {
                try {
                    if (support.isSubscribed()) {
                        logger.warn((Object)("Unable to provision test virtual machine under label " + label + ": " + t.getMessage()));
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    public String getTestVLANVmId(@Nonnull String label, @Nullable VmState desiredState, @Nullable String vlanId, boolean provisionIfNull, @Nullable String preferredDataCenterId) {
        VirtualMachineSupport support;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testVMs.entrySet()) {
                String id;
                if (entry.getKey().startsWith("removed") || (id = entry.getValue()) == null) continue;
                try {
                    VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(id);
                    if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState()) || vm.getProviderVlanId() == null) continue;
                    if (vlanId == null) {
                        return id;
                    }
                    if (!vm.getProviderVlanId().equalsIgnoreCase(vlanId)) continue;
                    return id;
                }
                catch (Throwable ignore) {
                }
            }
            return null;
        }
        String id = this.testVMs.get(label);
        if (id == null && !provisionIfNull) {
            return null;
        }
        ComputeServices services = this.provider.getComputeServices();
        if (services != null && (support = services.getVirtualMachineSupport()) != null) {
            try {
                VirtualMachine vm;
                VirtualMachine virtualMachine = vm = id == null ? null : support.getVirtualMachine(id);
                if ((vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState()) || vm.getProviderVlanId() == null || !vm.getProviderVlanId().equalsIgnoreCase(vlanId)) && provisionIfNull) {
                    String testImageId = this.getTestImageId("stateless", false);
                    if (testImageId == null) {
                        throw new CloudException("No test image exists for provisioning a virtual machine");
                    }
                    long now = System.currentTimeMillis();
                    String name = "dasein-test-" + label + " " + now;
                    String host = "dsnvm" + now % 10000L;
                    VMLaunchOptions vmOpts = VMLaunchOptions.getInstance((String)this.testVMProductId, (String)testImageId, (String)name, (String)host, (String)"Test VM for stateful integration tests for Dasein Cloud").withExtendedAnalytics();
                    NetworkResources network = DaseinTestManager.getNetworkResources();
                    if (vlanId != null) {
                        NetworkServices ns = this.provider.getNetworkServices();
                        VLANSupport vs = ns.getVlanSupport();
                        VLAN v = vs.getVlan(vlanId);
                        Iterable subnets = vs.listSubnets(vlanId);
                        if (subnets.iterator().hasNext()) {
                            Subnet sub = (Subnet)subnets.iterator().next();
                            vmOpts.inSubnet(null, v.getProviderDataCenterId(), sub.getProviderVlanId(), sub.getProviderSubnetId());
                        } else {
                            Subnet sub = vs.createSubnet(SubnetCreateOptions.getInstance((String)vlanId, (String)"192.168.50.0/24", (String)"dsnsub", (String)"dasein test create vm for vlan"));
                            vmOpts.inSubnet(null, v.getProviderDataCenterId(), sub.getProviderVlanId(), sub.getProviderSubnetId());
                        }
                    } else if (network != null) {
                        String networkId = network.getTestVLANId("stateful", true, preferredDataCenterId);
                        if (networkId == null) {
                            networkId = network.getTestVLANId("stateless", false, preferredDataCenterId);
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        if (networkId != null) {
                            String subnetId = network.getTestSubnetId("stateful", true, networkId, preferredDataCenterId);
                            if (subnetId == null) {
                                subnetId = network.getTestSubnetId("stateless", true, networkId, preferredDataCenterId);
                            }
                            if (subnetId != null) {
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                                Subnet subnet = this.provider.getNetworkServices().getVlanSupport().getSubnet(subnetId);
                                if (subnet != null) {
                                    String dcId = subnet.getProviderDataCenterId();
                                    if (dcId == null) {
                                        for (DataCenter dc : this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId())) {
                                            if ((!dc.isActive() || !dc.isAvailable()) && dcId != null) continue;
                                            dcId = dc.getProviderDataCenterId();
                                        }
                                    }
                                    vmOpts.inSubnet(null, dcId, vlanId, subnetId);
                                }
                            }
                        }
                    }
                    id = this.provisionVM(support, label, vmOpts, preferredDataCenterId);
                    vm = support.getVirtualMachine(id);
                }
                if (vm != null && desiredState != null) {
                    this.setState(support, vm, desiredState);
                }
                if (vlanId != null && vm.getProviderVlanId().equalsIgnoreCase(vlanId) && id != null) {
                    return id;
                }
                if (vlanId == null && id != null) {
                    return id;
                }
                return null;
            }
            catch (Throwable t) {
                try {
                    if (support.isSubscribed()) {
                        logger.warn((Object)("Unable to provision test virtual machine under label " + label + ": " + t.getMessage()));
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    public String getTestVMProductId() {
        return this.testVMProductId;
    }

    @Nullable
    public String getTestVolumeId(@Nonnull String label, boolean provisionIfNull, @Nullable VolumeFormat desiredFormat, @Nullable String preferredDataCenterId) {
        VolumeSupport support;
        ComputeServices services;
        if (label.equals("stateless")) {
            for (Map.Entry<String, String> entry : this.testVolumes.entrySet()) {
                String id;
                if (entry.getKey().equals("removed") || (id = entry.getValue()) == null) continue;
                return id;
            }
            return null;
        }
        String id = this.testVolumes.get(label);
        if (id != null) {
            return id;
        }
        if (provisionIfNull && (services = this.provider.getComputeServices()) != null && (support = services.getVolumeSupport()) != null) {
            try {
                return this.provisionVolume(support, label, "dsnvol" + System.currentTimeMillis() % 10000L, desiredFormat, preferredDataCenterId);
            }
            catch (Throwable ignore) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public String getTestVolumeProductId() {
        return this.testVolumeProductId;
    }

    public void init() {
        try {
            this.testDataCenterId = System.getProperty("test.dataCenter");
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        ComputeServices computeServices = this.provider.getComputeServices();
        String dataCenterId = System.getProperty("test.dataCenter");
        if (computeServices != null) {
            VolumeSupport volumeSupport;
            MachineImageSupport imageSupport;
            HashMap<Architecture, VirtualMachineProduct> productMap = new HashMap<Architecture, VirtualMachineProduct>();
            VirtualMachineSupport vmSupport = computeServices.getVirtualMachineSupport();
            if (vmSupport != null) {
                try {
                    for (Architecture architecture : Architecture.values()) {
                        VirtualMachineProduct defaultProduct = null;
                        try {
                            VirtualMachineProductFilterOptions options = VirtualMachineProductFilterOptions.getInstance().withDatacenterId(dataCenterId);
                            for (VirtualMachineProduct product : vmSupport.listProducts(options, architecture)) {
                                if (defaultProduct == null) {
                                    defaultProduct = product;
                                    continue;
                                }
                                if (defaultProduct.getRamSize().intValue() > product.getRamSize().intValue()) {
                                    if (product.getRamSize().intValue() <= 1000) continue;
                                    defaultProduct = product;
                                    continue;
                                }
                                if (defaultProduct.getRamSize().intValue() < 1024 && product.getRamSize().intValue() < 2200) {
                                    defaultProduct = product;
                                    continue;
                                }
                                if (defaultProduct.getCpuCount() <= product.getCpuCount() || defaultProduct.getRamSize().intValue() * 2 <= product.getRamSize().intValue()) continue;
                                defaultProduct = product;
                            }
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        productMap.put(architecture, defaultProduct);
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if ((imageSupport = computeServices.getImageSupport()) != null) {
                boolean volumeBased = false;
                try {
                    for (MachineImageType type : imageSupport.getCapabilities().listSupportedImageTypes()) {
                        if (!type.equals((Object)MachineImageType.VOLUME)) continue;
                        volumeBased = true;
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                for (Architecture architecture : new Architecture[]{Architecture.I64, Architecture.POWER, Architecture.I32, Architecture.SPARC}) {
                    VirtualMachineProduct currentProduct = (VirtualMachineProduct)productMap.get(architecture);
                    if (currentProduct == null) continue;
                    block22: for (Platform platform : new Platform[]{Platform.WINDOWS, Platform.UBUNTU, Platform.CENT_OS, Platform.RHEL}) {
                        ImageFilterOptions options = ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).withArchitecture(architecture).onPlatform(platform);
                        try {
                            for (MachineImage image : imageSupport.listImages(options)) {
                                if (!MachineImageState.ACTIVE.equals((Object)image.getCurrentState()) || !"".equals(image.getSoftware())) continue;
                                this.testVMProductId = currentProduct.getProviderProductId();
                                this.testMachineImages.put("stateless", image.getProviderMachineImageId());
                                this.testImagePlatform = image.getPlatform();
                                if (volumeBased && !image.getType().equals((Object)MachineImageType.VOLUME)) continue;
                                break;
                            }
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        if (this.testVMProductId != null) break;
                        options = ImageFilterOptions.getInstance((ImageClass)ImageClass.MACHINE).withArchitecture(architecture).onPlatform(platform);
                        try {
                            for (MachineImage image : imageSupport.searchPublicImages(options)) {
                                if (!MachineImageState.ACTIVE.equals((Object)image.getCurrentState()) || !"".equals(image.getSoftware())) continue;
                                this.testVMProductId = currentProduct.getProviderProductId();
                                this.testMachineImages.put("stateless", image.getProviderMachineImageId());
                                this.testImagePlatform = image.getPlatform();
                                if (volumeBased && !image.getType().equals((Object)MachineImageType.VOLUME)) continue;
                                continue block22;
                            }
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    if (this.testVMProductId != null) break;
                }
            }
            if ((volumeSupport = computeServices.getVolumeSupport()) != null) {
                try {
                    VolumeProduct defaultProduct = null;
                    for (VolumeProduct product : volumeSupport.listVolumeProducts()) {
                        if (defaultProduct == null) {
                            defaultProduct = product;
                            continue;
                        }
                        if (volumeSupport.getCapabilities().isVolumeSizeDeterminedByProduct()) {
                            if (product.getVolumeSize().intValue() >= defaultProduct.getVolumeSize().intValue() || product.getVolumeSize().intValue() < 20) continue;
                            defaultProduct = product;
                            continue;
                        }
                        if (!((double)product.getMonthlyGigabyteCost().floatValue() > 0.0) || !(product.getMonthlyGigabyteCost().floatValue() < defaultProduct.getMonthlyGigabyteCost().floatValue())) continue;
                        defaultProduct = product;
                    }
                    if (defaultProduct != null) {
                        this.testVolumeProductId = defaultProduct.getProviderProductId();
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (vmSupport != null) {
                try {
                    for (VirtualMachine vm : vmSupport.listVirtualMachines()) {
                        if (!vm.getProviderDataCenterId().equals(dataCenterId) || !VmState.RUNNING.equals((Object)vm.getCurrentState())) continue;
                        this.testVMs.put("stateless", vm.getProviderVirtualMachineId());
                        break;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (volumeSupport != null) {
                try {
                    Volume defaultVolume = null;
                    for (Volume volume : volumeSupport.listVolumes()) {
                        if (!volume.getProviderDataCenterId().equals(dataCenterId) || !VolumeState.AVAILABLE.equals((Object)volume.getCurrentState()) && defaultVolume != null) continue;
                        if (defaultVolume == null || volume.isAttached()) {
                            defaultVolume = volume;
                        }
                        if (!VolumeState.AVAILABLE.equals((Object)defaultVolume.getCurrentState()) || !defaultVolume.isAttached()) continue;
                        break;
                    }
                    if (defaultVolume != null) {
                        this.testVolumes.put("stateless", defaultVolume.getProviderVolumeId());
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionImage(@Nonnull MachineImageSupport support, @Nonnull String label, @Nonnull String namePrefix, @Nullable String vmId) throws CloudException, InternalException {
        VirtualMachineSupport vmSupport = null;
        ComputeServices services = this.provider.getComputeServices();
        if (services != null) {
            vmSupport = services.getVirtualMachineSupport();
        }
        if (vmSupport == null) {
            throw new CloudException("Unable to provisionKeypair a machine image because Dasein Cloud is showing no VM support");
        }
        if (vmId == null && (vmId = this.getTestVmId("stateful", VmState.RUNNING, true, null)) == null) {
            throw new CloudException("Could not identify a VM for imaging");
        }
        VirtualMachine vm = vmSupport.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("Could not identify a VM for imaging");
        }
        String imageId = vm.getProviderMachineImageId();
        MachineImage image = support.getImage(imageId);
        if (image == null || support.getCapabilities().supportsImageCapture(image.getType())) {
            String id = ImageCreateOptions.getInstance((VirtualMachine)vm, (String)(namePrefix + System.currentTimeMillis() % 10000L), (String)("Test machine image with label " + label)).build(this.provider);
            Map<String, String> map = this.testMachineImages;
            synchronized (map) {
                while (this.testMachineImages.containsKey(label)) {
                    label = label + random.nextInt(9);
                }
                this.testMachineImages.put(label, id);
            }
            return id;
        }
        if (!support.getCapabilities().identifyLocalBundlingRequirement().equals((Object)Requirement.REQUIRED)) {
            MachineImageFormat format;
            Iterator formats = support.getCapabilities().listSupportedFormatsForBundling().iterator();
            MachineImageFormat machineImageFormat = format = formats.hasNext() ? (MachineImageFormat)formats.next() : null;
            if (format != null) {
                String id = support.bundleVirtualMachine(vmId, format, "dsnimg" + System.currentTimeMillis() % 100000L, "dsnimg");
                Map<String, String> map = this.testMachineImages;
                synchronized (map) {
                    while (this.testMachineImages.containsKey(label)) {
                        label = label + random.nextInt(9);
                    }
                    this.testMachineImages.put(label, id);
                }
                return id;
            }
        }
        throw new CloudException("No mechanism exists for provisioning images from a virtual machine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionSnapshot(@Nonnull SnapshotSupport support, @Nonnull String label, @Nonnull String namePrefix, @Nullable String volumeId) throws CloudException, InternalException {
        SnapshotCreateOptions options;
        String id;
        if (volumeId == null && (volumeId = this.getTestVolumeId("stateful" + System.currentTimeMillis() % 1000L, true, null, null)) == null) {
            throw new CloudException("No volume from which to create a snapshot");
        }
        VolumeSupport vs = this.provider.getComputeServices().getVolumeSupport();
        if (vs != null) {
            VirtualMachine vm;
            String vmId;
            Volume volume = vs.getVolume(volumeId);
            if (volume != null) {
                long timeout = System.currentTimeMillis() + 1200000L;
                while (timeout > System.currentTimeMillis()) {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    try {
                        volume = vs.getVolume(volumeId);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    if (volume != null && !volume.getCurrentState().equals((Object)VolumeState.AVAILABLE) && !volume.getCurrentState().equals((Object)VolumeState.DELETED)) continue;
                }
            }
            if (volume != null && volume.getProviderVirtualMachineId() == null && support.getCapabilities().identifyAttachmentRequirement().equals((Object)Requirement.REQUIRED) && (vmId = this.getTestVmId("stateful", VmState.RUNNING, true, volume.getProviderDataCenterId())) != null && (vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId)) != null) {
                for (String deviceId : vs.getCapabilities().listPossibleDeviceIds(vm.getPlatform())) {
                    try {
                        vs.attach(volumeId, vmId, deviceId);
                        break;
                    }
                    catch (Throwable ignore) {
                    }
                }
            }
        }
        if ((id = (options = SnapshotCreateOptions.getInstanceForCreate((String)volumeId, (String)(namePrefix + System.currentTimeMillis() % 10000L), (String)("Dasein Snapshot Test " + label))).build(this.provider)) == null) {
            throw new CloudException("Unable to create a snapshot");
        }
        Map<String, String> map = this.testSnapshots;
        synchronized (map) {
            while (this.testSnapshots.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testSnapshots.put(label, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<String> provisionManyVMs(@Nonnull VirtualMachineSupport support, @Nonnull String label, @Nonnull VMLaunchOptions options, @Nullable String preferredDataCenter, int count) throws CloudException, InternalException {
        String ipId;
        NetworkResources network;
        String keypairId;
        IdentityResources identity;
        if (preferredDataCenter != null) {
            options.inDataCenter(preferredDataCenter);
        }
        if (options.getBootstrapUser() == null && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyPasswordRequirement(this.testImagePlatform))) {
            options.withBootstrapUser("dasein", "x" + random.nextInt(100000) + System.currentTimeMillis());
        }
        if (options.getBootstrapKey() == null && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyShellKeyRequirement(this.testImagePlatform)) && (identity = DaseinTestManager.getIdentityResources()) != null && (keypairId = identity.getTestKeypairId("stateful", true)) != null) {
            options.withBoostrapKey(keypairId);
        }
        if (options.getVlanId() == null && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyVlanRequirement()) && (network = DaseinTestManager.getNetworkResources()) != null) {
            String networkId = network.getTestVLANId("stateful", true, preferredDataCenter);
            if (networkId == null) {
                networkId = network.getTestVLANId("stateless", false, preferredDataCenter);
            }
            String subnetId = network.getTestSubnetId("stateful", true, networkId, preferredDataCenter);
            try {
                if (networkId != null || subnetId != null) {
                    String dcId;
                    if (subnetId != null) {
                        Subnet subnet = this.provider.getNetworkServices().getVlanSupport().getSubnet(subnetId);
                        if (subnet != null) {
                            dcId = subnet.getProviderDataCenterId();
                            if (dcId == null) {
                                for (DataCenter dc : this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId())) {
                                    if ((!dc.isActive() || !dc.isAvailable()) && dcId != null) continue;
                                    dcId = dc.getProviderDataCenterId();
                                }
                            }
                            options.inSubnet(null, dcId, networkId, subnetId);
                        }
                    } else {
                        VLAN vlan = this.provider.getNetworkServices().getVlanSupport().getVlan(networkId);
                        if (vlan != null) {
                            dcId = vlan.getProviderDataCenterId();
                            if (dcId == null) {
                                DataCenter dc;
                                Iterator i$ = this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId()).iterator();
                                while (!(!i$.hasNext() || ((dc = (DataCenter)i$.next()).isActive() && dc.isAvailable() || dcId == null) && (dcId = dc.getProviderDataCenterId()).equals(preferredDataCenter))) {
                                }
                            }
                            options.inVlan(null, dcId, networkId);
                        }
                    }
                }
            }
            catch (NullPointerException ignore) {
                // empty catch block
            }
        }
        if (options.getStaticIpIds().length < 1 && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyStaticIPRequirement()) && (network = DaseinTestManager.getNetworkResources()) != null && (ipId = options.getVlanId() != null ? network.getTestStaticIpId(label, true, null, true, options.getVlanId()) : network.getTestStaticIpId(label, true, null, false, null)) != null) {
            options.withStaticIps(new String[]{ipId});
        }
        if (options.getRootVolumeProductId() == null && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyRootVolumeRequirement()) && this.testVolumeProductId != null) {
            options.withRootVolumeProduct(this.testVolumeProductId);
        }
        options.withMetaData("dsntestcase", (Object)"true");
        Iterable ids = options.buildMany(this.provider, count);
        for (String id : ids) {
            Map<String, String> map = this.testVMs;
            synchronized (map) {
                while (this.testVMs.containsKey(label)) {
                    label = label + random.nextInt(9);
                }
                this.testVMs.put(label, id);
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionVM(@Nonnull VirtualMachineSupport support, @Nonnull String label, @Nonnull VMLaunchOptions options, @Nullable String preferredDataCenter) throws CloudException, InternalException {
        String ipId;
        NetworkResources network;
        String keypairId;
        IdentityResources identity;
        if (preferredDataCenter != null) {
            options.inDataCenter(preferredDataCenter);
        }
        if (options.getBootstrapUser() == null && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyPasswordRequirement(this.testImagePlatform))) {
            options.withBootstrapUser("dasein", "x" + random.nextInt(100000) + System.currentTimeMillis());
        }
        if (options.getBootstrapKey() == null && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyShellKeyRequirement(this.testImagePlatform)) && (identity = DaseinTestManager.getIdentityResources()) != null && (keypairId = identity.getTestKeypairId("stateful", true)) != null) {
            options.withBootstrapKey(keypairId);
        }
        if (options.getVlanId() == null && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyVlanRequirement()) && (network = DaseinTestManager.getNetworkResources()) != null) {
            String networkId = network.getTestVLANId("stateful", true, preferredDataCenter);
            if (networkId == null) {
                networkId = network.getTestVLANId("stateless", false, preferredDataCenter);
            }
            String subnetId = network.getTestSubnetId("stateful", true, networkId, preferredDataCenter);
            try {
                if (networkId != null || subnetId != null) {
                    String dcId;
                    if (subnetId != null) {
                        Subnet subnet = this.provider.getNetworkServices().getVlanSupport().getSubnet(subnetId);
                        if (subnet != null) {
                            dcId = subnet.getProviderDataCenterId();
                            if (dcId == null) {
                                for (DataCenter dc : this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId())) {
                                    if ((!dc.isActive() || !dc.isAvailable()) && dcId != null) continue;
                                    dcId = dc.getProviderDataCenterId();
                                }
                            }
                            options.inSubnet(null, dcId, networkId, subnetId);
                        }
                    } else {
                        VLAN vlan = this.provider.getNetworkServices().getVlanSupport().getVlan(networkId);
                        if (vlan != null) {
                            dcId = vlan.getProviderDataCenterId();
                            if (dcId == null) {
                                if (preferredDataCenter != null) {
                                    dcId = preferredDataCenter;
                                } else {
                                    for (DataCenter dc : this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId())) {
                                        if ((!dc.isActive() || !dc.isAvailable()) && dcId != null) continue;
                                        dcId = dc.getProviderDataCenterId();
                                    }
                                }
                            }
                            options.inVlan(null, dcId, networkId);
                        }
                    }
                }
            }
            catch (NullPointerException ignore) {
                // empty catch block
            }
        }
        if (options.getStaticIpIds().length < 1 && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyStaticIPRequirement()) && (network = DaseinTestManager.getNetworkResources()) != null && (ipId = options.getVlanId() != null ? network.getTestStaticIpId(label, true, null, true, options.getVlanId()) : network.getTestStaticIpId(label, true, null, false, null)) != null) {
            options.withStaticIps(new String[]{ipId});
        }
        if (options.getRootVolumeProductId() == null && Requirement.REQUIRED.equals((Object)support.getCapabilities().identifyRootVolumeRequirement()) && this.testVolumeProductId != null) {
            options.withRootVolumeProduct(this.testVolumeProductId);
        }
        options.withMetaData("dsntestcase", (Object)"true");
        String id = options.build(this.provider);
        Map<String, String> map = this.testVMs;
        synchronized (map) {
            while (this.testVMs.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testVMs.put(label, id);
        }
        return id;
    }

    @Nonnull
    public String provisionVM(@Nonnull VirtualMachineSupport support, @Nonnull String label, @Nonnull String namePrefix, @Nonnull String hostPrefix, @Nullable String preferredDataCenter) throws CloudException, InternalException {
        String testImageId = this.getTestImageId("stateless", false);
        if (testImageId == null) {
            throw new CloudException("No test image exists for provisioning a virtual machine");
        }
        long now = System.currentTimeMillis();
        String name = namePrefix + "-" + now;
        String host = hostPrefix + now % 10000L;
        return this.provisionVM(support, label, VMLaunchOptions.getInstance((String)this.testVMProductId, (String)testImageId, (String)name, (String)host, (String)"Test VM for stateful integration tests for Dasein Cloud").withExtendedAnalytics(), preferredDataCenter);
    }

    @Nonnull
    public Iterable<String> provisionManyVMs(@Nonnull VirtualMachineSupport support, @Nonnull String label, @Nonnull String namePrefix, @Nonnull String hostPrefix, @Nullable String preferredDataCenter, int count) throws CloudException, InternalException {
        String testImageId = this.getTestImageId("stateless", false);
        if (testImageId == null) {
            throw new CloudException("No test image exists for provisioning a virtual machine");
        }
        long now = System.currentTimeMillis();
        String name = namePrefix + " " + now;
        String host = hostPrefix + now % 10000L;
        return this.provisionManyVMs(support, label, VMLaunchOptions.getInstance((String)this.testVMProductId, (String)testImageId, (String)name, (String)host, (String)"Test VM for stateful integration tests for Dasein Cloud").withExtendedAnalytics(), preferredDataCenter, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String provisionVolume(@Nonnull VolumeSupport support, @Nonnull String label, @Nonnull String namePrefix, @Nullable VolumeFormat desiredFormat, @Nullable String preferredDataCenterId) throws CloudException, InternalException {
        VolumeCreateOptions options;
        if (desiredFormat == null) {
            for (VolumeFormat fmt : support.getCapabilities().listSupportedFormats()) {
                if (!fmt.equals((Object)VolumeFormat.BLOCK)) continue;
                desiredFormat = VolumeFormat.BLOCK;
                break;
            }
            if (desiredFormat == null) {
                desiredFormat = VolumeFormat.NFS;
            }
        }
        if (support.getCapabilities().getVolumeProductRequirement().equals((Object)Requirement.REQUIRED) && this.testVolumeProductId != null) {
            Storage size;
            if (support.getCapabilities().isVolumeSizeDeterminedByProduct()) {
                VolumeProduct prd = null;
                for (VolumeProduct product : support.listVolumeProducts()) {
                    if (!product.getProviderProductId().equals(this.testVolumeProductId)) continue;
                    prd = product;
                    break;
                }
                if (prd != null) {
                    size = prd.getVolumeSize();
                    if (size == null) {
                        size = support.getCapabilities().getMinimumVolumeSize();
                    }
                } else {
                    size = support.getCapabilities().getMinimumVolumeSize();
                }
            } else {
                size = support.getCapabilities().getMinimumVolumeSize();
            }
            if (desiredFormat.equals((Object)VolumeFormat.BLOCK)) {
                options = VolumeCreateOptions.getInstance((String)this.testVolumeProductId, (Storage)size, (String)(namePrefix + System.currentTimeMillis() % 1000L), (String)"Dasein Cloud Integration Tests Volume Tests", (int)0);
            } else {
                NetworkResources network = DaseinTestManager.getNetworkResources();
                String testVlanId = null;
                if (network != null) {
                    testVlanId = network.getTestVLANId("stateless", false, preferredDataCenterId);
                }
                options = testVlanId != null ? VolumeCreateOptions.getNetworkInstance((String)this.testVolumeProductId, (String)testVlanId, (Storage)size, (String)(namePrefix + System.currentTimeMillis() % 10000L), (String)"Dasein Cloud Integration Tests Volume Tests", (int)0) : VolumeCreateOptions.getInstance((String)this.testVolumeProductId, (Storage)size, (String)(namePrefix + System.currentTimeMillis() % 1000L), (String)"Dasein Cloud Integration Tests Volume Tests", (int)0);
            }
        } else if (desiredFormat.equals((Object)VolumeFormat.BLOCK)) {
            options = VolumeCreateOptions.getInstance((Storage)support.getCapabilities().getMinimumVolumeSize(), (String)(namePrefix + System.currentTimeMillis() % 10000L), (String)"Dasein Test Integration tests volume");
        } else {
            NetworkResources network = DaseinTestManager.getNetworkResources();
            String testVlanId = null;
            if (network != null) {
                testVlanId = network.getTestVLANId("stateless", false, preferredDataCenterId);
            }
            options = testVlanId != null ? VolumeCreateOptions.getNetworkInstance((String)testVlanId, (Storage)support.getCapabilities().getMinimumVolumeSize(), (String)(namePrefix + System.currentTimeMillis() % 10000L), (String)"Dasein Cloud Integration Tests Volume Tests") : VolumeCreateOptions.getInstance((Storage)support.getCapabilities().getMinimumVolumeSize(), (String)(namePrefix + System.currentTimeMillis() % 1000L), (String)"Dasein Cloud Integration Tests Volume Tests");
        }
        if (preferredDataCenterId == null) {
            preferredDataCenterId = this.getTestDataCenterId(false);
        }
        if (preferredDataCenterId != null) {
            options.inDataCenter(preferredDataCenterId);
        }
        options.withMetaData("dsntestcase", (Object)"true");
        String id = options.build(this.provider);
        Volume volume = support.getVolume(id);
        if (volume != null && this.testDataCenterId == null) {
            this.testDataCenterId = volume.getProviderDataCenterId();
        }
        Map<String, String> map = this.testVolumes;
        synchronized (map) {
            while (this.testVolumes.containsKey(label)) {
                label = label + random.nextInt(9);
            }
            this.testVolumes.put(label, id);
        }
        return id;
    }

    private boolean setState(@Nonnull VirtualMachineSupport support, @Nonnull VirtualMachine vm, @Nonnull VmState state) {
        VirtualMachine v;
        long timeout;
        String id;
        VmState currentState;
        block28: {
            currentState = vm.getCurrentState();
            if (state.equals((Object)currentState)) {
                return true;
            }
            if (state.equals((Object)VmState.TERMINATED)) {
                return false;
            }
            id = vm.getProviderVirtualMachineId();
            timeout = System.currentTimeMillis() + 1200000L;
            while (timeout > System.currentTimeMillis() && (currentState.equals((Object)VmState.PENDING) || currentState.equals((Object)VmState.PAUSING) || currentState.equals((Object)VmState.REBOOTING) || currentState.equals((Object)VmState.STOPPING) || currentState.equals((Object)VmState.SUSPENDING))) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    v = support.getVirtualMachine(id);
                    if (v == null) {
                        return state.equals((Object)VmState.TERMINATED);
                    }
                    vm = v;
                    currentState = vm.getCurrentState();
                }
                catch (Throwable ignore) {}
            }
            try {
                if (state.equals((Object)VmState.RUNNING)) {
                    if (currentState.equals((Object)VmState.PAUSED)) {
                        support.unpause(id);
                    } else if (currentState.equals((Object)VmState.STOPPED)) {
                        support.start(id);
                    } else if (currentState.equals((Object)VmState.SUSPENDED)) {
                        support.resume(id);
                    }
                    break block28;
                }
                if (state.equals((Object)VmState.PAUSED)) {
                    if (currentState.equals((Object)VmState.RUNNING) || this.setState(support, vm, VmState.RUNNING)) {
                        support.pause(id);
                        break block28;
                    }
                    return false;
                }
                if (state.equals((Object)VmState.STOPPED)) {
                    if (currentState.equals((Object)VmState.RUNNING) || this.setState(support, vm, VmState.RUNNING)) {
                        support.stop(id, true);
                        break block28;
                    }
                    return false;
                }
                if (!state.equals((Object)VmState.SUSPENDED)) break block28;
                if (currentState.equals((Object)VmState.RUNNING) || this.setState(support, vm, VmState.RUNNING)) {
                    support.suspend(id);
                    break block28;
                }
                return false;
            }
            catch (Throwable ignore) {
                return false;
            }
        }
        timeout = System.currentTimeMillis() + 1200000L;
        while (timeout > System.currentTimeMillis()) {
            if (state.equals((Object)currentState)) {
                return true;
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                v = support.getVirtualMachine(id);
                if (v == null) {
                    return state.equals((Object)VmState.TERMINATED);
                }
                vm = v;
                currentState = vm.getCurrentState();
            }
            catch (Throwable ignore) {}
        }
        return false;
    }
}

