/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.test.compute;

import java.util.Iterator;
import java.util.Random;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.test.DaseinTestManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StatefulImageTests {
    private static final Random random = new Random();
    private static DaseinTestManager tm;
    @Rule
    public final TestName name = new TestName();
    private String bundleLocation;
    private String provisionedImage;
    private String testShareAccount;
    private String testImageId;
    private String testVMId;
    private String testDataCenterId;
    private static boolean capturedOnce;

    @BeforeClass
    public static void configure() {
        tm = new DaseinTestManager(StatefulImageTests.class);
    }

    @AfterClass
    public static void cleanUp() {
        if (tm != null) {
            tm.close();
        }
    }

    @Before
    public void before() {
        tm.begin(this.name.getMethodName());
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        try {
            this.testDataCenterId = System.getProperty("test.dataCenter");
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            if (this.testDataCenterId == null) {
                this.testDataCenterId = ((DataCenter)tm.getProvider().getDataCenterServices().listDataCenters(tm.getContext().getRegionId()).iterator().next()).getProviderDataCenterId();
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        if (!this.name.getMethodName().startsWith("capture")) {
            this.testImageId = tm.getTestImageId("stateful", true);
        }
        this.testVMId = tm.getTestVMId("stateful", VmState.RUNNING, true, this.testDataCenterId);
        this.testShareAccount = System.getProperty("shareAccount");
        if (this.testImageId != null) {
            MachineImageSupport support;
            ComputeServices services;
            if ((this.name.getMethodName().equals("addPrivateShare") || this.name.getMethodName().equals("addPublicShare") || this.name.getMethodName().equals("removePrivateShare") || this.name.getMethodName().equals("removePublicShare") || this.name.getMethodName().equals("removeAllShares")) && (services = tm.getProvider().getComputeServices()) != null && (support = services.getImageSupport()) != null) {
                try {
                    support.removeAllImageShares(this.testImageId);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (this.testShareAccount != null && (this.name.getMethodName().equals("removePrivateShare") || this.name.getMethodName().equals("removeAllShares")) && (services = tm.getProvider().getComputeServices()) != null && (support = services.getImageSupport()) != null) {
                try {
                    support.addImageShare(this.testImageId, this.testShareAccount);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if ((this.name.getMethodName().equals("removePublicShare") || this.name.getMethodName().equals("removeAllShares")) && (services = tm.getProvider().getComputeServices()) != null && (support = services.getImageSupport()) != null) {
                try {
                    support.addPublicShare(this.testImageId);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            if (this.provisionedImage != null) {
                try {
                    tm.getProvider().getComputeServices().getImageSupport().remove(this.provisionedImage);
                }
                catch (Throwable t) {
                    tm.warn("Unable to de-provisionKeypair image " + this.provisionedImage + ": " + t.getMessage());
                }
            }
            this.testVMId = null;
            this.testImageId = null;
            this.testShareAccount = null;
        }
        finally {
            tm.end();
        }
    }

    @Test
    public void listShares() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (this.testImageId != null) {
                    MachineImage image = support.getImage(this.testImageId);
                    Assert.assertNotNull((String)"Failed to find the test image among possible images", (Object)image);
                    Iterable shares = support.listShares(this.testImageId);
                    tm.out("Image Shares", shares);
                    Assert.assertNotNull((String)"Image shares may not be null", (Object)shares);
                } else if (!support.isSubscribed()) {
                    tm.warn("No image ID was identified, so this test is not valid");
                } else if (!support.getCapabilities().supportsImageCapture(MachineImageType.STORAGE) && !support.getCapabilities().supportsImageCapture(MachineImageType.VOLUME)) {
                    tm.ok("No custom images, so sharing doesn't really make any sense");
                } else {
                    Assert.fail((String)"No test image exists for the getImage test");
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void addPrivateShare() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (this.testImageId != null) {
                    if (this.testShareAccount != null) {
                        Iterable shares = support.listShares(this.testImageId);
                        tm.out("Before", shares);
                        if (support.getCapabilities().supportsImageSharing()) {
                            support.addImageShare(this.testImageId, this.testShareAccount);
                            boolean found = false;
                            shares = support.listShares(this.testImageId);
                            long timeout = System.currentTimeMillis() + 180000L;
                            while (timeout > System.currentTimeMillis()) {
                                found = false;
                                for (String share : shares) {
                                    if (!share.equals(this.testShareAccount)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) break;
                                try {
                                    Thread.sleep(15000L);
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                                try {
                                    shares = support.listShares(this.testImageId);
                                }
                                catch (Throwable ignore) {}
                            }
                            tm.out("After", shares);
                            for (String share : shares) {
                                if (!share.equals(this.testShareAccount)) continue;
                                found = true;
                                break;
                            }
                            Assert.assertTrue((String)"Did not find the new share among the listed shares", (boolean)found);
                        } else {
                            try {
                                support.addImageShare(this.testImageId, this.testShareAccount);
                                Assert.fail((String)"Private image sharing is not supported, but the operation completed without error");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("Caught OperationNotSupportedException while attempting to share an image (OK)");
                            }
                        }
                    } else {
                        tm.warn("Unable to test account sharing due to no shareAccount property having been set (test invalid)");
                    }
                } else if (!support.isSubscribed()) {
                    tm.warn("No image ID was identified, so this test is not valid");
                } else if (!support.getCapabilities().supportsImageCapture(MachineImageType.STORAGE) && !support.getCapabilities().supportsImageCapture(MachineImageType.VOLUME)) {
                    tm.ok("No custom images, so sharing doesn't really make any sense");
                } else {
                    Assert.fail((String)("No test image exists for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void removePrivateShare() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (this.testImageId != null) {
                    if (this.testShareAccount != null) {
                        Iterable shares = support.listShares(this.testImageId);
                        tm.out("Before", shares);
                        if (support.getCapabilities().supportsImageSharing()) {
                            support.removeImageShare(this.testImageId, this.testShareAccount);
                            boolean found = false;
                            shares = support.listShares(this.testImageId);
                            long timeout = System.currentTimeMillis() + 180000L;
                            while (timeout > System.currentTimeMillis()) {
                                found = false;
                                for (String share : shares) {
                                    if (!share.equals(this.testShareAccount)) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) break;
                                try {
                                    Thread.sleep(15000L);
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                                try {
                                    shares = support.listShares(this.testImageId);
                                }
                                catch (Throwable ignore) {}
                            }
                            tm.out("After", shares);
                            for (String share : shares) {
                                if (!share.equals(this.testShareAccount)) continue;
                                found = true;
                                break;
                            }
                            Assert.assertFalse((String)"The test account remains among the shared accounts", (boolean)found);
                        } else {
                            try {
                                support.removeImageShare(this.testImageId, this.testShareAccount);
                                Assert.fail((String)"Private image sharing is not supported, but the operation completed without error");
                            }
                            catch (OperationNotSupportedException expected) {
                                tm.ok("Caught OperationNotSupportedException while attempting to remove an image share (OK)");
                            }
                        }
                    } else {
                        tm.warn("Unable to test account share removal due to no shareAccount property having been set (test invalid)");
                    }
                } else if (!support.isSubscribed()) {
                    tm.warn("No image ID was identified, so this test is not valid");
                } else if (!support.getCapabilities().supportsImageCapture(MachineImageType.STORAGE) && !support.getCapabilities().supportsImageCapture(MachineImageType.VOLUME)) {
                    tm.ok("No custom images, so sharing doesn't really make any sense");
                } else {
                    Assert.fail((String)("No test image exists for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void addPublicShare() throws CloudException, InternalException {
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (this.testImageId != null) {
                    if (support.getCapabilities().supportsImageSharingWithPublic()) {
                        tm.out("Before", support.isImageSharedWithPublic(this.testImageId));
                        support.addPublicShare(this.testImageId);
                        long timeout = System.currentTimeMillis() + 180000L;
                        boolean shared = false;
                        while (timeout > System.currentTimeMillis() && !(shared = support.isImageSharedWithPublic(this.testImageId))) {
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException ignore) {}
                        }
                        tm.out("After", shared);
                        Assert.assertTrue((String)"Image remains private", (boolean)shared);
                    } else {
                        try {
                            support.addPublicShare(this.testImageId);
                            Assert.fail((String)"Public image sharing is not supported, but the public share operation succeeded");
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException while attempting to remove an image share (OK)");
                        }
                    }
                } else if (!support.isSubscribed()) {
                    tm.warn("No image ID was identified, so this test is not valid");
                } else if (!support.getCapabilities().supportsImageCapture(MachineImageType.STORAGE) && !support.getCapabilities().supportsImageCapture(MachineImageType.VOLUME)) {
                    tm.ok("No custom images, so sharing doesn't really make any sense");
                } else {
                    Assert.fail((String)("No test image exists for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void removePublicShare() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (this.testImageId != null) {
                    if (support.getCapabilities().supportsImageSharingWithPublic()) {
                        tm.out("Before", support.isImageSharedWithPublic(this.testImageId));
                        support.removePublicShare(this.testImageId);
                        long timeout = System.currentTimeMillis() + 180000L;
                        boolean shared = true;
                        while (timeout > System.currentTimeMillis() && (shared = support.isImageSharedWithPublic(this.testImageId))) {
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException ignore) {}
                        }
                        tm.out("After", shared);
                        Assert.assertFalse((String)"Image remains public", (boolean)shared);
                    } else {
                        try {
                            support.removePublicShare(this.testImageId);
                            Assert.fail((String)"Public image sharing is not supported, but the public share operation succeeded");
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException while attempting to remove an image share (OK)");
                        }
                    }
                } else if (!support.isSubscribed()) {
                    tm.warn("No image ID was identified, so this test is not valid");
                } else if (!support.getCapabilities().supportsImageCapture(MachineImageType.STORAGE) && !support.getCapabilities().supportsImageCapture(MachineImageType.VOLUME)) {
                    tm.ok("No custom images, so sharing doesn't really make any sense");
                } else {
                    Assert.fail((String)("No test image exists for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void removeAllShares() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (this.testImageId != null) {
                    boolean shared;
                    tm.out("Before [Public]", support.isImageSharedWithPublic(this.testImageId));
                    tm.out("Before [Private]", support.listShares(this.testImageId));
                    try {
                        support.removeAllImageShares(this.testImageId);
                    }
                    catch (OperationNotSupportedException e) {
                        Assert.fail((String)"This operation should not throw an OperationNotSupportedException (just a NO-OP in clouds without sharing)");
                    }
                    long timeout = System.currentTimeMillis() + 180000L;
                    while (timeout > System.currentTimeMillis() && ((shared = support.isImageSharedWithPublic(this.testImageId)) || (shared = support.listShares(this.testImageId).iterator().hasNext()))) {
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ignore) {}
                    }
                    tm.out("After [Public]", support.isImageSharedWithPublic(this.testImageId));
                    tm.out("After [Private]", support.listShares(this.testImageId));
                    Assert.assertFalse((String)"Image remains public", (boolean)support.isImageSharedWithPublic(this.testImageId));
                    Assert.assertFalse((String)"Image still has private shares", (boolean)support.listShares(this.testImageId).iterator().hasNext());
                } else if (!support.isSubscribed()) {
                    tm.warn("No image ID was identified, so this test is not valid");
                } else if (!support.getCapabilities().supportsImageCapture(MachineImageType.STORAGE) && !support.getCapabilities().supportsImageCapture(MachineImageType.VOLUME)) {
                    tm.ok("No custom images, so sharing doesn't really make any sense");
                } else {
                    Assert.fail((String)("No test image exists for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void capture() throws CloudException, InternalException {
        ComputeServices services;
        if (capturedOnce) {
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException ignore) {}
        } else {
            capturedOnce = true;
        }
        if ((services = tm.getProvider().getComputeServices()) != null) {
            VirtualMachineSupport vmSupport = services.getVirtualMachineSupport();
            MachineImageSupport support = services.getImageSupport();
            if (support != null && vmSupport != null) {
                if (this.testVMId != null) {
                    VirtualMachine vm = vmSupport.getVirtualMachine(this.testVMId);
                    Assert.assertNotNull((String)("The test virtual machine " + this.testVMId + " does not exist"), (Object)vm);
                    ImageCreateOptions options = ImageCreateOptions.getInstance((VirtualMachine)vm, (String)("dsncap" + System.currentTimeMillis() % 10000L), (String)"Dasein Capture Image Test");
                    options.withMetaData("dsntestcase", (Object)"true");
                    String imageId = vm.getProviderMachineImageId();
                    MachineImageType type = null;
                    MachineImage source = support.getImage(imageId);
                    if (source != null) {
                        type = source.getType();
                    } else {
                        Iterator i$ = support.getCapabilities().listSupportedImageTypes().iterator();
                        while (i$.hasNext()) {
                            MachineImageType t;
                            type = t = (MachineImageType)i$.next();
                        }
                    }
                    if (type == null) {
                        type = MachineImageType.VOLUME;
                    }
                    if (support.getCapabilities().supportsImageCapture(type)) {
                        MachineImage image;
                        this.provisionedImage = options.build(tm.getProvider());
                        tm.out("New Image", this.provisionedImage);
                        Assert.assertNotNull((String)"The image ID returned from provisioning the image was null", (Object)this.provisionedImage);
                        long timeout = System.currentTimeMillis() + 1200000L;
                        while (timeout > System.currentTimeMillis()) {
                            try {
                                image = support.getImage(this.provisionedImage);
                                Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)image);
                                Assert.assertFalse((String)"The image is now in a deleted state, but before it became available", (boolean)MachineImageState.DELETED.equals((Object)image.getCurrentState()));
                                tm.out("--> Current State", image.getCurrentState());
                                if (MachineImageState.ACTIVE.equals((Object)image.getCurrentState())) {
                                    break;
                                }
                            }
                            catch (Throwable t) {
                                tm.warn("Error fetching captured image " + this.provisionedImage);
                            }
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException ignore) {}
                        }
                        image = support.getImage(this.provisionedImage);
                        Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)image);
                        Assert.assertEquals((String)"The image never entered an ACTIVE state during the allotted time window", (Object)MachineImageState.ACTIVE, (Object)image.getCurrentState());
                    } else {
                        try {
                            this.provisionedImage = options.build(tm.getProvider());
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException while attempting to capture image in cloud that does not support capture");
                        }
                    }
                } else if (!support.isSubscribed()) {
                    tm.warn("No test VM was identified for image capture, so this test is not valid");
                } else {
                    Assert.fail((String)("No test VM exists for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void captureAsync() throws Throwable {
        ComputeServices services;
        if (capturedOnce) {
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException ignore) {}
        } else {
            capturedOnce = true;
        }
        if ((services = tm.getProvider().getComputeServices()) != null) {
            VirtualMachineSupport vmSupport = services.getVirtualMachineSupport();
            MachineImageSupport support = services.getImageSupport();
            if (support != null && vmSupport != null) {
                if (this.testVMId != null) {
                    VirtualMachine vm = vmSupport.getVirtualMachine(this.testVMId);
                    Assert.assertNotNull((String)("The test virtual machine " + this.testVMId + " does not exist"), (Object)vm);
                    String imageId = vm.getProviderMachineImageId();
                    MachineImageType type = null;
                    MachineImage source = support.getImage(imageId);
                    if (source != null) {
                        type = source.getType();
                    } else {
                        Iterator i$ = support.getCapabilities().listSupportedImageTypes().iterator();
                        while (i$.hasNext()) {
                            MachineImageType t;
                            type = t = (MachineImageType)i$.next();
                        }
                    }
                    if (type == null) {
                        type = MachineImageType.VOLUME;
                    }
                    ImageCreateOptions options = ImageCreateOptions.getInstance((VirtualMachine)vm, (String)("dsncap" + System.currentTimeMillis() % 10000L), (String)"Dasein Capture Image Test");
                    options.withMetaData("dsntestcase", (Object)"true");
                    AsynchronousTask task = new AsynchronousTask();
                    if (support.getCapabilities().supportsImageCapture(type)) {
                        support.captureImageAsync(options, task);
                        tm.out("Task", "");
                        long timeout = System.currentTimeMillis() + 1800000L;
                        while (timeout > System.currentTimeMillis()) {
                            if (task.isComplete()) {
                                Throwable t = task.getTaskError();
                                if (t != null) {
                                    tm.out("-->", "Failure: " + t.getMessage());
                                    throw t;
                                }
                                tm.out("-->", "Complete");
                                break;
                            }
                            tm.out("-->", task.getPercentComplete() + "%");
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException ignore) {}
                        }
                        MachineImage image = (MachineImage)task.getResult();
                        tm.out("New Image", image);
                        Assert.assertNotNull((String)"The image ID returned from provisioning the image was null", (Object)image);
                        this.provisionedImage = image.getProviderMachineImageId();
                        timeout = System.currentTimeMillis() + 1800000L;
                        while (timeout > System.currentTimeMillis()) {
                            try {
                                MachineImage img = support.getImage(this.provisionedImage);
                                Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)img);
                                Assert.assertFalse((String)"The image is now in a deleted state, but before it became available", (boolean)MachineImageState.DELETED.equals((Object)img.getCurrentState()));
                                tm.out("--> Current State", img.getCurrentState());
                                if (MachineImageState.ACTIVE.equals((Object)img.getCurrentState())) {
                                    break;
                                }
                            }
                            catch (Throwable t) {
                                tm.warn("Error fetching captured image " + this.provisionedImage);
                            }
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException ignore) {}
                        }
                        image = support.getImage(this.provisionedImage);
                        Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)image);
                        Assert.assertEquals((String)"The image never entered an ACTIVE state during the allotted time window", (Object)MachineImageState.ACTIVE, (Object)image.getCurrentState());
                    } else {
                        try {
                            support.captureImageAsync(options, task);
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException while attempting to capture image in cloud that does not support capture");
                        }
                    }
                } else if (!support.isSubscribed()) {
                    tm.warn("No test VM was identified for image capture, so this test is not valid");
                } else {
                    Assert.fail((String)("No test VM exists for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void captureReboot() throws CloudException, InternalException {
        ComputeServices services;
        if (capturedOnce) {
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException ignore) {}
        } else {
            capturedOnce = true;
        }
        if ((services = tm.getProvider().getComputeServices()) != null) {
            VirtualMachineSupport vmSupport = services.getVirtualMachineSupport();
            MachineImageSupport support = services.getImageSupport();
            if (support != null && vmSupport != null) {
                if (this.testVMId != null) {
                    VirtualMachine vm = vmSupport.getVirtualMachine(this.testVMId);
                    Assert.assertNotNull((String)("The test virtual machine " + this.testVMId + " does not exist"), (Object)vm);
                    ImageCreateOptions options = ImageCreateOptions.getInstance((VirtualMachine)vm, (String)("dsncap" + System.currentTimeMillis() % 10000L), (String)"Dasein Capture Image Test", (Boolean)false);
                    options.withMetaData("dsntestcase", (Object)"true");
                    String imageId = vm.getProviderMachineImageId();
                    MachineImageType type = null;
                    MachineImage source = support.getImage(imageId);
                    if (source != null) {
                        type = source.getType();
                    } else {
                        Iterator i$ = support.getCapabilities().listSupportedImageTypes().iterator();
                        while (i$.hasNext()) {
                            MachineImageType t;
                            type = t = (MachineImageType)i$.next();
                        }
                    }
                    if (type == null) {
                        type = MachineImageType.VOLUME;
                    }
                    if (support.getCapabilities().supportsImageCapture(type)) {
                        MachineImage image;
                        this.provisionedImage = options.build(tm.getProvider());
                        tm.out("New Image", this.provisionedImage);
                        Assert.assertNotNull((String)"The image ID returned from provisioning the image was null", (Object)this.provisionedImage);
                        long timeout = System.currentTimeMillis() + 1200000L;
                        while (timeout > System.currentTimeMillis()) {
                            try {
                                image = support.getImage(this.provisionedImage);
                                Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)image);
                                Assert.assertFalse((String)"The image is now in a deleted state, but before it became available", (boolean)MachineImageState.DELETED.equals((Object)image.getCurrentState()));
                                tm.out("--> Current State", image.getCurrentState());
                                if (MachineImageState.ACTIVE.equals((Object)image.getCurrentState())) {
                                    break;
                                }
                            }
                            catch (Throwable t) {
                                tm.warn("Error fetching captured image " + this.provisionedImage);
                            }
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException ignore) {}
                        }
                        image = support.getImage(this.provisionedImage);
                        Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)image);
                        Assert.assertEquals((String)"The image never entered an ACTIVE state during the allotted time window", (Object)MachineImageState.ACTIVE, (Object)image.getCurrentState());
                    } else {
                        try {
                            this.provisionedImage = options.build(tm.getProvider());
                        }
                        catch (OperationNotSupportedException expected) {
                            tm.ok("Caught OperationNotSupportedException while attempting to capture image in cloud that does not support capture");
                        }
                    }
                } else if (!support.isSubscribed()) {
                    tm.warn("No test VM was identified for image capture, so this test is not valid");
                } else {
                    Assert.fail((String)("No test VM exists for the " + this.name.getMethodName() + " test"));
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void bundleVM() throws CloudException, InternalException {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (!support.getCapabilities().identifyLocalBundlingRequirement().equals((Object)Requirement.REQUIRED)) {
                    VirtualMachineSupport vmSupport = services.getVirtualMachineSupport();
                    if (vmSupport != null) {
                        if (this.testVMId != null) {
                            VirtualMachine vm = vmSupport.getVirtualMachine(this.testVMId);
                            Assert.assertNotNull((String)("The test virtual machine " + this.testVMId + " does not exist"), (Object)vm);
                            if (support.getCapabilities().listSupportedFormatsForBundling().iterator().hasNext()) {
                                MachineImage image;
                                MachineImageFormat fmt = (MachineImageFormat)support.getCapabilities().listSupportedFormatsForBundling().iterator().next();
                                this.bundleLocation = support.bundleVirtualMachine(this.testVMId, fmt, "dsnbucket" + random.nextInt(100000), "dsnimgbundle");
                                tm.out("Bundle Location", this.bundleLocation);
                                Assert.assertNotNull((String)"The bundle location returned from bundling the image was null", (Object)this.bundleLocation);
                                ImageCreateOptions options = ImageCreateOptions.getInstance((MachineImageFormat)fmt, (String)this.bundleLocation, (Platform)vm.getPlatform(), (String)("dsnimgbdl" + random.nextInt(100000)), (String)"Dasein Test Bundle Image");
                                options.withMetaData("dsntestcase", (Object)"true");
                                this.provisionedImage = support.registerImageBundle(options).getProviderMachineImageId();
                                long timeout = System.currentTimeMillis() + 1200000L;
                                while (timeout > System.currentTimeMillis()) {
                                    try {
                                        image = support.getImage(this.provisionedImage);
                                        Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)image);
                                        tm.out("--> Current State", image.getCurrentState());
                                        if (MachineImageState.ACTIVE.equals((Object)image.getCurrentState())) {
                                            break;
                                        }
                                    }
                                    catch (Throwable t) {
                                        tm.warn("Error fetching captured image " + this.provisionedImage);
                                    }
                                    try {
                                        Thread.sleep(15000L);
                                    }
                                    catch (InterruptedException ignore) {}
                                }
                                image = support.getImage(this.provisionedImage);
                                Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)image);
                                Assert.assertEquals((String)"The image never entered an ACTIVE state during the allotted time window", (Object)MachineImageState.ACTIVE, (Object)image.getCurrentState());
                            } else {
                                try {
                                    this.bundleLocation = support.bundleVirtualMachine(this.testVMId, MachineImageFormat.OVF, "dsnbundlefail" + random.nextInt(100000), "dsnimgbundle");
                                    Assert.fail((String)"Bundling completed even though bundling is not supposed to be supported");
                                }
                                catch (OperationNotSupportedException expected) {
                                    tm.ok("Caught OperationNotSupportedException while attempting to bundle image in cloud that does not support bundling");
                                }
                                try {
                                    ImageCreateOptions options = ImageCreateOptions.getInstance((MachineImageFormat)MachineImageFormat.OVF, (String)"/dev/null", (Platform)vm.getPlatform(), (String)("dsnimgbdl" + random.nextInt(100000)), (String)"Dasein Test Bundle Image");
                                    options.withMetaData("dsntestcase", (Object)"true");
                                    this.provisionedImage = support.registerImageBundle(options).getProviderMachineImageId();
                                    Assert.fail((String)"Registration succeeded from fake bundle even for some incomprehensible reason");
                                }
                                catch (OperationNotSupportedException expected) {
                                    tm.ok("Caught OperationNotSupportedException while attempting to register image in cloud that does not support bundling");
                                }
                            }
                        } else if (!support.isSubscribed()) {
                            tm.warn("No test VM was identified for image capture, so this test is not valid");
                        } else {
                            Assert.fail((String)("No test VM exists for the " + this.name.getMethodName() + " test"));
                        }
                    } else {
                        Assert.fail((String)"The non-existence of VM support along with the existence of image support makes no sense");
                    }
                } else {
                    tm.ok("Bundling must occur locally on the virtual machine and thus cannot be tested here");
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    @Test
    public void bundleVMAsync() throws Throwable {
        Assume.assumeTrue((!tm.isTestSkipped() ? 1 : 0) != 0);
        ComputeServices services = tm.getProvider().getComputeServices();
        if (services != null) {
            MachineImageSupport support = services.getImageSupport();
            if (support != null) {
                if (!support.getCapabilities().identifyLocalBundlingRequirement().equals((Object)Requirement.REQUIRED)) {
                    VirtualMachineSupport vmSupport = services.getVirtualMachineSupport();
                    if (support != null) {
                        if (this.testVMId != null) {
                            VirtualMachine vm = vmSupport.getVirtualMachine(this.testVMId);
                            Assert.assertNotNull((String)("The test virtual machine " + this.testVMId + " does not exist"), (Object)vm);
                            AsynchronousTask task = new AsynchronousTask();
                            if (support.getCapabilities().listSupportedFormatsForBundling().iterator().hasNext()) {
                                MachineImageFormat fmt = (MachineImageFormat)support.getCapabilities().listSupportedFormatsForBundling().iterator().next();
                                support.bundleVirtualMachineAsync(this.testVMId, fmt, "dsnbucket" + random.nextInt(100000), "dsnimgbundle", task);
                                tm.out("Task", "");
                                long timeout = System.currentTimeMillis() + 1200000L;
                                while (timeout > System.currentTimeMillis()) {
                                    if (task.isComplete()) {
                                        Throwable t = task.getTaskError();
                                        if (t != null) {
                                            tm.out("-->", "Failure: " + t.getMessage());
                                            throw t;
                                        }
                                        tm.out("-->", "Complete");
                                        break;
                                    }
                                    tm.out("-->", task.getPercentComplete() + "%");
                                    try {
                                        Thread.sleep(15000L);
                                    }
                                    catch (InterruptedException ignore) {}
                                }
                                this.bundleLocation = (String)task.getResult();
                                tm.out("Bundle Location", this.bundleLocation);
                                Assert.assertNotNull((String)"The bundle location returned from bundling the image was null", (Object)this.bundleLocation);
                                ImageCreateOptions options = ImageCreateOptions.getInstance((MachineImageFormat)fmt, (String)this.bundleLocation, (Platform)vm.getPlatform(), (String)("dsnimgbdl" + random.nextInt(100000)), (String)"Dasein Test Bundle Image");
                                options.withMetaData("dsntestcase", (Object)"true");
                                this.provisionedImage = support.registerImageBundle(options).getProviderMachineImageId();
                                timeout = System.currentTimeMillis() + 1200000L;
                                while (timeout > System.currentTimeMillis()) {
                                    try {
                                        MachineImage img = support.getImage(this.provisionedImage);
                                        Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)img);
                                        tm.out("--> Current State", img.getCurrentState());
                                        if (MachineImageState.ACTIVE.equals((Object)img.getCurrentState())) {
                                            break;
                                        }
                                    }
                                    catch (Throwable t) {
                                        tm.warn("Error fetching captured image " + this.provisionedImage);
                                    }
                                    try {
                                        Thread.sleep(15000L);
                                    }
                                    catch (InterruptedException ignore) {}
                                }
                                MachineImage image = support.getImage(this.provisionedImage);
                                Assert.assertNotNull((String)"The image disappeared after it was created, but before it became available", (Object)image);
                                Assert.assertEquals((String)"The image never entered an ACTIVE state during the allotted time window", (Object)MachineImageState.ACTIVE, (Object)image.getCurrentState());
                            } else {
                                try {
                                    support.bundleVirtualMachineAsync(this.testVMId, MachineImageFormat.OVF, "dsnbdlfail" + random.nextInt(100000), "dsnimgbundle", task);
                                    Assert.fail((String)"Bundling completed even though bundling is not supposed to be supported");
                                }
                                catch (OperationNotSupportedException expected) {
                                    tm.ok("Caught OperationNotSupportedException while attempting to bundle image in cloud that does not support bundling");
                                }
                            }
                        } else if (!support.isSubscribed()) {
                            tm.warn("No test VM was identified for image capture, so this test is not valid");
                        } else {
                            Assert.fail((String)("No test VM exists for the " + this.name.getMethodName() + " test"));
                        }
                    } else {
                        Assert.fail((String)"The non-existence of VM support along with the existence of image support makes no sense");
                    }
                } else {
                    tm.ok("Bundling must occur locally on the virtual machine and thus cannot be tested here");
                }
            } else {
                tm.ok("No image support in this cloud");
            }
        } else {
            tm.ok("No compute services in this cloud");
        }
    }

    static {
        capturedOnce = false;
    }
}

